/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Accelerators;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.PyroSimSelectionModel;
import pyrosim.WriteProtect;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.FDSRun;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.GridUtil;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IImplicitGeomSrc;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.ResultsArchive;
import pyrosim.domain.SimParams;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.bridge.IBridgeObj;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.DepUtil;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.CableFailDetector;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.simctrl.ASimCtrlDevice;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.IHvacGeomComp;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.AddGridBoundaryVentsTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.ExplodeTask;
import pyrosim.domain.tasks.FilterGeomTask;
import pyrosim.domain.tasks.GroupGeomTask;
import pyrosim.domain.tasks.InsertAdditionalRecordsTask;
import pyrosim.domain.tasks.RasterizeTask;
import pyrosim.domain.tasks.ReorderObjectsTask;
import pyrosim.domain.tasks.ReplacePreserveTask;
import pyrosim.domain.tasks.SelectByBIMTypeTask;
import pyrosim.domain.tasks.SelectByColorTask;
import pyrosim.domain.tasks.SelectReferencingObjTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.SetEnabledSomeObjsTask;
import pyrosim.domain.tasks.SetForceWriteTask;
import pyrosim.domain.tasks.ShowAllGeomTask;
import pyrosim.domain.tasks.ShowSomeGeomTask;
import pyrosim.domain.tasks.SortByNameTask;
import pyrosim.domain.tasks.Tasks;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;
import pyrosim.domain.zones.ZoneMgr;
import pyrosim.geom.Geometry;
import pyrosim.gui.CancelledException;
import pyrosim.gui.ConvertCadLinesDlg;
import pyrosim.gui.ExSpecManagerDlg;
import pyrosim.gui.FDSRunMonitor;
import pyrosim.gui.HvacManagerDlg;
import pyrosim.gui.LibraryDlg;
import pyrosim.gui.NewGroupDialog;
import pyrosim.gui.OpenMpDlg;
import pyrosim.gui.PyroFindDlg;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.ReplaceDlg;
import pyrosim.gui.SimulationPropertiesDlg;
import pyrosim.gui.TimeHistoryPlotDlg;
import pyrosim.gui.actions.ActionListBuilder;
import pyrosim.gui.actions.ActionsMesh;
import pyrosim.gui.actions.FdsIoUtil;
import pyrosim.gui.actions.ImportAction;
import pyrosim.gui.actions.ViewActions;
import pyrosim.gui.appearance.MaterialDlg;
import pyrosim.gui.boundcond.MaterialManagerDlg;
import pyrosim.gui.boundcond.SurfaceManagerDlg;
import pyrosim.gui.controls.ControlDlg;
import pyrosim.gui.devices.DevcEditorFactory;
import pyrosim.gui.devices.DeviceDlg;
import pyrosim.gui.devices.GasPointDevcEditor;
import pyrosim.gui.devices.HeatLinkModelManagerDlg;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.SmokeLinkModelMgrDlg;
import pyrosim.gui.devices.SprayModelManagerDlg;
import pyrosim.gui.devices.SprinklerLinkModelManagerDlg;
import pyrosim.gui.fds.ArchiveResultsDlg;
import pyrosim.gui.fds.RestoreResultsDlg;
import pyrosim.gui.geom.GroupChooserDlg;
import pyrosim.gui.geom.MirrorDialog;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.gui.geom.RasterizationPropsDlg;
import pyrosim.gui.geom.RotateDialog;
import pyrosim.gui.geom.ScaleDialog;
import pyrosim.gui.geom.TransformDialog;
import pyrosim.gui.geom.TranslateDialog;
import pyrosim.gui.grid.GridManagerDlg;
import pyrosim.gui.output.BoundariesDlg;
import pyrosim.gui.output.IsofDialog;
import pyrosim.gui.output.Plot3dDlg;
import pyrosim.gui.output.ProfListDlg;
import pyrosim.gui.output.Slcf3dDialog;
import pyrosim.gui.output.SlcfDialog;
import pyrosim.gui.output.StatisticsDlg;
import pyrosim.gui.particle.ParticleManagerDlg;
import pyrosim.gui.reaction.ReactionManagerDlg;
import pyrosim.gui.reaction.SetNewActiveSimpleReacDlg;
import pyrosim.gui.tasks.SimulationTask;
import pyrosim.gui.view.SectionBoxDlg;
import pyrosim.gui.zones.ZoneDlg;
import pyrosim.io.IOUtil;
import pyrosim.io.PyroDataContainer;
import pyrosim.io.TimeHistoryData;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParser;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiExceptionError;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.gui.guiSimpleError;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.ObjectSelection;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.Task;
import thunderheadeng.util.TaskManager;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class Actions {
    private static final Logger LOGGER = Logger.getLogger(Actions.class.getName());
    private static final Hashtable<String, ImageIcon> ICONS = new Hashtable();
    public static DataFlavor PYRO_DATA_FLAVOR = new DataFlavor(PyroDataContainer.class, "Mixed PyroSim Data");
    public static DataFlavor FDS_DATA_FLAVOR = DataFlavor.stringFlavor;
    public static final ProtectAction PROTECT_ACTION = new ProtectAction();
    public static final AddGroupAction CONTEXT_ADD_GROUP_ACTION = new AddGroupAction(true);
    public static final AddGroupAction GLOBAL_ADD_GROUP_ACTION = new AddGroupAction(false);
    public static final ChangeGroupAction CHANGE_GROUP = new ChangeGroupAction();
    public static final Action TRANSLATE_ACTION = new TranslateAction();
    public static final Action MIRROR_ACTION = new MirrorAction();
    public static final Action SCALE_ACTION = new ScaleAction();
    public static final Action ROTATE_ACTION = new RotateAction();
    public static final AddWallAction ADD_WALL_ACTION = new AddWallAction();
    public static final AddVentAction ADD_VENT_ACTION = new AddVentAction();
    public static final AddSlabAction ADD_SLAB_ACTION = new AddSlabAction();
    public static final AddHoleAction ADD_HOLE_ACTION = new AddHoleAction();
    public static final AddPartCloudAction ADD_PART_CLOUD_ACTION = new AddPartCloudAction();
    public static final AddPartLocationAction ADD_PART_LOC_ACTION = new AddPartLocationAction();
    public static final AddInitRegionAction ADD_INIT_REGION_ACTION = new AddInitRegionAction();
    public static final AddHvacDuctAction ADD_HVAC_DUCT_ACTION = new AddHvacDuctAction();
    public static final AddHvacNodeAction ADD_HVAC_NODE_ACTION = new AddHvacNodeAction();
    public static final RasterizeObjectsAction RASTERIZE_OBJECTS_ACTION = new RasterizeObjectsAction();
    public static final ExplodeAction EXPLODE_ACTION = new ExplodeAction();
    public static final GroupGeomAction GROUP_GEOM_ACTION = new GroupGeomAction();
    public static final AddHvacVentNode ADD_HVAC_VENT_NODES = new AddHvacVentNode();
    public static final ConnectWithHvac CONNECT_WITH_HVAC = new ConnectWithHvac();
    public static final ExtrudeLinesAction EXTRUDE_LINES = new ExtrudeLinesAction();
    public static final FindObjectsAction FIND_ACTION = new FindObjectsAction();
    public static final ViewActions.AddViewAction CONTEXT_ADD_VIEW = new ViewActions.AddViewAction(true);
    public static final ViewActions.AddViewAction GLOBAL_ADD_VIEW = new ViewActions.AddViewAction(false);
    public static final ViewActions.SetActiveViewAction SET_ACTIVE_VIEW_ACTION = new ViewActions.SetActiveViewAction();
    public static final ViewActions.AddSectionBox CONTEXT_ADD_SECTION_BOX = new ViewActions.AddSectionBox(true);
    public static final ViewActions.AddSectionBox GLOBAL_ADD_SECTION_BOX = new ViewActions.AddSectionBox(false);
    public static final ViewActions.ResetSectionBox CONTEXT_RESET_SECTION_BOX = new ViewActions.ResetSectionBox(true);
    public static final ViewActions.ResetSectionBox GLOBAL_RESET_SECTION_BOX = new ViewActions.ResetSectionBox(false);
    public static final ViewActions.SaveViewpoint CONTEXT_SAVE_VIEW_CAMERA = new ViewActions.SaveViewpoint(true);
    public static final ViewActions.SaveViewpoint GLOBAL_SAVE_VIEW_CAMERA = new ViewActions.SaveViewpoint(false);
    public static final ViewActions.ShowViewpoint CONTEXT_SHOW_VIEW_CAMERA = new ViewActions.ShowViewpoint(true);
    public static final ViewActions.ShowViewpoint GLOBAL_SHOW_VIEW_CAMERA = new ViewActions.ShowViewpoint(false);
    public static final ViewActions.CreationSection CREATE_SECTION = new ViewActions.CreationSection();
    public static final ViewActions.DuplicateView DUPLICATE_VIEW = new ViewActions.DuplicateView();
    public static final SetObstOptionAction WRITE_AS_GEOM = new SetObstOptionAction(Intl.intl("Write as GEOM"), 128, true);
    public static final SetObstOptionAction WRITE_AS_OBST = new SetObstOptionAction(Intl.intl("Write as OBST"), 128, false);
    public static final UndoAction UNDO_ACTION = new UndoAction();
    public static final RedoAction REDO_ACTION = new RedoAction();
    public static final CopyAction COPY_ACTION = new CopyAction();
    public static final CopyFDSRecordsAction COPY_FDS_ACTION = new CopyFDSRecordsAction();
    public static final GridAction GRID_ACTION = new GridAction();
    public static final ZonesAction ZONES_ACTION = new ZonesAction();
    public static final ControlsAction CONTROLS_ACTION = new ControlsAction();
    public static final CutAction CUT_ACTION = new CutAction();
    public static final EditSelectedNodeAction EDIT_SELECTED_NODE_ACTION = new EditSelectedNodeAction();
    public static final ChangeEnabledNodeAction ENABLE_NODE_ACTION = new ChangeEnabledNodeAction(Intl.intl("Enable Object(s)"), true);
    public static final ChangeEnabledNodeAction DISABLE_NODE_ACTION = new ChangeEnabledNodeAction(Intl.intl("Disable Object(s)"), false);
    public static final HideNodeAction HIDE_NODE_ACTION = new HideNodeAction();
    public static final HideUnselectedNodeAction HIDE_UNSELECTED_NODE_ACTION = new HideUnselectedNodeAction();
    public static final PasteAction PASTE_ACTION = new PasteAction();
    public static final RemoveSelectedNodeAction REMOVE_SELECTED_NODE_ACTION = new RemoveSelectedNodeAction();
    public static final ShowAllNodesAction SHOW_ALL_NODES_ACTION = new ShowAllNodesAction();
    public static final ShowNodeAction SHOW_NODE_ACTION = new ShowNodeAction();
    public static final AddFloorFromGeomAction ADD_FLOOR_FROM_GEOM_ACTION = new AddFloorFromGeomAction();
    public static final OpenGridsAction OPEN_GRIDS_ACTION = new OpenGridsAction();
    public static final MaterialManagerAction MATERIAL_MANAGER_ACTION = new MaterialManagerAction();
    public static final SurfaceManagerAction SURFACE_MANAGER_ACTION = new SurfaceManagerAction();
    public static final AppearanceManagerAction APPEARANCE_MANAGER_ACTION = new AppearanceManagerAction();
    public static final ReactionManagerAction REACTION_MANAGER_ACTION = new ReactionManagerAction();
    public static final SprayModelManagerAction SPRAY_MODEL_MANAGER_ACTION = new SprayModelManagerAction();
    public static final SprinklerLinkModelManagerAction SPRINKLER_LINK_MODEL_MANAGER_ACTION = new SprinklerLinkModelManagerAction();
    public static final HeatLinkModelManagerAction HEAT_LINK_MODEL_MANAGER_ACTION = new HeatLinkModelManagerAction();
    public static final SelectRefObjectsAction SELECT_REFERENCING_OBJECTS_ACTION = new SelectRefObjectsAction();
    public static final SelectByColorAction SELECT_BY_COLOR_ACTION = new SelectByColorAction();
    public static final SelectByBIMTypeAction SELECT_BY_BIM_TYPE_ACTION = new SelectByBIMTypeAction();
    public static final EditSimulationPropertiesAction EDIT_SIMULATION_PROPERTIES_ACTION = new EditSimulationPropertiesAction();
    public static final ParticleAction PARTICLE_ACTION = new ParticleAction();
    public static final SmodLinkModelsAction SMOD_MODELS_ACTION = new SmodLinkModelsAction();
    public static final ExSpecListAction EXSPEC_LIST_ACTION = new ExSpecListAction();
    public static final RunResultsAction RUN_SMOKEVIEW_ACTION = new RunResultsAction(Intl.intl("Run Smokeview..."), null, f -> FDSRunMonitor.showResults(FDSRunMonitor.ResultsApp.SMOKEVIEW, null, f), "smv", Intl.intl("Smokeview Files"));
    public static final RunResultsAction RUN_RESULTS_ACTION = new RunResultsAction(Intl.intl("Run Results..."), PyroGuiUtil.loadPyroSimIcon("burn16.png"), f -> FDSRunMonitor.showResults(FDSRunMonitor.ResultsApp.RESULTS, null, f), "smv", Intl.intl("Smokeview Files"), "smvv", Intl.intl("PyroSim Results Visualization"));
    public static final Results3dAction VIEW_RESULTS_ACTION = new Results3dAction();
    public static final TimeHistoryResultsAction VIEW_HRR_RESULTS_ACTION = new TimeHistoryResultsAction(Intl.intl("Plot Thermal Results"), (Icon)PyroGuiUtil.loadPyroSimIcon("burn16.png", 8), 3);
    public static final TimeHistoryResultsAction VIEW_DEVC_RESULTS_ACTION = new TimeHistoryResultsAction(Intl.intl("Plot Device Results"), (Icon)PyroGuiUtil.loadPyroSimIcon("smoke.png", 8), 4);
    public static final TimeHistoryResultsAction VIEW_CTRL_RESULTS_ACTION = new TimeHistoryResultsAction(Intl.intl("Plot Control Results"), (Icon)PyroGuiUtil.loadPyroSimIcon("or16.png", 8), 5);
    public static final ResultsPreviewAction RESULTS_PREVIEW_ACTION = new ResultsPreviewAction();
    public static final TCPlotsAction TC_PLOTS_ACTION = new TCPlotsAction();
    public static final ArchiveResultsAction ARCHIVE_RESULTS = new ArchiveResultsAction();
    public static final RestoreResultsAction RESTORE_RESULTS = new RestoreResultsAction();
    public static final SetReactionAction SET_REACTION_ACTION = new SetReactionAction();
    public static final ClearReactionAction CLEAR_REACTION_ACTION = new ClearReactionAction();
    public static final SetBackgroundSpecAction SET_BACKGROUND_ACTION = new SetBackgroundSpecAction();
    public static final ClearBackgroundSpecAction CLEAR_BACKGROUND_ACTION = new ClearBackgroundSpecAction();
    public static final SetAsDefaultSurfAction SET_DEFAULT_SURFACE_ACTION = new SetAsDefaultSurfAction();
    public static final EnableForceToWriteAction ENABLE_FORCE_TO_WRITE_ACTION = new EnableForceToWriteAction();
    public static final DisableForceToWriteAction DISABLE_FORCE_TO_WRITE_ACTION = new DisableForceToWriteAction();
    public static final EditHvac EDIT_HVAC = new EditHvac();
    public static final CrashAction CRASH_PYROSIM = new CrashAction();
    public static final EditOpenMpAction EDIT_OPENMP_ACTION = new EditOpenMpAction();
    public static final SelectHvacNetwork SELECT_HVAC_NETWORK = new SelectHvacNetwork();
    public static final guiAction SPLIT_MESH_ACTION = new ActionsMesh.SplitMeshAction();
    public static final guiAction REFINE_MESH_ACTION = new ActionsMesh.RefineMeshAction();
    public static final guiAction MERGE_MESH_ACTION = new ActionsMesh.MergeMeshAction();
    public static final EditLibAction EDIT_LIBRARIES_ACTION = new EditLibAction();
    public static final NewDeviceAction NEW_GAS_POINT_DEVICES_ACTION = new NewDeviceAction<GasPointMeasurer>(Intl.intl("New Gas-phase Device..."), GasPointMeasurer.class, 0);
    public static final NewDeviceAction NEW_SOLID_POINT_DEVICES_ACTION = new NewDeviceAction<SolidPointMeasurer>(Intl.intl("New Solid-phase Device..."), SolidPointMeasurer.class, 0);
    public static final NewDeviceAction NEW_THERMOCOUPLE_ACTION = new NewDeviceAction<Thermocouple>(Intl.intl("New Thermocouple..."), Thermocouple.class, 0);
    public static final NewDeviceAction<GasPointMeasurer> NEW_TIME_DEVC_ACTION = new NewDeviceAction<GasPointMeasurer>(Intl.intl("New Time Device..."), GasPointMeasurer.class, null, mod -> new GasPointDevcEditor((PyroMod)mod, Intl.intl("Time"), Intl.intl("Time"), Quantity.TIME.create(), IDevcEditor.Mode.CREATE));
    public static final NewDeviceAction NEW_PATH_OBSCURATION_MEASURER_ACTION = new NewDeviceAction<PathObscurationMeasurer>(Intl.intl("New Beam Detector Device..."), PathObscurationMeasurer.class, 0);
    public static final NewDeviceAction NEW_LAYER_INFORMATION_MEASURER_ACTION = new NewDeviceAction<LayerMeasurer>(Intl.intl("New Layer Zoning Device..."), LayerMeasurer.class, 0);
    public static final NewDeviceAction NEW_HEAT_RELEASE_RATE_MEASURER_ACTION = new NewDeviceAction<AABoxMeasurer>(Intl.intl("New Heat Release Rate Device..."), AABoxMeasurer.class, 0);
    public static final NewDeviceAction NEW_FLOW_MEASURER_ACTION = new NewDeviceAction<FlowMeasurer>(Intl.intl("New Flow Measuring Device..."), FlowMeasurer.class, 0);
    public static final NewDeviceAction NEW_ASPIRATOR_ACTION = new NewDeviceAction<Aspirator>(Intl.intl("New Aspirator..."), Aspirator.class, 0);
    public static final NewDeviceAction NEW_ASPIRATOR_SAMPLER_ACTION = new NewDeviceAction<AspiratorSampler>(Intl.intl("New Aspirator Sampler..."), AspiratorSampler.class, 0);
    public static final NewDeviceAction NEW_SMOKE_DETECTOR_ACTION = new NewDeviceAction<SmokeDetector>(Intl.intl("New Smoke Detector..."), SmokeDetector.class, (Icon)Actions.createIcon("pyrosim/icons/smoke.png"), 0);
    public static final NewDeviceAction NEW_HEAT_DETECTOR_DEVICE_ACTION = new NewDeviceAction<HeatDetector>(Intl.intl("New Heat Detector..."), HeatDetector.class, (Icon)Actions.createIcon("pyrosim/icons/heat.png"), 0);
    public static final NewDeviceAction NEW_SPRINKLER_LINK_ACTION = new NewDeviceAction<SprinklerLink>(Intl.intl("New Sprinkler Link..."), SprinklerLink.class, 0);
    public static final NewDeviceAction NEW_NOZZLE_ACTION = new NewDeviceAction<Nozzle>(Intl.intl("New Nozzle..."), Nozzle.class, 0);
    public static final NewDeviceAction NEW_SPRINKLER_DEVICE_ACTION = new NewDeviceAction<Sprinkler>(Intl.intl("New Sprinkler..."), Sprinkler.class, (Icon)Actions.createIcon("pyrosim/icons/sprk2.png"), 0);
    public static final NewDeviceAction NEW_DRY_PIPE_ACTION = new NewDeviceAction<DryPipe>(Intl.intl("New Dry Pipe..."), DryPipe.class, 0);
    @Deprecated
    public static final NewDeviceAction NEW_CABLE_MSR_ACTION = new NewDeviceAction<CableFailDetector>(Intl.intl("New Cable Failure Detector..."), CableFailDetector.class, 0);
    public static final NewDeviceAction NEW_SIMCTRL_ACTION = new NewDeviceAction<ASimCtrlDevice>(Intl.intl("New Sim Control Device..."), ASimCtrlDevice.class, 0);
    public static final NewDeviceAction NEW_HVAC_DUCT_DEVICE_ACTION = new NewDeviceAction<HvacDevice>(Intl.intl("New HVAC Duct Device..."), HvacDevice.class, 0);
    public static final NewDeviceAction NEW_HVAC_NODE_DEVICE_ACTION = new NewDeviceAction<HvacDevice>(Intl.intl("New HVAC Node Device..."), HvacDevice.class, 1);
    public static final BoundaryQuantityAction BOUNDARYQUANTITY_ACTION = new BoundaryQuantityAction();
    public static final Plot3DAction PLOT3D_ACTION = new Plot3DAction();
    public static final IsosurfaceAction ISOSURFACE_ACTION = new IsosurfaceAction();
    public static final SliceAction SLICE_ACTION = new SliceAction();
    public static final Slice3DAction SLICE3D_ACTION = new Slice3DAction();
    public static final ProfListAction PROF_ACTION = new ProfListAction();
    public static final MsrStatsAction MSR_STATS_ACTION = new MsrStatsAction();
    public static final Action SORT_ACTION = new SortAction();
    public static final Action IMPORT_ACTION = new ImportAction();
    private static ActionStateUpdater d_actionStateUpdater;
    private static final List<guiAction> DEFAULT_ACTIONS;
    public static final int PASTEOPT_SELECT_INSERTED_OBJS = 1;
    public static final int PASTEOPT_INSERT_ALL_AS_IMPLICIT = 2;
    public static final int PASTEOPT_INSERT_ALL_AS_EXPLICIT = 4;

    public static void init(PyroMod mediator) {
        d_actionStateUpdater = new ActionStateUpdater(mediator);
        mediator.getEvents().addObserver(d_actionStateUpdater);
        mediator.getTaskManager().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Actions.updateUndoRedoActions(((PyroSim)Application.getApp()).getMediator());
            }
        });
    }

    public static void applicationActivated(PyroSim app) {
    }

    public static void updatePasteAction() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        boolean flavorAvailable = false;
        for (DataFlavor flavor : Actions.getSupportedPasteFlavors()) {
            if (!cb.isDataFlavorAvailable(flavor)) continue;
            flavorAvailable = true;
            break;
        }
        PASTE_ACTION.setEnabled(flavorAvailable);
    }

    public static final ImageIcon createIcon(String loc) {
        if (loc == null) {
            return null;
        }
        if (!ICONS.containsKey(loc)) {
            ICONS.put(loc, new ImageIcon(Actions.class.getClassLoader().getResource(loc)));
        }
        return ICONS.get(loc);
    }

    private static boolean isExplodable(IGeomNode geom) {
        return !geom.getChildren().isEmpty() || Actions.isExplodable(geom.getLocalGeom());
    }

    private static boolean isExplodable(IGeom geom) {
        return geom instanceof GeomGroup;
    }

    private static void updateUndoRedoActions(PyroMod mediator) {
        UNDO_ACTION.update(mediator.getTaskManager());
        REDO_ACTION.update(mediator.getTaskManager());
    }

    private static JPopupMenu generateContextMenu(List<Action> actions, Action defAction) {
        JPopupMenu ctxMenu = new JPopupMenu();
        for (Action action : actions) {
            if (action != null) {
                JMenuItem item = ctxMenu.add(action);
                if (action != defAction) continue;
                item.setFont(item.getFont().deriveFont(1));
                continue;
            }
            ctxMenu.addSeparator();
        }
        return ctxMenu;
    }

    public static JPopupMenu getContextMenu(Collection<?> selStuff) {
        ActionListBuilder actions = new ActionListBuilder();
        actions.add(CONTEXT_ADD_GROUP_ACTION);
        actions.add(Actions.getAddFloorFromGeomAction());
        actions.add(CREATE_SECTION);
        actions.add(Actions.getSortAction());
        actions.addSeparator();
        actions.add(CHANGE_GROUP);
        actions.add(EXPLODE_ACTION);
        actions.add(GROUP_GEOM_ACTION);
        actions.add(Actions.getRasterizeAction());
        if (PyroSim.FDS7) {
            actions.add(WRITE_AS_GEOM);
            actions.add(WRITE_AS_OBST);
        }
        actions.add(SELECT_REFERENCING_OBJECTS_ACTION);
        actions.add(Actions.getSelectByColorAction());
        actions.add(Actions.getSelectByBimAction());
        actions.add(ENABLE_FORCE_TO_WRITE_ACTION);
        actions.add(DISABLE_FORCE_TO_WRITE_ACTION);
        actions.add(SELECT_HVAC_NETWORK);
        actions.add(ADD_HVAC_VENT_NODES);
        actions.add(CONNECT_WITH_HVAC);
        actions.add(EXTRUDE_LINES);
        actions.add(SET_DEFAULT_SURFACE_ACTION);
        actions.add(CLEAR_REACTION_ACTION);
        actions.add(SET_REACTION_ACTION);
        actions.add(CLEAR_BACKGROUND_ACTION);
        actions.add(SET_BACKGROUND_ACTION);
        actions.addSeparator();
        actions.add(CONTEXT_ADD_VIEW);
        actions.add(SET_ACTIVE_VIEW_ACTION);
        actions.add(CONTEXT_ADD_SECTION_BOX);
        actions.add(CONTEXT_RESET_SECTION_BOX);
        actions.add(CONTEXT_SAVE_VIEW_CAMERA);
        actions.add(CONTEXT_SHOW_VIEW_CAMERA);
        actions.add(DUPLICATE_VIEW);
        if (selStuff.isEmpty()) {
            actions.add(GLOBAL_ADD_VIEW);
            actions.add(GLOBAL_ADD_SECTION_BOX);
            actions.add(GLOBAL_RESET_SECTION_BOX);
            actions.add(GLOBAL_SAVE_VIEW_CAMERA);
            actions.add(GLOBAL_SHOW_VIEW_CAMERA);
        }
        actions.add(Actions.getOpenGridsAction());
        actions.add(Actions.getSubdivideMeshAction());
        actions.add(Actions.getRefineMeshAction());
        actions.add(Actions.getMergeMeshAction());
        actions.addSeparator();
        actions.add(Actions.getTranslateAction());
        actions.add(Actions.getMirrorAction());
        actions.add(Actions.getScaleAction());
        actions.add(Actions.getRotateAction());
        actions.addSeparator();
        actions.add(Actions.getCutAction());
        actions.add(Actions.getCopyAction());
        actions.add(Actions.getCopyFDSAction());
        actions.add(Actions.getPasteAction());
        actions.add(Actions.getDeleteAction());
        actions.addSeparator();
        actions.add(Actions.getEnableNodeAction());
        actions.add(Actions.getDisableNodeAction());
        actions.addSeparator();
        actions.add(Actions.getHideNodeAction());
        actions.add(Actions.getShowNodeAction());
        actions.add(Actions.getHideUnselectedNodeAction());
        actions.add(Actions.getShowAllNodesAction());
        actions.addSeparator();
        actions.add(PyroSim.getApp().getTreeView().getRenameAction());
        actions.add(Actions.getEditNodeAction());
        return Actions.generateContextMenu(actions.finalizeList(), Actions.getDefaultAction(PyroSim.getApp().getMediator()));
    }

    private static Collection<IPyroObject> getSelectedGeom(PyroMod pyMod) {
        Predicate<IPyroObject> filter = new Predicate<IPyroObject>(){

            @Override
            public boolean test(IPyroObject o) {
                if (o instanceof IPyroGeomSrc) {
                    return true;
                }
                return !Hierarchy.flatten(o.getMembers(), IPyroGeomSrc.class).isEmpty();
            }
        };
        return pyMod.getSelectionModel().getSelected(IPyroObject.class, filter);
    }

    public static Collection<IPyroObject> getTransformObjs(PyroSim app, PyroMod domain, Collection<IPyroObject> baseObjs) throws CancellationException {
        Collection<IImplicitGeomSrc> iobjs = Hierarchy.flatten(baseObjs, IImplicitGeomSrc.class);
        if (iobjs.isEmpty()) {
            return baseObjs;
        }
        LinkedIdentityHashSet definingObjs = new LinkedIdentityHashSet();
        ArrayDeque<IImplicitGeomSrc> open = new ArrayDeque<IImplicitGeomSrc>(iobjs);
        IdentityHashSet<IImplicitGeomSrc> closed = new IdentityHashSet<IImplicitGeomSrc>(iobjs);
        ArrayList<IPyroGeomSrc> tempList = new ArrayList<IPyroGeomSrc>();
        while (!open.isEmpty()) {
            IImplicitGeomSrc isrc = (IImplicitGeomSrc)open.removeFirst();
            isrc.getDefiningObjs(tempList);
            if (tempList.isEmpty()) {
                definingObjs.add(isrc);
                continue;
            }
            for (IPyroGeomSrc src2 : tempList) {
                if (src2 instanceof IImplicitGeomSrc) {
                    if (!closed.add(src2)) continue;
                    open.addLast((IImplicitGeomSrc)src2);
                    continue;
                }
                definingObjs.add(src2);
            }
            tempList.clear();
        }
        if (definingObjs.isEmpty()) {
            return baseObjs;
        }
        IdentityHashSet<IPyroGeomSrc> allSrcs = new IdentityHashSet<IPyroGeomSrc>(Hierarchy.flatten(baseObjs, IPyroGeomSrc.class));
        IFilteredCollection<IPyroGeomSrc> missing = theUtil.filter(definingObjs, src -> !allSrcs.contains(src));
        if (missing.isEmpty()) {
            return baseObjs;
        }
        ArrayList<IPyroObject> tobjs = new ArrayList<IPyroObject>(baseObjs);
        tobjs.addAll(missing);
        return tobjs;
    }

    public static void editControls(ControlBridge init) {
        ControlDlg dlg = new ControlDlg(PyroSim.getApp().getMainFrame());
        dlg.init(PyroSim.getApp().getMediator().getControls(), init);
        dlg.doModal();
    }

    public static void editZones(Zone init) {
        PyroMod mediator = PyroSim.getApp().getMediator();
        ZoneDlg dlg = new ZoneDlg(PyroSim.getApp().getMainFrame(), mediator);
        dlg.init(mediator.getZoneMgr(), init);
        dlg.doModal();
    }

    public static void doEditGrids(Grid init) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        GridList gList = pyMod.getGridManager();
        GridManagerDlg dlg = new GridManagerDlg(pySim.getMainFrame());
        dlg.init(gList, init);
        dlg.doModal();
    }

    private static void editMaterials(Material init) {
        PyroSim pySim = (PyroSim)Application.getApp();
        PyroMod pyMod = pySim.getMediator();
        MaterialManagerDlg mm = new MaterialManagerDlg(pySim.getMainFrame());
        mm.init(pyMod.getMaterialMgr(), init);
        mm.doModal();
    }

    public static void editSurfaces(Surface init) {
        PyroSim pySim = (PyroSim)Application.getApp();
        PyroMod pyMod = pySim.getMediator();
        SurfaceManagerDlg mm = new SurfaceManagerDlg(pySim.getMainFrame());
        mm.init(pyMod.getSurfaceMgr(), init);
        mm.doModal();
    }

    public static void editAppearance(pyrosim.domain.appearance.Material init) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        MaterialDlg dlg = new MaterialDlg(pySim.getMainFrame(), Intl.intl("Appearances"), pyMod.getAppearances(), init, false);
        dlg.doModal();
    }

    public static void doEditReactions(Reaction rInit) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        ReactionList reactMan = pyMod.getReactions();
        ExSpecList specList = pyMod.getExSpecList();
        ReactionManagerDlg dlg = new ReactionManagerDlg(pySim.getMainFrame());
        dlg.init(reactMan, rInit, specList);
        dlg.doModal();
    }

    public static void editSprayModel(SprayModel init) {
        PyroSim pySim = (PyroSim)Application.getApp();
        PyroMod pyMod = pySim.getMediator();
        SprayModelManagerDlg mm = new SprayModelManagerDlg(pySim.getMainFrame());
        mm.init(pyMod.getSprayModels(), init);
        mm.doModal();
    }

    public static void editSprinklerLinkModels(SprinklerLinkModel init) {
        PyroSim pySim = (PyroSim)Application.getApp();
        PyroMod pyMod = pySim.getMediator();
        SprinklerLinkModelManagerDlg mm = new SprinklerLinkModelManagerDlg(pySim.getMainFrame());
        mm.init(pyMod.getSprinklerLinkModels(), init);
        mm.doModal();
    }

    public static void editHeatLinkModels(HeatLinkModel init) {
        PyroSim pySim = (PyroSim)Application.getApp();
        PyroMod pyMod = pySim.getMediator();
        HeatLinkModelManagerDlg mm = new HeatLinkModelManagerDlg(pySim.getMainFrame());
        mm.init(pyMod.getHeatLinkModels(), init);
        mm.doModal();
    }

    protected static ModelComposite getModelInsertLoc() {
        PyroMod mediator = PyroSim.getApp().getMediator();
        IFilteredCollection<IPyroObject> sel = mediator.getSelectionModel().getSelected(IPyroObject.class);
        if (!sel.isEmpty()) {
            IPyroObject parent = Hierarchy.getCommonParent(sel);
            if (Hierarchy.isDescendent(mediator.getObstructions(), parent)) {
                return (ModelComposite)parent;
            }
        }
        return mediator.getObstructions();
    }

    public static void doCopy(PyroMod srcContainer, Clipboard c, DataFlavor ... copyFlavors) {
        LOGGER.info("Copying...");
        Application.getApp().beginWaitCursor();
        IFilteredCollection<IPyroObject> sel = srcContainer.getSelectionModel().getSelected(IPyroObject.class);
        try {
            ObjectSelection os = Actions.copyObjects(srcContainer, sel, true, copyFlavors);
            c.setContents(os, os);
        }
        catch (IllegalStateException e) {
            PyroGuiUtil.showError(Application.getApp(), Intl.intl("Clipboard Unavailable"), Intl.intl("The clipboard is unavailable."), (Throwable)e);
        }
        catch (IOException e) {
            PyroGuiUtil.showError(Application.getApp(), Intl.intl("Cannot Copy Objects"), Intl.intl("Cannot copy selected objects."), (Throwable)e);
        }
        Application.getApp().endWaitCursor();
    }

    public static Set<DataFlavor> getSupportedCopyFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{PYRO_DATA_FLAVOR, FDS_DATA_FLAVOR};
        return new IdentityHashSet<DataFlavor>(Arrays.asList(flavors));
    }

    public static Set<DataFlavor> getSupportedPasteFlavors() {
        return Actions.getSupportedCopyFlavors();
    }

    public static ObjectSelection copyObjects(PyroMod container, Collection<? extends IPyroObject> objectsToCopy, boolean includeBridgeObjs, DataFlavor ... flavors) throws IOException {
        if (includeBridgeObjs) {
            IdentityHashSet<? extends IPyroObject> copySet = null;
            if (objectsToCopy instanceof Set) {
                copySet = (IdentityHashSet<? extends IPyroObject>)objectsToCopy;
            }
            boolean modified = false;
            ArrayList<IPyroObject> bridgedObjs = new ArrayList<IPyroObject>();
            for (IBridgeObj bridge : container.getBridges().flatten()) {
                bridgedObjs.clear();
                bridge.getBridgedObjects(bridgedObjs);
                if (bridgedObjs.isEmpty()) continue;
                if (bridge instanceof Leak) {
                    bridgedObjs.remove(container.getZoneMgr().getOuter());
                }
                if (copySet == null) {
                    copySet = new IdentityHashSet<IPyroObject>(objectsToCopy);
                }
                if (!Hierarchy.flattenComposites(copySet).containsAll(bridgedObjs)) continue;
                if (!modified) {
                    objectsToCopy = new ArrayList<IPyroObject>(objectsToCopy);
                }
                modified = true;
                ((List)objectsToCopy).add(bridge);
            }
        }
        PyroDataContainer pyroRenData = null;
        if (theUtil.contains(PYRO_DATA_FLAVOR, flavors)) {
            if (!(objectsToCopy instanceof Serializable)) {
                objectsToCopy = new ArrayList<IPyroObject>(objectsToCopy);
            }
            Collection<? extends IPyroObject> copy = theUtil.serialCopy(objectsToCopy);
            pyroRenData = new PyroDataContainer(copy);
        }
        String fdsRenData = null;
        if (theUtil.contains(FDS_DATA_FLAVOR, flavors)) {
            Collection<IPyroObject> fdsObjectsToCopy = Hierarchy.flatten(objectsToCopy, IPyroObject.class);
            FDSRenderer writer = FDS.newRenderer(container, PyroSim.getApp().getFDSRenderProps(), FDSRenderer.RENDER_ORIGIN.DEFAULT);
            writer.getProps().setRasterGridSupplier(objs -> theUtil.filter(container.getGridManager().flatten(), new EnabledFilter()));
            FDSStringRenderer rend = new FDSStringRenderer(writer.getProps());
            writer.renderObjects(rend, fdsObjectsToCopy, Collections.EMPTY_MAP);
            fdsRenData = rend.toString();
        }
        return new ObjectSelection(pyroRenData, fdsRenData, PYRO_DATA_FLAVOR);
    }

    public static void doCut(PyroMod srcContainer, Clipboard c) {
        Application.getApp().beginWaitCursor();
        Actions.doCopy(srcContainer, c, PYRO_DATA_FLAVOR);
        Actions.doDelete(srcContainer);
        Application.getApp().endWaitCursor();
    }

    public static guiAction getDefaultAction(PyroMod domain) {
        for (guiAction action : DEFAULT_ACTIONS) {
            if (!action.isEnabled()) continue;
            return action;
        }
        return null;
    }

    private static int countNonZero(int ... counts) {
        int num = 0;
        for (int count : counts) {
            if (count <= 0) continue;
            ++num;
        }
        return num;
    }

    public static void editSelectedNode() {
        PyroMod pyMod = ((PyroSim)Application.getApp()).getMediator();
        PyroSimSelectionModel selModel = pyMod.getSelectionModel();
        IFilteredCollection<IPyroObject> selModelObjs = selModel.getSelected(IPyroObject.class, IModelObj.class, ModelComposite.class);
        int selGrids = selModel.getNum(Grid.class);
        int selGridList = selModel.getNum(GridList.class);
        int selZones = selModel.getNum(Zone.class);
        int selZoneMgr = selModel.getNum(ZoneMgr.class);
        int selSurf = selModel.getNum(Surface.class);
        int selSurfMgr = selModel.getNum(SurfaceManager.class);
        int selExSpecs = selModel.getNum(ExSpec.class);
        int selExSpecList = selModel.getNum(ExSpecList.class);
        int selParticles = selModel.getNum(Particle.class);
        int selParticleList = selModel.getNum(ParticleList.class);
        int selReacs = selModel.getNum(Reaction.class);
        int selReacList = selModel.getNum(ReactionList.class);
        int selMatls = selModel.getNum(Material.class);
        int selMatlMgr = selModel.getNum(MaterialManager.class);
        int selDevices = selModel.getNum(IDevice.class);
        int selCtrls = selModel.getNum(ControlBridge.class);
        int selCtrlMgr = selModel.getNum(ControlMgr.class);
        int selStatMgr = selModel.getNum(StatisticMgr.class);
        int selStats = selModel.getNum(IMeasurementStat.class);
        int selSlcfMgr = selModel.getNum(SliceList.class);
        int selSlcf = selModel.getNum(PlanarSlice.class);
        int selSlcf3dMgr = selModel.getNum(Slice3dList.class);
        int selSlcf3d = selModel.getNum(VolumeSlice.class);
        int selHvacMgr = selModel.getNum(HvacList.class);
        int selHvac = selModel.getNum(IHvacObject.class);
        int selSectionBoxes = selModel.getNum(SectionBox.class);
        int selectedGroups = Actions.countNonZero(selModelObjs.size(), selGrids, selGridList, selZones, selZoneMgr, selSurf, selSurfMgr, selExSpecs, selExSpecList, selParticles, selParticleList, selReacs, selReacList, selMatls, selMatlMgr, selDevices, selCtrls, selCtrlMgr, selStatMgr, selStats, selSlcfMgr, selSlcf, selSlcf3dMgr, selSlcf3d, selHvac, selHvacMgr, selSectionBoxes);
        if (selectedGroups != 1) {
            return;
        }
        if (selGrids > 0) {
            Actions.doEditGrids((Grid)selModel.getSelected(Grid.class).iterator().next());
        } else if (selGridList > 0) {
            Actions.doEditGrids(null);
        } else if (selZones > 0) {
            Actions.editZones((Zone)selModel.getSelected(Zone.class).iterator().next());
        } else if (selZoneMgr > 0) {
            Actions.editZones(null);
        } else if (selSurf > 0) {
            Actions.editSurfaces((Surface)selModel.getSelected(Surface.class).iterator().next());
        } else if (selSurfMgr > 0) {
            Actions.editSurfaces(null);
        } else if (selExSpecs > 0) {
            Actions.editSpecies((ExSpec)selModel.getSelected(ExSpec.class).iterator().next());
        } else if (selExSpecList > 0) {
            Actions.editSpecies(null);
        } else if (selParticles > 0) {
            Actions.editParticles((Particle)selModel.getSelected(Particle.class).iterator().next());
        } else if (selParticleList > 0) {
            Actions.editParticles(null);
        } else if (selMatls > 0) {
            Actions.editMaterials((Material)selModel.getSelected(Material.class).iterator().next());
        } else if (selMatlMgr > 0) {
            Actions.editMaterials(null);
        } else if (selReacs > 0) {
            Actions.doEditReactions((Reaction)selModel.getSelected(Reaction.class).iterator().next());
        } else if (selReacList > 0) {
            Actions.doEditReactions(null);
        } else if (selDevices == 1) {
            Actions.editDevice((IDevice)selModel.getSelected(IDevice.class).iterator().next(), 0);
        } else if (selCtrlMgr > 0) {
            Actions.editControls(null);
        } else if (selCtrls > 0) {
            Actions.editControls((ControlBridge)selModel.getSelected(ControlBridge.class).iterator().next());
        } else if (selStatMgr > 0) {
            Actions.editStats(Collections.EMPTY_LIST);
        } else if (selStats > 0) {
            Actions.editStats(selModel.getSelected(IMeasurementStat.class));
        } else if (selSlcfMgr > 0) {
            Actions.editSlices(Collections.EMPTY_LIST);
        } else if (selSlcf > 0) {
            Actions.editSlices(selModel.getSelected(PlanarSlice.class));
        } else if (selSlcf3dMgr > 0) {
            Actions.edit3DSlices(Collections.EMPTY_LIST);
        } else if (selSlcf3d > 0) {
            Actions.edit3DSlices(selModel.getSelected(VolumeSlice.class));
        } else if (selHvacMgr > 0) {
            Actions.editHvac(Collections.emptyList());
        } else if (selHvac > 0) {
            Actions.editHvac(selModel.getSelected(IHvacObject.class));
        } else if (selSectionBoxes > 0) {
            Actions.editSectionBoxes(selModel.getSelected(SectionBox.class));
        } else if (!selModelObjs.isEmpty()) {
            IPyroObject parent = ((IPyroObject)selModelObjs.iterator().next()).getParent();
            if (!(parent instanceof ModelComposite)) {
                parent = pyMod.getObstructions();
            }
            ArrayList<IPyroObject> selObjs = new ArrayList<IPyroObject>(selModelObjs);
            ModelObjectDialog dlg = new ModelObjectDialog(Application.getApp().getMainFrame(), pyMod, selObjs, (ModelComposite)parent, 1);
            if (dlg.doModal() == 1) {
                dlg.saveValues(selModelObjs);
            }
        }
    }

    public static void editSimulationProperties() {
        SimulationPropertiesDlg dlg = new SimulationPropertiesDlg(Application.getApp().getMainFrame());
        if (dlg.doModal() == 1) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            SimulationTask tsk = new SimulationTask(mediator, dlg);
            mediator.getTaskManager().exec(tsk, Intl.intl("Edit Sim Params"));
        }
    }

    public static File exportToFile(Component parentComp, File defaultFile, PyroMod container, Collection<? extends IPyroObject> objsToExport, String parentPathPref) {
        PyroSim pySim = PyroSim.getApp();
        File selectedFile = Actions.getValidLibraryFileFromUser(parentComp, defaultFile, parentPathPref);
        if (selectedFile == null) {
            return null;
        }
        if (parentPathPref != null) {
            PyroSim.getApp().setLastDir(parentPathPref, selectedFile);
        }
        pySim.beginWaitCursor();
        try {
            FDSRenderer writer = FDS.newRenderer(container, PyroSim.getApp().getFDSRenderProps(), FDSRenderer.RENDER_ORIGIN.DEFAULT);
            writer.renderFile(selectedFile, objsToExport);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(parentComp, Intl.intl("The library file could not be written."), Intl.intl("Error"), 0);
            pySim.endWaitCursor();
            return null;
        }
        pySim.endWaitCursor();
        return selectedFile;
    }

    private static File getValidLibraryFileFromUser(Component parentComp, File defaultFile, String parentPathPref) {
        if (defaultFile == null) {
            defaultFile = new File("untitled.fds");
        } else if (defaultFile.getName().equals("database3.data") || defaultFile.getName().equals("database4.data")) {
            defaultFile = new File(defaultFile.getParent(), "untitled.fds");
        }
        ExampleFileFilter filter = new ExampleFileFilter("fds", "Database File");
        guiFileChooser chooser = new guiFileChooser(filter);
        chooser.setAcceptAllFileFilterUsed(true);
        if (defaultFile == null || defaultFile.exists() && parentPathPref != null) {
            chooser.setCurrentDirectory(((PyroSim)Application.getApp()).getLastDir(parentPathPref));
        }
        chooser.setSelectedFile(defaultFile);
        chooser.setFileFilter(filter);
        int selection = chooser.showSaveDialog(parentComp);
        if (selection != 0) {
            return null;
        }
        File selectedFile = chooser.getSelectedFile();
        if (!selectedFile.exists()) {
            try {
                selectedFile.createNewFile();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(parentComp, Intl.intl("The library file could not be written."), Intl.intl("Error"), 0);
                return null;
            }
        }
        return selectedFile;
    }

    public static boolean isObjectInUse(PyroMod pyroMod, final Collection<IPyroObject> objs, DepSnapshot deps) {
        if (deps == null) {
            deps = pyroMod.getDependencies(new IPyroObject[0]);
        }
        IdentityHashSet total = new IdentityHashSet();
        Predicate<Object> filter = new Predicate<Object>(){

            @Override
            public boolean test(Object o) {
                if (o instanceof IPyroObject) {
                    return ((IPyroObject)o).isEnabled() && !objs.contains(o) && o instanceof IDirectDependent;
                }
                return false;
            }
        };
        for (IPyroObject obj : objs) {
            deps.findAllDependents(filter, obj, total);
        }
        return !total.isEmpty();
    }

    public static PyroDataContainer getClipboardObjects(Transferable contents, PyroMod destMod) {
        PyroDataContainer data = null;
        try {
            data = (PyroDataContainer)contents.getTransferData(PYRO_DATA_FLAVOR);
            try {
                if (!data.isCurrentVersion()) {
                    data = null;
                    JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Cannot paste between dissimilar versions of PyroSim."), Intl.intl("Paste Error"), 2);
                }
            }
            catch (Exception e) {
                data = null;
                JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Cannot paste between dissimilar versions of PyroSim."), Intl.intl("Paste Error"), 2);
            }
        }
        catch (IOException ioe) {
            Application.getApp().error(new guiExceptionError(ioe));
        }
        catch (UnsupportedFlavorException udfe) {
            try {
                String clipboardText = (String)contents.getTransferData(FDS_DATA_FLAVOR);
                PyroMod emptyTempMod = new PyroMod();
                FDSParser file = FDS.newParser(6);
                FDSParseResult result = file.parseBuffer((CharSequence)clipboardText, emptyTempMod, destMod);
                if (!result.warningReport.showWarnings(false) && result.extractedObjs.isEmpty()) {
                    Toolkit.getDefaultToolkit().beep();
                    return null;
                }
                String unprocessed = emptyTempMod.getUnprocessedRecords();
                data = new PyroDataContainer(result.extractedObjs, unprocessed);
            }
            catch (IOException ioe) {
                Application.getApp().error(new guiExceptionError(ioe));
            }
            catch (UnsupportedFlavorException udfe2) {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (FDSParseException rfe) {
                Application.getApp().error(new guiExceptionError(rfe));
            }
        }
        return data;
    }

    public static void doTransfer(PyroMod srcDomain, PyroMod dstDomain, Collection<? extends IPyroObject> objs) throws IOException {
        try {
            UIPasteCallback callback = new UIPasteCallback(dstDomain);
            if (!(objs instanceof Serializable)) {
                objs = new ArrayList<IPyroObject>(objs);
            }
            Collection<? extends IPyroObject> copiedObjs = theUtil.serialCopy(objs);
            Actions.pasteObjects(dstDomain, copiedObjs, "", callback);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public static void doPaste(PyroMod destContainer, Clipboard clipboard, IPasteCallback org) {
        try {
            PyroDataContainer data = Actions.getClipboardObjects(clipboard.getContents(PyroSim.getApp()), destContainer);
            if (data != null) {
                Actions.pasteObjects(destContainer, data.getObjects(), data.getUnprocessedRecords(), org);
            }
        }
        catch (CancellationException e) {
            return;
        }
        catch (IllegalStateException e) {
            guiUtil.showError(PyroSim.getApp(), Intl.intl("Clipboard Unavailable."), Intl.intl("The clipboard is unavailable."), (Throwable)e);
        }
    }

    public static void pasteObjects(PyroMod destContainer, Collection<? extends IPyroObject> pasteObjs, String unprocessedRecords, IPasteCallback pasteCallback) {
        Task paste = Actions.taskPasteObjects((PyroMod)destContainer, pasteObjs, (String)unprocessedRecords, (int)1, (IPasteCallback)pasteCallback).task;
        boolean resetCamera = destContainer.getAllGeom().isEmpty();
        int options = resetCamera ? 2 : 0;
        destContainer.getTaskManager().exec(paste, Intl.intl("Paste"), options);
    }

    public static PasteInfo taskPasteObjects(PyroMod destContainer, Collection<? extends IPyroObject> pasteObjs, String unprocessedRecords, int options, IPasteCallback pasteCallback) {
        PasteInfo insertTask = Actions.taskInsertObjects(destContainer, pasteObjs, pasteCallback, options);
        CompositeTask<PyroMod> paste = new CompositeTask<PyroMod>(destContainer);
        paste.addTask(insertTask.task);
        paste.addTask(new InsertAdditionalRecordsTask(destContainer, unprocessedRecords));
        return new PasteInfo(paste, insertTask.commands);
    }

    private static boolean test(int options, int option) {
        return (options & option) == option;
    }

    public static PasteInfo taskInsertObjects(PyroMod mod, Collection<? extends IPyroObject> pasteObjs, IPasteCallback pasteCallback, int options) {
        if (pasteObjs.isEmpty()) {
            return new PasteInfo(EmptyTask.INSTANCE, Collections.EMPTY_MAP);
        }
        DepSnapshot ds = new DepSnapshot();
        for (IPyroObject iPyroObject : pasteObjs) {
            ds.takeSnapshot(iPyroObject);
        }
        Set<IPyroObject> implicitInserts = ds.getAllDependedOn();
        LinkedIdentityHashMap<IPyroObject, PasteCommand> linkedIdentityHashMap = new LinkedIdentityHashMap<IPyroObject, PasteCommand>();
        boolean explicitKeepExisting = Actions.test(options, 2);
        boolean implicitKeepExisting = !Actions.test(options, 4);
        Actions.queueInsertTasks(mod, pasteObjs, explicitKeepExisting, pasteCallback, linkedIdentityHashMap);
        Actions.queueInsertTasks(mod, implicitInserts, implicitKeepExisting, pasteCallback, linkedIdentityHashMap);
        PasteReactionCommand pasteCommandReac = Actions.queueSetReactionTask(mod, linkedIdentityHashMap, pasteCallback);
        Task task = Actions.convertInsertCommandsToTask(ds, mod, linkedIdentityHashMap);
        Task reacTask = Actions.convertReactionSelectionToTask(pasteCommandReac, mod);
        CompositeTask<PyroMod> taskQueue = new CompositeTask<PyroMod>(mod);
        taskQueue.addTask(task);
        taskQueue.addTask(reacTask);
        if (Actions.test(options, 1)) {
            ArrayDeque objsNoSubs = new ArrayDeque();
            for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
                if (((PasteCommand)entry.getValue()).command == 1) continue;
                objsNoSubs.add(entry.getKey());
            }
            SelectTask wrapper = new SelectTask(mod, objsNoSubs);
            wrapper.addTask(taskQueue);
            task = wrapper;
        }
        return new PasteInfo(task, linkedIdentityHashMap);
    }

    private static Task convertInsertCommandsToTask(DepSnapshot ds, PyroMod mod, Map<IPyroObject, PasteCommand> pasteCommands) {
        CompositeTask<PyroMod> insertQueue = new CompositeTask<PyroMod>(mod);
        for (IPyroObject dependedOn : ds.getAllDependedOn()) {
            PasteCommand dependedOnPasteCommand = pasteCommands.get(dependedOn);
            if (dependedOnPasteCommand == null || dependedOnPasteCommand.command != 1) continue;
            for (Dependency dep : ds.getDependents(dependedOn)) {
                insertQueue.addTask(DepUtil.getReplacementTask(ds, dep.source, dependedOn, (IPyroObject)dependedOnPasteCommand.param));
            }
        }
        DepSnapshot insertDeps = mod.getDependencies(new IPyroObject[0]);
        ArrayList<Task> renameTasks = new ArrayList<Task>();
        for (Map.Entry<IPyroObject, PasteCommand> entry : pasteCommands.entrySet()) {
            IPyroObject obj = entry.getKey();
            PasteCommand pc = entry.getValue();
            switch (pc.command) {
                case 2: {
                    TVEntryPoint<Object> ep = TVEntryPoints.ep(pc.pasteLoc);
                    IPyroObject repl = (IPyroObject)pc.param;
                    renameTasks.add(ep.paste(mod, pc.pasteLoc, obj, repl, TVEntryPoint.ConflictResolution.RENAME_NEW, insertDeps));
                    break;
                }
                case 0: {
                    TVEntryPoint<Object> ep = TVEntryPoints.ep(pc.pasteLoc);
                    IPyroObject repl = (IPyroObject)pc.param;
                    insertQueue.addTask(ep.paste(mod, pc.pasteLoc, obj, repl, TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING, insertDeps));
                    break;
                }
            }
        }
        for (Task renameTask : renameTasks) {
            insertQueue.addTask(renameTask);
        }
        return insertQueue;
    }

    private static Task convertReactionSelectionToTask(PasteReactionCommand cmd, PyroMod mod) {
        return mod.getReactions().taskSetActiveReactions(cmd.newActives);
    }

    private static void getPasteLocs(PyroMod pasteMod, Object parent, Collection<?> children, IPasteCallback pasteCallback, Map<Object, Object> pasteLocations, List<Object> pasteObjs) {
        for (Object child : children) {
            if (child == null || pasteLocations.containsKey(child)) continue;
            Object pasteLoc = parent;
            if (pasteLoc == null && (pasteLoc = pasteCallback.getPasteLocation(pasteMod, child)) == null) {
                System.err.println("Nowhere to paste " + child.getClass());
                continue;
            }
            if (child instanceof Composite) {
                Composite group = (Composite)child;
                Collection<IPyroObject> newChildren = group.getMembers();
                child = group.clone(false);
                pasteObjs.add(child);
                Actions.getPasteLocs(pasteMod, (Composite)child, newChildren, pasteCallback, pasteLocations, pasteObjs);
            } else {
                pasteObjs.add(child);
            }
            pasteLocations.put(child, pasteLoc);
        }
    }

    private static void queueInsertTasks(PyroMod insertDomain, Collection<? extends Object> objects, boolean keepExistingIfEqual, IPasteCallback pasteCallback, Map<IPyroObject, PasteCommand> pasteCommands) {
        IdentityHashMap<Object, Object> pasteLocations = new IdentityHashMap<Object, Object>(objects.size());
        ArrayList<Object> pasteObjs = new ArrayList<Object>(objects.size());
        Actions.getPasteLocs(insertDomain, null, objects, pasteCallback, pasteLocations, pasteObjs);
        for (Object e : pasteObjs) {
            Actions.queueInsertTasks(insertDomain, pasteLocations.get(e), e, keepExistingIfEqual, pasteCallback, pasteCommands);
        }
    }

    private static void queueInsertTasks(PyroMod insertDomain, Object pasteLoc, Object object, boolean keepExistingIfEqual, IPasteCallback org, Map<IPyroObject, PasteCommand> pasteCommands) {
        TVEntryPoint<Object> rootEP;
        IPyroObject existing;
        if (pasteCommands.containsKey(object)) {
            return;
        }
        assert (object instanceof IPyroObject);
        IPyroObject o = (IPyroObject)object;
        TVEntryPoint<IPyroObject> ep = TVEntryPoints.ep(o);
        Object root = ep.getCategoryRoot(insertDomain, o);
        if (root == null) {
            System.err.println("No category root for " + o.getClass());
        }
        IPyroObject iPyroObject = existing = (rootEP = TVEntryPoints.ep(root)) != null ? (IPyroObject)rootEP.getConflict(insertDomain, root, o) : null;
        if (existing == null) {
            pasteCommands.put(o, new PasteCommand(0, pasteLoc, null));
        } else if (keepExistingIfEqual && rootEP.isEquivalent(insertDomain, root, existing, o)) {
            pasteCommands.put(o, new PasteCommand(1, pasteLoc, existing));
        } else if (ep.canRename(insertDomain, o)) {
            pasteCommands.put(o, new PasteCommand(2, pasteLoc, existing));
        } else {
            IPyroObject mergedObj;
            if (ep.canMerge(insertDomain, o) && (mergedObj = ep.mergeToRoot(insertDomain, o)) != null) {
                pasteCommands.put(mergedObj, new PasteCommand(0, pasteLoc, existing));
                return;
            }
            PasteOverwrite replace = org.getReplaceModelObject(existing, o);
            switch (replace) {
                case KEEP_EXISTING: {
                    pasteCommands.put(o, new PasteCommand(1, pasteLoc, existing));
                    break;
                }
                case REPLACE_EXISTING: {
                    pasteCommands.put(o, new PasteCommand(0, pasteLoc, existing));
                }
            }
        }
    }

    private static PasteReactionCommand queueSetReactionTask(PyroMod mod, Map<IPyroObject, PasteCommand> pasteCommands, IPasteCallback callback) {
        Map<Reaction, PasteCommand> filteredCommandList = pasteCommands.entrySet().stream().filter(kvPair -> kvPair.getKey() instanceof Reaction).filter(kvPair -> ((PasteCommand)kvPair.getValue()).command != 1).collect(Collectors.toMap(kvPair -> (Reaction)kvPair.getKey(), Map.Entry::getValue));
        List<Reaction> oldActives = mod.getReactions().getActiveReactions();
        List<Reaction> newActives = callback.getActiveReactions(mod.getReactions().flatten(), filteredCommandList, oldActives);
        return new PasteReactionCommand(oldActives, newActives);
    }

    public static void doDelete(PyroMod srcContainer) {
        System.out.println("Deleting...");
        IFilteredCollection<IPyroObject> objs = srcContainer.getSelectionModel().getSelected(IPyroObject.class);
        Task t = Actions.getDeleteTask(srcContainer, objs);
        if (t == null) {
            return;
        }
        srcContainer.getTaskManager().exec(t, Intl.intl("Delete"));
    }

    private static void markNonDeletes(PyroMod domain, Collection<? extends IPyroObject> delObjs, Set<IPyroObject> nonDelObjs) {
        for (IPyroObject obj : Hierarchy.flatten(delObjs, IPyroObject.class)) {
            if (Util.canDelete(domain, obj)) continue;
            while (obj != null) {
                nonDelObjs.add(obj);
                obj = obj.getParent();
            }
        }
    }

    private static void collectDeletes(IPyroObject delObj, Set<IPyroObject> nonDelObjs, Set<IPyroObject> deletes) {
        if (nonDelObjs.contains(delObj)) {
            for (IPyroObject iPyroObject : delObj.getMembers()) {
                Actions.collectDeletes(iPyroObject, nonDelObjs, deletes);
            }
        } else {
            deletes.add(delObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Task getDeleteTask(PyroMod srcContainer, Collection<? extends IPyroObject> objs) {
        if (objs.isEmpty()) {
            return null;
        }
        Application.getApp().beginWaitCursor();
        try {
            IdentityHashSet<IPyroObject> incidentalDeletes;
            void var5_8;
            Map<IPyroObject, IPyroObject> replacements;
            IdentityHashSet<IPyroObject> nonDeletes = new IdentityHashSet<IPyroObject>();
            nonDeletes.addAll(srcContainer.getMembers());
            Actions.markNonDeletes(srcContainer, objs, nonDeletes);
            LinkedIdentityHashSet<IPyroObject> toDelete = new LinkedIdentityHashSet<IPyroObject>();
            for (IPyroObject iPyroObject : objs) {
                Actions.collectDeletes(iPyroObject, nonDeletes, toDelete);
            }
            assert (!toDelete.contains(null)) : "Attempting to delete null object. See case 28897.";
            if (toDelete.isEmpty()) {
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("Cannot delete selected objects."), Intl.intl("Cannot Delete"), 0);
                Iterator<? extends IPyroObject> iterator = null;
                return iterator;
            }
            LinkedIdentityHashSet<IPyroObject> toFindDeps = new LinkedIdentityHashSet<IPyroObject>(Hierarchy.flatten(toDelete, IPyroObject.class));
            Object var5_6 = null;
            for (IPyroObject obj : toFindDeps) {
                if (!TVEntryPoints.ep(obj).mayBeReferenced(srcContainer, obj)) continue;
                DepSnapshot depSnapshot = srcContainer.getDependencies(new IPyroObject[0]);
                break;
            }
            if ((replacements = Actions.getReplacementsFor(srcContainer, (DepSnapshot)var5_8, toFindDeps, incidentalDeletes = new IdentityHashSet<IPyroObject>())) == null) {
                Task task = null;
                return task;
            }
            LinkedIdentityHashSet finalDeleteSet = new LinkedIdentityHashSet();
            finalDeleteSet.addAll(toDelete);
            finalDeleteSet.addAll(incidentalDeletes);
            CompositeTask<PyroMod> result = new CompositeTask<PyroMod>(srcContainer);
            for (Map.Entry<IPyroObject, IPyroObject> repl : replacements.entrySet()) {
                assert (var5_8 != null);
                Set<Dependency> dependents = var5_8.getDependents(repl.getKey());
                for (Dependency dep : dependents) {
                    if (dep.source instanceof IPyroObject && toFindDeps.contains((IPyroObject)((Object)dep.source))) continue;
                    result.addTask(DepUtil.getReplacementTask((DepSnapshot)var5_8, dep.source, repl.getKey(), repl.getValue()));
                }
            }
            result.addTask(Tasks.delete(finalDeleteSet));
            CompositeTask<PyroMod> compositeTask = result;
            return compositeTask;
        }
        finally {
            PyroSim.getApp().endWaitCursor();
        }
    }

    public static Map<IPyroObject, IPyroObject> getReplacementsFor(PyroMod srcContainer, DepSnapshot deps, Set<IPyroObject> objects, Collection<IPyroObject> collectedIncidental) {
        if (objects.isEmpty() || deps == null) {
            return Collections.EMPTY_MAP;
        }
        Set<IPyroObject> allDelObjs = objects;
        LinkedIdentityHashMap<IPyroObject, IPyroObject> replacements = new LinkedIdentityHashMap<IPyroObject, IPyroObject>();
        while (!objects.isEmpty()) {
            LinkedIdentityHashSet<IPyroObject> incidentalDeletes = new LinkedIdentityHashSet<IPyroObject>();
            for (IPyroObject objToReplace : objects) {
                Set<Dependency> dependents = deps.getDependents(objToReplace);
                if (dependents.isEmpty()) continue;
                IPyroObject root = Hierarchy.getCategoryRoot(objToReplace);
                assert (root != null);
                LinkedIdentityHashSet<IPyroObject> availableReplacements = new LinkedIdentityHashSet<IPyroObject>(Hierarchy.flattenComposites(Arrays.asList(root)));
                availableReplacements.add(null);
                availableReplacements.removeAll(objects);
                for (Dependency dep : dependents) {
                    if (dep.link == DLink.REQUIRED) {
                        availableReplacements.remove(null);
                    }
                    dep.source.removeInvalidReplacements(objToReplace, availableReplacements);
                }
                if (availableReplacements.isEmpty()) {
                    JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), String.format(Intl.intl("Cannot delete %s.  It is currently in use."), Util.getName(objToReplace)), Intl.intl("Delete Error"), 2);
                    return null;
                }
                String typeDesc = TVEntryPoints.ep(objToReplace).getCategoryName();
                IPyroObject replacement = null;
                if (availableReplacements.size() == 1) {
                    replacement = (IPyroObject)availableReplacements.iterator().next();
                    String message = replacement == null ? String.format(Intl.intl("%s references will be removed.  Would you like to continue?"), Util.getName(objToReplace)) : String.format(Intl.intl("References to %s will be replaced with %s.  Would you like to continue?"), Util.getName(objToReplace), Util.getName(replacement));
                    int choice = JOptionPane.showConfirmDialog(PyroSim.getApp().getMainFrame(), message, String.format(Intl.intl("%s Replacement"), typeDesc), 0);
                    if (choice != 0) {
                        return null;
                    }
                } else {
                    ReplaceDlg<IPyroObject> dlg = new ReplaceDlg<IPyroObject>(typeDesc, objToReplace, availableReplacements);
                    if (dlg.doModal() != 1) {
                        return null;
                    }
                    replacement = dlg.getReplacer();
                }
                replacements.put(objToReplace, replacement);
                if (replacement != null) continue;
                for (Dependency dep : dependents) {
                    if (dep.link != DLink.STRONG || !(dep.source instanceof IPyroObject) || objects.contains((IPyroObject)((Object)dep.source)) || !Util.canDelete(srcContainer, dep.source)) continue;
                    incidentalDeletes.add((IPyroObject)((Object)dep.source));
                }
            }
            allDelObjs.addAll(incidentalDeletes);
            collectedIncidental.addAll(incidentalDeletes);
            objects = incidentalDeletes;
        }
        return replacements;
    }

    private static void showBoundaryConditionsDialog() {
        PyroMod model;
        JFrame mainFrame = Application.getApp().getMainFrame();
        BoundariesDlg bndfDlg = new BoundariesDlg(mainFrame, model = PyroSim.getApp().getMediator());
        if (bndfDlg.doModal() == 1) {
            model.getTaskManager().exec(bndfDlg.taskSaveValues(), Intl.intl("Edit Boundary Quantities"));
        }
    }

    private static void showPlot3DDialog() {
        JFrame mainFrame = Application.getApp().getMainFrame();
        PyroMod model = PyroSim.getApp().getMediator();
        Plot3dDlg pl3DDialog = new Plot3dDlg(mainFrame, Intl.intl("Plot3D Data"), model.getPlot3d(), 5, PyroPrefs.LastPl3dDlgSizeX, PyroPrefs.LastPl3dDlgSizeY);
        if (pl3DDialog.doModal() == 1) {
            model.getTaskManager().exec(pl3DDialog.taskSaveValues(), Intl.intl("Edit Plot3D Output"));
        }
    }

    private static void edit3DSlices(Collection<? extends VolumeSlice> slices) {
        Slcf3dDialog dialog = new Slcf3dDialog(Application.getApp().getMainFrame());
        dialog.setInitialSel(slices);
        dialog.doModal();
    }

    private static void editSlices(Collection<? extends PlanarSlice> slices) {
        SlcfDialog slcf = new SlcfDialog(Application.getApp().getMainFrame());
        slcf.setInitialSel(slices);
        slcf.doModal();
    }

    private static void editHvac(Collection<? extends IHvacObject> hvacs) {
        PyroSim pySim = (PyroSim)Application.getApp();
        PyroMod pyMod = pySim.getMediator();
        HvacManagerDlg dlg = new HvacManagerDlg(pySim.getMainFrame(), pyMod, pySim.getUnitSystem());
        IHvacObject init = !hvacs.isEmpty() ? hvacs.iterator().next() : null;
        dlg.init(pyMod.getHvacList(), init);
        dlg.doModal();
    }

    private static void editSectionBoxes(Collection<? extends SectionBox> boxes) {
        PyroSim pySim = (PyroSim)Application.getApp();
        PyroMod pyMod = pySim.getMediator();
        SectionBoxDlg dlg = new SectionBoxDlg((Window)pySim.getMainFrame(), boxes);
        if (dlg.doModal() == 1) {
            Task task = dlg.taskSave(boxes);
            pyMod.getTaskManager().exec(task, Intl.intl("Edit Section Boxes"));
        }
    }

    public static void editParticles(Particle defSel) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        ParticleManagerDlg dlg = new ParticleManagerDlg(pySim.getMainFrame());
        dlg.init(pyMod.getPartList(), defSel);
        dlg.doModal();
    }

    public static void editSmokeLinkModels(SmokeLinkModel defaultSel) {
        PyroSim pySim = (PyroSim)Application.getApp();
        JFrame frm = pySim.getMainFrame();
        PyroMod pyMod = pySim.getMediator();
        SmokeLinkModelMgrDlg dlg = new SmokeLinkModelMgrDlg(frm);
        dlg.init(pyMod.getSmokeLinkModels(), defaultSel);
        dlg.doModal();
    }

    public static void editSpecies(ExSpec defaultSel) {
        PyroSim pySim = (PyroSim)Application.getApp();
        JFrame frm = pySim.getMainFrame();
        PyroMod pyMod = pySim.getMediator();
        ExSpecList exSpecList = pyMod.getExSpecList();
        ExSpecManagerDlg dlg = new ExSpecManagerDlg(frm);
        dlg.init(exSpecList, defaultSel);
        dlg.doModal();
    }

    public static boolean isValidSpecies(ExSpec spec) {
        if (spec == null) {
            return false;
        }
        ExSpecList specList = ((PyroSim)Application.getApp()).getMediator().getExSpecList();
        if (specList.get(spec.getName()) != null) {
            return true;
        }
        return ExSpecList.isPredefinedSpecies(spec.getName());
    }

    private static void editStats(Collection<? extends IMeasurementStat> stats) {
        PyroSim pySim = PyroSim.getApp();
        JFrame frm = pySim.getMainFrame();
        PyroMod pyMod = pySim.getMediator();
        StatisticsDlg dlg = new StatisticsDlg(frm);
        IMeasurementStat init = stats.isEmpty() ? null : stats.iterator().next();
        dlg.init(pyMod.getMsrStatMgr(), init);
        dlg.doModal();
    }

    public static File getResultsDir(PyroSim app) {
        File fdsFile = Actions.getFDSFile(app);
        return fdsFile == null ? null : fdsFile.getParentFile();
    }

    public static File getFDSFile(PyroSim app) {
        PyroMod pyMod = app.getMediator();
        FDSRun lastRun = pyMod.getLastFDSRun();
        if (lastRun.fdsFilepath != null) {
            return new File(lastRun.fdsFilepath);
        }
        if (app.getFilename() != null) {
            File pyroFile = new File(app.getFilename());
            return FdsIoUtil.getDefaultFDSInputFile(pyMod, pyroFile);
        }
        return null;
    }

    public static File[] getFDSFiles(PyroSim app) {
        File fdsFile = Actions.getFDSFile(app);
        if (fdsFile == null) {
            return null;
        }
        return FdsIoUtil.getFDSFiles(fdsFile);
    }

    private static File getDefaultResultsDir(PyroMod pyMod, File pyrosimFile) {
        return FdsIoUtil.getDefaultFDSInputFile(pyMod, pyrosimFile).getParentFile();
    }

    public static boolean hasResults(File resultsDir) {
        return resultsDir != null && resultsDir.exists() && resultsDir.isDirectory() && IOUtil.listFiles(resultsDir).size() > 0;
    }

    private static void archiveResults(File srcResultsDir) throws CancelledException {
        if (!Actions.hasResults(srcResultsDir)) {
            JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("There are no results to archive."), Intl.intl("No results"), 2);
            return;
        }
        PyroSim app = PyroSim.getApp();
        ArchiveResultsDlg dlg = new ArchiveResultsDlg((Window)app.getActiveFrame());
        String suggestedName = Actions.suggestArchiveName(app.getMediator(), app.getFilename());
        dlg.setName(suggestedName);
        if (dlg.doModal() != 1) {
            throw new CancelledException();
        }
        String name = dlg.getName();
        ResultsArchive.IMethod method = dlg.getMethod();
        boolean keepCurrentResults = dlg.getRetainCurrentResults();
        Object options = dlg.getOptions();
        try {
            File pyroFile = new File(app.getFilename());
            method.archive(srcResultsDir, pyroFile.getParentFile(), name, keepCurrentResults, options);
            ResultsArchive.Record rec = new ResultsArchive.Record(name, method, Calendar.getInstance().getTimeInMillis());
            PyroSim.getApp().getMediator().getResultsArchive().addArchive(rec);
        }
        catch (IOException e) {
            Actions.showArchiveIOException(e);
            throw new CancelledException();
        }
    }

    private static void showArchiveIOException(IOException e) {
        Actions.showIOException(e, Intl.intl("Could not create archive."));
    }

    private static void showRestoreIOException(IOException e) {
        Actions.showIOException(e, Intl.intl("Could not restore archive."));
    }

    public static void showIOException(IOException e, String baseMsg) {
        JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), baseMsg + "\n" + e.getClass().getSimpleName() + ": " + e.getLocalizedMessage(), Intl.intl("File Error"), 0);
    }

    private static String suggestArchiveName(PyroMod pyMod, String psmFile) {
        String baseName;
        String chid = FDSRenderer.generateChid(new File(psmFile).getName(), FDSRenderer.getDefaultScenarioNameForChid(pyMod.getScenarios()));
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        String suggestedName = baseName = String.format("%s_results_%d_%02d_%02d", chid, year, month + 1, day);
        File dir = new File(psmFile).getParentFile();
        int id = 1;
        while (Actions.archiveNameExists(dir, suggestedName)) {
            suggestedName = baseName + "_" + id++;
        }
        return suggestedName;
    }

    private static boolean archiveNameExists(File dir, String name) {
        for (ResultsArchive.IMethod method : ResultsArchive.ALL_METHODS) {
            if (!method.exists(dir, name)) continue;
            return true;
        }
        return false;
    }

    private static <T extends IDevice> DeviceDlg<T> newDevcDlg(Class<T> type, Function<PyroMod, ? extends IDevcEditor<T>> edFactory) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        IDevcEditor<T> editor = edFactory.apply(pyMod);
        if (editor == null) {
            System.err.println("No device editor for " + type);
            return null;
        }
        return new DeviceDlg<T>(pySim.getActiveFrame(), pyMod, type, editor);
    }

    public static <T extends IDevice> void editDevice(final T devc, int hvacType) {
        final DeviceDlg<?> dlg = Actions.newDevcDlg(devc.getClass(), mod -> {
            IDevcEditor<?> editor = DevcEditorFactory.create(mod, devc.getClass(), IDevcEditor.Mode.EDIT, hvacType);
            return editor;
        });
        if (dlg == null) {
            return;
        }
        PyroSim pySim = PyroSim.getApp();
        final PyroMod pyMod = pySim.getMediator();
        dlg.load(devc);
        if (dlg.doModal() == 1) {
            AOneTimeTask t = new AOneTimeTask(){

                @Override
                public void run() {
                    pyMod.pauseUpdates();
                    dlg.save(devc);
                    pyMod.resumeUpdates();
                }
            };
            pyMod.getTaskManager().exec(t, Intl.intl("Edit Device"));
        }
    }

    private static Task uiConvertToHvac(PyroSim app, PyroMod domain, Collection<? extends Vent> vents, Supplier<Boolean> convertAnswer) {
        boolean containsNonHVAC = vents.stream().anyMatch(v -> !v.getSurface().isPredefined(PredefSurf.HVAC));
        if (containsNonHVAC) {
            boolean convert = convertAnswer.get();
            Surface hvacSurf = domain.getSurfaceMgr().get(PredefSurf.HVAC);
            if (convert) {
                CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(PyroSim.getApp().getMediator());
                VentSurfSnapshot hvacSnapshot = new VentSurfSnapshot(hvacSurf, null);
                for (Vent vent : vents) {
                    if (vent.getSurface().isPredefined(PredefSurf.HVAC)) continue;
                    task.addTask(new ConvertToHvacTask(vent, hvacSnapshot));
                }
                return task;
            }
        }
        return EmptyTask.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IObstruction> Collection<T> validateGEOM(Window parent, Collection<T> obstructions) {
        if (obstructions.isEmpty() || !PyroPrefs.getBoolean(PyroPrefs.VALIDATE_GEOM)) {
            return obstructions;
        }
        TaskProgress progress = new TaskProgress();
        progress.reset(obstructions.size());
        guiProgressMonitor pmonitor = new guiProgressMonitor(parent, Intl.intl("Validating GEOM objects"), true, progress, 500, true);
        pmonitor.begin();
        try {
            List filtered;
            if (!(obstructions instanceof ArrayList)) {
                obstructions = new ArrayList<T>(obstructions);
            }
            if ((filtered = obstructions.parallelStream().filter(obst -> {
                boolean valid = pyrosim.domain.GeomUtil.validateGEOM(obst);
                progress.incrementAndCheck(1);
                return valid;
            }).collect(Collectors.toList())).size() == obstructions.size()) {
                Collection<T> collection = obstructions;
                return collection;
            }
            int invalidCount = obstructions.size() - filtered.size();
            String msg = "";
            msg = filtered.isEmpty() && obstructions.size() == 1 ? Intl.intl("The selected obstruction appears to be invalid to write as GEOM.\nDo you want to write it as GEOM anyway?") : (invalidCount == 1 ? Intl.intl("One of the selected obstructions appears to be invalid to write as GEOM.\nDo you want to write it as GEOM anyway?") : String.format(Intl.intl("%d of the selected obstructions appear to be invalid to write as GEOM.\nDo you want to write them as GEOM anyway?"), invalidCount));
            pmonitor.end();
            int option = JOptionPane.showConfirmDialog(parent, msg, Intl.intl("Write as GEOM?"), 1, 3);
            if (option == 0) {
                Collection<T> collection = obstructions;
                return collection;
            }
            if (option == 1) {
                List list = filtered;
                return list;
            }
            Collection<T> collection = null;
            return collection;
        }
        catch (CancellationException e) {
            Collection<T> collection = null;
            return collection;
        }
        finally {
            pmonitor.end();
        }
    }

    public static Action getImportDXFAction() {
        return IMPORT_ACTION;
    }

    public static Action getProtectAction() {
        return PROTECT_ACTION;
    }

    public static Action getTranslateAction() {
        return TRANSLATE_ACTION;
    }

    public static Action getMirrorAction() {
        return MIRROR_ACTION;
    }

    public static Action getScaleAction() {
        return SCALE_ACTION;
    }

    public static Action getRotateAction() {
        return ROTATE_ACTION;
    }

    public static Action getGridAction() {
        return GRID_ACTION;
    }

    public static Action getSubdivideMeshAction() {
        return SPLIT_MESH_ACTION;
    }

    public static Action getRefineMeshAction() {
        return REFINE_MESH_ACTION;
    }

    public static Action getMergeMeshAction() {
        return MERGE_MESH_ACTION;
    }

    public static AddWallAction getAddWallAction() {
        return ADD_WALL_ACTION;
    }

    public static AddVentAction getAddVentAction() {
        return ADD_VENT_ACTION;
    }

    public static AddSlabAction getAddSlabAction() {
        return ADD_SLAB_ACTION;
    }

    public static AAddPartCloudAction getAddPartCloudAction() {
        return ADD_PART_CLOUD_ACTION;
    }

    public static AddHoleAction getAddHoleAction() {
        return ADD_HOLE_ACTION;
    }

    public static RasterizeObjectsAction getRasterizeAction() {
        return RASTERIZE_OBJECTS_ACTION;
    }

    public static Action getUndoAction() {
        return UNDO_ACTION;
    }

    public static Action getRedoAction() {
        return REDO_ACTION;
    }

    public static guiAction getCopyAction() {
        return COPY_ACTION;
    }

    public static Action getCopyFDSAction() {
        return COPY_FDS_ACTION;
    }

    public static guiAction getCutAction() {
        return CUT_ACTION;
    }

    public static RemoveSelectedNodeAction getDeleteAction() {
        return REMOVE_SELECTED_NODE_ACTION;
    }

    public static EditSelectedNodeAction getEditNodeAction() {
        return EDIT_SELECTED_NODE_ACTION;
    }

    public static Action getEnableNodeAction() {
        return ENABLE_NODE_ACTION;
    }

    public static Action getDisableNodeAction() {
        return DISABLE_NODE_ACTION;
    }

    public static Action getHideNodeAction() {
        return HIDE_NODE_ACTION;
    }

    public static Action getHideUnselectedNodeAction() {
        return HIDE_UNSELECTED_NODE_ACTION;
    }

    public static guiAction getPasteAction() {
        return PASTE_ACTION;
    }

    public static Action getShowAllNodesAction() {
        return SHOW_ALL_NODES_ACTION;
    }

    public static Action getShowNodeAction() {
        return SHOW_NODE_ACTION;
    }

    public static AddFloorFromGeomAction getAddFloorFromGeomAction() {
        return ADD_FLOOR_FROM_GEOM_ACTION;
    }

    public static OpenGridsAction getOpenGridsAction() {
        return OPEN_GRIDS_ACTION;
    }

    public static MaterialManagerAction getMaterialManagerAction() {
        return MATERIAL_MANAGER_ACTION;
    }

    public static SurfaceManagerAction getSurfaceManagerAction() {
        return SURFACE_MANAGER_ACTION;
    }

    public static ReactionManagerAction getReactionManagerAction() {
        return REACTION_MANAGER_ACTION;
    }

    public static SprayModelManagerAction getSprayModelManagerAction() {
        return SPRAY_MODEL_MANAGER_ACTION;
    }

    public static SprinklerLinkModelManagerAction getSprinklerLinkModelManagerAction() {
        return SPRINKLER_LINK_MODEL_MANAGER_ACTION;
    }

    public static HeatLinkModelManagerAction getHeatLinkModelManagerAction() {
        return HEAT_LINK_MODEL_MANAGER_ACTION;
    }

    public static SelectByColorAction getSelectByColorAction() {
        return SELECT_BY_COLOR_ACTION;
    }

    public static SelectByBIMTypeAction getSelectByBimAction() {
        return SELECT_BY_BIM_TYPE_ACTION;
    }

    public static Action getResultsPreviewAction() {
        return RESULTS_PREVIEW_ACTION;
    }

    public static Action getEditSimulationPropertiesAction() {
        return EDIT_SIMULATION_PROPERTIES_ACTION;
    }

    public static BoundaryQuantityAction getBoundaryConditionAction() {
        return BOUNDARYQUANTITY_ACTION;
    }

    public static IsosurfaceAction getIsosurfaceAction() {
        return ISOSURFACE_ACTION;
    }

    public static Plot3DAction getPlot3DAction() {
        return PLOT3D_ACTION;
    }

    public static SliceAction getSliceAction() {
        return SLICE_ACTION;
    }

    public static Slice3DAction getSlice3DAction() {
        return SLICE3D_ACTION;
    }

    public static ProfListAction getProfListAction() {
        return PROF_ACTION;
    }

    public static ParticleAction getParticleAction() {
        return PARTICLE_ACTION;
    }

    public static SmodLinkModelsAction getSmokeDetectorModelsAction() {
        return SMOD_MODELS_ACTION;
    }

    public static Action getSortAction() {
        return SORT_ACTION;
    }

    public static Action getTCPlotsAction() {
        return TC_PLOTS_ACTION;
    }

    public static Action getExSpecListAction() {
        return EXSPEC_LIST_ACTION;
    }

    public static Action getHvacListAction() {
        return EDIT_HVAC;
    }

    public static Action getCrashAction() {
        return CRASH_PYROSIM;
    }

    public static Action getEditOpenMpAction() {
        return EDIT_OPENMP_ACTION;
    }

    public static Action getFindAction() {
        return FIND_ACTION;
    }

    public static Action getNewViewAction() {
        return GLOBAL_ADD_VIEW;
    }

    public static Action getNewSectionBoxAction() {
        return GLOBAL_ADD_SECTION_BOX;
    }

    public static Action getResetSectionBoxAction() {
        return GLOBAL_RESET_SECTION_BOX;
    }

    public static Action getSaveViewpointAction() {
        return GLOBAL_SAVE_VIEW_CAMERA;
    }

    public static Action getResetViewpointAction() {
        return GLOBAL_SHOW_VIEW_CAMERA;
    }

    static {
        DEFAULT_ACTIONS = Arrays.asList(SET_ACTIVE_VIEW_ACTION, CONTEXT_SHOW_VIEW_CAMERA, EDIT_SELECTED_NODE_ACTION);
    }

    private static class EditOpenMpAction
    extends guiAction {
        private static final long serialVersionUID = 1903040629493204595L;

        public EditOpenMpAction() {
            super(Intl.intl("OpenMP Environment..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            SimParams sp = pyMod.getSimParams();
            OpenMpDlg dlg = new OpenMpDlg((Window)PyroSim.getApp().getMainFrame());
            dlg.initFrom(sp.getOpenMp());
            if (dlg.doModal() == 1) {
                Task tsk = dlg.getSaveTask(sp.getOpenMp());
                pyMod.getTaskManager().exec(tsk, Intl.intl("Edit OpenMP Environment"));
            }
        }
    }

    private static class FindObjectsAction
    extends guiAction {
        private static final long serialVersionUID = -6112121873537434014L;

        public FindObjectsAction() {
            super(Intl.intl("Find Objects"), PyroGuiUtil.loadPyroSimIcon(null));
            this.putValue("ShortDescription", Intl.intl("Find objects matching a search string"));
            this.putValue("AcceleratorKey", Accelerators.FIND);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PyroSim app = PyroSim.getApp();
            PyroFindDlg find = new PyroFindDlg((Window)app.getActiveFrame(), app.getMediator());
            find.doModeless();
        }
    }

    private static class SetObstOptionAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public SetObstOptionAction(String name, int options, boolean state) {
            super(name, (ActionEvent e) -> {
                PyroMod mod = PyroSim.getApp().getMediator();
                Collection<IObstruction> selObsts = new ArrayList<IObstruction>(mod.getSelectionModel().flatten(IObstruction.class));
                if (state && (options & 0x80) != 0) {
                    IFilteredCollection<IObstruction> modifiedGEOMObsts = theUtil.filter(selObsts, obst -> !obst.getOptions(128));
                    Collection<IObstruction> validated = Actions.validateGEOM(Application.getApp().getActiveFrame(), modifiedGEOMObsts);
                    if (validated == null || validated.isEmpty()) {
                        return;
                    }
                    selObsts = validated;
                }
                SetObstOptionsTask task = new SetObstOptionsTask(selObsts, options, state);
                mod.getTaskManager().exec(task, name);
            });
            this.setEnabledUpdator(() -> {
                PyroMod mod = PyroSim.getApp().getMediator();
                Collection<IObstruction> obsts = mod.getSelectionModel().flatten(IObstruction.class);
                return obsts.stream().anyMatch(o -> o.getOptions(options) != state);
            });
        }
    }

    private static class SetObstOptionsTask
    extends AUndoableTask {
        public final Collection<? extends IObstruction> obsts;
        public final int options;
        public final boolean state;
        private int[] d_prevOptions = null;

        public SetObstOptionsTask(Collection<? extends IObstruction> obsts, int options, boolean state) {
            this.obsts = obsts;
            this.options = options;
            this.state = state;
        }

        @Override
        public void run() {
            if (this.obsts.isEmpty()) {
                return;
            }
            PyroMod domain = (PyroMod)this.obsts.iterator().next().getDomain();
            if (domain != null) {
                domain.pauseUpdates();
            }
            this.d_prevOptions = new int[this.obsts.size()];
            int ix = 0;
            for (IObstruction iObstruction : this.obsts) {
                this.d_prevOptions[ix++] = iObstruction.getSetOptions();
                iObstruction.setOptions(this.options, this.state);
            }
            if (domain != null) {
                domain.resumeUpdates();
            }
        }

        @Override
        public void undo() {
            if (this.obsts.isEmpty()) {
                return;
            }
            PyroMod domain = (PyroMod)this.obsts.iterator().next().getDomain();
            if (domain != null) {
                domain.pauseUpdates();
            }
            int ix = 0;
            for (IObstruction iObstruction : this.obsts) {
                iObstruction.setOptions(253, false);
                iObstruction.setOptions(this.d_prevOptions[ix++], true);
            }
            this.d_prevOptions = null;
            if (domain != null) {
                domain.resumeUpdates();
            }
        }
    }

    private static class ConnectWithHvac
    extends guiAction {
        private static final long serialVersionUID = -3466016507346646669L;

        public ConnectWithHvac() {
            super(Intl.intl("Connect with HVAC..."));
            this.putValue("ShortDescription", Intl.intl("Adds HVAC nodes and connects with an HVAC duct"));
        }

        public Collection<Vent> getObjs(PyroMod mod) {
            return mod.getSelectionModel().getSelected(Vent.class);
        }

        public void updateEnabled(PyroMod mod) {
            IFilteredCollection<Vent> vents = mod.getSelectionModel().getSelected(Vent.class);
            boolean enabled = vents.isExclusive() && vents.size() == 2;
            this.setEnabled(enabled);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mod = PyroSim.getApp().getMediator();
            ArrayList<Vent> vents = new ArrayList<Vent>(this.getObjs(mod));
            assert (vents.size() == 2);
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(PyroSim.getApp().getMediator());
            try {
                Task convertTask = Actions.uiConvertToHvac(PyroSim.getApp(), mod, vents, () -> {
                    String msg = Intl.intl("The vents in the selection will be converted to compatible HVAC vents.");
                    int option = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), msg, Intl.intl("Convert to HVAC Vents"), 2, 2);
                    if (option == 0) {
                        return true;
                    }
                    throw new CancellationException();
                });
                task.addTask(convertTask);
            }
            catch (CancellationException exc) {
                return;
            }
            NameGenerator nodeNames = mod.getNames(HvacNode.class);
            List<String> newNodeNames = nodeNames.generateNames(2);
            HvacNode node1 = ConnectWithHvac.newNode(newNodeNames.get(0), (Vent)vents.get(0));
            HvacNode node2 = ConnectWithHvac.newNode(newNodeNames.get(1), (Vent)vents.get(1));
            HvacDuct duct = new HvacDuct(mod.getNames(HvacDuct.class).generateName());
            duct.setNodes(node1, node2);
            IPyroObject parentObj = Hierarchy.getCommonParent(vents);
            Composite parent = parentObj instanceof Composite ? (Composite)parentObj : mod.getObstructions();
            task.addTask(new AddAutoRenameTask(parent, new IPyroObject[]{node1, node2, duct}));
            task.addTask(new SelectTask(mod, duct));
            mod.getTaskManager().exec(task, Intl.intl("Connect with HVAC"));
            Actions.editSelectedNode();
        }

        private static HvacNode newNode(String name, Vent vent) {
            HvacNode node = new HvacNode(name);
            node.setVent(vent);
            return node;
        }
    }

    private static class VentSurfSnapshot {
        private final Surface d_surf;
        private final Vent.OpenProps d_openProps;

        public VentSurfSnapshot(Vent vent) {
            this.d_surf = vent.getSurface();
            this.d_openProps = vent.getOpenProps();
        }

        public VentSurfSnapshot(Surface surf, Vent.OpenProps openProps) {
            this.d_surf = surf;
            this.d_openProps = openProps;
        }

        public void apply(Vent vent) {
            vent.setSurface(this.d_surf);
            vent.setOpenProps(this.d_openProps);
        }
    }

    private static class ConvertToHvacTask
    extends AReplaceRefTask<VentSurfSnapshot> {
        private final Vent d_vent;

        public ConvertToHvacTask(Vent vent, VentSurfSnapshot hvacSnapshot) {
            super(new VentSurfSnapshot(vent), hvacSnapshot);
            this.d_vent = vent;
        }

        @Override
        protected void set(VentSurfSnapshot obj) {
            obj.apply(this.d_vent);
        }
    }

    private static class AddHvacVentNode
    extends guiAction {
        private static final long serialVersionUID = 3934500793661271882L;

        public AddHvacVentNode() {
            super(Intl.intl("Add HVAC Nodes..."));
            this.putValue("ShortDescription", Intl.intl("Add an HVAC vent node"));
        }

        @Override
        public void updateEnabled() {
            PyroMod domain = PyroSim.getApp().getMediator();
            this.setEnabled(!domain.getSelectionModel().flatten(Vent.class).isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod domain = PyroSim.getApp().getMediator();
            Collection<Vent> vents = domain.getSelectionModel().flatten(Vent.class);
            if (vents.isEmpty()) {
                return;
            }
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(PyroSim.getApp().getMediator());
            try {
                Task convertTask = Actions.uiConvertToHvac(PyroSim.getApp(), domain, vents, () -> {
                    String msg = Intl.intl("Nodes can only be added for HVAC vents. Would you like to\nconvert all vents in the selection to compatible vents?");
                    int option = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), msg, Intl.intl("Convert to HVAC Vents?"), 1, 3);
                    if (option == 0) {
                        return true;
                    }
                    if (option == 1) {
                        return false;
                    }
                    throw new CancellationException();
                });
                if (convertTask == EmptyTask.INSTANCE) {
                    vents = new ArrayList<Vent>(theUtil.filter(vents, new Predicate<Vent>(){

                        @Override
                        public boolean test(Vent o) {
                            return o.getSurface().isPredefined(PredefSurf.HVAC);
                        }
                    }));
                } else {
                    task.addTask(convertTask);
                }
            }
            catch (CancellationException exc) {
                return;
            }
            ArrayList<HvacNode> newNodes = new ArrayList<HvacNode>(vents.size());
            List<String> nodeNames = domain.getNames(HvacNode.class).generateNames(vents.size());
            int m = 0;
            for (Vent vent : vents) {
                String name = nodeNames.get(m++);
                HvacNode newNode = new HvacNode(name);
                newNode.setVent(vent);
                newNodes.add(newNode);
            }
            IPyroObject parentObj = Hierarchy.getCommonParent(vents);
            Composite parent = parentObj instanceof Composite ? (Composite)parentObj : domain.getObstructions();
            task.addTask(new AddAutoRenameTask(parent, newNodes));
            domain.getTaskManager().exec(task, Intl.intl("Add HVAC Vent Nodes"));
        }
    }

    private static class EditHvac
    extends guiAction {
        private static final long serialVersionUID = 7114950057820074299L;
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("hvac_fan16.png");

        public EditHvac() {
            super(Intl.intl("Edit HVAC..."), ICON);
            this.putValue("ShortDescription", Intl.intl("Edit an HVAC Component"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.editHvac(Collections.EMPTY_LIST);
        }
    }

    private static class NewDeviceAction<T extends IDevice>
    extends guiAction {
        private static final long serialVersionUID = -2753847817063318197L;
        private final Class<T> d_class;
        private final Function<PyroMod, ? extends IDevcEditor<T>> d_editor;

        public NewDeviceAction(String title, Class<T> type, int hvacType) {
            this(title, type, null, hvacType);
        }

        public NewDeviceAction(String title, Class<T> type, Icon icon, int hvacType) {
            this(title, type, icon, mod -> {
                IDevcEditor editor = DevcEditorFactory.create(mod, type, IDevcEditor.Mode.CREATE, hvacType);
                return editor;
            });
        }

        public NewDeviceAction(String title, Class<T> type, Icon icon, Function<PyroMod, ? extends IDevcEditor<T>> editor) {
            super(title, icon);
            this.d_class = type;
            this.d_editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim pySim = PyroSim.getApp();
            PyroMod pyMod = pySim.getMediator();
            DeviceDlg dlg = Actions.newDevcDlg(this.d_class, this.d_editor);
            if (dlg == null) {
                return;
            }
            if (dlg.doModal() == 1) {
                Object obj = dlg.save(null);
                SelectTask wrapper = new SelectTask(pyMod, (Object)obj);
                wrapper.addTask(new AddTask((IPyroObject)pyMod.getDevices(), new IPyroObject[]{obj}));
                pyMod.getTaskManager().exec(wrapper, Intl.intl("New Device"));
            }
        }
    }

    private static class SelectHvacNetwork
    extends guiAction {
        private static final long serialVersionUID = 6100450032999815574L;

        public SelectHvacNetwork() {
            super(Intl.intl("Select HVAC Network"));
            this.putValue("ShortDescription", Intl.intl("Select the entire HVAC network containing the selected objects."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            PyroMod mod = app.getMediator();
            app.beginWaitCursor();
            Collection<IPyroObject> sel = this.getSelection(app.getMediator());
            IdentityHashMap<IPyroObject, Collection> implicitLinks = new IdentityHashMap<IPyroObject, Collection>();
            Function<IPyroObject, Collection> listMaker = node -> new ArrayList();
            for (HvacDuct duct : ((APyroObject)mod.getObstructions()).flatten(HvacDuct.class)) {
                for (HvacNode node2 : duct.getNodes()) {
                    if (node2 == null) continue;
                    Collection ducts = implicitLinks.computeIfAbsent(node2, listMaker);
                    ducts.add(duct);
                }
            }
            for (HvacNode node3 : ((APyroObject)mod.getObstructions()).flatten(HvacNode.class)) {
                if (node3.getNodeType() != HvacNode.NodeType.VENT || node3.getVent() == null) continue;
                Collection nodes = implicitLinks.computeIfAbsent(node3.getVent(), listMaker);
                nodes.add(node3);
            }
            ArrayList<IPyroObject> result = new ArrayList<IPyroObject>();
            ArrayDeque<IPyroObject> open = new ArrayDeque<IPyroObject>(sel);
            IdentityHashSet<IPyroObject> closed = new IdentityHashSet<IPyroObject>(sel);
            while (!open.isEmpty()) {
                IPyroObject comp = (IPyroObject)open.removeFirst();
                result.add(comp);
                for (IPyroObject obj : (Collection)implicitLinks.getOrDefault(comp, Collections.emptyList())) {
                    if (!closed.add(obj)) continue;
                    open.addLast(obj);
                }
                if (comp instanceof HvacNode) {
                    Vent vent;
                    HvacNode node4 = (HvacNode)comp;
                    if (node4.getNodeType() != HvacNode.NodeType.VENT || (vent = node4.getVent()) == null || !closed.add(vent)) continue;
                    open.addLast(vent);
                    continue;
                }
                if (!(comp instanceof HvacDuct)) continue;
                HvacDuct duct = (HvacDuct)comp;
                for (HvacNode node5 : duct.getNodes()) {
                    if (node5 == null || !closed.add(node5)) continue;
                    open.addLast(node5);
                }
            }
            mod.getTaskManager().exec(new SelectTask(mod, result), Intl.intl("Select HVAC Network"));
            app.endWaitCursor();
            String msg = result.isEmpty() ? Intl.intl("No objects selected") : String.format(Intl.intl("%d objects selected"), result.size());
            JOptionPane.showMessageDialog(app.getActiveFrame(), msg);
        }

        public void updateState(PyroMod mod) {
            boolean enabled = !this.getSelection(mod).isEmpty();
            this.setEnabled(enabled);
        }

        private Collection<IPyroObject> getSelection(PyroMod mod) {
            return mod.getSelectionModel().flatten(IPyroObject.class, obj -> obj instanceof IHvacGeomComp || obj instanceof Vent && ((Vent)obj).getSurface().isPredefined(PredefSurf.HVAC));
        }
    }

    private static class DisableForceToWriteAction
    extends AForceToWriteAction {
        private static final long serialVersionUID = 7970169758889109186L;

        public DisableForceToWriteAction() {
            super(Intl.intl("Disable Always Write"));
        }

        @Override
        boolean getEnabled() {
            return false;
        }
    }

    private static class EnableForceToWriteAction
    extends AForceToWriteAction {
        private static final long serialVersionUID = 2883115053592738359L;

        public EnableForceToWriteAction() {
            super(Intl.intl("Enable Always Write"));
        }

        @Override
        boolean getEnabled() {
            return true;
        }
    }

    private static abstract class AForceToWriteAction
    extends guiAction {
        private static final long serialVersionUID = 5798507937509893201L;

        public AForceToWriteAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            PyroMod mod = app.getMediator();
            app.beginWaitCursor();
            Collection<NamedPyroObject> sel = this.getSelection(mod);
            NamedPyroObject[] objs = new NamedPyroObject[sel.size()];
            sel.toArray(objs);
            mod.getTaskManager().exec(new SetForceWriteTask(this.getEnabled(), objs), "Set Force Write");
            app.endWaitCursor();
        }

        private Collection<NamedPyroObject> getSelection(PyroMod mod) {
            return mod.getSelectionModel().getSelected(NamedPyroObject.class);
        }

        abstract boolean getEnabled();

        public void updateState(PyroMod mod) {
            Collection<NamedPyroObject> selObjs = this.getSelection(mod);
            boolean shouldEnable = false;
            for (NamedPyroObject obj : selObjs) {
                if (obj.isForceWrite() == this.getEnabled() || obj instanceof Surface && ((Surface)obj).isPredefined() || obj instanceof AFDSObject || obj instanceof Composite) continue;
                shouldEnable = true;
                break;
            }
            this.setEnabled(shouldEnable);
        }
    }

    private static class SetAsDefaultSurfAction
    extends guiAction {
        private static final long serialVersionUID = 7406551533016012983L;

        public SetAsDefaultSurfAction() {
            super(Intl.intl("Set as the Default Surface"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            SimParams.Misc misc = pyMod.getSimParams().getMisc();
            IFilteredCollection<Surface> selSurfs = pyMod.getSelectionModel().getSelected(Surface.class);
            if (selSurfs.size() != 1) {
                return;
            }
            Surface selSurf = (Surface)selSurfs.iterator().next();
            pyMod.getTaskManager().exec(misc.taskSetSurfDefault(selSurf), Intl.intl("Set Default Surface"));
        }
    }

    private static class ClearBackgroundSpecAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public ClearBackgroundSpecAction() {
            super(Intl.intl("Set Species as Non-Background"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            Task t = pyMod.getExSpecList().taskSetBackgroundSpecies(null);
            pyMod.getTaskManager().exec(t, this.getName());
        }
    }

    private static class SetBackgroundSpecAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public SetBackgroundSpecAction() {
            super(Intl.intl("Set as Background Species"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            IFilteredCollection<ExSpec> selSpecs = pyMod.getSelectionModel().getSelected(ExSpec.class);
            if (selSpecs.size() != 1) {
                return;
            }
            Task t = pyMod.getExSpecList().taskSetBackgroundSpecies((ExSpec)selSpecs.iterator().next());
            pyMod.getTaskManager().exec(t, Intl.intl("Set Background Species"));
        }
    }

    private static class ClearReactionAction
    extends guiAction {
        private static final long serialVersionUID = 2848291704782496755L;

        public ClearReactionAction() {
            super(Intl.intl("Set Reaction Inactive"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            IFilteredCollection<Reaction> selReacs = pyMod.getSelectionModel().getSelected(Reaction.class);
            if (selReacs.size() != 1) {
                return;
            }
            Task tsk = pyMod.getReactions().taskClearActiveReaction((Reaction)selReacs.iterator().next());
            pyMod.getTaskManager().exec(tsk, Intl.intl("Set Reaction Inactive"));
        }
    }

    private static class SetReactionAction
    extends guiAction {
        private static final long serialVersionUID = -440688445518228251L;

        public SetReactionAction() {
            super(Intl.intl("Set as Active Reaction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            IFilteredCollection<Reaction> selReacs = pyMod.getSelectionModel().getSelected(Reaction.class);
            if (selReacs.size() != 1) {
                return;
            }
            Task tsk = pyMod.getReactions().taskSetActiveReaction((Reaction)selReacs.iterator().next());
            pyMod.getTaskManager().exec(tsk, Intl.intl("Set Active Reaction"));
        }
    }

    private static class ExtrudeLinesAction
    extends guiAction {
        private static final long serialVersionUID = -4524190554003085090L;

        public ExtrudeLinesAction() {
            super(Intl.intl("Convert CAD lines into Walls"));
            this.putValue("ShortDescription", Intl.intl("Convert CAD lines into walls by extruding up."));
        }

        private Collection<GenericGeomSrc> getObjects() {
            return PyroSim.getApp().getMediator().getSelectionModel().flatten(GenericGeomSrc.class, new Predicate<GenericGeomSrc>(){

                @Override
                public boolean test(GenericGeomSrc o) {
                    int lcount = o.getGeom().getNumPrims(2);
                    return lcount != 0 && lcount == o.getGeom().getNumPrims(7);
                }
            });
        }

        @Override
        public void updateEnabled() {
            this.setEnabled(!this.getObjects().isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection<GenericGeomSrc> lobjs = this.getObjects();
            if (lobjs.isEmpty()) {
                return;
            }
            ConvertCadLinesDlg dlg = new ConvertCadLinesDlg(PyroSim.getApp().getMainFrame());
            if (dlg.doModal() != 1) {
                return;
            }
            PyroMod domain = PyroSim.getApp().getMediator();
            double thickness = dlg.getWallThickness().get(SI.METER);
            double height = dlg.getWallHeight().get(SI.METER);
            WallGeom.Alignment alignment = WallGeom.Alignment.CENTER;
            Surface[] surf = new Surface[]{domain.getDefaultSurface()};
            ArrayList<GenericGeomSrc> removeObjs = new ArrayList<GenericGeomSrc>(lobjs.size());
            ArrayList<Obstruction> newObjs = new ArrayList<Obstruction>(lobjs.size());
            for (GenericGeomSrc lobj : lobjs) {
                IGeomNode geom = lobj.getGeom();
                IPropsSrc oldProps = lobj.getDisplayProps();
                List curves = GeomUtil.explode(geom.flatten().getLocalGeom(), ICurve.class);
                ArrayList<WallGeom> wallGeoms = new ArrayList<WallGeom>(curves.size());
                ArrayList<Color> newColors = new ArrayList<Color>();
                for (int m = 0; m < curves.size(); ++m) {
                    IPrimProps pprops = oldProps.get(m);
                    ICurve curve = (ICurve)curves.get(m);
                    WallGeom wgeom = new WallGeom(curve, alignment, thickness, height);
                    wallGeoms.add(wgeom);
                    for (int i = 0; i < wgeom.getNumPrims(7); ++i) {
                        newColors.add(pprops.getColor());
                    }
                }
                geom = GeomNodeUtil.newNode(GeomUtil.group(wallGeoms));
                Obstruction obst = new Obstruction(lobj.getName(), geom, surf);
                obst.setColors(pyrosim.domain.GeomUtil.optimize(theUtil.toArray(newColors, Color.class)));
                removeObjs.add(lobj);
                newObjs.add(obst);
            }
            SelectTask selTask = new SelectTask(domain, newObjs);
            selTask.addTask(new ReplacePreserveTask(removeObjs, newObjs));
            domain.getTaskManager().exec(selTask, Intl.intl("Convert Lines to Walls"));
        }
    }

    private static class TCPlotsAction
    extends guiAction {
        private static final long serialVersionUID = 2337901439261898105L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/results2D16.gif");

        public TCPlotsAction() {
            super(Intl.intl("Plot Time History Results") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            JFrame frm = app.getMainFrame();
            File[] fdsFiles = Actions.getFDSFiles(app);
            File defFile = fdsFiles == null ? null : fdsFiles[3];
            File csvFile = app.getFilenameManager().getOpenFile((Component)frm, Intl.intl("Choose a Time History Plot"), defFile, "csv", Intl.intl("CSV Data"));
            if (csvFile == null) {
                return;
            }
            try {
                TimeHistoryData data = new TimeHistoryData(csvFile);
                TimeHistoryPlotDlg dlg = new TimeHistoryPlotDlg(frm, data);
                dlg.setVisible(true);
            }
            catch (Throwable t) {
                guiUtil.showError(frm, Intl.intl("CSV Error"), String.format(Intl.intl("Error Reading %s"), csvFile.getName()), t);
            }
        }
    }

    private static class TimeHistoryResultsAction
    extends ViewResultsAction {
        private static final long serialVersionUID = 3455292903861794750L;
        private final int d_fileIx;

        public TimeHistoryResultsAction(String name, Icon icon, int fileIx) {
            super(name, new DecoratedIcon(PyroGuiUtil.loadPyroSimIcon("results2D16.gif"), icon, 3));
            this.d_fileIx = fileIx;
        }

        @Override
        protected File getResultsFile(PyroSim app) {
            File[] files = Actions.getFDSFiles(app);
            if (files != null) {
                return files[this.d_fileIx];
            }
            return null;
        }

        @Override
        protected void showResults(File csvFile) {
            JFrame frm = PyroSim.getApp().getActiveFrame();
            try {
                TimeHistoryData data = new TimeHistoryData(csvFile);
                TimeHistoryPlotDlg dlg = new TimeHistoryPlotDlg(frm, data);
                dlg.setVisible(true);
            }
            catch (Throwable t) {
                guiUtil.showError(frm, Intl.intl("CSV Error"), String.format(Intl.intl("Error Reading %s"), csvFile.getName()), t);
            }
        }
    }

    private static class SortAction
    extends guiAction {
        private static final long serialVersionUID = -3609795906592900294L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/sorttree.gif");

        public SortAction() {
            super(Intl.intl("Sort by Name"), ICON);
            this.putValue("ShortDescription", Intl.intl("Sort by Name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            IFilteredCollection<Composite> groups = mediator.getSelectionModel().getSelected(Composite.class);
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(mediator);
            for (Composite group : groups) {
                task.addTask(new SortByNameTask(group));
            }
            mediator.getTaskManager().exec(task, Intl.intl("Sort by Name"));
        }
    }

    private static class ResultsPreviewAction
    extends guiAction
    implements Runnable {
        private static final long serialVersionUID = -8495001270655031766L;
        private static final ImageIcon ICON = null;

        public ResultsPreviewAction() {
            super(Intl.intl("Preview Model in Results") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(this).start();
        }

        @Override
        public void run() {
            PyroSim app = (PyroSim)Application.getApp();
            PyroMod pyMod = app.getMediator();
            pyMod.pauseUpdates(false);
            UnitDouble startTime = pyMod.getSimParams().getTime().getStartTime();
            pyMod.getSimParams().getTime().setStartTime(new UnitDouble(0.0, SI.SECOND));
            UnitDouble stopTime = pyMod.getSimParams().getTime().getStopTime();
            pyMod.getSimParams().getTime().setStopTime(new UnitDouble(0.0, SI.SECOND));
            File tempFile = null;
            try {
                tempFile = File.createTempFile("pyrosim", ".data");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Application.getApp().getMainFrame(), Intl.intl("An error occurred trying to create a temporary file."), Intl.intl("Temporary File Error"), 0);
                pyMod.resumeUpdates();
                return;
            }
            boolean written = app.writeFDSFile(tempFile, false, FDSRenderer.RENDER_ORIGIN.DEFAULT);
            pyMod.getSimParams().getTime().setStartTime(startTime);
            pyMod.getSimParams().getTime().setStopTime(stopTime);
            pyMod.resumeUpdates();
            if (written) {
                FDSRunMonitor runner = new FDSRunMonitor(Intl.intl("Preview") + " - " + tempFile.getName(), tempFile.getAbsolutePath());
                runner.previewResults(pyMod.getSimParams().getOpenMp());
            }
        }
    }

    private static class RestoreResultsAction
    extends guiAction {
        private static final long serialVersionUID = -7446116802125072040L;

        public RestoreResultsAction() {
            super(Intl.intl("Restore FDS Results..."));
        }

        private List<ResultsArchive.Record> getActiveRecords() {
            String filename = PyroSim.getApp().getFilename();
            if (filename == null) {
                return Collections.EMPTY_LIST;
            }
            ResultsArchive archive = PyroSim.getApp().getMediator().getResultsArchive();
            return archive.getActiveArchives(new File(filename).getParentFile());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            app.beginWaitCursor();
            try {
                this.run();
            }
            finally {
                app.endWaitCursor();
            }
        }

        private void run() {
            PyroSim app = PyroSim.getApp();
            List<ResultsArchive.Record> recs = this.getActiveRecords();
            if (recs.isEmpty()) {
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("There are currently no archived results."), Intl.intl("No Archived Results"), 2);
                return;
            }
            File outputDir = Actions.getResultsDir(app);
            if (!outputDir.exists()) {
                outputDir = Actions.getDefaultResultsDir(PyroSim.getApp().getMediator(), new File(PyroSim.getApp().getFilename()));
            }
            RestoreResultsDlg dlg = new RestoreResultsDlg((Window)PyroSim.getApp().getActiveFrame());
            dlg.setDefaultDestination(outputDir);
            dlg.load(recs);
            if (dlg.doModal() != 1) {
                return;
            }
            outputDir = dlg.getDestinationDir();
            File workingDir = new File(PyroSim.getApp().getFilename()).getParentFile();
            boolean retain = dlg.getRetainArchive();
            ResultsArchive.Record rec = dlg.getSelectedRecord();
            File tempOutputDir = RestoreResultsAction.getTempResultsDir(outputDir);
            try {
                rec.method.restore(workingDir, rec.name, tempOutputDir, retain);
                for (File child : IOUtil.listFiles(outputDir)) {
                    if (child.getName().equals(tempOutputDir.getName())) continue;
                    IOUtil.delete(child);
                }
                for (File child : IOUtil.listFiles(tempOutputDir)) {
                    File newName;
                    if (child.renameTo(newName = new File(outputDir, child.getName()))) continue;
                    String msg = String.format(Intl.intl("Cannot rename %1$s to %2$s."), tempOutputDir.getAbsolutePath(), outputDir.getAbsolutePath());
                    throw new IOException(msg);
                }
                IOUtil.delete(tempOutputDir);
            }
            catch (IOException exc) {
                Actions.showRestoreIOException(exc);
                try {
                    if (tempOutputDir.exists()) {
                        IOUtil.delete(tempOutputDir);
                    }
                }
                catch (IOException exc2) {
                    exc2.printStackTrace();
                    return;
                }
                return;
            }
            JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), String.format(Intl.intl("Archive, \"%1$s,\" successfully restored to%n%2$s."), rec.name, outputDir.getAbsolutePath()), Intl.intl("Archive Restored"), 1);
        }

        private static File getTempResultsDir(File actualResultsDir) {
            File parent = actualResultsDir;
            String actualResultsName = actualResultsDir.getName();
            File result = new File(parent, "~" + actualResultsName);
            int ix = 1;
            while (result.exists()) {
                result = new File(parent, "~" + actualResultsName + "_" + ix++);
            }
            return result;
        }
    }

    private static class ArchiveResultsAction
    extends guiAction {
        private static final long serialVersionUID = 8423782582048981884L;

        public ArchiveResultsAction() {
            super(Intl.intl("Archive FDS Results..."));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            app.beginWaitCursor();
            try {
                Actions.archiveResults(Actions.getResultsDir(app));
            }
            catch (CancelledException cancelledException) {
            }
            finally {
                app.endWaitCursor();
            }
        }
    }

    private static class RunResultsAction
    extends guiAction
    implements Runnable {
        private static final long serialVersionUID = 3775970234632272022L;
        private final Consumer<File> d_run;
        private final String[] d_filters;
        private volatile File d_tempFile;

        public RunResultsAction(String actionName, Icon icon, Consumer<File> run, String ... filters) {
            super(actionName, icon);
            this.d_run = run;
            this.d_filters = filters;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            File[] fdsFiles = Actions.getFDSFiles(app);
            File defFile = fdsFiles == null ? null : fdsFiles[2];
            this.d_tempFile = app.getFilenameManager().getOpenFile((Component)app.getMainFrame(), Intl.intl("Open"), defFile, this.d_filters);
            if (this.d_tempFile == null) {
                return;
            }
            new Thread(this).start();
        }

        @Override
        public void run() {
            File tempFile = this.d_tempFile;
            if (tempFile != null) {
                this.d_run.accept(tempFile);
            }
        }
    }

    private static class Results3dAction
    extends ViewResultsAction {
        private static final long serialVersionUID = 6453125073690686274L;

        public Results3dAction() {
            super(Intl.intl("View Results"), PyroGuiUtil.loadPyroSimIcon("burn16.png"));
        }

        @Override
        protected File getResultsFile(PyroSim app) {
            File[] fdsFiles = Actions.getFDSFiles(app);
            if (fdsFiles != null) {
                return fdsFiles[2];
            }
            return null;
        }

        @Override
        protected void showResults(final File file) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    this.runResults(file);
                }
            };
            new Thread(r).start();
        }

        private void runResults(File file) {
            FDSRunMonitor.showResults(FDSRunMonitor.ResultsApp.RESULTS, null, file);
        }
    }

    private static abstract class ViewResultsAction
    extends guiAction
    implements IEventObserver {
        private static final long serialVersionUID = -2275722072265128579L;

        public ViewResultsAction(String name, Icon icon) {
            super(name, icon);
            this.putValue("ShortDescription", this.getName());
            PyroSim.getApp().getMediator().getEvents().addObserver(this);
            this.setEnabledUpdator(() -> {
                File resultsFile = this.getResultsFile(PyroSim.getApp());
                return resultsFile != null && resultsFile.exists();
            });
            ActionListener updator = e -> this.updateEnabled();
            Timer timer = new Timer(2000, updator);
            timer.setCoalesce(true);
            timer.start();
        }

        protected abstract File getResultsFile(PyroSim var1);

        protected abstract void showResults(File var1);

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            File resultsFile = this.getResultsFile(app);
            if (resultsFile != null && resultsFile.exists()) {
                this.showResults(resultsFile);
            } else {
                String msg = resultsFile == null ? Intl.intl("Results do not exist.") : String.format(Intl.intl("Cannot find %s."), resultsFile.getAbsolutePath());
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), msg, Intl.intl("Missing Results"), 2);
            }
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_FILENAME_CHANGED)) {
                this.updateEnabled();
            }
        }
    }

    public static class MsrStatsAction
    extends guiAction {
        private static final long serialVersionUID = 2526136464453806397L;

        public MsrStatsAction() {
            super(Intl.intl("Statistics..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.editStats(Collections.EMPTY_LIST);
        }
    }

    private static class ProfListAction
    extends guiAction {
        private static final long serialVersionUID = -7698826729950460193L;

        public ProfListAction() {
            super(Intl.intl("Edit Solid &Profiles..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim pySim = (PyroSim)Application.getApp();
            JFrame frm = pySim.getMainFrame();
            PyroMod pyMod = pySim.getMediator();
            ProfList profList = pyMod.getProfList();
            Unit uLen = pySim.getUnitSystem().getLengthUnit();
            ProfListDlg dlg = new ProfListDlg(frm, uLen);
            dlg.init(profList);
            if (dlg.doModal() == 1) {
                Task t = dlg.taskSaveTo(pyMod, profList);
                pyMod.getTaskManager().exec(t, Intl.intl("Edit Solid Profiles"));
            }
        }
    }

    private static class SmodLinkModelsAction
    extends guiAction {
        private static final long serialVersionUID = -8587146107133497882L;

        public SmodLinkModelsAction() {
            super(Intl.intl("Edit Smoke Detector Models") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.editSmokeLinkModels(null);
        }
    }

    private static class ExSpecListAction
    extends guiAction {
        private static final long serialVersionUID = 7833174983211536934L;
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("molecule16.png");

        public ExSpecListAction() {
            super(Intl.intl("Edit Species") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Actions.editSpecies(null);
        }
    }

    private static class ParticleAction
    extends guiAction {
        private static final long serialVersionUID = -3975184438299663937L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/particles16.gif");

        public ParticleAction() {
            super(Intl.intl("Edit Particles") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.editParticles(null);
        }
    }

    private static class SliceAction
    extends guiAction {
        private static final long serialVersionUID = -8590951427978755498L;

        public SliceAction() {
            super(Intl.intl("2D Slices") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.editSlices(Collections.EMPTY_LIST);
        }
    }

    private static class Slice3DAction
    extends guiAction {
        private static final long serialVersionUID = -3237070857767239656L;

        public Slice3DAction() {
            super(Intl.intl("3D Slices") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.edit3DSlices(Collections.EMPTY_LIST);
        }
    }

    private static class IsosurfaceAction
    extends guiAction {
        private static final long serialVersionUID = -4828198042434923247L;

        public IsosurfaceAction() {
            super(Intl.intl("Isosurfaces") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IsofDialog isof = new IsofDialog(Application.getApp().getMainFrame());
            isof.doModal();
        }
    }

    private static class Plot3DAction
    extends guiAction {
        private static final long serialVersionUID = 2213082634444477130L;

        public Plot3DAction() {
            super(Intl.intl("Plot3D Data") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Actions.showPlot3DDialog();
        }
    }

    private static class BoundaryQuantityAction
    extends guiAction {
        private static final long serialVersionUID = -2048961257887920858L;

        public BoundaryQuantityAction() {
            super(Intl.intl("Boundary Quantities") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Actions.showBoundaryConditionsDialog();
        }
    }

    private static class OpenGridsAction
    extends guiAction {
        private static final long serialVersionUID = 1449682465607102043L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/boundary16.gif");

        public OpenGridsAction() {
            super(Intl.intl("Open Mesh Boundaries"), ICON);
            this.putValue("ShortDescription", Intl.intl("Create open boundary vents for the selected, enabled meshes"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = PyroSim.getApp().getMediator();
            Collection<Grid> grids = mediator.getSelectionModel().flatten(Grid.class, new EnabledFilter());
            if (grids.isEmpty()) {
                return;
            }
            Surface surf = mediator.getSurfaceMgr().get(PredefSurf.OPEN);
            assert (surf != null);
            if (surf == null) {
                return;
            }
            Map<Grid, GridMergeUtil.BoundaryInfo> gridBoundaries = GridMergeUtil.mergeGrids(mediator.getGridManager().flatten(new EnabledFilter<T>()), (Collection<? extends IPyroGeomSrc>)Collections.EMPTY_LIST).faces;
            List<Pair<Grid, List<Vent>>> gridVents = GridUtil.constructVents(grids, gridBoundaries, surf, GridUtil.GridFace.values());
            if (gridVents.isEmpty()) {
                return;
            }
            ArrayList newVents = new ArrayList();
            for (Pair<Grid, List<Vent>> pair : gridVents) {
                newVents.addAll((Collection)pair.v2);
            }
            SelectTask st = new SelectTask(mediator, newVents);
            st.addTask(new AddGridBoundaryVentsTask(mediator, gridVents));
            mediator.getTaskManager().exec(st, Intl.intl("Add Vents"));
        }
    }

    private static class AddFloorFromGeomAction
    extends guiAction {
        private static final long serialVersionUID = 7757685971048096646L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/managefloors16_2.gif");

        public AddFloorFromGeomAction() {
            super(Intl.intl("Add Floor to Fit Objects"), ICON);
            this.putValue("ShortDescription", Intl.intl("Add Floor to Fit Objects"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            Collection<IPyroGeomSrc> obsts = mediator.getSelectionModel().flatten(IPyroGeomSrc.class);
            if (obsts.isEmpty()) {
                return;
            }
            AABox bounds = pyrosim.util.GeomUtil.getBounds(obsts);
            if (bounds.isValid() && !bounds.isInfinite()) {
                Floor newFloor = new Floor(mediator.getNames(Floor.class).generateName(), new UnitDouble(bounds.getMinZ(), Geometry.LU), new UnitDouble(0.0, SI.METER), new UnitDouble(bounds.getHeight(), Geometry.LU), null, Floor.DEFAULT_COLOR);
                CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(mediator);
                task.addTask(new AddTask((IPyroObject)mediator.getFloorManager(), new IPyroObject[]{newFloor}));
                mediator.getTaskManager().exec(task, Intl.intl("New Floor"));
            }
        }
    }

    private static class ShowNodeAction
    extends guiAction {
        private static final long serialVersionUID = -5077749889862006752L;

        public ShowNodeAction() {
            super(Intl.intl("Show Object(s)"));
            this.putValue("AcceleratorKey", Accelerators.SHOW);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            ShowSomeGeomTask tsk = new ShowSomeGeomTask(mediator, mediator.getSelectionModel().flatten(IPyroGeomSrc.class), true);
            mediator.getTaskManager().exec(tsk, this.getName());
        }
    }

    private static class ShowAllNodesAction
    extends guiAction {
        private static final long serialVersionUID = 7710554227825807626L;

        public ShowAllNodesAction() {
            super(Intl.intl("Show All Objects"));
            this.putValue("AcceleratorKey", Accelerators.SHOW_ALL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            ShowAllGeomTask tsk = new ShowAllGeomTask(mediator);
            mediator.getTaskManager().exec(tsk, this.getName());
        }
    }

    public static class RemoveSelectedNodeAction
    extends guiAction {
        private static final long serialVersionUID = -5504045286867996285L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Delete16.gif");

        public RemoveSelectedNodeAction() {
            super(Intl.intl("Delete"), ICON);
            this.addAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.addAccelerator(KeyStroke.getKeyStroke(8, 0));
            this.putValue("ShortDescription", Intl.intl("Delete"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            Actions.doDelete(mediator);
        }
    }

    public static class UIPasteCallback
    extends APasteCallback {
        private PasteOverwrite d_replace = null;

        public UIPasteCallback(PyroMod domain) {
            super(UIPasteCallback.getDefaultPasteLocs(domain));
        }

        private static Object[] getDefaultPasteLocs(PyroMod domain) {
            ArrayList<Object> pasteLocs = new ArrayList<Object>();
            Set<?> sel = domain.getSelectionModel().getSelection();
            if (sel.size() == 1) {
                pasteLocs.add(sel.iterator().next());
            } else {
                IPyroObject commonParent = Hierarchy.getCommonParent(theUtil.filter(sel, IPyroObject.class));
                if (commonParent != null) {
                    pasteLocs.add(commonParent);
                }
            }
            return theUtil.toArray(pasteLocs, Object.class);
        }

        @Override
        public PasteOverwrite getReplaceModelObject(IPyroObject modelObj, IPyroObject pasteObj) throws CancellationException {
            String description = Util.getName(pasteObj);
            String msg = String.format(Intl.intl("%s already exists in the model.\nWould you like to replace it?"), description);
            return this.getReplaceModelObject(modelObj, pasteObj, msg);
        }

        public PasteOverwrite getReplaceModelObject(IPyroObject modelObj, IPyroObject pasteObj, String msg) throws CancellationException {
            PasteOverwrite overwrite;
            if (this.d_replace != null) {
                return this.d_replace;
            }
            String YES = Intl.intl("Yes");
            String YES_TO_ALL = Intl.intl("Yes to All");
            String NO = Intl.intl("No");
            String NO_TO_ALL = Intl.intl("No to All");
            String CANCEL = Intl.intl("Cancel");
            Object[] INSERT_OVERWRITE_OPTIONS = new String[]{YES, YES_TO_ALL, NO, NO_TO_ALL, CANCEL};
            JOptionPane optionPane = new JOptionPane(msg, 3, 0, null, INSERT_OVERWRITE_OPTIONS, YES);
            JDialog optionDlg = optionPane.createDialog(Application.getApp().getActiveFrame(), Intl.intl("Object Exists"));
            optionDlg.setVisible(true);
            Object response = optionPane.getValue();
            if (YES.equals(response)) {
                overwrite = PasteOverwrite.REPLACE_EXISTING;
            } else if (YES_TO_ALL.equals(response)) {
                this.d_replace = overwrite = PasteOverwrite.REPLACE_EXISTING;
            } else if (NO.equals(response)) {
                overwrite = PasteOverwrite.KEEP_EXISTING;
            } else if (NO_TO_ALL.equals(response)) {
                this.d_replace = overwrite = PasteOverwrite.KEEP_EXISTING;
            } else {
                throw new CancellationException();
            }
            return overwrite;
        }

        @Override
        public List<Reaction> getActiveReactions(Collection<Reaction> oldReactions, Map<Reaction, PasteCommand> newReactions, List<Reaction> oldActives) throws CancellationException {
            if (newReactions.size() == 0) {
                return new ArrayList<Reaction>(oldActives);
            }
            Set types = newReactions.keySet().stream().map(r -> r.getReacType()).distinct().collect(Collectors.toSet());
            if (types.size() != 1) {
                return new ArrayList<Reaction>(oldActives);
            }
            if (oldReactions.size() == 0) {
                if (newReactions.size() == 1) {
                    return new ArrayList<Reaction>(newReactions.keySet());
                }
                if (types.size() == 1 && types.contains((Object)Reaction.ReacType.COMPLEX)) {
                    return new ArrayList<Reaction>(newReactions.keySet());
                }
            }
            if (types.contains((Object)Reaction.ReacType.SIMPLE)) {
                Function<Reaction, String> nameMapper = reac -> {
                    if (newReactions.containsKey(reac)) {
                        return String.format(Intl.intl("%s (Pasted Object)"), reac.getName());
                    }
                    return reac.getName();
                };
                SetNewActiveSimpleReacDlg dlg = new SetNewActiveSimpleReacDlg(new ArrayList<Reaction>(newReactions.keySet()), nameMapper, oldActives);
                if (dlg.doModal() == 1) {
                    return dlg.getSelectedReacs();
                }
                throw new CancellationException();
            }
            if (types.contains((Object)Reaction.ReacType.COMPLEX)) {
                int sel = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("Would you like to set pasted complex reactions as 'Active'?"), Intl.intl("Set Reactions Active"), 1, 3);
                if (sel == 0) {
                    return new ArrayList<Reaction>(newReactions.keySet());
                }
                if (sel == 1) {
                    return new ArrayList<Reaction>(oldActives);
                }
                if (sel == 2) {
                    throw new CancellationException();
                }
            }
            return oldActives;
        }
    }

    public static abstract class APasteCallback
    implements IPasteCallback {
        private final Object[] d_preferredPasteLocs;

        public APasteCallback(Object ... preferredPasteLocs) {
            this.d_preferredPasteLocs = preferredPasteLocs;
        }

        @Override
        public Object getPasteLocation(PyroMod pasteMod, Object pasteObj) {
            for (Object preferredLoc : this.d_preferredPasteLocs) {
                if (!TVEntryPoints.ep(preferredLoc).canPaste(pasteMod, preferredLoc, pasteObj)) continue;
                return preferredLoc;
            }
            return TVEntryPoints.ep(pasteObj).getPasteLocation(pasteMod, pasteObj);
        }
    }

    public static interface IPasteCallback {
        public PasteOverwrite getReplaceModelObject(IPyroObject var1, IPyroObject var2) throws CancellationException;

        public Object getPasteLocation(PyroMod var1, Object var2);

        public List<Reaction> getActiveReactions(Collection<Reaction> var1, Map<Reaction, PasteCommand> var2, List<Reaction> var3) throws CancellationException;
    }

    public static enum PasteOverwrite {
        REPLACE_EXISTING,
        KEEP_EXISTING;

    }

    public static class PasteCommand {
        public static final int OVERWRITE = 0;
        public static final int SUBSTITUTE = 1;
        public static final int RENAME = 2;
        public final int command;
        public final Object pasteLoc;
        public final Object param;

        public PasteCommand(int command, Object pasteLoc, Object param) {
            this.command = command;
            this.pasteLoc = pasteLoc;
            this.param = param;
        }
    }

    public static class PasteReactionCommand {
        public final List<Reaction> prevActives;
        public final List<Reaction> newActives;

        public PasteReactionCommand(List<Reaction> prevActives, List<Reaction> newActives) {
            this.prevActives = prevActives;
            this.newActives = newActives;
        }
    }

    public static class PasteInfo {
        public final Task task;
        public final Map<IPyroObject, PasteCommand> commands;

        public PasteInfo(Task task, Map<IPyroObject, PasteCommand> commands) {
            this.task = task;
            this.commands = commands;
        }
    }

    private static class PasteAction
    extends guiAction {
        private static final long serialVersionUID = -8752980443667274078L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Paste16.gif");

        public PasteAction() {
            super(Intl.intl("Paste"), ICON);
            this.putValue("AcceleratorKey", Accelerators.PASTE);
            this.putValue("ShortDescription", Intl.intl("Paste"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            PyroMod mediator = PyroSim.getApp().getMediator();
            Application.getApp().beginWaitCursor();
            try {
                Actions.doPaste(mediator, clip, new UIPasteCallback(mediator));
            }
            catch (CancellationException cancellationException) {
            }
            finally {
                Application.getApp().endWaitCursor();
            }
        }
    }

    private static class HideUnselectedNodeAction
    extends guiAction {
        private static final long serialVersionUID = 2847617481608042700L;

        public HideUnselectedNodeAction() {
            super(Intl.intl("Filter Object(s)"));
            this.putValue("AcceleratorKey", Accelerators.FILTER);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            FilterGeomTask tsk = new FilterGeomTask(mediator, mediator.getSelectionModel().flatten(IPyroGeomSrc.class));
            mediator.getTaskManager().exec(tsk, this.getName());
        }
    }

    private static class HideNodeAction
    extends guiAction {
        private static final long serialVersionUID = -121363112383909202L;

        public HideNodeAction() {
            super(Intl.intl("Hide Object(s)"));
            this.putValue("AcceleratorKey", Accelerators.HIDE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            ShowSomeGeomTask tsk = new ShowSomeGeomTask(mediator, mediator.getSelectionModel().flatten(IPyroGeomSrc.class), false);
            mediator.getTaskManager().exec(tsk, this.getName());
        }
    }

    private static class ChangeEnabledNodeAction
    extends guiAction {
        private static final long serialVersionUID = -5664988163492864743L;
        private boolean d_enabled;

        public ChangeEnabledNodeAction(String actionName, boolean enabled) {
            super(actionName);
            this.d_enabled = enabled;
        }

        protected Collection<IPyroObject> getSelection() {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            Hierarchy.CompositeFilter<IPyroObject> nonComposite = new Hierarchy.CompositeFilter<IPyroObject>();
            Predicate<IPyroObject> nonReactionEnabled = new Predicate<IPyroObject>(){

                @Override
                public boolean test(IPyroObject o) {
                    return !(o instanceof Reaction) && o.isEnabled() != d_enabled;
                }
            };
            Predicate<IPyroObject> filter = nonComposite.and(nonReactionEnabled);
            return mediator.getSelectionModel().flatten(IPyroObject.class, filter);
        }

        public void updateState() {
            Collection<IPyroObject> selObjs = this.getSelection();
            boolean enabled = !selObjs.isEmpty();
            this.setEnabled(enabled);
        }

        private void enable(PyroMod pyroMod, Collection<IPyroObject> selObjs) {
            DepSnapshot dp = new DepSnapshot();
            for (IPyroObject obj : selObjs) {
                dp.takeSnapshot(obj);
            }
            dp.removeMappings(selObjs);
            Set<IPyroObject> allDepOns = dp.getAllDependedOn();
            Predicate<IPyroObject> filter = new Predicate<IPyroObject>(){

                @Override
                public boolean test(IPyroObject o) {
                    return !o.isEnabled();
                }
            };
            IFilteredCollection<IPyroObject> disabledDepOns = theUtil.filter(allDepOns, IPyroObject.class, filter);
            LinkedHashSet<IPyroObject> enableObjs = new LinkedHashSet<IPyroObject>(selObjs);
            boolean goForEnable = disabledDepOns.isEmpty();
            if (!goForEnable) {
                String msg = String.format(Intl.intl("Enable %s additional object(s)?"), disabledDepOns.size());
                int choice = JOptionPane.showConfirmDialog(PyroSim.getApp().getMainFrame(), msg, Intl.intl("Enable Dependencies"), 2);
                if (choice == 0) {
                    goForEnable = true;
                    enableObjs.addAll(disabledDepOns);
                }
            }
            if (goForEnable) {
                SetEnabledSomeObjsTask tsk = new SetEnabledSomeObjsTask(pyroMod, enableObjs, true);
                pyroMod.getTaskManager().exec(tsk, this.getName());
            }
        }

        private void disable(PyroMod pyroMod, Collection<IPyroObject> selObjs) {
            if (!Actions.isObjectInUse(pyroMod, selObjs, null)) {
                SetEnabledSomeObjsTask tsk = new SetEnabledSomeObjsTask(pyroMod, selObjs, false);
                pyroMod.getTaskManager().exec(tsk, this.getName());
            } else {
                String msg = null;
                msg = selObjs.size() <= 1 ? Intl.intl("The selected object is in use.") : Intl.intl("One or more of the selected objects is in use.");
                JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), msg, Intl.intl("Error: In Use"), 0);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            mediator.pauseUpdates();
            Collection<IPyroObject> selObjs = this.getSelection();
            if (this.d_enabled) {
                this.enable(mediator, selObjs);
            } else {
                this.disable(mediator, selObjs);
            }
            mediator.resumeUpdates();
        }
    }

    private static class EditLibAction
    extends guiAction {
        private static final long serialVersionUID = -8900685277728987112L;

        public EditLibAction() {
            super(Intl.intl("Edit Libraries..."), Actions.createIcon(null));
            this.putValue("ShortDescription", Intl.intl("Edit Libraries"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim pySim = PyroSim.getApp();
            LibraryDlg dlg = new LibraryDlg(pySim.getMainFrame(), null);
            dlg.doModal();
        }
    }

    private static class EditSimulationPropertiesAction
    extends guiAction {
        private static final long serialVersionUID = -7243756585802759467L;
        private static final ImageIcon ICON = null;

        public EditSimulationPropertiesAction() {
            super(Intl.intl("Simulation Parameters") + "...", ICON);
            this.putValue("ShortDescription", Intl.intl("Simulation Parameters"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.editSimulationProperties();
        }
    }

    private static class EditSelectedNodeAction
    extends guiAction {
        private static final long serialVersionUID = -564450018016717491L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Edit16.gif");
        private static final Set<Class> NONEDIT_TYPES = Sets.fromArrayHS(CameraState.class, DeviceManager.class, View.class, ViewList.class);
        private static final Set<Class> EDIT_TYPES = Sets.fromArrayHS(new Class[0]);
        private static final Map<Class, Boolean> EDIT_CACHE = new HashMap<Class, Boolean>();
        private static final Function<Class, Boolean> EDIT_FUNC;
        private static Predicate<Object> EDIT_FILTER;

        public EditSelectedNodeAction() {
            super(Intl.intl("Properties") + "...", ICON);
            this.putValue("ShortDescription", Intl.intl("Properties"));
        }

        public void updateEnabled(PyroMod mediator) {
            PyroSimSelectionModel sm = mediator.getSelectionModel();
            IPyroObject editCategory = null;
            for (Object o : sm.getSelection()) {
                if (!EDIT_FILTER.test(o)) {
                    editCategory = null;
                    break;
                }
                IPyroObject category = Hierarchy.getCategoryRoot((IPyroObject)o);
                if (editCategory == null) {
                    editCategory = category;
                    continue;
                }
                if (category == editCategory) continue;
                editCategory = null;
                break;
            }
            EDIT_SELECTED_NODE_ACTION.setEnabled(editCategory != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.editSelectedNode();
        }

        static {
            for (Class type2 : NONEDIT_TYPES) {
                EDIT_CACHE.put(type2, false);
            }
            for (Class type2 : EDIT_TYPES) {
                EDIT_CACHE.put(type2, true);
            }
            EDIT_FUNC = type -> {
                if (!IPyroObject.class.isAssignableFrom((Class<?>)type)) {
                    return false;
                }
                Boolean result = theUtil.findObjectForClass(EDIT_CACHE, type);
                return result == null ? true : result;
            };
            EDIT_FILTER = o -> EDIT_CACHE.computeIfAbsent(o.getClass(), EDIT_FUNC);
        }
    }

    private static class CutAction
    extends guiAction {
        private static final long serialVersionUID = -6546742384472571267L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Cut16.gif");

        public CutAction() {
            super(Intl.intl("Cut"), ICON);
            this.putValue("AcceleratorKey", Accelerators.CUT);
            this.putValue("ShortDescription", Intl.intl("Cut"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            Actions.doCut(mediator, Toolkit.getDefaultToolkit().getSystemClipboard());
        }
    }

    private static class CopyFDSRecordsAction
    extends guiAction {
        private static final long serialVersionUID = -827474727532744310L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Copy16.gif");

        public CopyFDSRecordsAction() {
            super(Intl.intl("Copy FDS Records"), ICON);
            this.putValue("ShortDescription", Intl.intl("Copy FDS Records"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            Actions.doCopy(mediator, Toolkit.getDefaultToolkit().getSystemClipboard(), FDS_DATA_FLAVOR);
        }
    }

    private static class CopyAction
    extends guiAction {
        private static final long serialVersionUID = -7907213396355322043L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Copy16.gif");

        public CopyAction() {
            super(Intl.intl("Copy"), ICON);
            this.putValue("AcceleratorKey", Accelerators.COPY);
            this.putValue("ShortDescription", Intl.intl("Copy"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            Actions.doCopy(mediator, Toolkit.getDefaultToolkit().getSystemClipboard(), PYRO_DATA_FLAVOR);
        }
    }

    private static class RedoAction
    extends guiAction {
        private static final long serialVersionUID = -6347326337464097037L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Redo16.gif");

        public RedoAction() {
            super(Intl.intl("Redo"), ICON);
            this.putValue("AcceleratorKey", Accelerators.REDO);
            this.putValue("ShortDescription", Intl.intl("Redo"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            mediator.getTaskManager().redo();
        }

        public void update(TaskManager mgr) {
            this.setEnabled(mgr.canRedo());
            String desc = mgr.describeRedo();
            this.setName(desc);
            this.putValue("ShortDescription", desc);
        }
    }

    private static class UndoAction
    extends guiAction {
        private static final long serialVersionUID = -2894482227587354644L;
        public static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Undo16.gif");

        public UndoAction() {
            super(Intl.intl("Undo"), ICON);
            this.putValue("AcceleratorKey", Accelerators.UNDO);
            this.putValue("ShortDescription", Intl.intl("Undo"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            mediator.getTaskManager().undo();
        }

        public void update(TaskManager mgr) {
            this.setEnabled(mgr.canUndo());
            String desc = mgr.describeUndo();
            this.setName(desc);
            this.putValue("ShortDescription", desc);
        }
    }

    private static class CrashAction
    extends guiAction {
        private static final long serialVersionUID = 1519871291030549471L;

        public CrashAction() {
            super("x_x", (ActionEvent e) -> {
                throw new RuntimeException();
            });
        }
    }

    private static class ProtectAction
    extends guiAction {
        private static final long serialVersionUID = -7803068167094385248L;
        public static final ImageIcon ICON = null;

        public ProtectAction() {
            super(Intl.intl("Write Protection..."), ICON);
            this.putValue("ShortDescription", Intl.intl("Prevent changes to the model."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            PyroMod mod = app.getMediator();
            if (mod.isWriteProtected()) {
                boolean checkPassword = WriteProtect.isPasswordProtected(mod);
                WriteProtect.RemoveProtectionDlg dlg = new WriteProtect.RemoveProtectionDlg(app.getMainFrame(), checkPassword);
                if (dlg.doModal() == 1) {
                    WriteProtect.removeProtection(mod);
                    mod.getEvents().changed(mod, PyroMod.EVT_CHANGED);
                }
            } else {
                WriteProtect.AddProtectionDlg dlg = new WriteProtect.AddProtectionDlg(app.getMainFrame());
                if (dlg.doModal() == 1) {
                    String strPass = null;
                    if (dlg.getPasswordProtection()) {
                        strPass = dlg.getPassword();
                    }
                    WriteProtect.addProtection(mod, strPass);
                    mod.getEvents().changed(mod, PyroMod.EVT_CHANGED);
                }
            }
        }
    }

    private static class RasterizeObjectsAction
    extends guiAction {
        private static final long serialVersionUID = 8380453107532657945L;
        private static final ImageIcon ICON = null;

        public RasterizeObjectsAction() {
            super(Intl.intl("Convert to Blocks") + "...", ICON);
        }

        @Override
        public void updateEnabled() {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            this.setEnabled(!pyMod.getSelectionModel().flatten(FDSObject.class).isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod = ((PyroSim)Application.getApp()).getMediator();
            if (pyMod.getGridManager().flatten().isEmpty()) {
                PyroSim.getApp().error(new guiSimpleError(Intl.intl("There are currently no grids to rasterize the selected objects against.")));
                return;
            }
            RasterizationPropsDlg dlg = new RasterizationPropsDlg();
            dlg.load(pyMod.getRasterizations().getRastOptions());
            if (dlg.doModal() != 1) {
                return;
            }
            RasterizationOptions props = dlg.save();
            Collection<FDSObject> objs = pyMod.getSelectionModel().flatten(FDSObject.class);
            RasterizeTask tsk = new RasterizeTask(pyMod, objs, props);
            pyMod.getTaskManager().exec(tsk, Intl.intl("Convert to Blocks"));
        }
    }

    private static class AddModelObjAction<T extends IModelObj>
    extends guiAction {
        private static final long serialVersionUID = -620358460530122662L;
        private final Function<PyroMod, T> d_factory;

        public AddModelObjAction(String title, String desc, String pyroIcon, Function<PyroMod, T> factory) {
            this(title, desc, PyroGuiUtil.createNewObjIcon(pyroIcon), factory);
        }

        public AddModelObjAction(String title, String desc, Icon icon, Function<PyroMod, T> factory) {
            super(title, icon);
            this.putValue("ShortDescription", desc);
            this.d_factory = factory;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim app = PyroSim.getApp();
            Set<T> objs = Collections.singleton(this.d_factory.apply(app.getMediator()));
            ModelObjectDialog dlg = new ModelObjectDialog(app.getActiveFrame(), app.getMediator(), objs, Actions.getModelInsertLoc(), 0);
            if (dlg.doModal() == 1) {
                dlg.saveValues(objs);
            }
        }
    }

    private static class AddHvacDuctAction
    extends AddModelObjAction<HvacDuct> {
        private static final long serialVersionUID = 3024479750424912479L;

        public AddHvacDuctAction() {
            super(Intl.intl("New HVAC Duct..."), Intl.intl("New HVAC Duct"), "hvac_duct16.png", (PyroMod mod) -> new HvacDuct(mod.getNames(HvacDuct.class).generateName()));
        }
    }

    private static class AddHvacNodeAction
    extends AddModelObjAction<HvacNode> {
        private static final long serialVersionUID = -4893294826997045376L;

        public AddHvacNodeAction() {
            super(Intl.intl("New HVAC Node..."), Intl.intl("New HVAC Node"), "hvac_node16.png", (PyroMod mod) -> new HvacNode(mod.getNames(HvacNode.class).generateName()));
        }
    }

    private static class AddInitRegionAction
    extends AddModelObjAction<InitRegion> {
        private static final long serialVersionUID = -8850048267472473386L;

        public AddInitRegionAction() {
            super(Intl.intl("New Init Region") + "...", Intl.intl("New Init Region"), PyroGuiUtil.createNewObjIcon("init16.png"), (PyroMod mod) -> {
                AABoxGeom defGeom = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0);
                return new InitRegion(Intl.intl("Init Region"), defGeom);
            });
        }
    }

    private static class AddPartLocationAction
    extends AAddPartCloudAction {
        private static final long serialVersionUID = -3300751757155564813L;

        public AddPartLocationAction() {
            super(Intl.intl("New Particle Location"), PyroGuiUtil.createNewObjIcon("single_part16.gif"), () -> new Point(new Point3d(0.0, 0.0, 0.0)));
        }
    }

    private static class AddPartCloudAction
    extends AAddPartCloudAction {
        private static final long serialVersionUID = 6485134319840189877L;

        public AddPartCloudAction() {
            super(Intl.intl("New Particle Cloud"), (Icon)PyroGuiUtil.loadPyroSimIcon("newpartCloud16.gif"), () -> new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0));
        }
    }

    private static class AAddPartCloudAction
    extends AddModelObjAction<PartCloud> {
        private static final long serialVersionUID = 1125160956409643531L;

        public AAddPartCloudAction(String title, Icon icon, Supplier<IGeom> geomSupplier) {
            super(title + "...", title, icon, (PyroMod mod) -> {
                IGeom defGeom = (IGeom)geomSupplier.get();
                return new PartCloud(Intl.intl("Particle Cloud"), AAddPartCloudAction.getDefaultParticle(mod), defGeom);
            });
        }

        private static Particle getDefaultParticle(PyroMod mod) {
            ParticleList parts = mod.getPartList();
            Particle defPart = (Particle)parts.get(ParticleList.WATER);
            if (defPart == null && !parts.flatten().isEmpty()) {
                defPart = (Particle)parts.flatten().iterator().next();
            }
            return defPart;
        }
    }

    private static class AddHoleAction
    extends AddModelObjAction<Hole> {
        private static final long serialVersionUID = -4133691410946173213L;

        public AddHoleAction() {
            super(Intl.intl("New Hole") + "...", Intl.intl("New Hole"), PyroGuiUtil.loadPyroSimIcon("newhole16.gif"), (PyroMod mod) -> {
                AABoxGeom geom = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0);
                return new Hole(Intl.intl("Hole"), GeomNodeUtil.newNode(geom));
            });
        }
    }

    private static class AddVentAction
    extends AddModelObjAction<Vent> {
        private static final long serialVersionUID = 2560652193221572890L;

        public AddVentAction() {
            super(Intl.intl("New Vent") + "...", Intl.intl("New Vent"), PyroGuiUtil.loadPyroSimIcon("newvent16.gif"), (PyroMod mediator) -> new Vent(mediator.getNames(Vent.class).generateName(), mediator.getDefaultSurface(), new AARectangle()));
        }
    }

    private static class AddSlabAction
    extends AddModelObjAction<Obstruction> {
        private static final long serialVersionUID = 647205419302082191L;

        public AddSlabAction() {
            super(Intl.intl("New Slab") + "...", Intl.intl("New Slab"), PyroGuiUtil.loadPyroSimIcon("new_triangle.png"), (PyroMod mediator) -> {
                ExtrudedPoly defGeom = new ExtrudedPoly(new Quad(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 0.0, 0.0), new Point3d(1.0, 1.0, 0.0), new Point3d(0.0, 1.0, 0.0)), new Vector3d(0.0, 0.0, -0.2));
                return new Obstruction(Intl.intl("Slab"), GeomNodeUtil.newNode(defGeom), new Surface[]{mediator.getDefaultSurface()});
            });
        }
    }

    private static class AddWallAction
    extends AddModelObjAction<Obstruction> {
        private static final long serialVersionUID = -4722144147954253932L;

        public AddWallAction() {
            super(Intl.intl("New Obstruction") + "...", Intl.intl("New Obstruction"), PyroGuiUtil.loadPyroSimIcon("newblock16_2.gif"), (PyroMod mediator) -> {
                AABoxGeom defGeom = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0);
                return new Obstruction(Intl.intl("Obstruction"), GeomNodeUtil.newNode(defGeom), new Surface[]{mediator.getDefaultSurface()});
            });
        }
    }

    private static class SelectByColorAction
    extends AModelObjAction {
        private static final long serialVersionUID = 3466837901925077037L;

        public SelectByColorAction() {
            super(Intl.intl("Select by Color"), Intl.intl("Select All Visible Objects with the Same Color"), AFDSObject.class);
        }

        @Override
        public void updateEnabled() {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            this.setEnabled(!pyMod.getSelectionModel().flatten(FDSObject.class).isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = PyroSim.getApp().getMediator();
            IFilteredCollection<AFDSObject> selObjs = mediator.getSelectionModel().getSelected(AFDSObject.class);
            SelectByColorTask tsk = new SelectByColorTask(mediator, selObjs);
            mediator.getTaskManager().exec(tsk, Intl.intl("Select by Color"));
        }
    }

    private static class SelectByBIMTypeAction
    extends AModelObjAction {
        private static final long serialVersionUID = 1L;

        public SelectByBIMTypeAction() {
            super(Intl.intl("Select By BIM Type"), Intl.intl("Select All Visible Objects With the Same BIM Type"), new Class[0]);
        }

        @Override
        public void updateEnabled() {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            this.setEnabled(!pyMod.getSelectionModel().flatten(IModelObj.class).isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            ArrayList<IPyroObject> selObjs = new ArrayList<IPyroObject>(pyMod.getSelectionModel().getSelected(IPyroObject.class));
            SelectByBIMTypeTask task = new SelectByBIMTypeTask(pyMod, selObjs);
            pyMod.getTaskManager().exec(task, Intl.intl("Select by BIM Type"));
        }
    }

    private static class SelectRefObjectsAction
    extends guiAction {
        private static final long serialVersionUID = 8621399013459559802L;

        public SelectRefObjectsAction() {
            super(Intl.intl("Select Referencing Objects"));
            this.putValue("ShortDescription", Intl.intl("Select all referencing objects"));
        }

        public void updateEnabled(PyroMod mediator, Events events, boolean selChanged) {
            if (selChanged) {
                this.setEnabled(!mediator.getSelectionModel().flatten(IPyroObject.class).isEmpty());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            IFilteredCollection<IPyroObject> selObjs = mediator.getSelectionModel().getSelected(IPyroObject.class);
            SelectReferencingObjTask tsk = new SelectReferencingObjTask(mediator, selObjs);
            tsk.run();
        }
    }

    private static class HeatLinkModelManagerAction
    extends guiAction {
        private static final long serialVersionUID = -4139995227218552645L;

        public HeatLinkModelManagerAction() {
            super(Intl.intl("Edit Heat Detector Models") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Actions.editHeatLinkModels(null);
        }
    }

    private static class SprinklerLinkModelManagerAction
    extends guiAction {
        private static final long serialVersionUID = -6297257725709429957L;

        public SprinklerLinkModelManagerAction() {
            super(Intl.intl("Edit Sprinkler Link Models") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Actions.editSprinklerLinkModels(null);
        }
    }

    private static class SprayModelManagerAction
    extends guiAction {
        private static final long serialVersionUID = 33312413867539079L;

        public SprayModelManagerAction() {
            super(Intl.intl("Edit Spray Models") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Actions.editSprayModel(null);
        }
    }

    private static class ReactionManagerAction
    extends guiAction {
        private static final long serialVersionUID = -6547490850786824553L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/reaction16.gif");

        public ReactionManagerAction() {
            super(Intl.intl("Edit Reactions") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Actions.doEditReactions(null);
        }
    }

    private static class AppearanceManagerAction
    extends guiAction {
        private static final long serialVersionUID = 6756339722458509542L;
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("textures.png");

        public AppearanceManagerAction() {
            super(Intl.intl("Edit Appearances..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod = PyroSim.getApp().getMediator();
            MaterialDB mats = pyMod.getAppearances();
            Collection matsColl = mats.flatten();
            pyrosim.domain.appearance.Material initApp = !matsColl.isEmpty() ? (pyrosim.domain.appearance.Material)matsColl.iterator().next() : null;
            Actions.editAppearance(initApp);
        }
    }

    private static class SurfaceManagerAction
    extends guiAction {
        private static final long serialVersionUID = -5838150951911141872L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/surf2a.gif");

        public SurfaceManagerAction() {
            super(Intl.intl("Edit Surfaces") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PyroSim pySim = (PyroSim)Application.getApp();
            PyroMod pyMod = pySim.getMediator();
            SurfaceManager surfs = pyMod.getSurfaceMgr();
            Actions.editSurfaces(surfs.get(PredefSurf.INERT));
        }
    }

    private static class MaterialManagerAction
    extends guiAction {
        private static final long serialVersionUID = 1944586403465706691L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/surfacedb16.gif");

        public MaterialManagerAction() {
            super(Intl.intl("Edit Materials") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Actions.editMaterials(null);
        }
    }

    public static class GridAction
    extends guiAction {
        private static final long serialVersionUID = -4771890178672966907L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/3dgrid_smooth16.gif");

        public GridAction() {
            super(Intl.intl("Edit Meshes..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Actions.doEditGrids(null);
        }
    }

    private static class ZonesAction
    extends guiAction {
        private static final long serialVersionUID = 4370852229085106087L;
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("zones16.png");

        public ZonesAction() {
            super(Intl.intl("Edit Zones..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.editZones(null);
        }
    }

    private static class ControlsAction
    extends guiAction {
        private static final long serialVersionUID = -1353840320433837535L;
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("or16.png");

        public ControlsAction() {
            super(Intl.intl("Edit Activation Controls..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.editControls(null);
        }
    }

    private static class RotateAction
    extends TransformAction {
        private static final long serialVersionUID = -5606456857221272593L;

        public RotateAction() {
            super(Intl.intl("Rotate") + "...", Intl.intl("Rotate or copy an object"), (PyroMod pyMod, Collection<IPyroObject> objs) -> new RotateDialog((PyroMod)pyMod, (Collection<? extends IPyroObject>)objs));
        }
    }

    private static class ScaleAction
    extends TransformAction {
        private static final long serialVersionUID = -3336637975398614805L;

        public ScaleAction() {
            super(Intl.intl("Scale") + "...", Intl.intl("Scale or copy an object"), (PyroMod pyMod, Collection<IPyroObject> objs) -> new ScaleDialog((PyroMod)pyMod, (Collection<? extends IPyroObject>)objs));
        }
    }

    private static class MirrorAction
    extends TransformAction {
        private static final long serialVersionUID = -462716911275992089L;

        public MirrorAction() {
            super(Intl.intl("Mirror") + "...", Intl.intl("Mirror or copy an object"), (PyroMod pyMod, Collection<IPyroObject> objs) -> new MirrorDialog((PyroMod)pyMod, (Collection<? extends IPyroObject>)objs));
        }
    }

    private static class TranslateAction
    extends TransformAction {
        private static final long serialVersionUID = 7738165452601928234L;

        public TranslateAction() {
            super(Intl.intl("Move") + "...", Intl.intl("Move or copy an object"), (PyroMod pyMod, Collection<IPyroObject> objs) -> new TranslateDialog((PyroMod)pyMod, (Collection<? extends IPyroObject>)objs));
        }
    }

    private static class TransformAction
    extends guiAction {
        private static final long serialVersionUID = 5352086256413199064L;
        private final BiFunction<PyroMod, Collection<IPyroObject>, TransformDialog> d_dlgProducer;

        public TransformAction(String title, String desc, BiFunction<PyroMod, Collection<IPyroObject>, TransformDialog> dlgProducer) {
            super(title);
            this.putValue("ShortDescription", desc);
            this.d_dlgProducer = dlgProducer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim pySim = (PyroSim)Application.getApp();
            PyroMod pyMod = pySim.getMediator();
            Collection sel = Actions.getSelectedGeom(pyMod);
            Collection<IPyroObject> objs = Actions.getTransformObjs(pySim, pyMod, sel);
            TransformDialog dlg = this.d_dlgProducer.apply(pyMod, objs);
            dlg.doModal();
        }
    }

    public static class GroupGeomAction
    extends AModelObjAction {
        private static final long serialVersionUID = -2865070841485475727L;

        public GroupGeomAction() {
            super(Intl.intl("Merge into Composite..."), Intl.intl("Merge multiple objects into one composite object"), IObstruction.class, IHole.class, GenericGeomSrc.class);
        }

        @Override
        public void updateEnabled() {
            Collection<IModelObj> coll = this.getSelObjs();
            boolean enabled = coll.size() >= 2 && (Util.isExclusive(coll, FDSObject.class) || Util.isExclusive(coll, GenericGeomSrc.class));
            this.setEnabled(enabled);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupGeomTask.ConvertType type;
            Collection<IModelObj> coll = this.getSelObjs();
            if (coll.isEmpty()) {
                return;
            }
            if (Util.isExclusive(coll, IObstruction.class)) {
                type = GroupGeomTask.ConvertType.OBSTRUCTION;
            } else if (Util.isExclusive(coll, IHole.class)) {
                type = GroupGeomTask.ConvertType.HOLE;
            } else if (Util.isExclusive(coll, GenericGeomSrc.class)) {
                type = GroupGeomTask.ConvertType.GENERIC;
            } else {
                assert (theUtil.filter(coll, GenericGeomSrc.class).isEmpty());
                String obstStr = Intl.intl("Obstruction");
                String holeStr = Intl.intl("Hole");
                int sel = JOptionPane.showOptionDialog(PyroSim.getApp().getMainFrame(), Intl.intl("The selection has mixed object types. What type of object\nwould you like to turn the selection into?"), Intl.intl("Object Type"), 2, 1, null, new Object[]{obstStr, holeStr, Intl.intl("Cancel")}, obstStr);
                if (sel != 0 && sel != 1) {
                    return;
                }
                type = sel == 0 ? GroupGeomTask.ConvertType.OBSTRUCTION : GroupGeomTask.ConvertType.HOLE;
            }
            GroupGeomTask t = new GroupGeomTask(PyroSim.getApp().getMediator(), coll, type);
            PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Group"));
        }
    }

    public static class ExplodeAction
    extends AModelObjAction {
        private static final long serialVersionUID = 530618320977170151L;

        public ExplodeAction() {
            super(Intl.intl("Explode Composites"), Intl.intl("Explode composite objects into multiple sub-objects"), IObstruction.class, IHole.class, GenericGeomSrc.class);
        }

        @Override
        protected Collection<IModelObj> getSelObjs() {
            return theUtil.filter(super.getSelObjs(), new Predicate<IModelObj>(){

                @Override
                public boolean test(IModelObj o) {
                    return Actions.isExplodable(o.getGeom());
                }
            });
        }

        @Override
        public void updateEnabled() {
            this.setEnabled(!this.getSelObjs().isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection<IModelObj> coll = this.getSelObjs();
            if (coll.isEmpty()) {
                return;
            }
            ExplodeTask t = new ExplodeTask(PyroSim.getApp().getMediator(), coll);
            PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Explode"));
        }
    }

    private static abstract class AModelObjAction
    extends guiAction {
        private static final long serialVersionUID = 4665029373358628882L;
        private TypeFilter<IModelObj> d_filter;

        public AModelObjAction(String name, String shortDesc, Class<? extends IModelObj> ... types) {
            super(name);
            this.putValue("ShortDescription", shortDesc);
            this.d_filter = new TypeFilter(types);
        }

        protected Collection<IModelObj> getSelObjs() {
            return PyroSim.getApp().getMediator().getSelectionModel().flatten(IModelObj.class, this.d_filter);
        }
    }

    private static class ChangeGroupAction
    extends guiAction {
        private static final long serialVersionUID = -8844052856105830129L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/composite16_2.gif");

        public ChangeGroupAction() {
            super(Intl.intl("Change Group") + "...", ICON);
            this.putValue("ShortDescription", Intl.intl("Change Group"));
        }

        public void updateEnabled(PyroMod mediator, Events events, boolean selChanged) {
            if (selChanged) {
                this.setEnabled(this.getEnabled(mediator));
            }
        }

        private boolean getEnabled(PyroMod mediator) {
            IFilteredCollection<IPyroObject> objs = mediator.getSelectionModel().getSelected(IPyroObject.class);
            return this.getMoveInfo(objs) != null;
        }

        private Pair<Composite, Composite> getMoveInfo(Collection<IPyroObject> objs) {
            IPyroObject commonParent = Hierarchy.getCommonParent(objs);
            if (!(commonParent instanceof Composite)) {
                return null;
            }
            IPyroObject categoryRoot = Hierarchy.getCategoryRoot(commonParent);
            if (!(categoryRoot instanceof Composite)) {
                return null;
            }
            return new Pair<Composite, Composite>((Composite)categoryRoot, (Composite)commonParent);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mediator = ((PyroSim)Application.getApp()).getMediator();
            IFilteredCollection<IPyroObject> objs = mediator.getSelectionModel().getSelected(IPyroObject.class);
            Pair<Composite, Composite> moveInfo = this.getMoveInfo(objs);
            assert (moveInfo != null);
            JFrame mf = Application.getApp().getMainFrame();
            GroupChooserDlg<IPyroObject> dlg = new GroupChooserDlg<IPyroObject>((Window)mf, (Composite)moveInfo.v1, (Composite)moveInfo.v2, objs);
            if (dlg.doModal() == 1) {
                Composite target = dlg.getGroup();
                boolean isNew = dlg.isCreateNew();
                String newCompositeName = dlg.getNewText();
                CompositeTask<PyroMod> tsk = new CompositeTask<PyroMod>(mediator);
                if (isNew) {
                    Composite child = target.newGroup(newCompositeName);
                    tsk.addTask(new AddTask(target, new IPyroObject[]{child}));
                    target = child;
                }
                tsk.addTask(new ReorderObjectsTask(target, target.getMembers().size(), objs));
                mediator.getTaskManager().exec(tsk, Intl.intl("Change Group"));
            }
        }
    }

    private static class AddGroupAction
    extends guiAction {
        private static final long serialVersionUID = -5753214153164506236L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/newcomposite16_2.gif");
        private final boolean d_context;

        public AddGroupAction(boolean context) {
            super(Intl.intl("New Group") + "...", ICON);
            this.d_context = context;
            String tt = Intl.intl("Adds a new group to the model.");
            this.putValue("ShortDescription", tt);
        }

        public void updateEnabled(PyroMod mediator, Events events, boolean selChanged) {
            if (this.d_context && selChanged) {
                this.setEnabled(!mediator.getSelectionModel().getSelected(IPyroObject.class).isEmpty());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewGroupDialog<IModelObj> dlg;
            PyroMod mediator = PyroSim.getApp().getMediator();
            IFilteredCollection<IPyroObject> sel = mediator.getSelectionModel().getSelected(IPyroObject.class);
            Composite root = mediator.getObstructions();
            Composite parent = mediator.getObstructions();
            if (!sel.isEmpty()) {
                IPyroObject croot;
                IPyroObject commonParent;
                IPyroObject iPyroObject = commonParent = sel.size() == 1 && sel.iterator().next() instanceof Composite ? (IPyroObject)sel.iterator().next() : Hierarchy.getCommonParent(sel);
                if (commonParent instanceof Composite && (croot = Hierarchy.getCategoryRoot(commonParent)) instanceof Composite) {
                    root = (Composite)croot;
                    parent = (Composite)commonParent;
                }
            }
            if ((dlg = new NewGroupDialog<IModelObj>(Application.getApp().getMainFrame(), root, parent)).doModal() == 1) {
                parent = dlg.getParentComposite();
                String desc = dlg.getCompositeDescription();
                Composite newGroup = parent.newGroup(desc);
                SelectTask tsk = new SelectTask(mediator, newGroup);
                tsk.addTask(new AddTask((IPyroObject)parent, new IPyroObject[]{newGroup}));
                mediator.getTaskManager().exec(tsk, Intl.intl("New Group"));
            }
        }
    }

    public static class ActionStateUpdater
    implements IEventObserver {
        public ActionStateUpdater(PyroMod mediator) {
            this.updateActions(mediator);
        }

        @Override
        public void update(Events events) {
            boolean updateAll = false;
            PyroMod med = ((PyroSim)Application.getApp()).getMediator();
            IEventRecord<PyroMod> pyroEvts = events.getEvents(PyroMod.class, new Class[0]);
            boolean bl = updateAll = updateAll || pyroEvts.isModified();
            if (pyroEvts.containsChange(PyroMod.EVT_MODEL_CHANGED)) {
                med.getTaskManager().clearHistory();
            }
            IEventRecord<Object> objEvts = events.getEvents(Object.class, PyroMod.class, Grid.class);
            updateAll = updateAll || objEvts.hasAddedObjs() || objEvts.hasRemovedObjs() || objEvts.containsChange(PyroMod.EVT_SEL) || objEvts.containsChange(PyroMod.EVT_FDS_EVAC_CHANGED);
            updateAll = updateAll || events.isAffected(Grid.class) || events.isAffected(Reaction.class) || events.isAffected(ExSpec.class) || events.isAffected(SimParams.Misc.class) || events.isAffected(IObstruction.class);
            this.updateActions(med, events, updateAll);
            if (!updateAll) {
                if (objEvts.containsChange(PyroMod.EVT_ENABLED_CHANGED)) {
                    ENABLE_NODE_ACTION.updateState();
                    DISABLE_NODE_ACTION.updateState();
                }
                if (objEvts.containsChange(PyroMod.EVT_FORCEWRITE_CHANGED)) {
                    ENABLE_FORCE_TO_WRITE_ACTION.updateState(med);
                    DISABLE_FORCE_TO_WRITE_ACTION.updateState(med);
                }
            }
            Actions.updateUndoRedoActions(med);
        }

        private void updateActions(PyroMod mediator) {
            this.updateActions(mediator, null, true);
        }

        private void updateActions(PyroMod mediator, Events events, boolean force) {
            PyroSimSelectionModel sm = mediator.getSelectionModel();
            if (force) {
                SELECT_HVAC_NETWORK.updateState(mediator);
                SELECT_BY_COLOR_ACTION.setEnabled(true);
                ENABLE_NODE_ACTION.updateState();
                DISABLE_NODE_ACTION.updateState();
                IFilteredCollection<Composite> groups = sm.getSelected(Composite.class);
                Actions.getSortAction().setEnabled(!groups.isEmpty());
                Collection<IPyroGeomSrc> geoms = sm.flatten(IPyroGeomSrc.class);
                Actions.getAddFloorFromGeomAction().setEnabled(!geoms.isEmpty());
                RASTERIZE_OBJECTS_ACTION.updateEnabled();
                WRITE_AS_GEOM.updateEnabled();
                WRITE_AS_OBST.updateEnabled();
                EXPLODE_ACTION.updateEnabled();
                GROUP_GEOM_ACTION.updateEnabled();
                SELECT_BY_COLOR_ACTION.updateEnabled();
                ADD_HVAC_VENT_NODES.updateEnabled();
                CONNECT_WITH_HVAC.updateEnabled(mediator);
                EXTRUDE_LINES.updateEnabled();
                IFilteredCollection<Surface> surfs = sm.getSelected(Surface.class);
                SET_DEFAULT_SURFACE_ACTION.setEnabled(surfs.isExclusive() && surfs.size() == 1 && surfs.iterator().next() != mediator.getSimParams().getMisc().getSurfDefault());
                IFilteredCollection<Reaction> reacs = sm.getSelected(Reaction.class);
                CLEAR_REACTION_ACTION.setEnabled(reacs.isExclusive() && reacs.size() == 1 && ((Reaction)reacs.iterator().next()).isActive());
                SET_REACTION_ACTION.setEnabled(reacs.isExclusive() && reacs.size() == 1 && !((Reaction)reacs.iterator().next()).isActive());
                IFilteredCollection<ExSpec> specs = sm.getSelected(ExSpec.class);
                CLEAR_BACKGROUND_ACTION.setEnabled(specs.isExclusive() && specs.size() == 1 && ((ExSpec)specs.iterator().next()).isBackgroundSpec());
                SET_BACKGROUND_ACTION.setEnabled(specs.isExclusive() && specs.size() == 1 && !((ExSpec)specs.iterator().next()).isBackgroundSpec());
                ENABLE_FORCE_TO_WRITE_ACTION.updateState(mediator);
                DISABLE_FORCE_TO_WRITE_ACTION.updateState(mediator);
                IFilteredCollection<IPyroObject> grids = sm.getSelected(IPyroObject.class, Grid.class, GridList.class);
                Actions.getOpenGridsAction().setEnabled(!grids.isEmpty() && grids.isExclusive());
                Actions.getSubdivideMeshAction().setEnabled(!grids.isEmpty() && grids.isExclusive());
                Actions.getRefineMeshAction().setEnabled(!grids.isEmpty() && grids.isExclusive());
                Actions.getMergeMeshAction().setEnabled(ActionsMesh.MergeMeshAction.isMergeOptionAvailable(sm));
                Actions.getTranslateAction().setEnabled(!geoms.isEmpty());
                Actions.getMirrorAction().setEnabled(!geoms.isEmpty());
                Actions.getScaleAction().setEnabled(!geoms.isEmpty());
                Actions.getRotateAction().setEnabled(!geoms.isEmpty());
                HIDE_NODE_ACTION.setEnabled(!geoms.isEmpty());
                SHOW_NODE_ACTION.setEnabled(!geoms.isEmpty());
                HIDE_UNSELECTED_NODE_ACTION.setEnabled(!geoms.isEmpty());
                SHOW_ALL_NODES_ACTION.setEnabled(true);
                IFilteredCollection<IPyroObject> pyros = sm.getSelected(IPyroObject.class);
                boolean cutEnabled = !pyros.isEmpty();
                boolean copyEnabled = !pyros.isEmpty();
                boolean removeEnabled = !pyros.isEmpty();
                CUT_ACTION.setEnabled(cutEnabled);
                COPY_ACTION.setEnabled(copyEnabled);
                COPY_FDS_ACTION.setEnabled(copyEnabled);
                REMOVE_SELECTED_NODE_ACTION.setEnabled(removeEnabled);
                EDIT_SELECTED_NODE_ACTION.updateEnabled(mediator);
                PASTE_ACTION.setEnabled(true);
                Actions.updateUndoRedoActions(mediator);
            }
            CONTEXT_ADD_GROUP_ACTION.updateEnabled(mediator, events, force);
            GLOBAL_ADD_GROUP_ACTION.updateEnabled(mediator, events, force);
            SELECT_REFERENCING_OBJECTS_ACTION.updateEnabled(mediator, events, force);
            CHANGE_GROUP.updateEnabled(mediator, events, force);
            CONTEXT_ADD_VIEW.updateEnabled(mediator, events, force);
            SET_ACTIVE_VIEW_ACTION.updateEnabled(mediator, events, force);
            CONTEXT_ADD_SECTION_BOX.updateEnabled(mediator, events, force);
            GLOBAL_ADD_SECTION_BOX.updateEnabled(mediator, events, force);
            CONTEXT_RESET_SECTION_BOX.updateEnabled(mediator, events, force);
            GLOBAL_RESET_SECTION_BOX.updateEnabled(mediator, events, force);
            CONTEXT_SAVE_VIEW_CAMERA.updateEnabled(mediator, events, force);
            GLOBAL_SAVE_VIEW_CAMERA.updateEnabled(mediator, events, force);
            CONTEXT_SHOW_VIEW_CAMERA.updateEnabled(mediator, events, force);
            GLOBAL_SHOW_VIEW_CAMERA.updateEnabled(mediator, events, force);
            CREATE_SECTION.updateEnabled(mediator, events, force);
            DUPLICATE_VIEW.updateEnabled(mediator, events, force);
        }
    }
}

