/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.ModelImage;
import pyrosim.gui.FloorBGImageEditor;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Global;

public class ManageFloorsDlg
extends guiDialog {
    private static final long serialVersionUID = -3663137074371411086L;
    private guiTable d_table;
    private PyroMod d_mediator;
    private UnitSystem d_unitSystem;
    private FloorBGImageEditor.EditBGImageAction d_editImageAction;
    private BGImageTableCell d_bgImageCell;

    public ManageFloorsDlg(JFrame owner, PyroMod mediator, FloorBGImageEditor.EditBGImageAction imageEditor) {
        super((Window)owner, Intl.intl("Manage Floors"), 9);
        this.d_mediator = mediator;
        this.d_editImageAction = imageEditor;
        this.d_editImageAction.acquire();
        JButton newFloorBtn = new JButton(new AddFloorAction());
        String[] headers = new String[Column.values().length];
        Class[] colClasses = new Class[Column.values().length];
        for (int m = 0; m < Column.values().length; ++m) {
            Column col = Column.values()[m];
            headers[m] = col.desc;
            colClasses[m] = col.type;
        }
        this.d_table = guiTableUtil.fixedColumnTable(headers, colClasses, 0, Integer.MAX_VALUE, 31);
        this.d_table.setSortOrder(0);
        this.d_bgImageCell = new BGImageTableCell();
        this.d_table.setDefaultRenderer(ModelImage.class, this.d_bgImageCell);
        this.d_table.setDefaultEditor(ModelImage.class, this.d_bgImageCell);
        this.d_table.setDefaultEditor(UnitDouble.class, new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getLengthUnit()));
        this.d_table.autoSizeColumns(200);
        guiTableEditor e = new guiTableEditor(this.d_table, 18);
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(newFloorBtn, 0);
        gb.addRow(e, new double[]{1.0, 1.0}, new int[]{0, 0});
        gb.finalizeRows();
        this.loadValues();
        this.setDisposeAfterModal(false);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        int row;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        TableModel model = this.d_table.getModel();
        for (row = 0; row < model.getRowCount(); ++row) {
            for (Column col : Column.values()) {
                if (col.nullAllowed || model.getValueAt(row, col.ordinal()) != null) continue;
                if (col == Column.CLIPCOLOR) {
                    this.d_table.setValueAt(Floor.DEFAULT_COLOR, row, col.ordinal());
                    continue;
                }
                if (showWarn) {
                    int viewRow = this.d_table.convertRowIndexToView(row) + 1;
                    String msg = String.format(Intl.intl("Error on row %d: %s must not be empty."), viewRow, col.desc);
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Error"), 0);
                }
                return false;
            }
        }
        for (int rowA = 0; rowA < model.getRowCount(); ++rowA) {
            String rowAName = (String)model.getValueAt(rowA, Column.NAME.ordinal());
            for (int rowB = rowA + 1; rowB < model.getRowCount(); ++rowB) {
                String rowBName = (String)model.getValueAt(rowB, Column.NAME.ordinal());
                if (!rowAName.equals(rowBName)) continue;
                if (showWarn) {
                    int viewRowA = this.d_table.convertRowIndexToView(rowA) + 1;
                    int viewRowB = this.d_table.convertRowIndexToView(rowB) + 1;
                    String msg = String.format(Intl.intl("Error on rows %d and %d: each floor must have a unique name."), viewRowA, viewRowB);
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Error"), 0);
                }
                return false;
            }
        }
        for (row = 0; row < model.getRowCount(); ++row) {
            UnitDouble slabThickness = (UnitDouble)model.getValueAt(row, Column.SLAB.ordinal());
            UnitDouble wallHeight = (UnitDouble)model.getValueAt(row, Column.WALL.ordinal());
            if (!(slabThickness.getValueNoUnit() < 0.0) && !(wallHeight.getValueNoUnit() < 0.0)) continue;
            if (showWarn) {
                int viewRow = this.d_table.convertRowIndexToView(row) + 1;
                String msg = String.format(Intl.intl("Error on row %d: Slab Thickness and Wall Height must be >= 0."), viewRow);
                JOptionPane.showMessageDialog(this, msg, Intl.intl("Error"), 0);
            }
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.d_editImageAction.release();
        super.dispose();
    }

    @Override
    public int doModal() {
        int res = super.doModal();
        if (res != 1) {
            this.dispose();
        }
        return res;
    }

    private void loadValues() {
        int i = 0;
        for (Floor f : this.d_mediator.getFloorManager().flatten()) {
            this.load(f, i);
            ++i;
        }
    }

    private void load(Floor f, int row) {
        guiDefaultTableModel tm = (guiDefaultTableModel)this.d_table.getModel();
        tm.setValueAt(f.getName(), row, Column.NAME.ordinal());
        tm.setValueAt(f.getElevation(), row, Column.ELEVATION.ordinal());
        tm.setValueAt(f.getWallHeight(), row, Column.WALL.ordinal());
        tm.setValueAt(f.getSlabThickness(), row, Column.SLAB.ordinal());
        tm.setValueAt(f.getBgImage(), row, Column.BG.ordinal());
        tm.setValueAt(f.getClipColor(), row, Column.CLIPCOLOR.ordinal());
    }

    public void saveValues() {
        this.d_mediator.pauseUpdates();
        List<Floor> newFloors = this.saveFloors();
        FloorManager fm = this.d_mediator.getFloorManager();
        ArrayList<Floor> floorsRemoved = new ArrayList<Floor>();
        ArrayList<Floor> floorsAdded = new ArrayList<Floor>();
        HashMap<String, Floor> floorsNotAdded = new HashMap<String, Floor>();
        for (Floor newFloor : newFloors) {
            Floor oldFloor = (Floor)fm.get(newFloor.getName());
            if (oldFloor != null) {
                if (!newFloor.equals(oldFloor)) {
                    oldFloor.setName(newFloor.getName());
                    oldFloor.setBgImage(newFloor.getBgImage());
                    oldFloor.setElevation(newFloor.getElevation());
                    oldFloor.setSlabThickness(newFloor.getSlabThickness());
                    oldFloor.setWallHeight(newFloor.getWallHeight());
                    oldFloor.setClipColor(newFloor.getClipColor());
                }
                floorsNotAdded.put(newFloor.getName(), oldFloor);
                continue;
            }
            floorsAdded.add(newFloor);
        }
        for (Floor oldFloor : fm.flatten()) {
            Floor changedFloor = (Floor)floorsNotAdded.get(oldFloor.getName());
            if (changedFloor != null) continue;
            floorsRemoved.add(oldFloor);
        }
        fm.addAll(floorsAdded);
        fm.removeAll(floorsRemoved);
        this.d_mediator.resumeUpdates();
    }

    protected List<Floor> saveFloors() {
        ArrayList<Floor> newFloors = new ArrayList<Floor>();
        guiDefaultTableModel tm = (guiDefaultTableModel)this.d_table.getModel();
        int count = tm.getRowCount();
        for (int i = 0; i < count; ++i) {
            String name = (String)tm.getValueAt(i, Column.NAME.ordinal());
            UnitDouble elevation = (UnitDouble)tm.getValueAt(i, Column.ELEVATION.ordinal());
            UnitDouble wallHeight = (UnitDouble)tm.getValueAt(i, Column.WALL.ordinal());
            UnitDouble slabThickness = (UnitDouble)tm.getValueAt(i, Column.SLAB.ordinal());
            ModelImage bgImage = (ModelImage)tm.getValueAt(i, Column.BG.ordinal());
            Color color = (Color)tm.getValueAt(i, Column.CLIPCOLOR.ordinal());
            Floor newFloor = new Floor(name, elevation, slabThickness, wallHeight, bgImage, color);
            newFloors.add(newFloor);
        }
        return newFloors;
    }

    private class BGImageTableCell
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private static final long serialVersionUID = -4378633585542267895L;
        private FloorBGImageEditor d_editor;
        private FloorBGImageEditor d_renderer;
        private DefaultTableCellRenderer d_defaultRend = new DefaultTableCellRenderer();
        private DefaultCellEditor d_defaultEditor = new DefaultCellEditor(new JTextField());

        public BGImageTableCell() {
            this.d_editor = new FloorBGImageEditor(null, ManageFloorsDlg.this.d_editImageAction);
            this.d_renderer = new FloorBGImageEditor(null, ManageFloorsDlg.this.d_editImageAction);
            ActionListener editingDoneListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BGImageTableCell.this.stopCellEditing();
                }
            };
            this.d_editor.addFloorEditedListener(editingDoneListener);
            this.d_editor.addFloorDeletedListener(editingDoneListener);
            this.d_renderer.addFloorEditedListener(editingDoneListener);
            this.d_renderer.addFloorDeletedListener(editingDoneListener);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                Rectangle[] btnBounds;
                MouseEvent me = (MouseEvent)e;
                guiTable tbl = (guiTable)me.getSource();
                int row = tbl.rowAtPoint(me.getPoint());
                int col = tbl.columnAtPoint(me.getPoint());
                Rectangle rendBounds = tbl.getCellRect(row, col, false);
                Point clickLoc = new Point(me.getX() - rendBounds.x, me.getY() - rendBounds.y);
                for (Rectangle bound : btnBounds = new Rectangle[]{this.d_renderer.getEditButton().getBounds(), this.d_renderer.getDeleteButton().getBounds()}) {
                    if (!bound.contains(clickLoc)) continue;
                    return true;
                }
                return me.getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component sampleComp = this.d_defaultEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            return this.getComponent(this.d_editor, sampleComp, table, value, row, column, true, true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component sampleComp = this.d_defaultRend.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this.getComponent(this.d_renderer, sampleComp, table, value, row, column, isSelected, hasFocus);
        }

        @Override
        public Object getCellEditorValue() {
            return this.d_editor.getEditingFloor().getBgImage();
        }

        private Component getComponent(FloorBGImageEditor component, Component defaultComp, JTable table, Object value, int row, int column, boolean isSelected, boolean hasFocus) {
            String name = (String)table.getValueAt(row, Column.NAME.ordinal());
            if (name == null) {
                name = "";
            }
            ModelImage bgImage = (ModelImage)value;
            Floor defFloor = new Floor("");
            Floor tempFloor = new Floor(name, new UnitDouble(0.0, SI.METER), new UnitDouble(0.0, SI.METER), defFloor.getSlabThickness().add(defFloor.getWallHeight()), bgImage, Floor.DEFAULT_COLOR);
            component.setEditingFloor(tempFloor);
            Color bgColor = defaultComp.getBackground();
            Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            if (defaultComp instanceof JComponent) {
                border = ((JComponent)defaultComp).getBorder();
            }
            component.setBorder(border);
            component.setBackground(bgColor);
            return component;
        }
    }

    private static class NewFloorDlg
    extends guiDialog {
        private static final long serialVersionUID = 8076233534308445082L;
        private final List<Floor> d_floors;
        private final guiTextField d_name;
        private final ValueField<UnitDouble> d_elevation;
        private final ValueField<UnitDouble> d_slab;
        private final ValueField<UnitDouble> d_wall;
        private final Color d_newColor;

        public NewFloorDlg(Window parent, List<Floor> floors) {
            super(parent, Intl.intl("New Floor"), 9);
            UnitDouble defElevation;
            UnitDouble defWall;
            UnitDouble defSlab;
            this.d_floors = floors;
            this.d_name = new guiTextField();
            IUnitSrc ltype = UnitSystem.getSource(0);
            this.d_elevation = ValueFields.udFld(ltype);
            this.d_slab = ValueFields.udFld(ltype, UnitDoubleVR.above(0.0, SI.METER, true));
            this.d_wall = ValueFields.udFld(ltype, UnitDoubleVR.above(0.0, SI.METER, true));
            if (!floors.isEmpty()) {
                Floor prevFloor = floors.get(floors.size() - 1);
                defSlab = prevFloor.getSlabThickness();
                defWall = prevFloor.getWallHeight();
                defElevation = this.suggestElevation(floors, defSlab);
                this.d_newColor = floors.get(floors.size() - 1).getClipColor();
            } else {
                Floor defFloor = new Floor("");
                defElevation = defFloor.getElevation();
                defWall = defFloor.getWallHeight();
                defSlab = defFloor.getSlabThickness();
                this.d_newColor = Floor.DEFAULT_COLOR;
            }
            this.d_elevation.setValue(defElevation);
            this.d_slab.setValue(defSlab);
            this.d_wall.setValue(defWall);
            this.d_name.setValue(this.suggestName(defElevation));
            final PropertyChangeListener elevationListener = evt -> {
                if (!this.d_elevation.validateData(false, false)) {
                    return;
                }
                this.d_name.setValue(this.suggestName((UnitDouble)this.d_elevation.getValue()));
            };
            final PropertyChangeListener slabListener = evt -> {
                UnitDouble slab = (UnitDouble)this.d_slab.getValue();
                UnitDouble newElevation = this.suggestElevation(floors, slab);
                this.d_elevation.setValue(newElevation);
            };
            this.d_slab.addValueCommitListener(slabListener);
            this.d_elevation.addValueChangeListener(elevationListener);
            this.d_elevation.addValueCommitListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    d_slab.removeValueCommitListener(slabListener);
                    d_elevation.removeValueCommitListener(this);
                }
            });
            this.d_name.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    d_elevation.removeValueChangeListener(elevationListener);
                    d_name.removeKeyListener(this);
                }
            });
            guiLabel keyLbl = new guiLabel(PyroGuiUtil.loadPyroSimIcon("floor_key.png"));
            keyLbl.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.d_colSpace = 24;
            gb.addRow(Intl.intl("Name:"), this.d_name, 1, 1.0, keyLbl, new double[]{1.0, 1.0}, new int[]{0, 0});
            gb.addRow(Intl.intl("Slab Thickness (A):"), this.d_slab, 1, 1.0);
            gb.addRow(Intl.intl("Elevation (B):"), this.d_elevation, 1, 1.0);
            gb.addRow(Intl.intl("Wall Height (C):"), this.d_wall, 1, 1.0);
            gb.finalizeRows();
        }

        private String suggestName(UnitDouble elevation) {
            elevation = elevation.convert(PyroSim.getApp().getUnitSystem().getLengthUnit());
            return String.format(Intl.intl("Floor %s"), Global.format(elevation));
        }

        private UnitDouble suggestElevation(List<Floor> floors, UnitDouble slabThickness) {
            if (floors.isEmpty()) {
                assert (false);
                Floor defFloor = new Floor("");
                return defFloor.getElevation();
            }
            Floor prevFloor = floors.get(floors.size() - 1);
            return prevFloor.getCeilingLoc().add(slabThickness);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (showWarn) {
                Floor floor = this.save();
                for (Floor existingFloor : this.d_floors) {
                    if (!floor.intersects(existingFloor)) continue;
                    String msg = String.format(Intl.intl("Floor overlaps %s. Would you like to continue?"), existingFloor.getName());
                    int option = JOptionPane.showConfirmDialog(this, msg, Intl.intl("Overlapping Floors"), 0);
                    if (option == 0) break;
                    return false;
                }
            }
            return true;
        }

        public Floor save() {
            return new Floor(this.d_name.getText(), (UnitDouble)this.d_elevation.getValue(), (UnitDouble)this.d_slab.getValue(), (UnitDouble)this.d_wall.getValue(), null, this.d_newColor);
        }
    }

    private class AddFloorAction
    extends guiAction {
        private static final long serialVersionUID = 8519975812980401958L;

        public AddFloorAction() {
            super(Intl.intl("Add Floor..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ManageFloorsDlg.this.validateData(true, true)) {
                return;
            }
            List<Floor> tempFloors = ManageFloorsDlg.this.saveFloors();
            Collections.sort(tempFloors, new Floor.CompareLevel());
            NewFloorDlg dlg = new NewFloorDlg(ManageFloorsDlg.this.getOwner(), tempFloors);
            if (dlg.doModal() != 1) {
                return;
            }
            Floor newFloor = dlg.save();
            TableModel tm = ManageFloorsDlg.this.d_table.getModel();
            int row = tm.getRowCount();
            ManageFloorsDlg.this.load(newFloor, row);
        }
    }

    private static enum Column {
        NAME(Intl.intl("Name"), String.class, false),
        ELEVATION(Intl.intl("Elevation"), UnitDouble.class, false),
        SLAB(Intl.intl("Slab Thickness"), UnitDouble.class, false),
        WALL(Intl.intl("Wall Height"), UnitDouble.class, false),
        CLIPCOLOR(Intl.intl("Clip Color"), Color.class, false),
        BG(Intl.intl("Background Image"), ModelImage.class, true);

        public final String desc;
        public final Class type;
        public final boolean nullAllowed;

        private Column(String desc, Class type, boolean nullAllowed) {
            this.desc = desc;
            this.type = type;
            this.nullAllowed = nullAllowed;
        }
    }
}

