/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import thunderheadeng.gui.HTMLLabel;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class CloudFDSDlg
extends guiDialog {
    static final long serialVersionUID = 1L;
    private static Collection<Integer> s_cpuOpts = new ArrayList<Integer>();
    private final guiComboBox<CLOUD_PROVIDERS> d_cloudServCombo = new guiComboBox<CLOUD_PROVIDERS>(CLOUD_PROVIDERS.CFD_FEA);
    private final guiTextField d_apiKeyField = new guiTextField();
    private final guiComboBox<FDS_VERS> d_fdsVerCombo;
    private final guiComboBox<MEM_OPTS> d_ramCombo;
    private final guiComboBox<Integer> d_cpuCombo;

    public CloudFDSDlg(JFrame owner, File outFile) {
        super((Window)owner, Intl.intl("Cloud FDS Parameters"), 9);
        this.d_apiKeyField.setRangeCheck(true);
        this.d_apiKeyField.setToolTipText(Intl.intl("Enter the API Key from your CFD FEA Service Account Profile"));
        this.d_fdsVerCombo = new guiComboBox<FDS_VERS>(FDS_VERS.FDS_6_7_4);
        this.d_ramCombo = new guiComboBox<MEM_OPTS>(MEM_OPTS.HIGHCPU, MEM_OPTS.STANDARD, MEM_OPTS.HIGHMEM);
        this.d_cpuCombo = new guiComboBox<Integer>(s_cpuOpts);
        guiPanel panel = this.getDialogPane();
        panel.setLayout(new MigLayout("insets 0", "[][50][50]"));
        HTMLLabel serviceLink = new HTMLLabel("<a href=https://cloudhpc.cloud/cloud-hpc-registration-thunderheadeng/>Create a new CFD FEA Service Account</a>", 200);
        System.out.println("HTML label height: " + serviceLink.getHeight());
        System.out.println("HTML label preferred size: " + serviceLink.getPreferredSize());
        System.out.println("HTML Label size: " + serviceLink.getSize());
        panel.add(new guiLabel(Intl.intl("Cloud Provider:")));
        panel.add(this.d_cloudServCombo, "growx, wrap");
        panel.add(new guiLabel(Intl.intl("API Key:")));
        panel.add((Component)this.d_apiKeyField, "wrap, growx, span 2");
        panel.add((Component)serviceLink, "gapbottom 2, wrap, skip 1, spanx 2");
        panel.add(new guiLabel(Intl.intl("FDS Version:")));
        panel.add(this.d_fdsVerCombo, "growx, wrap");
        panel.add(new guiLabel(Intl.intl("Number of vCPUs:")));
        panel.add(this.d_cpuCombo, "growx, wrap");
        panel.add(new guiLabel(Intl.intl("Memory Options:")));
        panel.add(this.d_ramCombo, "growx, wrap -20px");
        panel.setPreferredSize(new Dimension(330, 180));
        this.initDefaults();
    }

    private void initDefaults() {
        this.d_fdsVerCombo.setSelectedItem((Object)FDS_VERS.FDS_6_7_4);
        this.d_apiKeyField.setValue(PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey));
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_apiKeyField.getText().trim().isEmpty()) {
            return this.invalidateFld(showWarn, allowModify, this.d_apiKeyField, Intl.intl("Please enter an API Key."));
        }
        return true;
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        if (result == 1) {
            PyroSim.setPref(PyroPrefs.FDSFEA_ApiKey, this.d_apiKeyField.getValue(), false);
            System.out.println(PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey));
        }
        return result;
    }

    public CLOUD_PROVIDERS getProvider() {
        return this.d_cloudServCombo.getSelectedItem();
    }

    public FDS_VERS getFDSVers() {
        return this.d_fdsVerCombo.getSelectedItem();
    }

    public MEM_OPTS getRamOpts() {
        return this.d_ramCombo.getSelectedItem();
    }

    public int getNumCores() {
        return this.d_cpuCombo.getSelectedItem();
    }

    public String getAPIKey() {
        return this.d_apiKeyField.getValue();
    }

    public CFD_FEA_Params getParams() {
        return new CFD_FEA_Params(this.getAPIKey(), this.getFDSVers(), this.getRamOpts(), this.getNumCores());
    }

    static {
        s_cpuOpts.add(1);
        s_cpuOpts.add(2);
        s_cpuOpts.add(4);
        s_cpuOpts.add(8);
        s_cpuOpts.add(16);
        s_cpuOpts.add(32);
        s_cpuOpts.add(64);
        s_cpuOpts.add(96);
    }

    public static class CFD_FEA_Params {
        public final FDS_VERS version;
        public final MEM_OPTS ramOpts;
        public final int numCores;
        public final String uri;
        public final String apiKey;

        public CFD_FEA_Params(String apiKey, FDS_VERS vers, MEM_OPTS ram, int cores) {
            this.apiKey = apiKey;
            this.version = vers;
            this.ramOpts = ram;
            this.numCores = cores;
            this.uri = CLOUD_PROVIDERS.CFD_FEA.URI;
        }
    }

    public static enum MEM_OPTS {
        HIGHCPU("1 GB / vCPU", "highcpu"),
        STANDARD("4 GB / vCPU", "standard"),
        HIGHMEM("8 GB / vCPU", "highmem");

        public final String name;
        public final String value;

        private MEM_OPTS(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum FDS_VERS {
        FDS_6_7_4("fds6.7.4", "FDS 6.7.4");

        public final String value;
        public final String name;

        private FDS_VERS(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum CLOUD_PROVIDERS {
        CFD_FEA("CFD FEA", "https://cloud.cfdfeaservice.it");

        public final String name;
        public final String URI;

        private CLOUD_PROVIDERS(String serviceName, String URI2) {
            this.name = serviceName;
            this.URI = URI2;
        }

        public String toString() {
            return this.name;
        }
    }
}

