/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.scenario;

import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.scenario.Scenario;
import pyrosim.domain.scenario.ScenarioList;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;

public class ScenariosCtrl {
    private ScenarioList d_scenarios = null;
    private IEventObserver d_modelObjListener = events -> this.modelObjChangeHandler(events);

    public void attach(PyroMod pyMod) {
        this.d_scenarios = pyMod.getScenarios();
        this.listenForPropertyChanges(pyMod.getEvents());
    }

    private void listenForPropertyChanges(Events events) {
        if (!events.getObservers().contains(this.d_modelObjListener)) {
            events.addObserver(this.d_modelObjListener);
        }
    }

    public void ignorePropertyChanges(Events events) {
        events.removeObserver(this.d_modelObjListener);
    }

    private void modelObjChangeHandler(Events events) {
        Scenario current = this.d_scenarios.getActive();
        if (current == null) {
            return;
        }
        IEventRecord<IPyroObject> allEvents = events.getEvents(IPyroObject.class, new Class[0]);
        for (IPyroObject obj : allEvents.getChangedObjs(PyroMod.EVT_ENABLED_CHANGED)) {
            current.recordStatus(obj);
        }
        this.d_scenarios.removeDeletedObjs(allEvents.getRemovedObjs());
    }
}

