/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacNode;

public class HvacUtil {
    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacNode node) {
        return new NodeFilter(node);
    }

    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacDuct duct) {
        return new DuctFilter(duct);
    }

    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacDuct duct1, HvacDuct duct2) {
        return new DuctFilter2(duct1, duct2);
    }

    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacNode node, HvacDuct duct1, HvacDuct duct2) {
        NodeFilter nodeFilter = new NodeFilter(node);
        return nodeFilter.and(new DuctFilter2(duct1, duct2));
    }

    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacNode node, HvacDuct duct) {
        NodeFilter nodeFilter = new NodeFilter(node);
        return nodeFilter.and(new DuctFilter(duct));
    }

    public static Collection<HvacDuctLoss> getDuctLosses(BridgeList bridges, HvacNode node) {
        return bridges.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(node));
    }

    public static Collection<HvacDuctLoss> getDuctLosses(BridgeList bridges, HvacDuct duct) {
        return bridges.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(duct));
    }

    public static Collection<HvacDuctLoss> getDuctLosses(BridgeList bridges, HvacDuct duct1, HvacDuct duct2) {
        return bridges.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(duct1, duct2));
    }

    public static HvacDuctLoss getDuctLoss(BridgeList bridges, HvacNode node, HvacDuct duct1, HvacDuct duct2) {
        Collection<HvacDuctLoss> losses = bridges.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(node, duct1, duct2));
        return losses.isEmpty() ? null : losses.iterator().next();
    }

    public static Collection<HvacDuctLoss> getDuctLosses(BridgeList bridges, HvacNode node, HvacDuct duct) {
        return bridges.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(node, duct));
    }

    public static Predicate<HvacDuct> getConnectedDuctsFilter(HvacNode node) {
        return new ConnectedNodeFilter(node);
    }

    public static Collection<HvacDuct> getConnectedDucts(ModelComposite group, HvacNode node) {
        return group.flatten(HvacDuct.class, HvacUtil.getConnectedDuctsFilter(node));
    }

    public static class DuctFilter2
    implements Predicate<HvacDuctLoss> {
        public final HvacDuct duct1;
        public final HvacDuct duct2;

        public DuctFilter2(HvacDuct duct1, HvacDuct duct2) {
            this.duct1 = duct1;
            this.duct2 = duct2;
        }

        @Override
        public boolean test(HvacDuctLoss o) {
            return this.accept(o);
        }

        public boolean accept(HvacDuctLoss o) {
            return o.duct1 == this.duct1 && o.duct2 == this.duct2 || o.duct1 == this.duct2 && o.duct2 == this.duct1;
        }
    }

    public static class DuctFilter
    implements Predicate<HvacDuctLoss> {
        public final HvacDuct duct;

        public DuctFilter(HvacDuct duct) {
            this.duct = duct;
        }

        @Override
        public boolean test(HvacDuctLoss o) {
            return o.duct1 == this.duct || o.duct2 == this.duct;
        }
    }

    public static class NodeFilter
    implements Predicate<HvacDuctLoss> {
        public final HvacNode node;

        public NodeFilter(HvacNode node) {
            this.node = node;
        }

        @Override
        public boolean test(HvacDuctLoss o) {
            return o.node == this.node;
        }
    }

    public static class ConnectedNodeFilter
    implements Predicate<HvacDuct> {
        public final HvacNode node;

        public ConnectedNodeFilter(HvacNode node) {
            this.node = node;
        }

        @Override
        public boolean test(HvacDuct o) {
            return o.getNodes().contains(this.node);
        }
    }
}

