/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.Point2d;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.geom.TexCoordGenerator;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.CachedSupplier;
import thunderheadeng.util.Pair;

public class FDSUtil {
    public static DisplayGeom getRastDisplay(IPyroDisplayProps dispProps, FDSObject obj, TexOrigin texOrigin) {
        if (dispProps == null || dispProps.getRasterizer() == null || !dispProps.getRasterizer().shouldRasterize(obj)) {
            return null;
        }
        FDSRasterization rast = dispProps.getRasterizer();
        FDSObjectRasterization objRast = rast.rasterize(obj);
        if (objRast == null) {
            return DisplayGeom.EMPTY;
        }
        ArrayList geoms = new ArrayList(objRast.geoms.length);
        PropsBuilder propsBuilder = new PropsBuilder();
        for (Pair<IGeom, FaceProps[]> pair : objRast.geoms) {
            geoms.add(pair.v1);
            if (((FaceProps[])pair.v2).length == 1) {
                IPrimProps prop = objRast.fragGen.generateDisplayProps(((FaceProps[])pair.v2)[0]);
                int numFaces = ((IGeom)pair.v1).getNumPrims(1);
                propsBuilder.add(prop, numFaces);
                continue;
            }
            for (FaceProps prop : (FaceProps[])pair.v2) {
                propsBuilder.add(objRast.fragGen.generateDisplayProps(prop));
            }
        }
        IPropsSrc props = propsBuilder.finalizeProps();
        GeomGroup geom = new GeomGroup(geoms);
        IGeomNode node = GeomNodeUtil.newNode(geom);
        PlanarCoordMapper texGen = TexCoordGenerator.newGenerator(node, texOrigin);
        node = node.initUVElements(texGen);
        return new DisplayGeom(node, props);
    }

    public static Color resolveObstPropColor(Color c, Surface s) {
        if (c != null || s == null) {
            return c;
        }
        return s.getColor();
    }

    public static IPrimProps.Face newObstFaceProps(Color color, Surface surf, int options) {
        assert (color != null || surf != null);
        Color primColor = FDSUtil.resolveObstPropColor(color, surf);
        if (surf.getAppearance() == null) {
            surf = null;
        }
        assert (primColor != null || surf != null);
        return new IPrimProps.Face(primColor, surf, options);
    }

    public static boolean isDefaultTexMapper(IElemSource<Point2d> mapper) {
        return mapper == Elements.NO_UV || mapper instanceof ElementUniform && mapper.getPrimSource(0) == Elements.NO_UV;
    }

    public static IElemSource<Point2d> getDefaultTexMapper() {
        return Elements.NO_UV;
    }

    public static Map<String, IElemSource<Point2d>> getDefaultTexMapperSets() {
        return Collections.emptyMap();
    }

    public static IElemSource<Point2d> getUsableTexMapperPrim(IGeomNode geom, TexOrigin origin) {
        return TexCoordGenerator.newGenerator(geom, origin);
    }

    public static IGeomNode finalizeUVElements(IGeomNode geom, TexOrigin origin) {
        CachedSupplier<IElemSource<Point2d>> defMapper = new CachedSupplier<IElemSource<Point2d>>(() -> FDSUtil.getUsableTexMapperPrim(geom, origin));
        IGeomNode result = geom;
        result = result.applyUVElements((uvset, ix, oldEl) -> oldEl == Elements.NO_UV ? (IElemSource)defMapper.get() : oldEl);
        result = result.applyDefaultUVElements(defMapper);
        return result;
    }
}

