/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.detectors.APointDetector;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.Util;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class SprinklerLink
extends APointDetector
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private SprinklerLinkModel d_linkDesc;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.GREEN, 10.0);

    public SprinklerLink(String name, SprinklerLinkModel desc, FreePointLoc loc) {
        super(name, loc);
        this.d_linkDesc = desc;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SprinklerLink && super.equals(obj) && this.d_linkDesc.equals(((SprinklerLink)obj).d_linkDesc);
    }

    @Override
    protected IQuantity getQuantity() {
        return Quantity.SPRINKLER_LINK_TEMPERATURE.create();
    }

    public SprinklerLinkModel getModel() {
        return this.d_linkDesc;
    }

    public void setModel(SprinklerLinkModel link) {
        this.d_linkDesc = link;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        assert (this.d_linkDesc != null) : "A sprinkler link must have a link description";
        deps.add(DLink.STRONG, (IPyroObject)this.d_linkDesc);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.keepIfNullOr(objs, SprinklerLinkModel.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.getModel()) {
            assert (replacement != null);
            return new AReplaceRefTask<SprinklerLinkModel>((Object)old, (Object)replacement){

                @Override
                public void set(SprinklerLinkModel obj) {
                    SprinklerLink.this.setModel(obj);
                }
            };
        }
        return null;
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }
}

