/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class AttachedPointGeom
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = -6537792298278955828L;
    public final AttachedPointLoc loc;

    public AttachedPointGeom(AttachedPointLoc loc) {
        this.loc = loc;
    }

    @Override
    public AttachedPointGeom optimize(IPointOptimizer pool) {
        return this;
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        AttachedPointLoc newLoc = this.loc.transform(ti.getMatrix());
        return new AttachedPointGeom(newLoc);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.loc.d_location.getPoint3dValue(Geometry.LU));
        return aabb;
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public int getNumPrims(int types) {
        if ((types & 4) == 4) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        prims.add(this.getPoint());
        return prims;
    }

    private Point getPoint() {
        return new Point(this.loc.d_location.getPoint3dValue(Geometry.LU));
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        this.getPoint().pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        this.getPoint().pickBox(source, filter, region, isects);
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        this.getPoint().find(test, result);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        this.getPoint().getAll(result);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this));
    }

    private static class Handle
    implements IHandle {
        private AttachedPointGeom d_geom;

        public Handle(AttachedPointGeom geom) {
            this.d_geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(new Point(this.d_geom.loc.d_location.getPoint3dValue(Geometry.LU)));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            AttachedPointLoc newFreeLoc = new AttachedPointLoc(new UnitPoint3D(newLoc, Geometry.LU), this.d_geom.loc.d_faceNormal, this.d_geom.loc.d_rotation);
            this.d_geom = new AttachedPointGeom(newFreeLoc);
            return this.d_geom;
        }

        @Override
        public Object end() {
            return this.d_geom;
        }
    }
}

