/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices;

import java.io.Serializable;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class AlarmInfo
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble setpoint;
    public final int tripFlags;

    public AlarmInfo(UnitDouble setpoint) {
        this(setpoint, 1);
    }

    public AlarmInfo(UnitDouble setpoint, int tripFlags) {
        this.setpoint = setpoint;
        this.tripFlags = tripFlags;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlarmInfo)) {
            return false;
        }
        AlarmInfo ai = (AlarmInfo)obj;
        return this.setpoint.equals(ai.setpoint) && this.tripFlags == ai.tripFlags;
    }

    public int hashCode() {
        return 10462195 + this.tripFlags + this.setpoint.hashCode();
    }

    public static boolean checkAlarmChange(ISignalSource src, AlarmInfo oldai, AlarmInfo newai, LogicOutPin alarmPin) {
        if (theUtil.equal(oldai, newai)) {
            return false;
        }
        PyroMod domain = (PyroMod)src.getDomain();
        if (newai == null && domain != null) {
            DepSnapshot dss = domain.getDependencies(src);
            Set<Dependency> deps = dss.getDependents(src);
            for (Dependency dep : deps) {
                if (!(dep.source instanceof IInPin)) continue;
                IInPin inPin = (IInPin)dep.source;
                inPin.disconnect(alarmPin);
            }
        }
        return true;
    }
}

