/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.domain.APyroObject;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SurfaceUtil;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.util.Util;

public abstract class SurfDescStatic
extends APyroObject
implements ISurfDesc {
    static final long serialVersionUID = 1L;

    public abstract PredefSurf getPredefType();

    public static class Periodic
    extends SurfDescStatic {
        static final long serialVersionUID = 1L;

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Periodic;
        }

        @Override
        public PredefSurf getPredefType() {
            return PredefSurf.PERIODIC;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return obj instanceof Periodic;
        }
    }

    public static class Hvac
    extends SurfDescStatic {
        static final long serialVersionUID = 1L;

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Hvac;
        }

        @Override
        public PredefSurf getPredefType() {
            return PredefSurf.HVAC;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return obj instanceof Hvac;
        }
    }

    public static class Mirror
    extends SurfDescStatic {
        static final long serialVersionUID = 1L;

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Mirror;
        }

        @Override
        public PredefSurf getPredefType() {
            return PredefSurf.MIRROR;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return obj instanceof Mirror;
        }
    }

    public static class Open
    extends SurfDescStatic {
        static final long serialVersionUID = 1L;

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Open;
        }

        @Override
        public PredefSurf getPredefType() {
            return PredefSurf.OPEN;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return obj instanceof Open;
        }
    }

    public static class Adiabatic
    extends SurfDescStatic {
        static final long serialVersionUID = 1L;
        public final ISlip slip;

        public Adiabatic() {
            this(ISlip.DEFAULT);
        }

        public Adiabatic(ISlip slip) {
            this.slip = slip;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return obj instanceof Adiabatic && this.slip.equals(((Adiabatic)obj).slip);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ISurfDesc)) {
                return false;
            }
            return SurfaceUtil.surfDescEquals(this, (ISurfDesc)obj);
        }

        public static ISurfDesc getNonStaticRep() {
            return new ConstantTempSurfDesc(TempRegulation.newAdiabaticTR(null, false), null, IGeometry.DEFAULT);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (PyroSimObjectInputStream.getVersion(in) < 38) {
                try {
                    Util.assignFinalField(this, "slip", ISlip.DEFAULT);
                }
                catch (Exception e) {
                    throw new IOException(e.getLocalizedMessage());
                }
            }
        }

        @Override
        public PredefSurf getPredefType() {
            return PredefSurf.ADIABATIC;
        }
    }

    public static class Inert
    extends SurfDescStatic {
        static final long serialVersionUID = 1L;

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Inert;
        }

        @Override
        public PredefSurf getPredefType() {
            return PredefSurf.INERT;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return obj instanceof Inert;
        }
    }
}

