/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import pyrosim.domain.Grid;
import pyrosim.io.fds.FDSRenderer;

public class GridProcessUtil {
    private Collection<Grid> d_grids;
    private final PREF d_optimizationLevel;
    private final PROC_COUNT d_processCount;
    private Map<Grid, Integer> d_gridToProcMap;
    private final FDSRenderer.RENDER_ORIGIN d_writeOrigin;

    public static PREF getPrefForString(String name) {
        for (PREF p : PREF.values()) {
            if (!name.equals(p.getPropName())) continue;
            return p;
        }
        return PREF.BASIC;
    }

    public static PROC_COUNT getProcCountForString(String name) {
        for (PROC_COUNT p : PROC_COUNT.values()) {
            if (!name.equals(p.getPropName())) continue;
            return p;
        }
        return PROC_COUNT.PER_CORE;
    }

    public GridProcessUtil(Collection<Grid> grids, PREF optimzationLevel, PROC_COUNT numProcs, FDSRenderer.RENDER_ORIGIN origin) {
        this.d_optimizationLevel = optimzationLevel;
        this.d_processCount = numProcs;
        this.d_writeOrigin = origin;
        this.d_grids = grids.stream().filter(g -> g.isEnabled()).collect(Collectors.toList());
        this.initializeLookup(optimzationLevel, numProcs);
    }

    @Nullable
    public Integer getMPI_PROCESS(Grid g) {
        return this.d_gridToProcMap.get(g);
    }

    @Nullable
    public Integer getNumThreads(Grid g) {
        if (this.d_gridToProcMap.containsKey(g)) {
            return 1;
        }
        return null;
    }

    private void initializeLookup(PREF level, PROC_COUNT processes) {
        int numCores;
        this.d_gridToProcMap = new HashMap<Grid, Integer>();
        if (!this.d_writeOrigin.equals((Object)FDSRenderer.RENDER_ORIGIN.RUN_FDS_MPI)) {
            return;
        }
        int numMeshes = this.d_grids.size();
        if (numMeshes < (numCores = this.getNumCores())) {
            return;
        }
        if (level.equals((Object)PREF.BASIC) && processes.equals((Object)PROC_COUNT.PER_CORE)) {
            int leftoverMeshes;
            int meshesPerCore = numMeshes / numCores;
            int remainingRollovers = leftoverMeshes = numMeshes % numCores;
            int currProcCount = 0;
            int currProc = 0;
            boolean addOneMore = false;
            for (Grid g : this.d_grids) {
                this.d_gridToProcMap.put(g, currProc);
                if (!addOneMore && ++currProcCount == meshesPerCore && remainingRollovers > 0) {
                    addOneMore = true;
                    --remainingRollovers;
                    continue;
                }
                if (currProcCount < meshesPerCore) continue;
                ++currProc;
                currProcCount = 0;
                addOneMore = false;
            }
        }
    }

    private int getNumCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static enum PROC_COUNT {
        ONE_PROC("oneProc"),
        PER_MESH("perMesh"),
        PER_CORE("perCore");

        private final String propName;

        private PROC_COUNT(String propName) {
            this.propName = propName;
        }

        public String getPropName() {
            return this.propName;
        }
    }

    public static enum PREF {
        NONE("none"),
        BASIC("basic");

        private final String propName;

        private PREF(String propName) {
            this.propName = propName;
        }

        public String getPropName() {
            return this.propName;
        }
    }
}

