/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.output.StatGeom;
import pyrosim.geom.Geometry;
import pyrosim.geom.IGeomSource;
import pyrosim.geom.IPyroDisplayProps;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.IProxyGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.ManifoldSolid;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class GeomUtil
extends thunderheadeng.geometry.objs.GeomUtil {
    public static AABox getBounds(IGeom geomObj) {
        AABox bounds = new AABox();
        geomObj.getBoundingBox(bounds);
        return bounds;
    }

    public static AABox getBounds(IGeomSource geomObj) {
        return geomObj.getBounds();
    }

    public static AABox getBounds(Collection<? extends IGeomSource> geomObjs) {
        AABox bounds = new AABox();
        for (IGeomSource iGeomSource : geomObjs) {
            bounds.add(iGeomSource.getBounds());
        }
        return bounds;
    }

    public static UnitAABox getUnitBounds(IGeomSource geomObj) {
        return new UnitAABox(GeomUtil.getBounds(geomObj), Geometry.LU);
    }

    public static UnitAABox getUnitBounds(IGeom geomObj) {
        return new UnitAABox(GeomUtil.getBounds(geomObj), Geometry.LU);
    }

    public static <T> boolean isUniform(T[] vals, boolean identityEquals) {
        if (vals.length == 0) {
            return false;
        }
        T base = vals[0];
        if (identityEquals) {
            for (int m = 1; m < vals.length; ++m) {
                if (vals[m] == base) continue;
                return false;
            }
        } else {
            for (int m = 1; m < vals.length; ++m) {
                if (theUtil.equal(base, vals[m])) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> T[] optimizeArray(T[] vals, Class<T> clazz, boolean identityEquals) {
        if (!GeomUtil.isUniform(vals, identityEquals) || vals.length <= 1) {
            return vals;
        }
        Object[] newVals = (Object[])Array.newInstance(clazz, 1);
        newVals[0] = vals[0];
        return newVals;
    }

    public static boolean isUniform(Surface[] surfs) {
        return GeomUtil.isUniform(surfs, true);
    }

    public static Surface[] optimize(Surface[] surfs) {
        return GeomUtil.optimizeArray(surfs, Surface.class, true);
    }

    public static boolean isUniform(Color[] colors) {
        return GeomUtil.isUniform(colors, false);
    }

    public static Color[] optimize(Color[] colors) {
        return GeomUtil.optimizeArray(colors, Color.class, false);
    }

    public static Pair<Surface[], Color[]> getSurfsAndColors(int numFaces, IPropsSrc props) {
        Color[] colors;
        Surface[] surfs;
        int nUniform = props.getUniformCount(0, numFaces);
        if (nUniform == numFaces) {
            IPrimProps first = props.iterator().next();
            surfs = new Surface[]{(Surface)first.getMaterial()};
            colors = new Color[]{first.getColor()};
        } else {
            surfs = new Surface[numFaces];
            colors = new Color[numFaces];
            int ix = 0;
            for (IPrimProps pprops : props) {
                surfs[ix] = (Surface)pprops.getMaterial();
                colors[ix] = pprops.getColor();
                ++ix;
            }
            surfs = GeomUtil.optimize(surfs);
            colors = GeomUtil.optimize(colors);
        }
        return new Pair<Surface[], Color[]>(surfs, colors);
    }

    public static DisplayGeom convertToOutline(DisplayGeom dispGeom) {
        IGeomNode fnode = dispGeom.node.flatten();
        List<IPrimitive> prims = thunderheadeng.geometry.objs.GeomUtil.explodeToTypes(fnode.getLocalGeom(), 7);
        IElemSource<Boolean> creaseElem = fnode.getElements(Elements.CREASE);
        IElemSource<Elements.Orient> orientElem = fnode.getElements(Elements.ORIENT);
        ArrayList resultGeom = new ArrayList();
        PropsBuilder resultProps = new PropsBuilder();
        Elements.processPolys(prims, (ufaces, m, allPolys) -> {
            if (!allPolys.booleanValue()) {
                return;
            }
            int pcount = ufaces.size();
            List<Boolean> creases = creaseElem.subset((int)m, pcount).generate(Boolean.class, (List<IPolygon>)ufaces, orientElem.subset((int)m, pcount), displayGeom.props.subset((int)m, pcount));
            Iterator<Boolean> creaseit = creases.iterator();
            Iterator<IPrimProps> propit = displayGeom.props.subset((int)m, pcount).iterator();
            for (IPrimitive prim : ufaces) {
                IPolygon poly = (IPolygon)prim;
                IPrimProps props = propit.next();
                int nloops = poly.getNumLoops();
                for (int n = 0; n < nloops; ++n) {
                    int nverts = poly.getNumPoints(n);
                    for (int o = 0; o < nverts; ++o) {
                        Boolean creased = creaseit.next();
                        if (!creased.booleanValue()) continue;
                        resultGeom.add(poly.getPoint(n, o));
                        resultGeom.add(poly.getPoint(n, (o + 1) % nverts));
                        resultProps.add(props);
                    }
                }
            }
        });
        Mesh mesh = new Mesh(theUtil.toArray(resultGeom, Point3d.class), theUtil.sequentialList(0, resultGeom.size()), 1);
        IPropsSrc props = resultProps.finalizeProps();
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(mesh), props);
    }

    public static boolean isCullGeom(IGeomNode node) {
        if (GeomUtil.isCullGeom(node.getLocalGeom())) {
            return true;
        }
        for (IGeomNode iGeomNode : node.getChildren()) {
            if (!GeomUtil.isCullGeom(iGeomNode)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCullGeom(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            return true;
        }
        if (geom instanceof IProxyGeom) {
            return GeomUtil.isCullGeom(((IProxyGeom)geom).getBase());
        }
        if (geom instanceof GeomGroup) {
            for (IGeom child : ((GeomGroup)geom).children) {
                if (GeomUtil.isCullGeom(child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<IPolygon> toPolys(IFace face, double errorTol, boolean triangulateIfHoles) {
        ArrayList<IPolygon> polys = new ArrayList<IPolygon>();
        GeomUtil.toPolys(face, errorTol, triangulateIfHoles, polys);
        return polys;
    }

    public static void toPolys(IFace face, double errorTol, boolean triangulateIfHoles, List<IPolygon> polys) {
        if (face instanceof IPolygon) {
            IPolygon poly = (IPolygon)face;
            if (!triangulateIfHoles || poly.getNumLoops() <= 1) {
                polys.add(poly);
                return;
            }
        }
        polys.addAll(thunderheadeng.geometry.objs.GeomUtil.getTriangles(errorTol, face));
    }

    public static <T> T[] matchPrimCount(IGeomNode geom, int primTypes, T[] vals, Class<T> type) {
        return GeomUtil.matchPrimCount(geom, primTypes, vals, type, false);
    }

    public static <T> T[] matchPrimCount(IGeomNode geom, int primTypes, T[] vals, Class<T> type, boolean newArray) {
        return GeomUtil.matchPrimCount(vals, type, newArray, geom.getNumPrims(primTypes));
    }

    public static <T> T[] matchPrimCount(T[] vals, Class<T> type, boolean newArray, int primCount) {
        if (vals.length == primCount) {
            return newArray ? (Object[])vals.clone() : vals;
        }
        assert (vals.length == 1);
        Object[] newVals = (Object[])Array.newInstance(type, primCount);
        for (int m = 0; m < primCount; ++m) {
            newVals[m] = vals[0];
        }
        return newVals;
    }

    public static Task taskChanged(IPyroObject obj) {
        return new ChangedTask(obj);
    }

    public static IPolygon toPoly(Face face) {
        return GeomUtil.toPoly(face, i -> {});
    }

    public static IPolygon toPoly(Face face, Consumer<int[]> edgeids) {
        ArrayList<Point3d[]> verts = new ArrayList<Point3d[]>();
        for (int m = 0; m < face.edgeLoops.size(); ++m) {
            FaceLoop loop = face.edgeLoops.get(m);
            if (loop.edges.size() < 3) continue;
            Point3d[] loopVerts = new Point3d[loop.edges.size()];
            for (int n = 0; n < loop.edges.size(); ++n) {
                EdgeUse eu = loop.edges.get(n);
                loopVerts[n] = eu.v1().loc;
                edgeids.accept(eu.edge.groups);
            }
            verts.add(loopVerts);
        }
        return PolyUtil.newPoly(theUtil.toArray(verts, Point3d[].class));
    }

    public static DisplayGeom generateClipCaps(IPyroDisplayProps drawProps, DisplayGeom uncappedGeom, ConvexHull region, IPropsSrc psrc, boolean autoOpacity, IElemSource<Point2d> capUV) {
        if (drawProps == null) {
            return DisplayGeom.EMPTY;
        }
        try {
            if (uncappedGeom.node.getNumPrims(1) == 0) {
                return DisplayGeom.EMPTY;
            }
            IFilteredCollection<Pair> solidGeom = theUtil.filter(uncappedGeom.node.quickFlatten(1), pair -> !((IGeom)pair.v2).isShell());
            if (solidGeom.isEmpty()) {
                return DisplayGeom.EMPTY;
            }
            AABox bounds = uncappedGeom.node.getBoundingBox(new AABox());
            if (region.test(bounds) != Containment.INTERSECTS) {
                return DisplayGeom.EMPTY;
            }
            int geomid = Integer.MAX_VALUE;
            Model model = null;
            Matrix4d wl = null;
            Matrix4d lw = null;
            Point3d tp = null;
            AABox lbounds = null;
            Plane3d[] planes = region.getPlanes();
            for (int n = 0; n < planes.length; ++n) {
                Point3d[] fverts;
                Plane3d plane = planes[n];
                double side = Inter3D.testPlaneAABox(plane, bounds, 1.0E-6);
                if (side != 0.0) continue;
                if (model == null) {
                    model = new Model();
                    wl = new Matrix4d();
                    lw = new Matrix4d();
                    tp = new Point3d();
                    lbounds = new AABox();
                } else {
                    lbounds.reset();
                }
                Util.getPlaneTransforms(plane, wl, lw);
                for (int m = 0; m < 8; ++m) {
                    bounds.getCorner(m, tp);
                    wl.transform(tp);
                    lbounds.add(tp);
                }
                lbounds = lbounds.scale(1.5);
                for (Point3d p : fverts = new Point3d[]{new Point3d(lbounds.getMinX(), lbounds.getMinY(), 0.0), new Point3d(lbounds.getMaxX(), lbounds.getMinY(), 0.0), new Point3d(lbounds.getMaxX(), lbounds.getMaxY(), 0.0), new Point3d(lbounds.getMinX(), lbounds.getMaxY(), 0.0)}) {
                    lw.transform(p);
                }
                model.addPolygonFace(n, plane, fverts);
            }
            if (model == null || model.getFaces().isEmpty()) {
                return DisplayGeom.EMPTY;
            }
            ArrayList<IGeom> xformedSolidGeoms = new ArrayList<IGeom>(theUtil.map(solidGeom, pair -> ((IGeom)pair.v2).transform((TransformInfo)pair.v1, 0)));
            List<IFace> solidFaces = thunderheadeng.geometry.objs.GeomUtil.explode(xformedSolidGeoms, IFace.class);
            ArrayList<Face> delFaces = new ArrayList<Face>();
            for (IFace face : solidFaces) {
                IPolygon poly;
                boolean triangulate = true;
                if (face instanceof IPolygon && (poly = (IPolygon)face).getNumLoops() == 1) {
                    model.addPolygonFace(Integer.MAX_VALUE, poly.getPlane(true), PolyUtil.getAllVerts(poly, false));
                    triangulate = false;
                }
                if (triangulate) {
                    Mesh fmesh = face.triangulate(drawProps.getFaceError());
                    int m = 0;
                    while (m < fmesh.indices.length) {
                        Point3d p1 = fmesh.vertices[fmesh.indices[m++]];
                        Point3d p2 = fmesh.vertices[fmesh.indices[m++]];
                        Point3d p3 = fmesh.vertices[fmesh.indices[m++]];
                        model.addPolygonFace(Integer.MAX_VALUE, new Plane3d(true, p1, p2, p3), p1, p2, p3);
                    }
                }
                delFaces.clear();
                delFaces.addAll(model.getFaces(Integer.MAX_VALUE));
                for (Face delFace : delFaces) {
                    if (delFace.groups.length > 1) continue;
                    model.deleteFace(delFace, true, true);
                }
            }
            int alpha = -1;
            if (psrc == null || autoOpacity) {
                int nuniform;
                IPropsSrc cprops = null;
                int numPrims = uncappedGeom.node.getNumPrims(7);
                for (int m = 0; m < numPrims; m += nuniform) {
                    nuniform = uncappedGeom.props.getUniformCount(m, numPrims - m);
                    IPrimProps pprops = uncappedGeom.props.get(m);
                    if (!(pprops instanceof IPrimProps.Face)) continue;
                    cprops = new UniformProps(pprops);
                    break;
                }
                if (cprops == null) {
                    return DisplayGeom.EMPTY;
                }
                if (psrc == null) {
                    psrc = cprops;
                } else {
                    IPrimProps props0 = cprops.get(0);
                    if (props0.getMaterial() == null) {
                        alpha = props0.getColor().getAlpha();
                    } else {
                        IMatAttrs attrs = props0.getMaterial().getAttributes();
                        alpha = attrs.getAlphaFromDiffuseAndOpacity();
                    }
                }
            }
            ArrayList<ManifoldSolid> solidInfos = null;
            ArrayList<IPolygon> geomResult = new ArrayList<IPolygon>();
            PropsBuilder pbuilder = new PropsBuilder();
            for (Face face : model.getFaces()) {
                tp = model.findPointInFace(face);
                if (tp == null || !region.contains(tp, 1.0E-6)) continue;
                if (face.groups.length == 1) {
                    if (solidInfos == null) {
                        solidInfos = new ArrayList<ManifoldSolid>();
                        for (IGeom solid : xformedSolidGeoms) {
                            solidInfos.add(new ManifoldSolid(solid, false));
                        }
                    }
                    boolean inSolid = false;
                    Iterator solid = solidInfos.iterator();
                    while (solid.hasNext()) {
                        Object si = (ManifoldSolid)solid.next();
                        if (((ManifoldSolid)si).classify(tp, 1.0E-6) == ManifoldSolid.PointClassify.OUTSIDE) continue;
                        inSolid = true;
                        break;
                    }
                    if (!inSolid) continue;
                }
                IPolygon poly = GeomUtil.toPoly(face);
                geomResult.add(poly);
                Object pid = -1;
                for (int id : face.groups) {
                    if (id == Integer.MAX_VALUE) continue;
                    pid = id;
                    break;
                }
                assert (pid != -1);
                IPrimProps fprops = psrc.get((int)pid);
                if (alpha != -1 && alpha != fprops.getColor().getAlpha()) {
                    Color c = fprops.getColor();
                    fprops = fprops.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                }
                pbuilder.add(fprops);
            }
            if (geomResult.isEmpty()) {
                return DisplayGeom.EMPTY;
            }
            IPropertySet elements = Elements.newElements("teciuv0x193fa", capUV);
            GeomNodeLeaf node = GeomNodeUtil.newNode(thunderheadeng.geometry.objs.GeomUtil.group(geomResult), elements);
            return new DisplayGeom((IGeomNode)node, pbuilder.finalizeProps());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return DisplayGeom.EMPTY;
        }
    }

    public static List<Pair<TransformInfo, IGeom>> flatten(IGeomNode node) {
        return node.quickFlatten(1);
    }

    private static Point3d[] calcPointArray(Point3d p1, Point3d p2, int numPoints) {
        Point3d[] r = new Point3d[numPoints];
        double dx = (p2.x - p1.x) / (double)(numPoints - 1);
        double dy = (p2.y - p1.y) / (double)(numPoints - 1);
        double dz = (p2.z - p1.z) / (double)(numPoints - 1);
        r[0] = p1;
        r[numPoints - 1] = p2;
        for (int i = 1; i < numPoints - 1; ++i) {
            r[i] = new Point3d(p1.x + dx * (double)i, p1.y + dy * (double)i, p1.z + dz * (double)i);
        }
        return r;
    }

    public static DisplayGeom generateLinearArrayDisplayGeom(StatGeom.LinearArrayGeom geom, IPrimProps pointProp) {
        Point3d[] r;
        assert (geom instanceof LineSeg);
        ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
        PropsBuilder gprops = new PropsBuilder();
        geoms.add(geom);
        gprops.add(new IPrimProps.Edge(pointProp.getColor(), 3.0, IPrimProps.DEF_STIPPLE, 0));
        for (Point3d p : r = GeomUtil.calcPointArray(geom.p1, geom.p2, geom.d_numPoints)) {
            geoms.add(new Point(p));
            gprops.add(pointProp);
        }
        IGeom geometry = thunderheadeng.geometry.objs.GeomUtil.group(geoms);
        GeomNodeLeaf node = GeomNodeUtil.newNode(geometry);
        return new DisplayGeom((IGeomNode)node, gprops.finalizeProps());
    }

    public static boolean validateGEOM(IObstruction obst) {
        IGeomNode gnode = obst.getGeom();
        for (Pair<TransformInfo, IGeom> gi : gnode.quickFlatten(1)) {
            IGeom geom = (IGeom)gi.v2;
            if (!geom.isShell()) continue;
            return false;
        }
        return true;
    }

    private static class ChangedTask
    extends AUndoableTask {
        private final IPyroObject d_obj;

        public ChangedTask(IPyroObject obj) {
            this.d_obj = obj;
        }

        @Override
        public void run() {
            this.d_obj.changedEvt(new Object[0]);
        }

        @Override
        public void undo() {
            this.d_obj.changedEvt(new Object[0]);
        }
    }
}

