/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Task;

public class ExSpecList
extends Composite<ExSpec> {
    static final long serialVersionUID = 1L;
    public static final String[] RADCAL_SPECS;
    public static final Map<String, ExSpec> PREDEFINED;
    public static final List<String> LUMPED_AIR_COMPS;
    public static final List<String> LUMPED_PRODUCT_COMPS;
    private Collection<String> d_reacDefAlias = new ArrayList<String>();
    public static final String RC_CARBON_DIOXIDE = "CARBON DIOXIDE";
    public static final String RC_CARBON_MONOXIDE = "CARBON_MONOXIDE";
    public static final String RC_ETHANE = "ETHANE";
    public static final String RC_ETHYLENE = "ETHYLENE";
    public static final String RC_MMA = "MMA";
    public static final String RC_METHANE = "METHANE";
    public static final String RC_METHANOL = "METHANOL";
    public static final String RC_N_HEPTANE = "N-HEPTANE";
    public static final String RC_PROPANE = "PROPANE";
    public static final String RC_PROPYLENE = "PROPYLENE";
    public static final String RC_SOOT = "SOOT";
    public static final String RC_TOLUENE = "TOLUENE";
    public static final String RC_WATER_VAPOR = "WATER VAPOR";

    public ExSpecList() {
        this(Intl.intl("Species"));
    }

    public ExSpecList(String name) {
        super(name, ExSpec.class);
    }

    public List<String> getPredefinedSpeciesNamesFree() {
        ArrayList<String> names = new ArrayList<String>(PREDEFINED.keySet());
        for (ExSpec es : this.flatten()) {
            String name = es.getName();
            if (!names.contains(name)) continue;
            names.remove(name);
        }
        Collections.sort(names);
        return names;
    }

    public static boolean isPredefinedSpecies(String id) {
        return PREDEFINED.containsKey(id);
    }

    public static boolean equalsPredefinedSpecies(ExSpec spec) {
        if (!ExSpecList.isPredefinedSpecies(spec.getName())) {
            return false;
        }
        ExSpec predefSpec = ExSpecList.getPredefinedSpecies(spec.getName());
        return spec.getMolecularWeight().equals(predefSpec.getMolecularWeight()) && spec.getMassFrac0() == predefSpec.getMassFrac0() && spec.getPrimParams().equals(predefSpec.getPrimParams()) && spec.getCustomFDSProps().equals(predefSpec.getCustomFDSProps());
    }

    public static boolean isImplicitSpecies(String id) {
        return id.equals("AIR") || id.equals("PRODUCTS") || LUMPED_AIR_COMPS.contains(id) || LUMPED_PRODUCT_COMPS.contains(id);
    }

    public static ExSpec getPredefinedSpecies(String id) {
        assert (ExSpecList.isPredefinedSpecies(id));
        return PREDEFINED.get(id);
    }

    public static String[] getRadCalSurrogates() {
        return RADCAL_SPECS;
    }

    public static boolean isRadCalSpecies(String id) {
        for (String spec : RADCAL_SPECS) {
            if (!id.equals(spec)) continue;
            return true;
        }
        return false;
    }

    public List<ExSpec> getAllNamedSpecs() {
        ArrayList<ExSpec> specs = new ArrayList<ExSpec>(this.flatten());
        for (ExSpec predefSpec : PREDEFINED.values()) {
            if (specs.contains(predefSpec)) continue;
            specs.add(predefSpec);
        }
        return specs;
    }

    public ExSpec getDefaultFuel() {
        for (ExSpec spec : this.flatten()) {
            if (spec.getType() != 4) continue;
            return spec;
        }
        return null;
    }

    public static ExSpec getDefaultFuel(boolean addToDomain) {
        PyroMod pyMod = PyroSim.getApp().getMediator();
        return ExSpecList.getDefaultFuel(pyMod.getExSpecList(), pyMod.getNames(ExSpec.class), addToDomain);
    }

    public static ExSpec getDefaultFuel(ExSpecList specList, NameGenerator ng, boolean addToDomain) {
        if (specList.getDefaultFuel() != null) {
            return specList.getDefaultFuel();
        }
        String fuelName = "REAC_FUEL";
        fuelName = ng.generateValidName(fuelName);
        ExSpec reacFuel = new ExSpec(fuelName, 4);
        if (addToDomain) {
            specList.add(reacFuel);
            specList.setReacDefaultAlias(fuelName);
        }
        return reacFuel;
    }

    public void setReacDefaultAlias(String str) {
        this.d_reacDefAlias.add(str);
    }

    public boolean isReacDefaultAlias(String str) {
        return this.d_reacDefAlias.contains(str);
    }

    @Override
    public ExSpec get(String name) {
        ExSpec spec = (ExSpec)super.get(name);
        if (spec == null && this.isReacDefaultAlias(name)) {
            return ExSpecList.getDefaultFuel(true);
        }
        return spec;
    }

    public void addDefaults() {
        this.addImplicitSpecs();
    }

    public Collection<ExSpec> getInitialFractions() {
        ArrayList<ExSpec> initSpecs = new ArrayList<ExSpec>();
        for (ExSpec spec : this.flatten()) {
            if (!(spec.getMassFrac0() > 0.0)) continue;
            initSpecs.add(spec);
        }
        return initSpecs;
    }

    public void addImplicitSpecs() {
        this.addAirSpecs();
        this.addProductSpecs();
    }

    public void addAirSpecs() {
        this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies("AIR")));
        for (String specName : LUMPED_AIR_COMPS) {
            this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies(specName)));
        }
    }

    public void addProductSpecs() {
        this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies("PRODUCTS")));
        for (String specName : LUMPED_PRODUCT_COMPS) {
            this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies(specName)));
        }
    }

    public static boolean shouldRenderExplicit(ExSpec spec, boolean simpleReac, boolean complexReac, boolean requiredExplicit) {
        if (spec.isForceWrite()) {
            return true;
        }
        if (!requiredExplicit) {
            if (!simpleReac && !complexReac && LUMPED_AIR_COMPS.contains(spec.getName())) {
                return false;
            }
            if (simpleReac && (LUMPED_AIR_COMPS.contains(spec.getName()) || LUMPED_PRODUCT_COMPS.contains(spec.getName())) && ExSpecList.equalsPredefinedSpecies(spec)) {
                return false;
            }
        }
        return spec.getType() != 5 || !(spec.getName().equals(Predefined.AIR.getName()) && !complexReac ? ExSpecList.equalsPredefinedSpecies(spec) : spec.getName().equals(Predefined.PRODUCTS.getName()) && simpleReac && ExSpecList.equalsPredefinedSpecies(spec));
    }

    @Override
    public <T extends IPyroObject> T find(String name, Class<T> type, boolean deep) {
        T spec = super.find(name, type, deep);
        if (spec == null && type.isAssignableFrom(ExSpec.class) && this.isReacDefaultAlias(name)) {
            return (T)ExSpecList.getDefaultFuel(false);
        }
        return spec;
    }

    public Task taskSetBackgroundSpecies(final ExSpec spec) {
        final ExSpec background = this.getBackgroundSpecies();
        return new AUndoableTask(){

            @Override
            public void undo() {
                ExSpecList.this.pauseUpdates();
                if (spec != null) {
                    spec.setIsBackgroundSpec(false);
                }
                if (background != null) {
                    background.setIsBackgroundSpec(true);
                }
                ExSpecList.this.resumeUpdates();
            }

            @Override
            public void run() {
                ExSpecList.this.pauseUpdates();
                if (background != null) {
                    background.setIsBackgroundSpec(false);
                }
                if (spec != null) {
                    spec.setIsBackgroundSpec(true);
                }
                ExSpecList.this.resumeUpdates();
            }
        };
    }

    public ExSpec getBackgroundSpecies() {
        for (ExSpec spec : this.flatten()) {
            if (!spec.isBackgroundSpec()) continue;
            return spec;
        }
        return null;
    }

    public void setBackgroundSpecies(ExSpec spec) {
        ExSpec background = this.getBackgroundSpecies();
        if (background != null) {
            background.setIsBackgroundSpec(false);
        }
        if (spec != null) {
            spec.setIsBackgroundSpec(true);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (this.d_reacDefAlias == null) {
            this.d_reacDefAlias = new ArrayList<String>();
            this.d_reacDefAlias.add("REAC_FUEL");
        }
        in.defaultReadObject();
    }

    static {
        PREDEFINED = new LinkedHashMap<String, ExSpec>();
        for (Predefined predef : Predefined.values()) {
            PREDEFINED.put(predef.spec.getName(), predef.spec);
        }
        RADCAL_SPECS = new String[]{RC_CARBON_DIOXIDE, RC_CARBON_MONOXIDE, RC_ETHANE, RC_ETHYLENE, RC_MMA, RC_METHANE, RC_METHANOL, RC_N_HEPTANE, RC_PROPANE, RC_PROPYLENE, RC_SOOT, RC_TOLUENE, RC_WATER_VAPOR};
        LUMPED_AIR_COMPS = new ArrayList<String>();
        LUMPED_AIR_COMPS.add("NITROGEN");
        LUMPED_AIR_COMPS.add("OXYGEN");
        LUMPED_AIR_COMPS.add(RC_CARBON_DIOXIDE);
        LUMPED_AIR_COMPS.add(RC_WATER_VAPOR);
        LUMPED_PRODUCT_COMPS = new ArrayList<String>();
        LUMPED_PRODUCT_COMPS.add(RC_CARBON_DIOXIDE);
        LUMPED_PRODUCT_COMPS.add(RC_WATER_VAPOR);
        LUMPED_PRODUCT_COMPS.add("CARBON MONOXIDE");
        LUMPED_PRODUCT_COMPS.add(RC_SOOT);
        LUMPED_PRODUCT_COMPS.add("NITROGEN");
    }

    public static enum Predefined {
        AIR("AIR", 0.0, 3.711, 78.6, "air", false),
        PRODUCTS("PRODUCTS", 0.0, 0.0, 0.0, "products", false),
        ACETONE("ACETONE", 58.07914, 4.6, 560.2, "C3H6O", true),
        ACETYLENE("ACETYLENE", 26.03728, 4.033, 231.8, "C2H2", false),
        ACROLEIN("ACROLEIN", 56.03728, 4.549, 576.7, "C3H4O", true),
        ARGON("ARGON", 39.948, 3.42, 124.0, "Ar", true),
        BENZENE("BENZENE", 78.11184, 5.349, 412.3, "C6H6", true),
        BUTANE("BUTANE", 58.1222, 4.687, 531.4, "C4H10", true),
        CARBON("CARBON", 12.0107, 2.84, 74.8, "C", false),
        CARBON_DIOXIDE("CARBON DIOXIDE", 44.0095, 3.941, 195.2, "CO2", false),
        CARBON_MONOXIDE("CARBON MONOXIDE", 28.0101, 3.69, 91.7, "CO", true),
        DODECANE("DODECANE", 170.33484, 4.701, 205.78, "C2H26", true),
        ETHANE("ETHANE", 30.06904, 4.443, 215.7, "C2H6", true),
        ETHANOL("ETHANOL", 46.06844, 4.53, 362.6, "C2H5OH", true),
        ETHYLENE("ETHYLENE", 28.05316, 4.163, 224.7, "C2H4", true),
        FORMALDEHYDE("FORMALDEHYDE", 30.06904, 3.626, 481.8, "CH2O", true),
        HELIUM("HELIUM", 4.002602, 2.551, 10.22, "He", true),
        HYDROGEN("HYDROGEN", 2.02699, 2.827, 59.7, "H2", true),
        HYDROGEN_A("HYDROGEN ATOM", 1.00794, 2.31, 123.6, "H", false),
        HYDROGEN_BROMIDE("HYDROGEN BROMIDE", 80.91194, 3.353, 449.0, "HBr", true),
        HYDROGEN_CHLORIDE("HYDROGEN CHLORIDE", 36.46094, 3.339, 344.7, "HCl", true),
        HYDROGEN_CYANIDE("HYDROGEN CYANIDE", 27.02534, 3.63, 569.1, "HCN", true),
        HYDROGEN_FLOURIDE("HYDROGEN FLOURIDE", 20.006343, 3.148, 330.0, "HF", true),
        HYDROGEN_PEROXIDE("HYDROGEN PEROXIDE", 34.01468, 3.02, 106.5, "H2O2", true),
        HYDROPEROXY_RADICAL("HYDROPEROXY RADICAL", 33.00674, 3.02, 106.5, "HO2", false),
        HYDROXYL_RADICAL("HYDROXYL RADICAL", 17.00734, 2.66, 92.1, "OH", false),
        ISOPROPANOL("ISOPROPANOL", 60.09502, 4.549, 576.7, "C3H7OH", true),
        METHANE("METHANE", 16.04246, 3.758, 148.6, "CH4", true),
        METHANOL("METHANOL", 32.04186, 3.626, 481.8, "CH2OH", true),
        N_DECANE("N-DECANE", 142.28168, 5.233, 226.46, "C10H22", false),
        N_HEPTANE("N-HEPTANE", 100.20194, 4.701, 205.75, "C7H16", true),
        N_HEXANE("N-HEXANE", 86.17536, 4.524, 199.41, "C6H12", true),
        N_OCTANE("N-OCTANE", 114.22852, 4.892, 231.16, "C8H18", true),
        NITRIC_OXIDE("NITRIC OXIDE", 44.0128, 3.492, 116.7, "NO", true),
        NITROGEN("NITROGEN", 28.0134, 3.798, 71.4, "N2", true),
        NITROGEN_A("NITROGEN ATOM", 14.0067, 2.66, 92.1, "N", false),
        NITROGEN_DIOXIDE("NITROGEN DIOXIDE", 46.055, 3.992, 204.88, "NO2", true),
        NITROUS_OXIDE("NITROUS OXIDE", 44.0128, 3.828, 232.4, "N2O", true),
        OXYGEN("OXYGEN", 31.9988, 3.467, 106.7, "O2", true),
        OXYGEN_A("OXYGEN ATOM", 15.9994, 2.66, 92.1, "O", false),
        PROPANE("PROPANE", 44.0128, 5.118, 237.1, "C3H8", true),
        PROPYLENE("PROPYLENE", 42.07974, 4.678, 298.9, "C3H6", true),
        SOOT("SOOT", 10.91042, 3.798, 71.4, "C0.9H0.1", false),
        SULFUR_DIOXIDE("SULFUR DIOXIDE", 64.0638, 4.112, 335.4, "SO2", true),
        SULFUR_HEXAFLUORIDE("SULFUR HEXAFLUORIDE", 146.055419, 5.128, 146.0, "SF6", false),
        TOLUENE("TOLUENE", 92.13842, 5.698, 480.0, "C6H5CH3", true),
        WATER_VAPOR("WATER VAPOR", 18.01528, 2.641, 809.1, "H2O", true),
        XENON("XENON", 131.293, 4.047, 231.0, "Xe", true);

        public final ExSpec spec;

        private Predefined(String id, double molWt, double sigma, double ek, String formula, boolean isLiquid) {
            this.spec = new ExSpec(id, 0);
            if (id.equals("AIR") || id.equals("PRODUCTS")) {
                this.spec.setType(5);
            } else {
                this.spec.setMolecularWeight(new UnitDouble(molWt, SI.GRAM.divide(SI.MOLE)));
                this.spec.setChemFormula(formula);
            }
        }

        public String getName() {
            return this.spec.getName();
        }
    }
}

