/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroNamesDB;
import pyrosim.PyroSimSelectionModel;
import pyrosim.PyroTaskManager;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.FDSRun;
import pyrosim.domain.FloorManager;
import pyrosim.domain.GeomLocator;
import pyrosim.domain.GeomProximity;
import pyrosim.domain.GridList;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.ResultsArchive;
import pyrosim.domain.Serialized;
import pyrosim.domain.SimParams;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import pyrosim.domain.evac.CorrList;
import pyrosim.domain.evac.DoorList;
import pyrosim.domain.evac.EntrList;
import pyrosim.domain.evac.EvacList;
import pyrosim.domain.evac.EvhoList;
import pyrosim.domain.evac.EvssList;
import pyrosim.domain.evac.ExitList;
import pyrosim.domain.evac.PersList;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.output.IsosurfaceMgr;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.scenario.ScenarioList;
import pyrosim.domain.scenario.ScenariosCtrl;
import pyrosim.domain.view.ViewMgr;
import pyrosim.domain.zones.ZoneMgr;
import pyrosim.event.NonModifyingEvent;
import pyrosim.io.BimImporter;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParser;
import pyrosim.io.pyrosimV4V5.Convert;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.PropsUtil;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Task;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class PyroMod
extends Mediator
implements Serializable,
IPyroObject {
    static final long serialVersionUID = 1L;
    public static final Object EVT_CHANGED = new Object();
    public static final Object EVT_SEL = new NonModifyingEvent();
    public static final Object EVT_CHILDREN_CHANGED = new Object();
    public static final Object EVT_PARENT_CHANGED = "PARENT_CHANGED";
    public static final Object EVT_ENABLED_CHANGED = new Object();
    public static final Object EVT_VISIBILITY_CHANGED = new Object();
    public static final Object EVT_FORCEWRITE_CHANGED = new Object();
    public static final Object EVT_CHILDREN_ADDED = new Object();
    public static final Object EVT_CHILDREN_REMOVED = new Object();
    public static final Object EVT_FILENAME_CHANGED = new NonModifyingEvent();
    public static final Object EVT_FDS_RUN_CHANGED = new Object();
    public static final Object EVT_FDS_CLUSTER_OPTIONS_CHANGED = new Object();
    public static final Object EVT_MODEL_CHANGED = new Object();
    public static final Object EVT_PREFS_CHANGED = new NonModifyingEvent();
    public static final Object EVT_UNITSYSTEM_CHANGED = new NonModifyingEvent();
    public static final Object EVT_UNPROC_RECS_CHANGED = new Object();
    public static final Object EVT_APPEARANCE = new Object();
    public static final Object EVT_FDS_EVAC_CHANGED = new Object();
    public static final Object EVT_RAST_PROPS = new Object();
    public static final Object EVT_NAME_CHANGED = new Object();
    public static final Object EVT_SCENARIO_CHANGED = new Object();
    private Serialized ser;
    private final transient PyroTaskManager d_taskMan;
    private transient PyroSimSelectionModel d_selModel;
    private final transient FDSRasterization d_rasterizations = new FDSRasterization(this);
    private boolean d_autoProxUpdate = true;
    private final transient GeomProximity d_geomProx;
    private final transient GeomLocator d_geomLocator;
    private PyroNamesDB d_names;
    private final ScenariosCtrl d_scenarioCtrl;

    public PyroMod() {
        this(false);
    }

    public PyroMod(boolean initDefaults) {
        this(null, initDefaults, true);
    }

    public PyroMod(Serialized preSer) {
        this(preSer, false, true);
    }

    public PyroMod(Serialized preSer, boolean initDefaults, boolean enableEvents) {
        if (enableEvents) {
            this.setEvents(new PyroEvents());
        } else {
            this.setEvents(new NilEvents());
        }
        this.d_selModel = new PyroSimSelectionModel(this);
        this.d_taskMan = new PyroTaskManager(this);
        this.d_geomLocator = new GeomLocator();
        this.d_geomProx = new GeomProximity(this);
        this.d_scenarioCtrl = new ScenariosCtrl();
        if (preSer == null) {
            this.setSerialized(new Serialized(initDefaults));
        } else {
            this.setSerialized(preSer);
        }
        this.ser.setDomain(this);
    }

    @Override
    public Collection<? extends IPyroObject> getMembers() {
        return PyroMod.getMembers(this.ser, this.getFdsEvacEnabled());
    }

    public static Collection<? extends IPyroObject> getMembers(Serialized ser, boolean fdsEvac) {
        ArrayList<APyroObject> members = new ArrayList<APyroObject>();
        List<APyroObject> core = Arrays.asList(ser.boundaryOutput, ser.controls, ser.devices, ser.exSpecs, ser.floors, ser.grids, ser.heatLinkModels, ser.hvacSystem, ser.isosurfaces, ser.matmgr, ser.msrStats, ser.obstructions, ser.particles, ser.plot3d, ser.profs, ser.reactions, ser.simParams, ser.slices, ser.slices3d, ser.smokeLinkModels, ser.sprayModels, ser.sprkLinkModels, ser.surfmgr, ser.appearances, ser.zones, ser.bridges, ser.views, ser.scenarios);
        members.addAll(core);
        if (fdsEvac) {
            List<Composite> evac = Arrays.asList(ser.corrs, ser.doors, ser.entrs, ser.evacs, ser.evhos, ser.evsss, ser.exits, ser.perss);
            members.addAll(evac);
        }
        return members;
    }

    public Collection<? extends IPyroObject> getSelectableMembers() {
        return PyroMod.getSelectableMembers(this.ser);
    }

    public static Collection<? extends IPyroObject> getSelectableMembers(Serialized ser) {
        LinkedHashSet<IPyroObject> members = new LinkedHashSet<IPyroObject>();
        members.add(ser.views);
        members.addAll(ser.views.getDeepMembers());
        members.add(ser.grids);
        members.addAll(ser.grids.getDeepMembers());
        members.add(ser.zones);
        members.addAll(ser.zones.getDeepMembers());
        members.add(ser.reactions);
        members.addAll(ser.reactions.getDeepMembers());
        members.add(ser.matmgr);
        members.addAll(ser.matmgr.getDeepMembers());
        members.add(ser.surfmgr);
        members.addAll(ser.surfmgr.getDeepMembers());
        members.add(ser.exSpecs);
        members.addAll(ser.exSpecs.getDeepMembers());
        members.add(ser.particles);
        members.addAll(ser.particles.getDeepMembers());
        members.add(ser.devices);
        members.addAll(ser.devices.getDeepMembers());
        members.add(ser.controls);
        members.addAll(ser.controls.getDeepMembers());
        members.add(ser.msrStats);
        members.addAll(ser.msrStats.getDeepMembers());
        members.add(ser.slices);
        members.addAll(ser.slices.getDeepMembers());
        members.add(ser.slices3d);
        members.addAll(ser.slices3d.getDeepMembers());
        members.add(ser.hvacSystem);
        members.addAll(ser.hvacSystem.getDeepMembers());
        members.add(ser.obstructions);
        members.addAll(ser.obstructions.getDeepMembers());
        return members;
    }

    public void initializeDatabases(File dbDir) {
        this.ser.appearances.setDBDir(dbDir);
        this.ser.appearances.scan();
    }

    public Set<Material> getInUseAppearances() {
        LinkedIdentityHashSet<Material> inUse = new LinkedIdentityHashSet<Material>();
        for (Surface surf : this.getSurfaceMgr().flatten()) {
            Material appearance = surf.getAppearance();
            if (appearance == null) continue;
            inUse.add(appearance);
        }
        LinkedIdentityHashSet<IMaterial> inUseIMats = new LinkedIdentityHashSet<IMaterial>();
        for (GenericGeomSrc geomSrc : ((APyroObject)this.getObstructions()).flatten(GenericGeomSrc.class)) {
            PropsUtil.getReferencedMaterials(geomSrc.getGeom(), geomSrc.getDisplayProps(), inUseIMats);
        }
        inUse.addAll(theUtil.filter(inUseIMats, Material.class));
        return inUse;
    }

    public void setAutoProxUpdate(boolean autoUpdate) {
        this.d_autoProxUpdate = autoUpdate;
    }

    public GeomLocator getGeomLocator() {
        return this.d_geomLocator;
    }

    public GeomProximity getGeomProx() {
        return this.d_geomProx;
    }

    public void updateGeomSearchesEnabled(boolean enabled) {
        this.d_geomProx.setEnabled(enabled);
        if (enabled) {
            Collection<? extends IPyroGeomSrc> geoms = this.getAllGeom();
            for (IPyroGeomSrc iPyroGeomSrc : geoms) {
                this.d_geomProx.add(iPyroGeomSrc);
            }
            this.pauseUpdates(false);
            this.d_geomProx.update();
            this.resumeUpdates();
        }
    }

    public void updateGeom() {
        if (this.d_autoProxUpdate) {
            boolean modChanged = this.getEvents().getEvents(PyroMod.class, new Class[0]).containsChange(EVT_MODEL_CHANGED);
            if (modChanged) {
                this.pauseUpdates(false);
            }
            this.d_geomProx.update();
            if (modChanged) {
                this.resumeUpdates();
            }
        }
    }

    public FDSRasterization getRasterizations() {
        return this.d_rasterizations;
    }

    public PyroTaskManager getTaskManager() {
        return this.d_taskMan;
    }

    public PyroSimSelectionModel getSelectionModel() {
        return this.d_selModel;
    }

    public void resetModel(boolean initDefaults) {
        this.pauseUpdates(false);
        this.d_selModel.clearSelection();
        this.setSerialized(new Serialized(initDefaults));
        this.resumeUpdates();
        this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
    }

    public RasterizationOptions getRastOptions() {
        return this.ser.rastProps;
    }

    public void setRastProps(RasterizationOptions props) {
        if (this.ser.rastProps.equals(props)) {
            return;
        }
        this.ser.rastProps = props;
        this.getEvents().changed(this, EVT_RAST_PROPS);
    }

    public ModelComposite getObstructions() {
        return this.ser.obstructions;
    }

    public ScenarioList getScenarios() {
        return this.ser.scenarios;
    }

    public SimParams getSimParams() {
        return this.ser.simParams;
    }

    public MaterialManager getMaterialMgr() {
        return this.ser.matmgr;
    }

    public SurfaceManager getSurfaceMgr() {
        return this.ser.surfmgr;
    }

    public ReactionList getReactions() {
        return this.ser.reactions;
    }

    public String getUnprocessedRecords() {
        return this.ser.unprocessedRecords;
    }

    public void setUnprocessedRecords(String unprocessedRecords) {
        this.ser.unprocessedRecords = unprocessedRecords;
        this.changedEvt(EVT_UNPROC_RECS_CHANGED);
    }

    public boolean fromLegacy(File dbDir, pyrosim.legacy_2006_2.PyroMod pyModOld, WarningReport<Warning> warnings) {
        pyrosim.legacy_2006_2.Serialized serOld = pyModOld.ser;
        this.pauseUpdates(false);
        this.resetModel(false);
        Convert cvt = new Convert(dbDir, warnings);
        pyrosim.legacy_2012_1.domain.Serialized ser = new pyrosim.legacy_2012_1.domain.Serialized(false);
        ser = cvt.fromLegacy(ser, serOld);
        this.resumeUpdates();
        pyrosim.legacy_2012_1.PyroMod pyModMed = new pyrosim.legacy_2012_1.PyroMod(ser);
        return this.fromLegacy(dbDir, pyModMed, warnings);
    }

    public boolean fromLegacy(File dbDir, pyrosim.legacy_2012_1.PyroMod pyModOld, WarningReport<Warning> warnings) {
        pyrosim.legacy_2012_1.domain.Serialized serOld = pyModOld.ser;
        this.pauseUpdates(false);
        this.resetModel(false);
        pyrosim.io.pyrosimV5V6.Convert cvt = new pyrosim.io.pyrosimV5V6.Convert(dbDir, warnings);
        Serialized ser = new Serialized(false);
        ser = cvt.fromLegacy(ser, serOld, this.getAppearances());
        this.setSerialized(ser);
        this.resumeUpdates();
        this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
        return true;
    }

    private static void showWarnings(WarningReport<Warning> warnings, boolean suppress) {
        if (!warnings.isEmpty()) {
            if (!suppress) {
                WarningDlg<Warning> dlg = new WarningDlg<Warning>((Window)Application.getApp().getMainFrame(), Intl.intl("PSM Warnings"), Intl.intl("There were some problems reading the PyroSim file.  The following table lists the problems and how they were resolved."), warnings);
                dlg.doModal();
            } else {
                System.out.println("Warnings:\n" + warnings.prepareReport());
            }
        }
    }

    public void openModel(PyroSimObjectInputStream ois, boolean suppressWarnings) throws IOException, ClassNotFoundException, Exception {
        this.pauseUpdates(false);
        try {
            Serialized serNew = ois.readModel();
            this.setSerialized(serNew);
            PyroMod.showWarnings(ois.getWarnings(), suppressWarnings);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.resumeUpdates();
        }
        this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
    }

    public void saveModel(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.ser);
    }

    public boolean readBIMFile(String filename) {
        boolean result = true;
        this.pauseUpdates();
        try {
            BimImporter.open(this.ser, filename);
        }
        catch (Throwable e) {
            result = false;
            e.printStackTrace();
        }
        this.resumeUpdates();
        return result;
    }

    public boolean readFDS6File(String filename, boolean suppressWarnings) throws Exception {
        this.pauseUpdates(false);
        try {
            PyroMod tempMod = new PyroMod();
            tempMod.setAutoProxUpdate(false);
            FDSParser parser = FDS.newParser(6);
            FDSParseResult result = parser.parseFile(filename, tempMod);
            result.warningReport.showWarnings(suppressWarnings);
            tempMod.ser.initDefaults();
            this.setSerialized(tempMod.ser);
            this.getFloorManager().addDefaults();
            tempMod = null;
            this.resumeUpdates();
            this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
            return true;
        }
        catch (Exception e) {
            this.resumeUpdates();
            throw e;
        }
    }

    public PyroNamesDB getNames() {
        return this.d_names;
    }

    public NameGenerator getNames(Object obj) {
        return this.d_names.getNames(obj);
    }

    public NameGenerator getNames(Class type) {
        return this.d_names.getNames(type);
    }

    public void setSerialized(PyroMod tempMod) {
        this.pauseUpdates();
        try {
            tempMod.ser.setDomain(null);
            this.setSerialized(tempMod.ser);
        }
        finally {
            this.resumeUpdates();
        }
    }

    public void setSerialized(Serialized serialized) {
        MaterialDB matDB = null;
        MaterialDB newMatDB = serialized.appearances;
        if (this.ser != null) {
            this.ser.setDomain(null);
            matDB = this.ser.appearances;
        }
        this.ser = serialized;
        this.d_names = this.ser.generateNamesDB();
        if (matDB != null) {
            this.ser.appearances = matDB;
        }
        this.ser.setDomain(this);
        if (matDB != null) {
            matDB.loadFrom(newMatDB);
        }
        this.d_selModel.clearSelection();
        this.getEvents().resetEvents();
        this.d_scenarioCtrl.attach(this);
    }

    public GridList getGridManager() {
        return this.ser.grids;
    }

    public ZoneMgr getZoneMgr() {
        return this.ser.zones;
    }

    public BridgeList getBridges() {
        return this.ser.bridges;
    }

    public FloorManager getFloorManager() {
        return this.ser.floors;
    }

    public void setPL3DRecord(Plot3d rec) {
        this.ser.plot3d = rec;
        this.getEvents().changed(this.ser.plot3d, new Object[0]);
    }

    public void setSimParams(SimParams params) {
        this.ser.simParams = params;
        this.getEvents().changed(this.ser.simParams, new Object[0]);
    }

    public SmokeLinkModelMgr getSmokeLinkModels() {
        return this.ser.smokeLinkModels;
    }

    public HeatLinkModelMgr getHeatLinkModels() {
        return this.ser.heatLinkModels;
    }

    public SprinklerLinkModelMgr getSprinklerLinkModels() {
        return this.ser.sprkLinkModels;
    }

    public SprayModelMgr getSprayModels() {
        return this.ser.sprayModels;
    }

    public DeviceManager getDevices() {
        return this.ser.devices;
    }

    public ControlMgr getControls() {
        return this.ser.controls;
    }

    public Boundaries getBoundaryOutput() {
        return this.ser.boundaryOutput;
    }

    public void setBoundaries(Boundaries bounds) {
        this.ser.boundaryOutput = bounds;
        this.getEvents().changed(this.ser.boundaryOutput, new Object[0]);
    }

    public IsosurfaceMgr getIsofList() {
        return this.ser.isosurfaces;
    }

    public SliceList getSlcfList() {
        return this.ser.slices;
    }

    public Slice3dList getSlcf3dList() {
        return this.ser.slices3d;
    }

    public ParticleList getPartList() {
        return this.ser.particles;
    }

    public ExSpecList getExSpecList() {
        return this.ser.exSpecs;
    }

    public HvacList getHvacList() {
        return this.ser.hvacSystem;
    }

    public boolean getFdsEvacEnabled() {
        return this.ser.enableFdsEvac;
    }

    private Task taskSetFdsEvacEnabled(final boolean flag) {
        return new AUndoableTask(){

            @Override
            public void undo() {
                this.set(!flag);
            }

            @Override
            public void run() {
                this.set(flag);
            }

            private void set(boolean flag2) {
                ((PyroMod)PyroMod.this).ser.enableFdsEvac = flag2;
                PyroMod.this.getEvents().changed(PyroMod.this, EVT_FDS_EVAC_CHANGED);
            }
        };
    }

    public void setEvacEnabled(boolean flag) {
        Task t = this.taskSetFdsEvacEnabled(flag);
        String desc = flag ? Intl.intl("Enable FDS+EVAC") : Intl.intl("Disable FDS+Evac");
        this.getTaskManager().exec(t, desc);
    }

    public EvacList getEvacList() {
        return this.ser.evacs;
    }

    public EntrList getEntrList() {
        return this.ser.entrs;
    }

    public EvhoList getEvhoList() {
        return this.ser.evhos;
    }

    public CorrList getCorrList() {
        return this.ser.corrs;
    }

    public EvssList getEvssList() {
        return this.ser.evsss;
    }

    public ExitList getExitList() {
        return this.ser.exits;
    }

    public PersList getPersList() {
        return this.ser.perss;
    }

    public DoorList getDoorList() {
        return this.ser.doors;
    }

    public Plot3d getPlot3d() {
        return this.ser.plot3d;
    }

    public ProfList getProfList() {
        return this.ser.profs;
    }

    public StatisticMgr getMsrStatMgr() {
        return this.ser.msrStats;
    }

    public ViewMgr getViews() {
        return this.ser.views;
    }

    public MaterialDB getAppearances() {
        return this.ser.appearances;
    }

    public Surface getDefaultSurface() {
        return this.getSurfaceMgr().get(PredefSurf.INERT);
    }

    public ResultsArchive getResultsArchive() {
        return this.ser.resultsArchive;
    }

    public Collection<? extends IPyroGeomSrc> getAllGeom() {
        return Hierarchy.flatten(this.getMembers(), IPyroGeomSrc.class);
    }

    public DepSnapshot getDependencies(IPyroObject ... interestingDepOns) {
        return this.getDependencies(Arrays.asList(interestingDepOns));
    }

    public DepSnapshot getDependencies(Collection<? extends IPyroObject> interestingDepOns) {
        DepSnapshot ds = new DepSnapshot(interestingDepOns);
        this.collectDeps(ds);
        return ds;
    }

    private void collectDeps(DepSnapshot ds) {
        ds.start(this, this.ser);
    }

    public Object getLockObj() {
        return this.ser;
    }

    public void setLastFDSRun(FDSRun run) {
        if (!theUtil.equal(run, this.ser.lastFDSRun)) {
            this.ser.lastFDSRun = run;
            this.getEvents().changed(this, EVT_FDS_RUN_CHANGED);
        }
    }

    public FDSRun getLastFDSRun() {
        return this.ser.lastFDSRun;
    }

    public FDSClusterOptions getClusterOptions() {
        return this.ser.clusterOptions;
    }

    public void setClusterOptions(FDSClusterOptions options) {
        this.ser.clusterOptions = options;
        this.getEvents().changed(this, EVT_FDS_CLUSTER_OPTIONS_CHANGED);
    }

    public void setWriteProtected(boolean flag, byte[] passHash) {
        assert (passHash != null);
        this.ser.d_protect = flag;
        this.ser.d_protectPassHash = passHash;
    }

    public boolean isWriteProtected() {
        return this.ser.d_protect;
    }

    public byte[] getWriteProtectedPassHash() {
        return this.ser.d_protectPassHash;
    }

    @Override
    public PyroMod getDomain() {
        return this;
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        return this.getEvents().changed(this, changes);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void setDomain(PyroMod domain) {
    }

    @Override
    public void setDomain(PyroMod domain, IPyroObject parent) {
    }

    @Override
    public IPyroObject getParent() {
        return null;
    }

    @Override
    public Object clone() {
        assert (false);
        return null;
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this == obj;
    }

    private static class NilEvents
    extends Events {
        private NilEvents() {
        }

        @Override
        public void addObserver(IEventObserver o) {
        }

        @Override
        public void removeObserver(IEventObserver o) {
        }

        @Override
        public void clearObservers() {
        }

        @Override
        public void resetEvents() {
        }

        public Set<EventChannel> getAffectedChannels(Class type, Class ... exclusions) {
            return Collections.emptySet();
        }

        @Override
        public void pause() {
        }

        @Override
        public void pause(boolean listenToEvents) {
        }

        @Override
        public boolean resume() {
            return false;
        }

        @Override
        public boolean willFireOnResume() {
            return false;
        }

        @Override
        public Collection<EventChannel> getChannels() {
            return Collections.emptySet();
        }

        @Override
        public boolean added(Object obj) {
            return false;
        }

        @Override
        public boolean added(Object ... objs) {
            return false;
        }

        @Override
        public boolean added(Collection<?> objs) {
            return false;
        }

        @Override
        public boolean removed(Object obj) {
            return false;
        }

        @Override
        public boolean removed(Object ... objs) {
            return false;
        }

        @Override
        public boolean removed(Collection<?> objs) {
            return false;
        }

        @Override
        public boolean changed(Object obj, Object ... changes) {
            return false;
        }

        @Override
        public boolean changed(Collection<?> objs, Object ... changes) {
            return false;
        }
    }

    private class PyroEvents
    extends Events {
        private PyroEvents() {
        }

        @Override
        protected void fireNotification() {
            PyroMod.this.updateGeom();
            PyroMod.this.pauseUpdates(false);
            for (EventChannel channel : this.getChannels()) {
                PyroMod.this.d_selModel.deselectAll(channel.getRemovedObjs());
            }
            PyroMod.this.resumeUpdates();
            PyroMod.this.d_rasterizations.update(this);
            super.fireNotification();
        }
    }

    public static class PasteOption {
        public static final int PASTE_ADD_INCOMING = 0;
        public static final int PASTE_REPLACE_EXISTING = 1;
        public static final int PASTE_KEEP_EXISTING = 2;
        public static final int PASTE_MAKE_INCOMING_UNIQUE = 3;
        public final int command;
        public final Object param;

        public PasteOption(int command, Object param) {
            this.command = command;
            this.param = param;
        }
    }
}

