/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.awt.Font;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.DepUtil;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import pyrosim.domain.evac.Corr;
import pyrosim.domain.evac.CorrList;
import pyrosim.domain.evac.Door;
import pyrosim.domain.evac.DoorList;
import pyrosim.domain.evac.Entr;
import pyrosim.domain.evac.EntrList;
import pyrosim.domain.evac.Evac;
import pyrosim.domain.evac.EvacList;
import pyrosim.domain.evac.Evho;
import pyrosim.domain.evac.EvhoList;
import pyrosim.domain.evac.Evss;
import pyrosim.domain.evac.EvssList;
import pyrosim.domain.evac.Exit;
import pyrosim.domain.evac.ExitList;
import pyrosim.domain.evac.Pers;
import pyrosim.domain.evac.PersList;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.output.IsosurfaceMgr;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.AutoRenameTask;
import pyrosim.domain.tasks.ReorderObjectsTask;
import pyrosim.domain.tasks.Tasks;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.ClipPlane;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;
import pyrosim.domain.zones.ZoneMgr;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IProxyGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Global;
import thunderheadeng.util.Task;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class TVEntryPoints {
    private static final Icon s_mgrIcon = PyroGuiUtil.loadPyroSimIcon("manager8.png");
    private static final Map<Class, TVEntryPoint> s_entryPoints;
    private static final TVEntryPoint s_defEP;
    private static final ResultsNode RESULTS_NODE;

    public static <T> TVEntryPoint<T> ep(Class<T> clazz) {
        TVEntryPoint ep = s_entryPoints.get(clazz);
        if (ep == null) {
            ep = theUtil.findObjectForClass(s_entryPoints, clazz);
            if (ep == null) {
                ep = s_defEP;
            }
            s_entryPoints.put(clazz, ep);
        }
        return ep;
    }

    public static <T> TVEntryPoint<T> ep(T obj) {
        if (obj == null) {
            return null;
        }
        return TVEntryPoints.ep(obj.getClass());
    }

    private static boolean isOwnParent(PyroMod md, Set<?> objs, Composite target) {
        for (IPyroObject pobj = target; pobj != null; pobj = pobj.getParent()) {
            if (!objs.contains(pobj)) continue;
            return true;
        }
        return false;
    }

    private static boolean allOfType(Collection<?> objs, Class type) {
        for (Object obj : objs) {
            if (!(obj instanceof Composite ? !type.isAssignableFrom(((Composite)obj).getType()) : !type.isInstance(obj))) continue;
            return false;
        }
        return true;
    }

    private static ImageIcon newMgrIcon(Icon baseIcon) {
        return baseIcon == null ? null : new DecoratedIcon(baseIcon, s_mgrIcon, 3);
    }

    static /* synthetic */ ImageIcon access$100(Icon x0) {
        return TVEntryPoints.newMgrIcon(x0);
    }

    static {
        s_defEP = new TVEntryPoint(Intl.intl("Object"));
        s_entryPoints = new HashMap<Class, TVEntryPoint>();
        s_entryPoints.put(PyroMod.class, new RootEP());
        s_entryPoints.put(Composite.class, new CompositeEP(null));
        s_entryPoints.put(MaterialManager.class, new MatlMgrEP());
        s_entryPoints.put(pyrosim.domain.boundcond.mat.Material.class, new MatlEP());
        s_entryPoints.put(ReactionList.class, new ReacMgrEP());
        s_entryPoints.put(Reaction.class, new ReacEP());
        s_entryPoints.put(SurfaceManager.class, new SurfaceMgrEP());
        s_entryPoints.put(Surface.class, new SurfaceEP());
        s_entryPoints.put(MaterialDB.class, new AppearanceDBEP());
        s_entryPoints.put(DeviceManager.class, new DevcMgrEP());
        s_entryPoints.put(IDevice.class, new DevcEP());
        s_entryPoints.put(ControlMgr.class, new CtrlMgrEP());
        s_entryPoints.put(ControlBridge.class, new TVEntryPoint(Intl.intl("Control")));
        s_entryPoints.put(GridList.class, new GridMgrEP());
        s_entryPoints.put(Grid.class, new GridEP());
        s_entryPoints.put(ZoneMgr.class, new ZoneMgrEP());
        s_entryPoints.put(Zone.class, new ZoneEP());
        s_entryPoints.put(ModelComposite.class, new ModelCompositeEP());
        s_entryPoints.put(IModelObj.class, new ModelObjEP());
        s_entryPoints.put(SimParams.class, new SimParamsEP());
        s_entryPoints.put(Plot3d.class, new Plot3dEP());
        s_entryPoints.put(Leak.class, new LeakEP());
        s_entryPoints.put(ExSpecList.class, new ExSpecMgrEP());
        s_entryPoints.put(ExSpec.class, new ExSpecEP());
        s_entryPoints.put(HvacList.class, new CompositeEP(PyroGuiUtil.loadPyroSimIcon("hvac_fan16.png")));
        s_entryPoints.put(IHvacObject.class, new TVEntryPoint(Intl.intl("HVAC Component")));
        s_entryPoints.put(HvacDuctLoss.class, new HvacDuctLossEP());
        s_entryPoints.put(HvacNode.class, new HvacNodeEP());
        s_entryPoints.put(HvacDuct.class, new HvacDuctEP());
        s_entryPoints.put(ParticleList.class, new ParticleListEP());
        s_entryPoints.put(Particle.class, new ParticleEP());
        s_entryPoints.put(HeatLinkModelMgr.class, new CompositeEP(null));
        s_entryPoints.put(HeatLinkModel.class, new TVEntryPoint(Intl.intl("Heat Detector Model")));
        s_entryPoints.put(SmokeLinkModelMgr.class, new CompositeEP(null));
        s_entryPoints.put(SmokeLinkModel.class, new TVEntryPoint(Intl.intl("Smoke Detector Model")));
        s_entryPoints.put(SprinklerLinkModelMgr.class, new CompositeEP(null));
        s_entryPoints.put(SprinklerLinkModel.class, new TVEntryPoint(Intl.intl("Sprinkler Link Model")));
        s_entryPoints.put(SprayModelMgr.class, new CompositeEP(null));
        s_entryPoints.put(SprayModel.class, new TVEntryPoint(Intl.intl("Spray Model")));
        s_entryPoints.put(CorrList.class, new CompositeEP(null));
        s_entryPoints.put(Corr.class, new TVEntryPoint(Intl.intl("Corridor")));
        s_entryPoints.put(DoorList.class, new CompositeEP(null));
        s_entryPoints.put(Door.class, new TVEntryPoint(Intl.intl("Door")));
        s_entryPoints.put(EntrList.class, new CompositeEP(null));
        s_entryPoints.put(Entr.class, new TVEntryPoint(Intl.intl("ENTR")));
        s_entryPoints.put(EvacList.class, new CompositeEP(null));
        s_entryPoints.put(Evac.class, new TVEntryPoint(Intl.intl("EVAC")));
        s_entryPoints.put(EvhoList.class, new CompositeEP(null));
        s_entryPoints.put(Evho.class, new TVEntryPoint(Intl.intl("EVHO")));
        s_entryPoints.put(EvssList.class, new CompositeEP(null));
        s_entryPoints.put(Evss.class, new TVEntryPoint(Intl.intl("EVSS")));
        s_entryPoints.put(ExitList.class, new CompositeEP(null));
        s_entryPoints.put(Exit.class, new TVEntryPoint(Intl.intl("Exit")));
        s_entryPoints.put(PersList.class, new CompositeEP(null));
        s_entryPoints.put(Pers.class, new TVEntryPoint(Intl.intl("PERS")));
        s_entryPoints.put(ResultsNode.class, new ResultsNodeEP());
        s_entryPoints.put(ViewList.class, new ViewListEP());
        s_entryPoints.put(View.class, new ViewEP());
        s_entryPoints.put(ClipPlane.class, new ClipPlaneEP());
        s_entryPoints.put(SectionBox.class, new SectionBoxEP());
        s_entryPoints.put(CameraState.class, new CameraStateEP());
        s_entryPoints.put(StatisticMgr.class, new StatMgrEP());
        s_entryPoints.put(IMeasurementStat.class, new StatisticEP());
        s_entryPoints.put(Boundaries.class, new BoundaryEP());
        s_entryPoints.put(SliceList.class, new SliceMgrEP());
        s_entryPoints.put(PlanarSlice.class, new SliceEP());
        s_entryPoints.put(Slice3dList.class, new Slice3dMgrEP());
        s_entryPoints.put(VolumeSlice.class, new Slice3dEP());
        s_entryPoints.put(IsosurfaceMgr.class, new IsofMgrEP());
        s_entryPoints.put(Isosurface.class, new IsofEP());
        s_entryPoints.put(ProfList.class, new CompositeEP(null));
        s_entryPoints.put(ProfRec.class, new TVEntryPoint(Intl.intl("Material Profile")));
        s_entryPoints.put(FloorManager.class, new CompositeEP(null));
        s_entryPoints.put(Floor.class, new TVEntryPoint(Intl.intl("Floor")));
        RESULTS_NODE = new ResultsNode();
    }

    private static class ResultsNode {
        private ResultsNode() {
        }
    }

    public static class SliceEP
    extends TVEntryPoint<PlanarSlice> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("slices16.png");

        public SliceEP() {
            super(ICON, Intl.intl("Slice"));
        }

        @Override
        public String getName(PlanarSlice obj) {
            if (obj instanceof PlanarSlice) {
                PlanarSlice ps = obj;
                String name = "";
                switch (ps.getPlane()) {
                    case 0: {
                        name = Intl.intl("X");
                        break;
                    }
                    case 1: {
                        name = Intl.intl("Y");
                        break;
                    }
                    case 2: {
                        name = Intl.intl("Z");
                    }
                }
                name = name + " = " + Global.format(ps.getLocation());
                name = name + ": " + ps.getQuantity().getDescription();
                return name;
            }
            return super.getName(obj);
        }

        @Override
        public boolean isOccluder(PyroMod md, PlanarSlice obj) {
            return false;
        }

        @Override
        public boolean isDrawingSnappable(PyroMod md, PlanarSlice obj) {
            return false;
        }
    }

    public static class Slice3dEP
    extends TVEntryPoint<VolumeSlice> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("slices3d.png");

        public Slice3dEP() {
            super(ICON, Intl.intl("3D Slice"));
        }

        @Override
        public String getName(VolumeSlice obj) {
            return obj.toString();
        }

        @Override
        public boolean isOccluder(PyroMod md, VolumeSlice obj) {
            return false;
        }

        @Override
        public boolean isDrawingSnappable(PyroMod md, VolumeSlice obj) {
            return false;
        }
    }

    public static class Slice3dMgrEP
    extends CompositeEP<Slice3dList> {
        private static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("slices3d.png"));

        public Slice3dMgrEP() {
            super(ICON);
        }

        @Override
        public Object getTreeviewParent(PyroMod md, Slice3dList obj) {
            if (obj == md.getSlcf3dList()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(md, obj);
        }

        @Override
        public Object getConflict(PyroMod md, Slice3dList categoryRoot, Object child) {
            for (VolumeSlice existing : md.getSlcf3dList().flatten()) {
                if (!existing.equals(child)) continue;
                return existing;
            }
            return null;
        }
    }

    public static class SliceMgrEP
    extends CompositeEP<SliceList> {
        private static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("slices16.png"));

        public SliceMgrEP() {
            super(ICON);
        }

        @Override
        public Object getTreeviewParent(PyroMod md, SliceList obj) {
            if (obj == md.getSlcfList()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(md, obj);
        }

        @Override
        public Object getConflict(PyroMod md, SliceList categoryRoot, Object child) {
            for (PlanarSlice existing : md.getSlcfList().flatten()) {
                if (!existing.equals(child)) continue;
                return existing;
            }
            return null;
        }
    }

    public static class StatisticEP
    extends TVEntryPoint<IMeasurementStat> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("stat16.png");

        public StatisticEP() {
            super(ICON, Intl.intl("Statistic"));
        }
    }

    public static class StatMgrEP
    extends CompositeEP<StatisticMgr> {
        public static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("stat16.png"));

        public StatMgrEP() {
            super(ICON);
        }

        @Override
        public Object getTreeviewParent(PyroMod md, StatisticMgr obj) {
            if (obj == md.getMsrStatMgr()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(md, obj);
        }
    }

    public static class ResultsNodeEP
    extends TVEntryPoint<ResultsNode> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("composite16_2.gif");

        public ResultsNodeEP() {
            super(ICON, Intl.intl("Results"));
        }

        @Override
        public boolean isLeaf(PyroMod md, ResultsNode obj) {
            return false;
        }

        @Override
        public boolean objectInModel(PyroMod md, ResultsNode obj) {
            return true;
        }

        @Override
        public Object getTreeviewParent(PyroMod md, ResultsNode obj) {
            return md;
        }

        @Override
        public boolean canRename(PyroMod md, ResultsNode obj) {
            return false;
        }

        @Override
        public String getName(ResultsNode obj) {
            return Intl.intl("Results");
        }

        @Override
        public Collection<?> getTreeviewChildren(PyroMod md, ResultsNode obj) {
            return Arrays.asList(md.getMsrStatMgr(), md.getSlcfList(), md.getSlcf3dList());
        }
    }

    public static class CameraStateEP
    extends TVEntryPoint<CameraState> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("camera16.png");

        public CameraStateEP() {
            super(ICON, Intl.intl("Viewpoint"));
        }

        @Override
        public boolean canDelete(PyroMod md, CameraState obj, Object child) {
            return true;
        }

        @Override
        public String getDisplayName(CameraState obj) {
            return Intl.intl("Viewpoint");
        }

        @Override
        public Object getCategoryRoot(PyroMod md, CameraState obj) {
            return null;
        }

        @Override
        public Object getPasteLocation(PyroMod md, CameraState obj) {
            return null;
        }
    }

    public static class SectionBoxEP
    extends TVEntryPoint<SectionBox> {
        public SectionBoxEP() {
            super(Intl.intl("Section Box"));
        }

        @Override
        public boolean canRename(PyroMod md, SectionBox obj) {
            return false;
        }

        @Override
        public boolean canDelete(PyroMod md, SectionBox obj, Object child) {
            return true;
        }

        @Override
        public String getDisplayName(SectionBox obj) {
            return Intl.intl("Section Box");
        }

        @Override
        public Object getCategoryRoot(PyroMod md, SectionBox obj) {
            return null;
        }

        @Override
        public Object getPasteLocation(PyroMod md, SectionBox obj) {
            return null;
        }
    }

    public static class ClipPlaneEP
    extends TVEntryPoint<ClipPlane> {
        public ClipPlaneEP() {
            super(Intl.intl("Clip Plane"));
        }

        @Override
        public boolean canRename(PyroMod md, ClipPlane obj) {
            return false;
        }

        @Override
        public boolean canDelete(PyroMod md, ClipPlane obj, Object child) {
            return false;
        }

        @Override
        public boolean canDrop(PyroMod md, ClipPlane obj, Set<?> objs, Object commonParent) {
            return false;
        }

        @Override
        public String getName(ClipPlane obj) {
            return obj.getPlane().toString(PyroSim.getApp().getUnitSystem().getLengthUnit());
        }
    }

    public static class ViewEP
    extends TVEntryPoint<View> {
        public ViewEP() {
            super(Intl.intl("View"));
        }

        @Override
        public Font getBaseFont(PyroMod md, View obj) {
            boolean active;
            boolean bl = active = md.getViews().getActiveView() == obj;
            if (active) {
                return s_bold;
            }
            return super.getBaseFont(md, obj);
        }

        @Override
        public boolean canDelete(PyroMod md, View obj, Object child) {
            if (child instanceof SectionBox || child instanceof CameraState) {
                return true;
            }
            return super.canDelete(md, obj, child);
        }

        @Override
        public boolean add(View obj, Object child) {
            if (child instanceof SectionBox) {
                SectionBox sb = (SectionBox)child;
                if (obj.get(View.PROP_SECTION_BOX) == null) {
                    obj.set(View.PROP_SECTION_BOX, sb);
                }
                return true;
            }
            if (child instanceof CameraState) {
                if (obj.get(View.PROP_CAMERA) == null) {
                    obj.set(View.PROP_CAMERA, (CameraState)child);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(View obj, Object child) {
            if (child instanceof SectionBox) {
                obj.remove(View.PROP_SECTION_BOX);
                return true;
            }
            if (child instanceof CameraState) {
                obj.remove(View.PROP_CAMERA);
            }
            return false;
        }

        @Override
        public boolean isDroppable(PyroMod md, View target) {
            return target.get(View.PROP_SECTION_BOX) == null || target.get(View.PROP_CAMERA) == null;
        }

        @Override
        public boolean canDrop(PyroMod md, View obj, Set<?> objs, Object commonParent) {
            if (theUtil.filter(objs, new TypeFilter(SectionBox.class, CameraState.class)).isExclusive() && (theUtil.filter(objs, SectionBox.class).size() == 1 || theUtil.filter(objs, CameraState.class).size() == 1)) {
                for (Object o : objs) {
                    if (this.canPaste(md, obj, o)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public Task drop(PyroMod md, View target, int insertPos, Collection<?> objs) {
            return new ReorderObjectsTask((IPyroObject)target, insertPos, theUtil.filter(objs, IPyroObject.class));
        }

        @Override
        public boolean canPaste(PyroMod md, View obj, Object child) {
            return child instanceof SectionBox && obj.get(View.PROP_SECTION_BOX) == null || child instanceof CameraState && obj.get(View.PROP_CAMERA) == null;
        }

        @Override
        public Task paste(PyroMod md, View pasteLoc, Object newObj, Object existingObj, TVEntryPoint.ConflictResolution cr, DepSnapshot deps) {
            return new AddTask<IPyroObject>((IPyroObject)pasteLoc, (Collection<IPyroObject>)Arrays.asList((IPyroObject)newObj));
        }

        @Override
        public boolean isContainer(PyroMod md, View obj, Object child) {
            if (child instanceof SectionBox || child instanceof CameraState) {
                return true;
            }
            return super.isContainer(md, obj, child);
        }
    }

    public static class ViewListEP
    extends CompositeEP<ViewList> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("cameras16.png");

        public ViewListEP() {
            super(ICON);
        }

        @Override
        public boolean canDrop(PyroMod md, ViewList obj, Set<?> objs, Object commonParent) {
            if (!super.canDrop(md, obj, objs, commonParent)) {
                return false;
            }
            for (Object o : objs) {
                if (this.canPaste(md, obj, o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Font getBaseFont(PyroMod md, ViewList obj) {
            if (obj != md.getViews()) {
                View aview = md.getViews().getActiveView();
                for (IPyroObject parent = aview.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent != obj) continue;
                    return s_bold;
                }
            }
            return super.getBaseFont(md, obj);
        }

        @Override
        public boolean canDelete(PyroMod md, ViewList obj, Object child) {
            if (child instanceof View) {
                View view = (View)child;
                return md.getViews().getActiveView() != view;
            }
            return super.canDelete(md, obj, child);
        }
    }

    public static class ModelCompositeEP
    extends CompositeEP<ModelComposite> {
        public ModelCompositeEP() {
            super(PyroGuiUtil.loadPyroSimIcon("composite16_2.gif"));
        }
    }

    public static class ModelObjEP
    extends TVEntryPoint<IModelObj> {
        public static final ImageIcon VENT_ICON = PyroGuiUtil.loadPyroSimIcon("vent16.gif");
        public static final ImageIcon SLAB_ICON = PyroGuiUtil.loadPyroSimIcon("triangle.png");
        public static final ImageIcon WALL_ICON = PyroGuiUtil.loadPyroSimIcon("block16_2.gif");
        public static final ImageIcon INIT_REGION_ICON = PyroGuiUtil.loadPyroSimIcon("init16.png");
        public static final ImageIcon PART_CLOUD_ICON = PyroGuiUtil.loadPyroSimIcon("partCloud16.gif");
        public static final ImageIcon SINGLE_PART_ICON = PyroGuiUtil.loadPyroSimIcon("single_part16.gif");
        public static final ImageIcon ABLOCK_ICON = PyroGuiUtil.loadPyroSimIcon("cube16.png");
        public static final ImageIcon AHOLE_ICON = PyroGuiUtil.loadPyroSimIcon("hole16.gif");
        public static final ImageIcon HOLE_ICON = PyroGuiUtil.loadPyroSimIcon("wall_hole16.png");
        public static final ImageIcon GEOMGROUP_ICON = PyroGuiUtil.loadPyroSimIcon("geomgroup16.png");

        public ModelObjEP() {
            super(Intl.intl("Geometric Object"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Icon[] getIcons(PyroMod md, IModelObj obj) {
            ImageIcon icon;
            IGeomNode node = obj.getGeom();
            if (node.getChildren().isEmpty()) {
                IGeom geom = node.getLocalGeom();
                while (geom instanceof IProxyGeom) {
                    geom = ((IProxyGeom)geom).getBase();
                }
                if (geom instanceof AABoxGeom && obj instanceof IObstruction) {
                    icon = ABLOCK_ICON;
                    return new Icon[]{icon, null};
                } else if (geom instanceof AABoxGeom && obj instanceof IHole) {
                    icon = AHOLE_ICON;
                    return new Icon[]{icon, null};
                } else if (geom instanceof WallGeom && obj instanceof IObstruction) {
                    icon = WALL_ICON;
                    return new Icon[]{icon, null};
                } else if (geom instanceof WallGeom && obj instanceof IHole) {
                    icon = HOLE_ICON;
                    return new Icon[]{icon, null};
                } else if (geom instanceof ExtrudedPoly) {
                    icon = SLAB_ICON;
                    return new Icon[]{icon, null};
                } else if (geom instanceof GeomGroup) {
                    icon = GEOMGROUP_ICON;
                    return new Icon[]{icon, null};
                } else if (obj instanceof InitRegion) {
                    icon = INIT_REGION_ICON;
                    return new Icon[]{icon, null};
                } else if (obj instanceof PartCloud) {
                    PartCloud cloud = (PartCloud)obj;
                    icon = cloud.getGeom().getLocalGeom() instanceof Point ? SINGLE_PART_ICON : PART_CLOUD_ICON;
                    return new Icon[]{icon, null};
                } else {
                    if (!(obj instanceof Vent)) return super.getIcons(md, obj);
                    icon = VENT_ICON;
                }
                return new Icon[]{icon, null};
            } else {
                icon = GEOMGROUP_ICON;
            }
            return new Icon[]{icon, null};
        }

        @Override
        public boolean mayBeReferenced(PyroMod md, IModelObj obj) {
            return obj instanceof Vent;
        }

        @Override
        public Object getCategoryRoot(PyroMod md, IModelObj obj) {
            return md.getObstructions();
        }
    }

    public static class CompositeEP<T extends Composite>
    extends TVEntryPoint<T> {
        public CompositeEP(ImageIcon icon) {
            super(icon, Intl.intl("Group"));
        }

        @Override
        public boolean isVisible(PyroMod md, T obj) {
            if (((Composite)obj).getMembers().isEmpty()) {
                return true;
            }
            for (IPyroObject child : ((Composite)obj).getMembers()) {
                if (!TVEntryPoints.ep(child).isVisible(md, child)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isContainer(PyroMod md, T obj, Object child) {
            return child instanceof IPyroObject && ((Composite)obj).accept((IPyroObject)child);
        }

        @Override
        public boolean canDelete(PyroMod md, T obj, Object child) {
            return true;
        }

        @Override
        public boolean add(T obj, Object child) {
            return ((Composite)obj).add((IPyroObject)child);
        }

        @Override
        public boolean addAll(T obj, Collection<?> children) {
            return ((Composite)obj).addAll(children);
        }

        @Override
        public boolean remove(T obj, Object child) {
            return ((Composite)obj).remove((IPyroObject)child);
        }

        @Override
        public boolean removeAll(T obj, Collection<?> children) {
            return ((Composite)obj).removeAll(children);
        }

        @Override
        public void reorder(T obj, Collection<?> newOrder) {
            ((Composite)obj).reorder(newOrder);
        }

        @Override
        public Object getConflict(PyroMod md, T categoryRoot, Object child) {
            if (Util.isKeyedByName(md, child)) {
                String name = Util.getName((IPyroObject)child);
                if (!md.getNames().getNames(child).isRegistered(name)) {
                    return null;
                }
                return ((Composite)categoryRoot).get(name);
            }
            return null;
        }

        @Override
        public boolean canPaste(PyroMod md, T obj, Object pasteObj) {
            return pasteObj instanceof IPyroObject && ((Composite)obj).accept((IPyroObject)pasteObj);
        }

        @Override
        public Task paste(PyroMod md, T pasteLoc, Object newObj, Object existingObj, TVEntryPoint.ConflictResolution cr, DepSnapshot deps) {
            assert (newObj instanceof IPyroObject && ((Composite)pasteLoc).accept((IPyroObject)newObj));
            assert (existingObj == null || existingObj instanceof IPyroObject && ((Composite)pasteLoc).accept((IPyroObject)existingObj));
            if (existingObj == null) {
                return new AddTask(pasteLoc, new IPyroObject[]{(IPyroObject)newObj});
            }
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(md);
            if (cr == TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING) {
                for (Dependency dep : deps.getDependents((IPyroObject)existingObj)) {
                    task.addTask(DepUtil.getReplacementTask(deps, dep.source, (IPyroObject)existingObj, (IPyroObject)newObj));
                }
                task.addTask(Tasks.delete((IPyroObject)existingObj));
            } else {
                Object catRoot = TVEntryPoints.ep(newObj).getCategoryRoot(md, newObj);
                assert (catRoot instanceof Composite);
                if (newObj instanceof INamed) {
                    task.addTask(new AutoRenameTask(md, new INamed[]{(INamed)newObj}));
                }
            }
            task.addTask(new AddTask(pasteLoc, new IPyroObject[]{(IPyroObject)newObj}));
            return task;
        }

        @Override
        public boolean isDroppable(PyroMod md, T target) {
            return true;
        }

        @Override
        public boolean canDrop(PyroMod md, T obj, Set<?> objs, Object commonParent) {
            if (!(commonParent instanceof Composite)) {
                return false;
            }
            IPyroObject categoryRoot = Hierarchy.getCategoryRoot((Composite)commonParent);
            if (categoryRoot == null) {
                return false;
            }
            return Hierarchy.isDescendent(categoryRoot, obj) && !TVEntryPoints.isOwnParent(md, objs, obj);
        }

        @Override
        public Task drop(PyroMod md, T target, int insertPos, Collection<?> objs) {
            return new ReorderObjectsTask((IPyroObject)target, insertPos, (Collection<? extends IPyroObject>)theUtil.filter(objs, IPyroObject.class));
        }
    }

    public static class ZoneEP
    extends TVEntryPoint<Zone> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("zones16.png");

        public ZoneEP() {
            super(ICON, Intl.intl("Zone"));
        }

        @Override
        public boolean canRename(PyroMod md, Zone obj) {
            return !obj.isOuter();
        }

        @Override
        public Font getBaseFont(PyroMod md, Zone obj) {
            return obj.isOuter() ? s_bold : super.getBaseFont(md, obj);
        }
    }

    public static class ZoneMgrEP
    extends CompositeEP<ZoneMgr> {
        public static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("zones16.png"));

        public ZoneMgrEP() {
            super(ICON);
        }

        @Override
        public boolean canDelete(PyroMod md, ZoneMgr obj, Object child) {
            if (child instanceof Zone) {
                return !((Zone)child).isOuter();
            }
            return true;
        }
    }

    public static class GridEP
    extends TVEntryPoint<Grid> {
        private static ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif");
        private static ImageIcon ICON_EVAC = PyroGuiUtil.loadPyroSimIcon("3dgrid_evac16.gif");

        public GridEP() {
            super(Intl.intl("Mesh"));
        }

        @Override
        public Icon[] getIcons(PyroMod md, Grid obj) {
            ImageIcon icon = obj.getEvacuation() ? ICON_EVAC : ICON;
            return new Icon[]{icon, null};
        }

        @Override
        public String getDisplayName(Grid g) {
            long totalCells = g.getNumCells();
            String d = NumberFormat.getNumberInstance(Locale.getDefault()).format(totalCells);
            return g.getName() + " (" + d + ")";
        }
    }

    public static class GridMgrEP
    extends CompositeEP<GridList> {
        public static final ImageIcon ICON_GRID = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif"));

        public GridMgrEP() {
            super(ICON_GRID);
        }

        @Override
        public String getDisplayName(GridList gl) {
            Collection grids = gl.flatten();
            long totalCells = 0L;
            for (Grid g : grids) {
                totalCells += g.getNumCells();
            }
            String d = NumberFormat.getNumberInstance(Locale.getDefault()).format(totalCells);
            return gl.getName() + " (" + d + ")";
        }
    }

    public static class CtrlMgrEP
    extends CompositeEP<ControlMgr> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("or16.png");

        public CtrlMgrEP() {
            super(ICON);
        }
    }

    public static class ParticleListEP
    extends CompositeEP<ParticleList> {
        public static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("particles16.gif"));

        public ParticleListEP() {
            super(ICON);
        }
    }

    public static class ParticleEP
    extends TVEntryPoint<Particle> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("particles16.gif");

        public ParticleEP() {
            super(ICON, Intl.intl("Particle"));
        }
    }

    public static class ExSpecEP
    extends TVEntryPoint<ExSpec> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("molecule16.png");

        public ExSpecEP() {
            super(ICON, Intl.intl("Species"));
        }

        @Override
        public Font getBaseFont(PyroMod md, ExSpec obj) {
            if (obj.isBackgroundSpec()) {
                return s_bold;
            }
            return super.getBaseFont(md, obj);
        }

        @Override
        public String getDisplayName(ExSpec obj) {
            String name = super.getDisplayName(obj);
            if (obj.isBackgroundSpec()) {
                name = String.format(Intl.intl("%s (Background)"), name);
            }
            return name;
        }
    }

    public static class ExSpecMgrEP
    extends CompositeEP<ExSpecList> {
        private static final ImageIcon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("molecule16.png"));

        public ExSpecMgrEP() {
            super(ICON);
        }

        @Override
        public boolean canDelete(PyroMod md, ExSpecList obj, Object child) {
            if (child instanceof ExSpec) {
                ExSpec childSpec = (ExSpec)child;
                if (childSpec.getType() == 4) {
                    List<Reaction> reacs = md.getReactions().getActiveReactions();
                    if (reacs.isEmpty()) {
                        return true;
                    }
                    if (reacs.iterator().next().getReacType().equals((Object)Reaction.ReacType.SIMPLE)) {
                        return false;
                    }
                }
                return true;
            }
            return super.canDelete(md, obj, child);
        }
    }

    public static class DevcEP
    extends TVEntryPoint<IDevice> {
        public DevcEP() {
            super(Intl.intl("Device"));
        }

        @Override
        public Icon[] getIcons(PyroMod md, IDevice obj) {
            return obj.getIcons();
        }
    }

    public static class DevcMgrEP
    extends CompositeEP<DeviceManager> {
        public static final ImageIcon ICON_DEVICE = PyroGuiUtil.loadPyroSimIcon("sprk3.gif");

        public DevcMgrEP() {
            super(ICON_DEVICE);
        }

        @Override
        public Object getConflict(PyroMod md, DeviceManager categoryRoot, Object child) {
            if (Clock.isClock((IPyroObject)child)) {
                return Clock.INSTANCE;
            }
            return super.getConflict(md, categoryRoot, child);
        }
    }

    public static class AppearanceEP
    extends TVEntryPoint<Material> {
        public AppearanceEP() {
            super(Intl.intl("Appearance"));
        }

        @Override
        public Icon[] getIcons(PyroMod md, Material obj) {
            int options = 3;
            return PyroGuiUtil.getIcons(obj, -1, 16, options, guiUtil.ImageFilter.NORMAL, guiUtil.ImageFilter.DISABLED);
        }
    }

    public static class AppearanceDBEP
    extends CompositeEP<MaterialDB> {
        public AppearanceDBEP() {
            super((ImageIcon)null);
        }

        @Override
        public Object getConflict(PyroMod md, MaterialDB categoryRoot, Object child) {
            if (!(child instanceof Material)) {
                return null;
            }
            for (Material appearance : categoryRoot.flatten()) {
                if (!appearance.pseudoEquals((Material)child)) continue;
                return appearance;
            }
            return null;
        }

        @Override
        public boolean isEquivalent(PyroMod md, MaterialDB categoryRoot, Object existing, Object incoming) {
            assert (((Material)existing).pseudoEquals((Material)incoming));
            return true;
        }
    }

    public static class SurfaceEP
    extends TVEntryPoint<Surface> {
        public static final ImageIcon DEF_ICON = PyroGuiUtil.loadPyroSimIcon("surf2a.gif");

        public SurfaceEP() {
            super(Intl.intl("Surface"));
        }

        @Override
        public Font getBaseFont(PyroMod md, Surface obj) {
            if (obj == md.getSimParams().getMisc().getSurfDefault()) {
                return s_bold;
            }
            return super.getBaseFont(md, obj);
        }

        @Override
        public boolean canRename(PyroMod md, Surface obj) {
            return !obj.isPredefined();
        }

        @Override
        public Icon[] getIcons(PyroMod md, Surface obj) {
            return obj.getIcons(DEF_ICON.getIconWidth(), DEF_ICON.getIconHeight());
        }
    }

    public static class SurfaceMgrEP
    extends CompositeEP<SurfaceManager> {
        public static final ImageIcon ICON_SURFDB = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("surf2a.gif"));

        public SurfaceMgrEP() {
            super(ICON_SURFDB);
        }

        @Override
        public boolean canDelete(PyroMod md, SurfaceManager obj, Object child) {
            return !(child instanceof Surface) || !((Surface)child).isPredefined();
        }
    }

    public static class HvacDuctEP
    extends TVEntryPoint<HvacDuct> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("hvac_duct16.png");

        public HvacDuctEP() {
            super(ICON, Intl.intl("HVAC Duct"));
        }

        @Override
        public Object getCategoryRoot(PyroMod md, HvacNode obj) {
            return md.getObstructions();
        }
    }

    public static class HvacNodeEP
    extends TVEntryPoint<HvacNode> {
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("hvac_node16.png");

        public HvacNodeEP() {
            super(ICON, Intl.intl("HVAC Node"));
        }

        @Override
        public Object getCategoryRoot(PyroMod md, HvacNode obj) {
            return md.getObstructions();
        }
    }

    public static class HvacDuctLossEP
    extends TVEntryPoint<HvacDuctLoss> {
        public HvacDuctLossEP() {
            super(Intl.intl("HVAC Duct Loss"));
        }

        @Override
        public String getName(HvacDuctLoss obj) {
            return String.format(Intl.intl("Duct Loss: Node=%s: %s -> %s (%s : %s)"), obj.node.getName(), obj.duct1.getName(), obj.duct2.getName(), Global.format(obj.fwdLoss), Global.format(obj.revLoss));
        }
    }

    public static class LeakEP
    extends TVEntryPoint<Leak> {
        public LeakEP() {
            super(Intl.intl("Zone Leak"));
        }

        @Override
        public String getName(Leak obj) {
            return String.format(Intl.intl("Leak: %s -> %s (%s)"), obj.zone1.getName(), obj.zone2.getName(), Global.format(obj.area));
        }
    }

    public static class IsofEP
    extends TVEntryPoint<Isosurface> {
        public IsofEP() {
            super(Intl.intl("Isosurface"));
        }

        @Override
        public String getName(Isosurface obj) {
            return obj.getQuantity().getDescription();
        }
    }

    public static class IsofMgrEP
    extends CompositeEP<IsosurfaceMgr> {
        public IsofMgrEP() {
            super((ImageIcon)null);
        }

        @Override
        public Object getConflict(PyroMod md, IsosurfaceMgr categoryRoot, Object child) {
            for (Isosurface existing : md.getIsofList().flatten()) {
                if (!existing.equals(child)) continue;
                return existing;
            }
            return null;
        }
    }

    public static class MatlEP
    extends TVEntryPoint<pyrosim.domain.boundcond.mat.Material> {
        public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("surf.png");

        public MatlEP() {
            super(ICON, Intl.intl("Material"));
        }
    }

    public static class MatlMgrEP
    extends CompositeEP<MaterialManager> {
        public static final ImageIcon ICON_MATLDB = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("surf.png"));

        public MatlMgrEP() {
            super(ICON_MATLDB);
        }
    }

    public static class Plot3dEP
    extends TVEntryPoint<Plot3d> {
        public Plot3dEP() {
            super(Intl.intl("Plot3d Output"));
        }

        @Override
        public String getName(Plot3d obj) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod md, Plot3d obj) {
            return md.getPlot3d() == obj;
        }

        @Override
        public Object getCategoryRoot(PyroMod md, Plot3d obj) {
            return md;
        }

        public Task paste(final PyroMod md, Composite<? extends IPyroObject> location, final Plot3d newObj, final Plot3d existingObj, TVEntryPoint.ConflictResolution cr) {
            return new AUndoableTask(){

                @Override
                public void run() {
                    md.setPL3DRecord(newObj);
                }

                @Override
                public void undo() {
                    md.setPL3DRecord(existingObj);
                }
            };
        }
    }

    public static class SimParamsEP
    extends TVEntryPoint<SimParams> {
        public SimParamsEP() {
            super(Intl.intl("Simulation Parameters"));
        }

        @Override
        public String getName(SimParams obj) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod md, SimParams obj) {
            return md.getSimParams() == obj;
        }

        @Override
        public Object getCategoryRoot(PyroMod md, SimParams obj) {
            return md;
        }

        public Task paste(final PyroMod md, Composite<? extends IPyroObject> location, final SimParams newObj, final SimParams existingObj, TVEntryPoint.ConflictResolution cr) {
            return new AUndoableTask(){

                @Override
                public void run() {
                    md.setSimParams(newObj);
                }

                @Override
                public void undo() {
                    md.setSimParams(existingObj);
                }
            };
        }
    }

    public static class BoundaryEP
    extends TVEntryPoint<Boundaries> {
        public BoundaryEP() {
            super(Intl.intl("Boundary Quantities"));
        }

        @Override
        public String getName(Boundaries obj) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod md, Boundaries obj) {
            return md.getBoundaryOutput() == obj;
        }

        @Override
        public Object getCategoryRoot(PyroMod md, Boundaries obj) {
            return md;
        }

        @Override
        public boolean canMerge(PyroMod md, Boundaries obj) {
            return true;
        }

        @Override
        public Boundaries mergeToRoot(PyroMod md, Boundaries obj) {
            return Boundaries.mergeBoundaries(obj, md.getBoundaryOutput());
        }

        public Task paste(final PyroMod md, Composite<? extends IPyroObject> location, final Boundaries newObj, final Boundaries existingObj, TVEntryPoint.ConflictResolution cr) {
            return new AUndoableTask(){

                @Override
                public void run() {
                    md.setBoundaries(newObj);
                }

                @Override
                public void undo() {
                    md.setBoundaries(existingObj);
                }
            };
        }
    }

    public static class ReacEP
    extends TVEntryPoint<Reaction> {
        private static ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("reaction16.gif");

        public ReacEP() {
            super(ICON, Intl.intl("Reaction"));
        }

        @Override
        public Font getBaseFont(PyroMod md, Reaction obj) {
            if (obj.isActive()) {
                return s_bold;
            }
            return super.getBaseFont(md, obj);
        }

        @Override
        public String getDisplayName(Reaction obj) {
            String name = super.getDisplayName(obj);
            if (obj.isActive()) {
                name = String.format(Intl.intl("%s (Active)"), name);
            }
            return name;
        }
    }

    public static class ReacMgrEP
    extends CompositeEP<ReactionList> {
        public static final ImageIcon ICON_REACT = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("reaction16.gif"));

        public ReacMgrEP() {
            super(ICON_REACT);
        }
    }

    public static class RootEP
    extends TVEntryPoint<PyroMod> {
        public RootEP() {
            super(Intl.intl("PyroSim Model"));
        }

        @Override
        public String getName(PyroMod obj) {
            return "";
        }

        @Override
        public boolean objectInModel(PyroMod md, PyroMod obj) {
            return obj == md;
        }

        @Override
        public boolean isLeaf(PyroMod md, PyroMod obj) {
            return false;
        }

        @Override
        public Collection<?> getTreeviewChildren(PyroMod md, PyroMod obj) {
            return Arrays.asList(obj.getViews(), obj.getGridManager(), obj.getZoneMgr(), obj.getExSpecList(), obj.getReactions(), obj.getPartList(), obj.getMaterialMgr(), obj.getSurfaceMgr(), obj.getDevices(), obj.getControls(), RESULTS_NODE, obj.getHvacList(), obj.getObstructions());
        }

        @Override
        public boolean isContainer(PyroMod md, PyroMod obj, Object child) {
            if (!(child instanceof IPyroObject)) {
                return false;
            }
            for (IPyroObject iPyroObject : obj.getMembers()) {
                if (!iPyroObject.getClass().isInstance(child)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getConflict(PyroMod md, PyroMod categoryRoot, Object child) {
            if (child instanceof Plot3d) {
                return md.getPlot3d();
            }
            if (child instanceof SimParams) {
                return md.getSimParams();
            }
            if (child instanceof Boundaries) {
                return md.getBoundaryOutput();
            }
            return null;
        }

        @Override
        public Task paste(final PyroMod md, PyroMod pasteLoc, Object newObj, Object existingObj, TVEntryPoint.ConflictResolution cr, DepSnapshot deps) {
            assert (cr == TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING);
            if (newObj instanceof Plot3d) {
                return new AReplaceRefTask<Plot3d>(existingObj, newObj){

                    @Override
                    protected void set(Plot3d obj) {
                        md.setPL3DRecord(obj);
                    }
                };
            }
            if (newObj instanceof SimParams) {
                return new AReplaceRefTask<SimParams>(existingObj, newObj){

                    @Override
                    protected void set(SimParams obj) {
                        md.setSimParams(obj);
                    }
                };
            }
            if (newObj instanceof Boundaries) {
                return new AReplaceRefTask<Boundaries>(existingObj, newObj){

                    @Override
                    protected void set(Boundaries obj) {
                        md.setBoundaries(obj);
                    }
                };
            }
            return super.paste(md, pasteLoc, newObj, existingObj, cr, deps);
        }
    }
}

