/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools.popupmenu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.constraint.ConstantConstraintGen;
import pyrosim.mv.tools.constraint.IConstraintGen;
import pyrosim.mv.tools.popupmenu.IPopupMenuBuilder;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SnapConstraintMenuBuilder
implements IPopupMenuBuilder {
    public final List<Pair<Object, IConstraintGen>> d_constraints;

    public SnapConstraintMenuBuilder(Pair<Object, IConstraintGen> ... constraints) {
        this.d_constraints = Arrays.asList(constraints);
    }

    public SnapConstraintMenuBuilder(Collection<Pair<Object, IConstraintGen>> constraints) {
        this.d_constraints = new ArrayList<Pair<Object, IConstraintGen>>(constraints);
    }

    public SnapConstraintMenuBuilder(Object ... args) {
        this.d_constraints = new ArrayList<Pair<Object, IConstraintGen>>(args.length / 2);
        int m = 0;
        while (m < args.length) {
            Object name = null;
            IConstraintGen constraint = null;
            for (int n = 0; n < 2 && n + m < args.length; ++n) {
                Object arg = args[m + n];
                if (arg instanceof IConstraintGen) {
                    constraint = (IConstraintGen)arg;
                    continue;
                }
                if (arg instanceof ISnapConstraint) {
                    constraint = new ConstantConstraintGen((ISnapConstraint)arg);
                    continue;
                }
                name = arg;
            }
            if (name == null || constraint == null) continue;
            this.d_constraints.add(new Pair<Object, Object>(name, constraint));
        }
    }

    @Override
    public void buildMenu(IPyroTool tool, MenuBuilder menuBuilder) {
        ArrayList<ConstraintAction> actions = new ArrayList<ConstraintAction>(this.d_constraints.size());
        for (Pair<Object, IConstraintGen> constraint : this.d_constraints) {
            actions.add(new ConstraintAction(tool, constraint.v1.toString(), (IConstraintGen)constraint.v2));
        }
        menuBuilder.addMutuallyExclusive(actions);
    }

    public boolean toggleCurrentConstraint(IPyroTool tool) {
        IConstraintGen currConstraint = tool.getConstraintGen();
        for (int m = 0; m < this.d_constraints.size(); ++m) {
            if (!currConstraint.equals(this.d_constraints.get((int)m).v2)) continue;
            currConstraint = (IConstraintGen)this.d_constraints.get((int)((m + 1) % this.d_constraints.size())).v2;
            tool.setConstraintGen(currConstraint);
            tool.repaintSurface();
            return true;
        }
        return false;
    }

    protected static class ConstraintAction
    extends BooleanAction {
        private static final long serialVersionUID = -7014485830040692107L;
        private final IPyroTool d_tool;
        private final IConstraintGen d_constraint;

        public ConstraintAction(IPyroTool tool, String name, IConstraintGen constraint) {
            super(name, theUtil.equal(tool.getConstraintGen(), constraint));
            this.d_tool = tool;
            this.d_constraint = constraint;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                this.d_tool.setConstraintGen(this.d_constraint);
                this.d_tool.repaintSurface();
            }
        }
    }
}

