/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.mv.ModelView;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.tools.ATransformTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.GeomUtil;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.format.DoubleListFormat;
import thunderheadeng.gui.format.UDListFormat;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.theUtil;

public class RotateTool
extends ATransformTool
implements ValueEditor.IListener {
    private RotInfo d_rotation = null;

    public RotateTool(ModelView mv, TransformMgr xformMgr, ModelScene toolScene, DrawProps props) {
        super(mv, xformMgr, toolScene, props);
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
        editor.addChoice(Value.BASE.name(), new ValueEditor.Choice(Intl.intl("Rotate Center (x,y,z)"), new guiFormattedFld<Object>(new UDListFormat(UnitSystem.getSource(0), 3, 3), null)));
        editor.addChoice(Value.REF_VECTOR.name(), new ValueEditor.Choice(Intl.intl("Reference Direction (x,y,z)"), new guiFormattedFld<Object>(new DoubleListFormat(3, 3), null)));
        editor.addChoice(Value.ANGLE.name(), new ValueEditor.Choice(Intl.intl("Angle"), new guiFormattedFld<Object>(new UnitDoubleFormat(new ConstantUnitSrc(NonSI.DEGREE_ANGLE)), null)));
    }

    @Override
    public void activate() {
        super.activate();
        this.reset();
    }

    @Override
    public Point3d getAngledSnapBasis() {
        if (this.getRotation().baseCommitted) {
            return this.getRotation().base;
        }
        return null;
    }

    protected RotInfo getRotation() {
        if (this.d_rotation == null) {
            this.d_rotation = new RotInfo();
        }
        return this.d_rotation;
    }

    @Override
    public void reset() {
        this.d_rotation = null;
        super.reset();
    }

    @Override
    public void valueEditorChanged(ValueEditor editor, boolean commit) {
        RotInfo ri = this.getRotation();
        Value val = Value.valueOf(editor.getCurrentValueType());
        switch (val) {
            case BASE: {
                UnitDouble[] coords = (UnitDouble[])editor.getValue();
                if (coords.length < 3) break;
                Point3d p = new UnitPoint3D(coords).getPoint3dValue(Geometry.LU);
                try {
                    p = this.constrain(this.getSnapConstraint(), p);
                    this.setBase(ri, p, commit);
                }
                catch (CursorTool.ConstraintException constraintException) {}
                break;
            }
            case REF_VECTOR: {
                Point3d p2;
                double[] coords = (double[])editor.getValue();
                if (coords.length < 3) break;
                Vector3d vec = new Vector3d(coords);
                Plane3d plane = this.getWorkingPlane();
                Point3d p1 = plane.projectOntoPlane(new Point3d(0.0, 0.0, 0.0));
                vec = Util3D.vector(p1, p2 = plane.projectOntoPlane(new Point3d(vec.x, vec.y, vec.z)));
                double len = vec.length();
                if (!theUtil.eq0(len, 1.0E-6)) {
                    vec.scale(1.0 / len);
                    this.setV1(ri, vec, commit);
                    break;
                }
                this.setV1(ri, null, false);
                break;
            }
            case ANGLE: {
                UnitDouble angle = (UnitDouble)editor.getValue();
                this.setAngle(ri, angle.getValue(Geometry.AU), commit);
                break;
            }
        }
        this.updateEditorState(false);
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        RotInfo ri = this.getRotation();
        if (!ri.baseCommitted) {
            this.setBase(ri, this.getBase(ri, p), p.committed);
        } else if (!ri.v1Committed) {
            this.setV1(ri, this.getV1(ri, p), p.committed);
        } else if (!ri.angleCommitted) {
            this.setAngle(ri, this.getAngle(ri, p), p.committed);
        }
    }

    private Point3d getBase(RotInfo ri, MouseHistory.Point p) {
        return p.p;
    }

    private Vector3d getV1(RotInfo ri, MouseHistory.Point p) {
        if (p.p.equals(ri.base)) {
            return null;
        }
        return Util3D.vectorN(ri.base, p.p);
    }

    private double getAngle(RotInfo ri, MouseHistory.Point p) {
        Vector3d v2 = Util3D.vector(ri.base, p.p);
        double len = v2.length();
        if (!theUtil.eq0(len, 1.0E-6)) {
            Vector3d axis = this.getWorkingPlane().getNormal();
            v2.scale(1.0 / len);
            double angle = Util3D.angle(ri.v1, v2, axis);
            IDOF dof = this.getXformMgr().getDOF();
            if (dof == IDOF.NONE) {
                return Double.NaN;
            }
            double snappedAngle = RotateTool.snapAngle(angle, dof);
            if (snappedAngle != angle) {
                angle = snappedAngle;
                Matrix4d rot = Util.rotMat(axis.x, axis.y, axis.z, angle);
                v2 = new Vector3d(ri.v1);
                rot.transform(v2);
            }
            if (theUtil.eq(angle, Math.PI, 1.0E-9)) {
                angle = Math.PI;
            }
            return angle;
        }
        return Double.NaN;
    }

    private static double snapAngle(double angle, IDOF dof) {
        if (!GeomUtil.isAligned(dof)) {
            return angle;
        }
        double mul = angle / 1.5707963267948966;
        mul = Math.round(mul);
        return mul * Math.PI * 0.5;
    }

    private void setBase(RotInfo ri, Point3d base, boolean commit) {
        ri.base = base;
        ri.baseCommitted = commit && base != null;
        this.update(ri);
    }

    private void setV1(RotInfo ri, Vector3d v1, boolean commit) {
        ri.v1 = v1;
        ri.v1Committed = commit && v1 != null;
        this.update(ri);
    }

    private void setAngle(RotInfo ri, double angle, boolean commit) {
        ri.angle = angle;
        ri.angleCommitted = commit && !Double.isNaN(angle);
        this.update(ri);
    }

    @Override
    protected void updateEditorState(boolean fromMouseEvent) {
        RotInfo ri = this.getRotation();
        if (!ri.baseCommitted) {
            this.getValueEditor().setValueType(Value.BASE.name());
            if (fromMouseEvent && ri.base != null) {
                UnitPoint3D p3d = new UnitPoint3D(ri.base, Geometry.LU);
                UnitDouble[] coords = new UnitDouble[]{p3d.xu(), p3d.yu(), p3d.zu()};
                this.getValueEditor().setValue(coords);
            }
        } else if (!ri.v1Committed) {
            this.getValueEditor().setValueType(Value.REF_VECTOR.name());
            if (fromMouseEvent && ri.v1 != null) {
                double[] coords = new double[]{ri.v1.x, ri.v1.y, ri.v1.z};
                this.getValueEditor().setValue(coords);
            }
        } else if (!ri.angleCommitted) {
            this.getValueEditor().setValueType(Value.ANGLE.name());
            if (fromMouseEvent && !Double.isNaN(ri.angle)) {
                this.getValueEditor().setValue(new UnitDouble(ri.angle, Geometry.AU));
            }
        }
    }

    private void update(RotInfo ri) {
        ITransform rotMat;
        Plane3d plane = this.getWorkingPlane();
        Vector3d axis = plane != null ? plane.getNormal() : null;
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        PropsBuilder props = new PropsBuilder();
        if (!Double.isNaN(ri.angle)) {
            assert (axis != null);
            View view = this.getView();
            double angleRadius = view.screenToWorld(25.0, ri.base);
            Vector3d localX = ri.v1;
            Vector3d localZ = axis;
            Vector3d localY = Util3D.cross(localZ, localX);
            Matrix4d xform = Util.translateMat(ri.base.x, ri.base.y, ri.base.z);
            Matrix4d arcXform = new Matrix4d(localX.x, localY.x, localZ.x, 0.0, localX.y, localY.y, localZ.y, 0.0, localX.z, localY.z, localZ.z, 0.0, 0.0, 0.0, 0.0, 1.0);
            xform.mul(arcXform);
            Arc2D.Double arc = ShapeUtil.newCircularArc(0.0, 0.0, angleRadius, 0.0, ri.angle, ri.angle >= 0.0);
            ShapeGeom geom = new ShapeGeom((Shape)arc, xform);
            geoms.add(geom);
            props.add(new IPrimProps.Edge(Color.BLUE, 2.0, IPrimProps.DEF_STIPPLE, 0));
            Point3d v2p1 = ri.base;
            Vector3d v2 = new Vector3d(ri.v1);
            Matrix4d rotXform = Util.rotMat(axis.x, axis.y, axis.z, ri.angle);
            rotXform.transform(v2);
            Point3d v2p2 = this.projectToFrustum(ri.base, v2);
            geoms.add(new LineSeg(v2p1, v2p2));
            props.add(new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0));
        }
        if (ri.v1 != null) {
            Point3d v1p1 = ri.base;
            Point3d v1p2 = this.projectToFrustum(ri.base, ri.v1);
            geoms.add(new LineSeg(v1p1, v1p2));
            props.add(new IPrimProps.Edge(Color.RED, 3.0, IPrimProps.DEF_STIPPLE, 0));
        }
        if (ri.base != null) {
            geoms.add(new Point(ri.base));
            props.add(new IPrimProps.Vertex(Color.RED, 10.0));
        }
        this.updateToolDisplay(GeomNodeUtil.newNode(new GeomGroup(geoms)), props.finalizeProps());
        ITransform newXform = TransformUtil.IDENTITY;
        if (!Double.isNaN(ri.angle) && (rotMat = TransformUtil.rotate(axis.x, axis.y, axis.z, ri.angle)).getInfo().isAccepted(this.getXformMgr().getDOF())) {
            ITransform xform = TransformUtil.translate(ri.base.x, ri.base.y, ri.base.z);
            xform = xform.concatenate(rotMat);
            xform = xform.concatenate(TransformUtil.translate(-ri.base.x, -ri.base.y, -ri.base.z));
            newXform = xform;
        }
        this.getXformMgr().modify(newXform);
        if (ri.angleCommitted) {
            this.finish();
        }
        this.repaintSurface();
    }

    @Override
    protected Plane3d getWorkingPlane() {
        RotInfo ri = this.getRotation();
        if (this.getView().getCamera() instanceof PerspectiveCamera && ri.baseCommitted) {
            return new Plane3d(new Vector3d(0.0, 0.0, 1.0), ri.base);
        }
        return super.getWorkingPlane();
    }

    private static class RotInfo {
        public Point3d base = null;
        public boolean baseCommitted = false;
        public Vector3d v1 = null;
        public boolean v1Committed = false;
        public double angle = Double.NaN;
        public boolean angleCommitted = false;

        private RotInfo() {
        }
    }

    private static enum Value {
        BASE,
        REF_VECTOR,
        ANGLE;

    }
}

