/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.gui.MenuBuilder;
import pyrosim.mv.ModelView;
import pyrosim.mv.PyroDrawProps;
import pyrosim.mv.PyroNativeProps;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.snappers.ModelGridSnapper;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.util.theUtil;

public abstract class ATransformTool
extends APyroTool {
    private final TransformMgr d_xformMgr;
    private final ModelScene d_toolScene;
    private final GeomDisplay d_geomDisp;

    public ATransformTool(ModelView mv, TransformMgr xformMgr, ModelScene toolScene, DrawProps props) {
        super((IToolController)mv, props);
        this.d_xformMgr = xformMgr;
        this.d_toolScene = toolScene;
        this.d_geomDisp = new GeomDisplay(new PyroDrawProps(new PyroNativeProps(), () -> null), new GenericGeomSrc("", DisplayGeom.EMPTY.node, DisplayGeom.EMPTY.props));
        this.setSnapInfo(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(){

            @Override
            public boolean acceptPickObject(Object obj) {
                if (ATransformTool.this.d_xformMgr.getCopyMode()) {
                    return true;
                }
                if (ATransformTool.this.d_xformMgr.isTransforming()) {
                    if (obj instanceof ModelGridSnapper) {
                        obj = ((ModelGridSnapper)obj).getGrid();
                    }
                    return !ATransformTool.this.d_xformMgr.getDomain().getSelectionModel().isSelected(obj);
                }
                return true;
            }
        });
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool tool) {
                ATransformTool.this.d_xformMgr.setCopyMode(!ATransformTool.this.d_xformMgr.getCopyMode());
                ATransformTool.this.repaintSurface();
            }
        });
    }

    public TransformMgr getXformMgr() {
        return this.d_xformMgr;
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return this.getClickHistory().getLastCommitted();
    }

    protected void updateToolDisplay(IGeomNode geom, IPropsSrc props) {
        GenericGeomSrc src = (GenericGeomSrc)this.d_geomDisp.getSource();
        src.setGeom(geom.bakeIfRecommended());
        src.setDisplayProps(props);
        this.d_geomDisp.update();
        this.repaintSurface();
    }

    @Override
    protected void addContextMenuActions(MenuBuilder builder) {
        builder.addSeparator();
        builder.addMutuallyExclusive(new ModeAction(false), new ModeAction(true));
        builder.addSeparator();
        super.addContextMenuActions(builder);
    }

    @Override
    public void reset() {
        super.reset();
        this.updateToolDisplay(DisplayGeom.EMPTY.node, DisplayGeom.EMPTY.props);
    }

    @Override
    public void activate() {
        this.pauseRepaint();
        super.activate();
        this.d_toolScene.addObjects(this.d_geomDisp);
        this.resumeRepaint(true);
    }

    @Override
    public void deactivate() {
        this.pauseRepaint();
        this.d_toolScene.removeObjects(this.d_geomDisp);
        super.deactivate();
        this.resumeRepaint(true);
    }

    @Override
    public void finish() {
        this.pauseRepaint();
        if (this.d_xformMgr.isTransforming()) {
            this.d_xformMgr.end(true);
        }
        this.reset();
        super.finish();
        this.resumeRepaint();
    }

    @Override
    public void cancel() {
        this.pauseRepaint();
        if (this.d_xformMgr.isTransforming()) {
            this.d_xformMgr.end(false);
        }
        this.reset();
        super.cancel();
        this.resumeRepaint();
    }

    protected Point3d projectToFrustum(Point3d p1, Vector3d dir) {
        View v = this.getView();
        Box3d frustum = v.getFrustum();
        double mint = 1.0E20;
        for (int m = 0; m < 6; ++m) {
            double t = Inter3D.linePlaneIntersectionT(p1, dir, frustum.getPlanes()[m], 1.0E-6);
            if (Double.isNaN(t) || theUtil.le0(t, 1.0E-6) || !(t < mint)) continue;
            mint = t;
        }
        return Util3D.linePoint(p1, dir, mint);
    }

    @Override
    protected String getStatusMessage() {
        String mode = this.d_xformMgr.getCopyMode() ? "[" + Intl.intl("Copy Mode") + "] " : "[" + Intl.intl("Move Mode") + "] ";
        mode = mode + Intl.intl("Press CTRL to change mode ");
        String status = this.getValueEditor().getStatusMessage();
        if (status.startsWith("<html>&lt;")) {
            mode = "<html>" + mode;
            status = status.substring(6);
        }
        return mode + status;
    }

    protected class ModeAction
    extends BooleanAction {
        private static final long serialVersionUID = -2264843991704589282L;
        private final boolean d_copyMode;

        public ModeAction(boolean copyMode) {
            super(copyMode ? Intl.intl("Copy Mode") : Intl.intl("Move Mode"), copyMode == ATransformTool.this.d_xformMgr.getCopyMode());
            this.d_copyMode = copyMode;
        }

        @Override
        protected void stateChanged() {
            ATransformTool.this.d_xformMgr.setCopyMode(this.d_copyMode);
        }
    }
}

