/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theObservable;

public class DisplayFilter
extends theObservable {
    private final Map<Class<?>, Predicate<?>> d_filters = new HashMap();
    private final Map<Class<?>, Predicate<?>[]> d_cachedFilters = new HashMap();

    public void changed(Class type) {
        this.clearCache();
        this.setChanged();
        this.tryFireNotification(type);
    }

    public <T> void registerFilter(Class<T> clazz, Predicate<? super T> filter) {
        assert (filter != null) : "Filter must not be null. To remove a filter, use the method, removeFilter.";
        Predicate<? super T> oldFilter = this.d_filters.put(clazz, filter);
        if (!filter.equals(oldFilter)) {
            this.changed(clazz);
        }
    }

    public <T> void filterAllOfType(Class<T> type) {
        this.registerFilter(type, Filters.rejectAll(type));
    }

    public <T> void removeFilter(Class<T> clazz) {
        Predicate<?> existing = this.d_filters.remove(clazz);
        if (existing != null) {
            this.changed(clazz);
        }
    }

    public <T> boolean isFilteringAllOf(Class<T> type) {
        Predicate[] filters;
        for (Predicate filter : filters = this.getHierarchyFilters(type)) {
            if (filter != Predicates.alwaysFalse()) continue;
            return true;
        }
        return false;
    }

    private void clearCache() {
        this.d_cachedFilters.clear();
    }

    public boolean filter(Object obj) {
        return this.filter(obj, obj.getClass());
    }

    private boolean filter(Object obj, Class level) {
        Predicate[] filters;
        for (Predicate filter : filters = this.getHierarchyFilters(level)) {
            if (filter.test(obj)) continue;
            return true;
        }
        return false;
    }

    private Predicate[] getHierarchyFilters(Class clazz) {
        Predicate[] filters = this.d_cachedFilters.get(clazz);
        if (filters == null) {
            ArrayList<Predicate> flist = new ArrayList<Predicate>();
            this.getHierarchyFilters(clazz, flist);
            filters = flist.toArray(new Predicate[flist.size()]);
            this.d_cachedFilters.put(clazz, filters);
        }
        return filters;
    }

    private void getHierarchyFilters(Class clazz, List<Predicate> filters) {
        Class superClass;
        Predicate<?> filter = this.d_filters.get(clazz);
        if (filter != null) {
            filters.add(filter);
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            this.getHierarchyFilters(superClass, filters);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            this.getHierarchyFilters(iface, filters);
        }
    }
}

