/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.util;

import java.awt.geom.Rectangle2D;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BGImageXform;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Sets;
import pyrosim.legacy_2012_1.thunderheadeng.util.TypeFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.treeview.TVEntryPoint;
import pyrosim.legacy_2012_1.treeview.TVEntryPoints;
import pyrosim.legacy_2012_1.util.NamedSorter;

public class Util {
    public static void removeAllNotOfType(Collection<?> objs, Class<?> type) {
        Iterator<?> it = objs.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next == null || type.isInstance(next)) continue;
            it.remove();
        }
    }

    public static void removeNonNull(Collection<?> objs) {
        Iterator<?> it = objs.iterator();
        while (it.hasNext()) {
            if (it.next() == null) continue;
            it.remove();
        }
    }

    public static BGImageXform createDxfImageTransform(Image img, Rectangle2D bounds, Unit boundsUnit, UnitDouble z) {
        int iwidth = img.getWidth();
        int iheight = img.getHeight();
        if (iwidth == 0) {
            iwidth = (int)bounds.getWidth();
        }
        if (iheight == 0) {
            iheight = (int)bounds.getHeight();
        }
        Point2d originImg = new Point2d(-bounds.getMinX() / bounds.getWidth() * (double)iwidth, -bounds.getMinY() / bounds.getHeight() * (double)iheight);
        return new BGImageXform(originImg, new Point3d(0.0, 0.0, z.getValue(SI.METER)), new Point2d(0.0, 0.0), new Point2d(iwidth, 0.0), UnitDouble.convert(bounds.getWidth(), boundsUnit, SI.METER), 0.0);
    }

    public static void assignFinalField(Object obj, String strField, Object val) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = obj.getClass().getField(strField);
        f.setAccessible(true);
        f.set(obj, val);
        f.setAccessible(false);
    }

    public static <T> Collection<T> filter(Collection<?> coll, Class<T> type) {
        if (coll instanceof Set) {
            return Util.filter((Set)coll, type);
        }
        return new FilteredCollection<T>(coll, type);
    }

    public static <T> Set<T> filter(Set<?> set, Class<T> type) {
        return new FilteredSet<T>(set, type);
    }

    public static <T> Collection<T> filter(Collection<?> coll, Class<T> type, IObjectFilter<T> filter) {
        if (coll instanceof Set) {
            return Util.filter((Set)coll, type, filter);
        }
        return new FilteredCollection<T>(coll, type, filter);
    }

    public static <T> Set<T> filter(Set<?> set, Class<T> type, IObjectFilter<T> filter) {
        return new FilteredSet<T>(set, type, filter);
    }

    public static <T extends IPyroObject> Collection<? extends T> getAllObjects(PyroMod domain, Class<T> type, IObjectFilter<T> filter, boolean includeImplicitObjs) {
        Collection<T> mixFracSpecs;
        Composite root = Util.getCategoryRoot(domain, type);
        if (root == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<T> objs = root.flatten(type, filter);
        if (includeImplicitObjs && ExSpec.class.isAssignableFrom(type) && !(mixFracSpecs = Util.filter(Arrays.asList(ExSpecList.MIXFRAC_EXSPECS), type, filter)).isEmpty()) {
            ArrayList<T> iobjs = new ArrayList<T>(objs);
            iobjs.addAll(mixFracSpecs);
            objs = iobjs;
        }
        return objs;
    }

    public static Composite getCategoryRoot(PyroMod domain, Class<? extends IPyroObject> type) {
        for (IPyroObject iPyroObject : domain.getMembers()) {
            if (!(iPyroObject instanceof Composite) || !((Composite)iPyroObject).getType().isAssignableFrom(type)) continue;
            return (Composite)iPyroObject;
        }
        return null;
    }

    public static String getCatName(IPyroObject obj) {
        return TVEntryPoints.ep(obj).getCategoryName();
    }

    public static String getName(IPyroObject obj) {
        TVEntryPoint<IPyroObject> ep = TVEntryPoints.ep(obj);
        return ep.getName(obj);
    }

    public static boolean canDelete(PyroMod md, Object o) {
        IPyroObject parent;
        if (o instanceof IPyroObject && (parent = ((IPyroObject)o).getParent()) != null) {
            return TVEntryPoints.ep(parent).canDelete(md, parent, o);
        }
        return false;
    }

    public static String validateName(PyroMod md, INamed obj, String name) throws Exception {
        Object existing;
        if ((name = name.trim()).isEmpty()) {
            throw new Exception(Intl.intl("Empty names are not allowed."));
        }
        if (obj.getName().equals(name)) {
            return name;
        }
        TVEntryPoint<INamed> ep = TVEntryPoints.ep(obj);
        Object catRoot = ep.getCategoryRoot(md, obj);
        if (catRoot instanceof Composite && Util.isKeyedByName(md, catRoot, obj) && (existing = ((Composite)catRoot).get(name)) != null) {
            String msg = String.format(Intl.intl("The name, \"%s,\" is already in use."), name);
            throw new Exception(msg);
        }
        return name;
    }

    public static boolean isKeyedByName(PyroMod md, Object o) {
        if (o instanceof Composite) {
            return false;
        }
        Object catRoot = TVEntryPoints.ep(o).getCategoryRoot(md, o);
        return catRoot != null && TVEntryPoints.ep(catRoot).keysMembersByName(md, catRoot);
    }

    public static boolean isKeyedByName(PyroMod md, Object catRoot, Object o) {
        if (o instanceof Composite) {
            return false;
        }
        return catRoot != null && TVEntryPoints.ep(catRoot).keysMembersByName(md, catRoot);
    }

    public static <T extends IPyroObject> List<T> sort(Composite<? extends T> group) {
        return Util.sort(group.flatten());
    }

    public static <T extends IPyroObject> List<T> sort(Collection<? extends T> objs) {
        ArrayList<? extends T> members = new ArrayList<T>(objs);
        Collections.sort(members, new NamedSorter());
        return members;
    }

    public static <T> List<T> sort(Collection<? extends T> objs, Comparator<T> sorter) {
        ArrayList<? extends T> members = new ArrayList<T>(objs);
        Collections.sort(members, sorter);
        return members;
    }

    public static <T> int indexOf(Collection<? extends T> objs, T obj) {
        int ix = 0;
        for (T o : objs) {
            if (o == obj) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public static <T> T[] matchPrimCount(IGeom geom, int primTypes, T[] vals, Class<T> type) {
        int numFaces = geom.getNumPrims(primTypes);
        if (vals.length == numFaces) {
            return vals;
        }
        assert (vals.length == 1);
        Object[] newVals = (Object[])Array.newInstance(type, numFaces);
        for (int m = 0; m < numFaces; ++m) {
            newVals[m] = vals[0];
        }
        return newVals;
    }

    public static boolean identityMapsEqual(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry1 : map1.entrySet()) {
            Object key2 = null;
            Object val2 = null;
            for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
                if (!entry1.getKey().equals(entry2.getKey())) continue;
                key2 = entry2.getKey();
                val2 = entry2.getValue();
                break;
            }
            if (key2 == null) {
                return false;
            }
            if (theUtil.equal(entry1.getValue(), val2)) continue;
            return false;
        }
        return true;
    }

    public static boolean identitySetsEqual(Set<?> map1, Set<?> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Object val1 : map1) {
            boolean found = false;
            for (Object val2 : map2) {
                if (!theUtil.equal(val1, val2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isExclusive(Collection<?> coll, Class<?> ... types) {
        if (types.length == 1) {
            return new FilteredCollection(coll, types[0]).isExclusive();
        }
        return new FilteredCollection<Object>(coll, Object.class, new TypeFilter(types)).isExclusive();
    }

    public static boolean isExclusive(Collection<?> coll, Class<?> type, IObjectFilter<?> filter) {
        return new FilteredCollection(coll, type, filter).isExclusive();
    }

    public static <T> Collection<T> filterExcluded(Collection<T> objs, Class<T> type, Set<?> toExclude) {
        ExcludeFilter filter = new ExcludeFilter(toExclude);
        return Util.filter(objs, type, filter);
    }

    public static class ExcludeFilter<T>
    implements IObjectFilter<T> {
        public final Set<?> toExclude;

        public ExcludeFilter(Object toExclude) {
            this(Sets.fromArrayHS(toExclude));
        }

        public ExcludeFilter(Set<?> toExclude) {
            this.toExclude = toExclude;
        }

        @Override
        public boolean shouldFilter(T o) {
            return this.toExclude.contains(o);
        }
    }
}

