/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.treeview;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.tasks.SetNameTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.treeview.TVEntryPoints;
import pyrosim.legacy_2012_1.util.Util;

public class TVEntryPoint<T> {
    protected static final Font s_plain = new Font("Sans Serif", 0, 11);
    protected static final Font s_bold = new Font("Sans Serif", 1, 11);
    protected static final Font s_italic = new Font("Sans Serif", 2, 11);
    protected static final Font s_italicBold = s_italic.deriveFont(1);
    private final Icon d_icon;
    private final String d_categoryName;

    public TVEntryPoint(String categoryName) {
        this(null, categoryName);
    }

    public TVEntryPoint(Icon icon, String categoryName) {
        this.d_icon = icon;
        this.d_categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.d_categoryName;
    }

    public String getName(T obj) {
        if (obj instanceof INamed) {
            return ((INamed)obj).getName();
        }
        return obj.toString();
    }

    public String getDisplayName(T obj) {
        return this.getName(obj);
    }

    public void setName(PyroMod md, T obj, String newText) {
        if (obj instanceof INamed) {
            try {
                newText = Util.validateName(md, (INamed)obj, newText);
                SetNameTask tsk = new SetNameTask((INamed)obj, newText);
                md.getTaskManager().exec(tsk, Intl.intl("Rename"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), e.getLocalizedMessage(), Intl.intl("Invalid Name"), 0);
            }
        }
    }

    public boolean objectInModel(PyroMod md, T obj) {
        if (!(obj instanceof IPyroObject)) {
            return false;
        }
        return ((IPyroObject)obj).getDomain() == md;
    }

    public Object getTreeviewParent(PyroMod md, T obj) {
        if (obj instanceof IPyroObject) {
            return ((IPyroObject)obj).getParent();
        }
        return null;
    }

    public boolean canRename(PyroMod md, T obj) {
        return obj instanceof INamed;
    }

    public Icon getIcon(PyroMod md, T obj) {
        return this.d_icon;
    }

    public Font getBaseFont(PyroMod md, T obj) {
        return s_plain;
    }

    public Font getFont(PyroMod md, T obj) {
        Font base = this.getBaseFont(md, obj);
        if (!this.isEnabled(md, obj)) {
            HashMap attribs = new HashMap(base.getAttributes());
            attribs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            base = base.deriveFont(attribs);
        }
        return base;
    }

    public boolean isVisible(PyroMod md, T obj) {
        if (obj instanceof IPyroGeomSrc) {
            return ((IPyroGeomSrc)obj).isVisible();
        }
        return true;
    }

    public boolean isEnabled(PyroMod md, T obj) {
        if (obj instanceof IPyroObject) {
            return ((IPyroObject)obj).isEnabled();
        }
        return true;
    }

    public boolean isLeaf(PyroMod md, T obj) {
        if (obj instanceof IPyroObject) {
            return ((IPyroObject)obj).getMembers().isEmpty();
        }
        return false;
    }

    public Object getPasteLocation(PyroMod md, T obj) {
        return this.getCategoryRoot(md, obj);
    }

    public boolean showInTree(PyroMod md, T obj) {
        T curr = obj;
        Object parent = this.getTreeviewParent(md, obj);
        if (parent != null) {
            TVEntryPoint<Object> parentep = TVEntryPoints.ep(parent);
            if (parent == md) {
                return parentep.getTreeviewChildren(md, parent).contains(curr);
            }
            return parentep.showInTree(md, parent);
        }
        return false;
    }

    public boolean mayBeReferenced(PyroMod md) {
        return true;
    }

    public Object getCategoryRoot(PyroMod md, T obj) {
        for (IPyroObject iPyroObject : md.getMembers()) {
            if (!TVEntryPoints.ep(iPyroObject).isContainer(md, iPyroObject, obj)) continue;
            return iPyroObject;
        }
        return null;
    }

    public Collection<?> getTreeviewChildren(PyroMod md, T obj) {
        if (obj instanceof IPyroObject) {
            return ((IPyroObject)obj).getMembers();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isContainer(PyroMod md, T obj, Object child) {
        return false;
    }

    public boolean keysMembersByName(PyroMod md, T obj) {
        return false;
    }

    public boolean canDelete(PyroMod md, T obj, Object child) {
        return false;
    }

    public boolean preserveIndexOnDelete(PyroMod md, T obj, Object child) {
        return true;
    }

    public Object getConflict(PyroMod md, T categoryRoot, Object child) {
        return null;
    }

    public Task paste(PyroMod md, T pasteLoc, Object newObj, Object existingObj, ConflictResolution cr, DepSnapshot deps) {
        return EmptyTask.INSTANCE;
    }

    public boolean canDrop(PyroMod md, T obj, Set<?> objs, Object commonParent) {
        return false;
    }

    public void drop(PyroMod md, T target, int insertPos, Collection<?> objs) {
    }

    public static enum ConflictResolution {
        OVERWRITE_EXISTING,
        RENAME_NEW;

    }
}

