/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Box3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSegRTreeTest;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.View;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.DefaultFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IPickConfig;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IPickRoot;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IPickable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IsectInfo;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.RayPointProx;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.TaskProgress;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class GeomPicker {
    private final IPickRoot d_geometry;
    private final View d_view;
    private boolean d_occlusionFilterEnabled;
    public static final IIsectFilter ACCEPT_ALL = new DefaultFilter(){

        @Override
        public boolean acceptGeomType(Object source, GeomType type) {
            return type != GeomType.VOLUME;
        }
    };

    public GeomPicker(IPickRoot geometry, View view) {
        this.d_geometry = geometry;
        this.d_view = view;
        this.d_occlusionFilterEnabled = true;
    }

    public void setOcclusionFilteringEnabled(boolean enabled) {
        this.d_occlusionFilterEnabled = enabled;
    }

    public boolean isOcclusionFilteringEnabled() {
        return this.d_occlusionFilterEnabled;
    }

    public IPickRoot getGeomSource() {
        return this.d_geometry;
    }

    @Deprecated
    public IsectInfo pickClosest(Mode searchMode, Point2d viewScr, double screenTol) {
        return this.pickClosest(searchMode, viewScr, screenTol, ACCEPT_ALL);
    }

    @Deprecated
    public IsectInfo pickClosest(Mode searchMode, Point2d viewScr, double screenTol, IIsectFilter filter) {
        try {
            Collection<IsectInfo> isects = this.pick(new TaskProgress(), searchMode, viewScr, screenTol, filter);
            Iterator<IsectInfo> it = isects.iterator();
            if (!it.hasNext()) {
                return null;
            }
            return it.next();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Collection<IsectInfo> pick(TaskProgress progress, Mode searchMode, Point2d viewScr, double screenTol) {
        return this.pick(progress, searchMode, viewScr, screenTol, ACCEPT_ALL);
    }

    public Collection<IsectInfo> pick(TaskProgress progress, Mode searchMode, Point2d viewScr, double screenTol, IIsectFilter filter) {
        filter = new VisibilityFilter(filter, this.d_geometry);
        LineSeg3D ray = this.getPickRay(viewScr);
        ArrayList<IsectInfo> allIsects = new ArrayList<IsectInfo>();
        for (IPickConfig pickConfig : this.d_geometry.getPickConfigs()) {
            IRayProxDetector proxDet;
            ITest<AABox> test;
            LineSeg3D clipRay = GeomPicker.trim(ray, pickConfig.getClippingRegion());
            if (clipRay == null) continue;
            if (screenTol > 0.0) {
                Box3d frustum = this.d_view.toFrustum(viewScr, screenTol);
                ConvexHull ch = GeomPicker.intersect(frustum, pickConfig.getClippingRegion());
                test = new CHTest(ch);
                proxDet = new RayTolProxDetector(this.d_view, viewScr, screenTol, clipRay, ch);
            } else {
                test = new LineSegRTreeTest(clipRay.p1, clipRay.p2);
                proxDet = new RayProxDetector(clipRay);
            }
            RaySearchResult result = new RaySearchResult(progress, searchMode, filter, clipRay, test, this.d_geometry, proxDet);
            this.d_geometry.find(pickConfig, test, result);
            allIsects.addAll(result.getIsects());
        }
        IsectSorter sorter = new IsectSorter(searchMode, this.d_geometry);
        Collections.sort(allIsects, sorter);
        AbstractCollection isects = !this.d_occlusionFilterEnabled ? allIsects : new FilteredCollection<IsectInfo>(allIsects, IsectInfo.class, new OcclusionFilter(progress), true);
        if (isects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return isects;
    }

    private static LineSeg3D trim(LineSeg3D ls, ConvexHull ch) {
        if (ch.acceptsAll()) {
            return ls;
        }
        if (ch.acceptsNone()) {
            return null;
        }
        LineSeg line = new LineSeg(ls.p1, ls.p2);
        Vector3d lineDir = ls.getDir();
        int numTs = 0;
        double[] ts = new double[]{Double.NaN, Double.NaN};
        if (ch.contains(ls.p1, 1.0E-9)) {
            ts[numTs++] = 0.0;
        }
        if (ch.contains(ls.p2, 1.0E-9)) {
            ts[numTs++] = 1.0;
        }
        if (numTs < 2) {
            for (Plane3d plane : ch.getPlanes()) {
                double t = Inter3D.linePlaneIntersectionT(ls.p1, lineDir, plane, 1.0E-9);
                if (Double.isNaN(t) || !theUtil.ge0(t, 1.0E-9) || !theUtil.le(t, 1.0, 1.0E-9) || !ch.contains(line.evaluate(t), 1.0E-9)) continue;
                ts[numTs++] = t;
                if (numTs == 2) break;
            }
        }
        if (numTs == 0) {
            return null;
        }
        if (numTs == 1) {
            System.err.println("0x223459f: Could not trim pick ray to clip region.");
            return ls;
        }
        Arrays.sort(ts);
        return new LineSeg3D(line.evaluate(ts[0]), line.evaluate(ts[1]));
    }

    private static ConvexHull intersect(Box3d box, ConvexHull ch) {
        return box.toConvexHull().intersect(ch, true);
    }

    public Collection<Object> pickBox(Point2d viewScr1, Point2d viewScr2) {
        return this.pickBox(viewScr1, viewScr2, ACCEPT_ALL);
    }

    public Collection<Object> pickBox(Point2d viewScr1, Point2d viewScr2, IIsectFilter filter) {
        filter = new VisibilityFilter(filter, this.d_geometry);
        Box3d frustum = this.d_view.toFrustum(viewScr1, viewScr2);
        IPickConfig[] configs = this.d_geometry.getPickConfigs();
        ArrayList<Object> allObjs = configs.length == 1 ? new ArrayList() : new IdentityHashSet();
        for (IPickConfig config : configs) {
            ConvexHull ch = GeomPicker.intersect(frustum, config.getClippingRegion());
            BoxSearchResult result = new BoxSearchResult(filter, ch, this.d_geometry);
            this.d_geometry.find(config, new CHTest(ch), result);
            allObjs.addAll(result.d_objs);
        }
        return allObjs;
    }

    private LineSeg3D getPickRay(Point2d viewScr) {
        Point3d rayBegin = this.d_view.screenToWorld(new Point3d(viewScr.x, viewScr.y, 0.0));
        Point3d rayEnd = this.d_view.screenToWorld(new Point3d(viewScr.x, viewScr.y, 1.0));
        return new LineSeg3D(rayBegin, rayEnd);
    }

    public double findOccluderDistSq(Point3d p) {
        IsectInfo occluder = this.findOccluder(new TaskProgress(), p);
        if (occluder == null) {
            return Double.NaN;
        }
        return occluder.isectPoint.distanceSquared(p);
    }

    public IsectInfo findOccluder(TaskProgress progress, Point3d p) {
        return this.findOccluder(progress, p, false);
    }

    public IsectInfo findOccluder(TaskProgress progress, Point3d p, boolean findClosest) {
        this.d_view.updateLayout();
        Matrix4d wsXform = this.d_view.getCamera().getMatrix(6);
        Matrix4d swXform = this.d_view.getCamera().getMatrix(7);
        return this.findOccluder(progress, p, findClosest, wsXform, swXform);
    }

    protected IsectInfo findOccluder(TaskProgress progress, Point3d p, boolean findClosest, Matrix4d wsXform, Matrix4d swXform) {
        OccludedPointIsectFilter occlfilter = new OccludedPointIsectFilter(this.d_geometry, p, findClosest);
        VisibilityFilter filter = new VisibilityFilter(occlfilter, this.d_geometry);
        Point3d screen = Util3D.xform(wsXform, p, true);
        screen.z = 0.0;
        Point3d nearP = Util3D.xform(swXform, screen, true);
        LineSeg3D ray = new LineSeg3D(nearP, p);
        try {
            IPickConfig[] configs = this.d_geometry.getPickConfigs();
            for (int m = 0; m < configs.length; ++m) {
                LineSeg3D trimRay = GeomPicker.trim(ray, configs[m].getClippingRegion());
                if (trimRay == null) continue;
                LineSegRTreeTest test = new LineSegRTreeTest(trimRay.getP1(), trimRay.getP2());
                RayProxDetector proxDet = new RayProxDetector(trimRay);
                RaySearchResult result = new RaySearchResult(progress, Mode.SNAP, filter, trimRay, this.d_geometry, proxDet);
                this.d_geometry.find(configs[m], test, result);
            }
        }
        catch (HaltException haltException) {
            // empty catch block
        }
        return occlfilter.occluder;
    }

    protected double findOccluderDistSq(final TaskProgress progress, final Point3d p, IFace prim, Matrix4d wsXform, Matrix4d swXform) {
        Point3d screen = Util3D.xform(wsXform, p, true);
        screen.z = 0.0;
        Point3d nearP = Util3D.xform(swXform, screen, true);
        LineSeg3D ray = new LineSeg3D(nearP, p);
        LineSegRTreeTest test = new LineSegRTreeTest(ray.getP1(), ray.getP2());
        final Point3d[] primIsect = new Point3d[]{null};
        IIsectCollector result = new IIsectCollector(){

            @Override
            public void add(Object obj, Point3d ip, GeomType type, IPrimitive prim) {
                if (ip.distance(p) > 1.0E-6) {
                    primIsect[0] = p;
                    throw new HaltException();
                }
            }

            @Override
            public void addInfinite(Object obj, Point3d p2, GeomType type, IPrimitive prim) {
                this.add(obj, p2, type, prim);
            }

            @Override
            public TaskProgress getProgress() {
                return progress;
            }
        };
        try {
            prim.pickPoints(result, new DefaultFilter(GeomType.FACE), null, ray.p1, ray.p2, ray.getDirN(), test);
        }
        catch (HaltException haltException) {
            // empty catch block
        }
        return primIsect[0] == null ? Double.NaN : primIsect[0].distanceSquared(p);
    }

    private static class IsectSorter<T>
    implements Comparator<IsectInfo> {
        private static final int[] s_snapTypePriorities = new int[6];
        private static final int[] s_selTypePriorities;
        private final IPickRoot d_geometry;
        private final int[] d_searchPriorities;

        public IsectSorter(Mode searchMode, IPickRoot geom) {
            this.d_searchPriorities = searchMode == Mode.SNAP ? s_snapTypePriorities : s_selTypePriorities;
            this.d_geometry = geom;
        }

        @Override
        public int compare(IsectInfo o1, IsectInfo o2) {
            int prior2;
            int prior1 = this.d_searchPriorities[o1.searchType.ordinal()];
            if (prior1 == (prior2 = this.d_searchPriorities[o2.searchType.ordinal()])) {
                int proxCompare = o1.prox.compareTo(o2.prox);
                if (proxCompare == 0) {
                    return o1.obj == o2.obj ? 0 : this.d_geometry.compare(o1.obj, o2.obj);
                }
                return proxCompare;
            }
            return prior1 - prior2;
        }

        static {
            IsectSorter.s_snapTypePriorities[GeomType.VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.FACE_VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.EDGE.ordinal()] = 1;
            IsectSorter.s_snapTypePriorities[GeomType.FACE_EDGE.ordinal()] = 1;
            IsectSorter.s_snapTypePriorities[GeomType.FACE.ordinal()] = 2;
            IsectSorter.s_snapTypePriorities[GeomType.VOLUME.ordinal()] = 3;
            s_selTypePriorities = new int[6];
            IsectSorter.s_selTypePriorities[GeomType.VERTEX.ordinal()] = 0;
            IsectSorter.s_selTypePriorities[GeomType.EDGE.ordinal()] = 1;
            IsectSorter.s_selTypePriorities[GeomType.FACE.ordinal()] = 2;
            IsectSorter.s_selTypePriorities[GeomType.FACE_EDGE.ordinal()] = 3;
            IsectSorter.s_selTypePriorities[GeomType.FACE_VERTEX.ordinal()] = 3;
            IsectSorter.s_selTypePriorities[GeomType.VOLUME.ordinal()] = 4;
        }
    }

    private static class RayTolProxDetector
    implements IRayProxDetector {
        private final LineSeg3D d_ray;
        private final ConvexHull d_infTolFrustum;
        private final ConvexHull d_tolFrustum;
        private final Point2d d_rayOriginSc;
        private final double d_tolScrSq;
        private final Matrix4d d_wsXform;

        public RayTolProxDetector(View v, Point2d viewScrPos, double tolScreen, LineSeg3D ray, ConvexHull test) {
            this.d_ray = ray;
            this.d_infTolFrustum = v.toInfiniteFrustum(viewScrPos, tolScreen);
            this.d_tolFrustum = test;
            this.d_rayOriginSc = viewScrPos;
            this.d_tolScrSq = tolScreen * tolScreen;
            v.updateLayout();
            this.d_wsXform = v.getCamera().getMatrix(6);
        }

        @Override
        public RayPointProx getProximity(Point3d p, boolean infinite) {
            RayPointProx prox = this.testTolerance(p);
            if (prox == null) {
                return null;
            }
            if (infinite && this.d_infTolFrustum.contains(p, 1.0E-6) || !infinite && this.d_tolFrustum.contains(p, 1.0E-6)) {
                return prox;
            }
            return null;
        }

        private RayPointProx testTolerance(Point3d p) {
            Point3d isectScreen = Util3D.xform(this.d_wsXform, p, true);
            double dx = isectScreen.x - this.d_rayOriginSc.x;
            double dy = isectScreen.y - this.d_rayOriginSc.y;
            double proximity = dx * dx + dy * dy;
            if (proximity > this.d_tolScrSq) {
                return null;
            }
            return new RayPointProx(this.d_ray.p1.distance(p), proximity);
        }
    }

    private static class RayProxDetector
    implements IRayProxDetector {
        private final LineSeg3D d_ray;
        private final Vector3d d_rayDir;
        private final double d_rayLen;

        public RayProxDetector(LineSeg3D ray) {
            this.d_ray = ray;
            this.d_rayDir = ray.getDir();
            this.d_rayLen = ray.length();
        }

        @Override
        public RayPointProx getProximity(Point3d p, boolean infinite) {
            double t = Inter3D.nearestTOnLine(this.d_ray.p1, this.d_rayDir, p);
            if (theUtil.lt0(t, 1.0E-9) || theUtil.gt(t, 1.0, 1.0E-9) || Util3D.linePoint(this.d_ray.p1, this.d_rayDir, t).distance(p) > 1.0E-9) {
                return null;
            }
            double dist = t * this.d_rayLen;
            return new RayPointProx(dist, 0.0);
        }

        private static boolean pointWithinSeg(Point3d p, Point3d p1, Vector3d lineDir, double tol) {
            double dot = Util3D.dot(lineDir, p);
            return theUtil.ge0(dot, tol) && theUtil.le(dot, 1.0, tol);
        }
    }

    public static class IsectCollector
    implements IIsectCollector {
        private final TaskProgress d_progress;
        private final IPickRoot d_pickRoot;
        private final IIsectFilter d_searchFilter;
        private final List<IsectInfo> d_points;
        private final IRayProxDetector d_proxDet;

        public IsectCollector(TaskProgress progress, IPickRoot pickRoot, IIsectFilter filter, IRayProxDetector proximityDetector) {
            this.d_pickRoot = pickRoot;
            this.d_searchFilter = filter;
            this.d_progress = progress;
            this.d_proxDet = proximityDetector;
            this.d_points = new ArrayList<IsectInfo>();
        }

        @Override
        public TaskProgress getProgress() {
            return this.d_progress;
        }

        public List<IsectInfo> getIsects() {
            return this.d_points;
        }

        @Deprecated
        public final void add(Object obj, Point3d p, GeomType type) {
        }

        @Override
        public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
            this.add(obj, p, type, prim, true);
        }

        @Override
        public void add(Object obj, Point3d p, GeomType type, IPrimitive prim) {
            this.add(obj, p, type, prim, false);
        }

        public void add(Object obj, Point3d p, GeomType type, IPrimitive prim, boolean infinite) {
            this.d_progress.check();
            RayPointProx prox = this.d_proxDet.getProximity(p, infinite);
            if (prox != null) {
                IsectInfo si;
                if ((type == GeomType.FACE_EDGE || type == GeomType.FACE_VERTEX) && this.d_pickRoot.isWireframe(obj)) {
                    type = type == GeomType.FACE_EDGE ? GeomType.EDGE : GeomType.VERTEX;
                }
                if (this.d_searchFilter.acceptIntersection(si = new IsectInfo(type, obj, p, prim, prox))) {
                    this.d_points.add(si);
                }
            }
        }
    }

    public static class BoxCollector
    implements IBoxCollector {
        private final BoxSearchResult d_result;

        public BoxCollector(BoxSearchResult result) {
            this.d_result = result;
        }

        @Override
        public void add(Object obj) {
            this.add(obj, null);
        }

        public void add(Object obj, GeomType type) {
            this.d_result.d_objs.add(obj);
        }
    }

    private static class RaySearchResult
    implements IResult<IPickable> {
        private final TaskProgress d_progress;
        private final ITest<AABox> d_tester;
        private final LineSeg3D d_ray;
        private final Vector3d d_rayDirN;
        private final IsectCollector d_isectCollector;

        public RaySearchResult(TaskProgress progress, Mode searchMode, IIsectFilter searchFilter, LineSeg3D ray, IPickRoot display, IRayProxDetector proxDet) {
            this(progress, searchMode, searchFilter, ray, new LineSegRTreeTest(ray.p1, ray.p2), display, proxDet);
        }

        public RaySearchResult(TaskProgress progress, Mode searchMode, IIsectFilter searchFilter, LineSeg3D ray, ITest<AABox> tester, IPickRoot display, IRayProxDetector proxDet) {
            this.d_progress = progress;
            this.d_tester = tester;
            this.d_ray = ray;
            this.d_rayDirN = this.d_ray.getDirN();
            this.d_isectCollector = new IsectCollector(progress, display, searchFilter, proxDet);
        }

        public IsectCollector getResult() {
            return this.d_isectCollector;
        }

        public List<IsectInfo> getIsects() {
            return this.d_isectCollector.getIsects();
        }

        @Override
        public void mark(IPickable pickObj, Containment ctmt) {
            this.d_progress.check();
            pickObj.pickPoints(this.d_isectCollector, this.d_isectCollector.d_searchFilter, this.d_ray.p1, this.d_ray.p2, this.d_rayDirN, this.d_tester);
        }
    }

    private static interface IRayProxDetector {
        public RayPointProx getProximity(Point3d var1, boolean var2);
    }

    private static class BoxSearchResult
    implements IResult<IPickable> {
        public final List<Object> d_objs;
        private final ConvexHull d_tester;
        private final IIsectFilter d_searchFilter;
        private final IPickRoot d_display;
        private final BoxCollector d_result;

        public BoxSearchResult(IIsectFilter searchFilter, ConvexHull tester, IPickRoot display) {
            this.d_tester = tester;
            this.d_objs = new ArrayList<Object>();
            this.d_searchFilter = searchFilter;
            this.d_display = display;
            this.d_result = new BoxCollector(this);
        }

        @Override
        public void mark(IPickable obj, Containment ctmt) {
            switch (ctmt) {
                case INSIDE: {
                    obj.getAll(this.d_result, this.d_searchFilter);
                    break;
                }
                default: {
                    obj.pickBox(this.d_result, this.d_searchFilter, this.d_tester);
                }
            }
        }
    }

    private static class OccludedPointIsectFilter
    extends DefaultFilter {
        private final IPickRoot d_pickRoot;
        private final Point3d d_searchPoint;
        private final boolean d_findClosest;
        public IsectInfo occluder = null;

        public OccludedPointIsectFilter(IPickRoot pickRoot, Point3d searchPoint, boolean findClosest) {
            super(GeomType.FACE);
            this.d_pickRoot = pickRoot;
            this.d_searchPoint = searchPoint;
            this.d_findClosest = findClosest;
        }

        @Override
        public boolean acceptPickObject(Object obj) {
            return this.d_pickRoot.isOcclusionSource(obj);
        }

        @Override
        public boolean acceptIntersection(IsectInfo info) {
            double dist = info.isectPoint.distance(this.d_searchPoint);
            if (dist > 1.0E-6) {
                if (this.occluder == null || dist > this.occluder.isectPoint.distance(this.d_searchPoint)) {
                    this.occluder = info;
                }
                if (!this.d_findClosest) {
                    throw new HaltException();
                }
            }
            return false;
        }
    }

    private static class HaltException
    extends RuntimeException {
        private static final long serialVersionUID = -820726468639723761L;

        private HaltException() {
        }
    }

    private class OcclusionFilter
    implements IObjectFilter<IsectInfo> {
        private final TaskProgress d_progress;
        private IsectInfo d_firstFaceIsect = null;
        private Map<Point3d, Boolean> d_occludedCache = new HashMap<Point3d, Boolean>();
        private List<IsectInfo> d_foundOccluders = new ArrayList<IsectInfo>();
        private final Matrix4d d_wsXform;
        private final Matrix4d d_swXform;

        public OcclusionFilter(TaskProgress progress) {
            this.d_progress = progress;
            GeomPicker.this.d_view.updateLayout();
            this.d_wsXform = GeomPicker.this.d_view.getCamera().getMatrix(6);
            this.d_swXform = GeomPicker.this.d_view.getCamera().getMatrix(7);
        }

        @Override
        public boolean shouldFilter(IsectInfo o) {
            if (!this.d_progress.isRunning()) {
                return true;
            }
            if (!GeomPicker.this.d_geometry.isOcclusionTarget(o.obj)) {
                return false;
            }
            Boolean occluded = this.d_occludedCache.get(o.isectPoint);
            if (occluded == null) {
                try {
                    for (IsectInfo occluder : this.d_foundOccluders) {
                        double distSq = GeomPicker.this.findOccluderDistSq(this.d_progress, o.isectPoint, (IFace)occluder.prim, this.d_wsXform, this.d_swXform);
                        if (Double.isNaN(distSq)) continue;
                        occluded = true;
                        break;
                    }
                    if (occluded == null) {
                        IsectInfo occluder = GeomPicker.this.findOccluder(this.d_progress, o.isectPoint, false, this.d_wsXform, this.d_swXform);
                        if (occluder != null) {
                            this.d_foundOccluders.add(occluder);
                        }
                        occluded = occluder != null;
                    }
                    this.d_occludedCache.put(o.isectPoint, occluded);
                }
                catch (HaltException e) {
                    occluded = true;
                }
            }
            return occluded;
        }
    }

    private static class VisibilityFilter
    implements IIsectFilter {
        private final IPickRoot d_display;
        private final IIsectFilter d_baseFilter;

        public VisibilityFilter(IIsectFilter baseFilter, IPickRoot geom) {
            this.d_display = geom;
            this.d_baseFilter = baseFilter;
        }

        @Override
        public boolean acceptIntersection(IsectInfo info) {
            return this.d_baseFilter.acceptIntersection(info);
        }

        @Override
        public boolean acceptGeomType(Object source, GeomType type) {
            if (type == GeomType.FACE && this.d_display.isWireframe(source)) {
                return false;
            }
            return this.d_baseFilter.acceptGeomType(source, type);
        }

        @Override
        public boolean acceptPickObjType(Class type) {
            return this.d_baseFilter.acceptPickObjType(type);
        }

        @Override
        public boolean acceptPickObject(Object obj) {
            return this.d_baseFilter.acceptPickObject(obj) && this.d_display.isVisible(obj);
        }
    }

    private static class CHTest
    implements ITest<AABox> {
        public final ConvexHull ch;
        public final double tol;

        public CHTest(ConvexHull ch) {
            this(ch, 1.0E-9);
        }

        public CHTest(ConvexHull ch, double tol) {
            this.ch = ch;
            this.tol = tol;
        }

        @Override
        public Containment test(AABox bounds) {
            return this.ch.test(bounds, this.tol);
        }
    }

    public static enum Mode {
        SNAP,
        PICK;

    }
}

