/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiUtil;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.AToolFunction;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.CursorTool;

public class OrbitFunc
extends AToolFunction<CursorTool> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Orbit", "orbit32.png", 15, 15);
    public static final Icon ICON = guiUtil.loadTeciIcon("orbit16.png");
    private Vector3d d_vLast;

    @Override
    public Cursor getCursor(CursorTool tool) {
        return tool.isDragging() ? CURSOR : null;
    }

    @Override
    public boolean isDrawable(CursorTool tool) {
        return false;
    }

    private void turnMEIntoVec(CursorTool tool, MouseEvent e, Vector3d v) {
        double x = (double)e.getX() - (double)tool.getView().getSurface().getWidth() / 2.0;
        double y = -((double)e.getY() - (double)tool.getView().getSurface().getHeight() / 2.0);
        double r = (double)tool.getView().getSurface().getWidth() / 2.5;
        v.x = x;
        v.y = y;
        v.z = r * r <= x * x + y * y ? 0.0 : Math.sqrt(r * r - x * x - y * y);
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
        this.d_vLast = null;
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
        if (this.d_vLast == null) {
            this.d_vLast = new Vector3d();
            this.turnMEIntoVec(tool, e, this.d_vLast);
        }
        Vector3d vNew = new Vector3d();
        Vector3d vRotate = new Vector3d();
        this.turnMEIntoVec(tool, e, vNew);
        Vector3d diff = new Vector3d();
        diff.sub(vNew, this.d_vLast);
        vRotate.cross(this.d_vLast, vNew);
        if (vRotate.length() < 0.1) {
            return;
        }
        double asinArg = vRotate.length() / (this.d_vLast.length() * vNew.length());
        if (asinArg > 1.0) {
            asinArg = 1.0;
        } else if (asinArg < -1.0) {
            asinArg = -1.0;
        }
        double angle = Math.asin(asinArg) * 180.0 / Math.PI;
        vRotate.normalize();
        tool.getView().getCamera().orbit(-1.5 * angle, vRotate.x, vRotate.y, vRotate.z);
        this.d_vLast.set(vNew);
        tool.repaintSurface();
    }
}

