/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IConcreteRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.RenderBuffer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.SceneLayout;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.VirtualRenderSurface;

public class nb3dUtil {
    public static void write(INativeStream writer, Matrix4d mat) {
        writer.writeDoubles(mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33);
    }

    public static void writeFloats(INativeStream writer, Color color) {
        nb3dUtil.writeFloats(writer, color, new float[4]);
    }

    public static void writeFloats(INativeStream writer, Color color, float[] tempArr) {
        color.getComponents(tempArr);
        writer.writeFloats(tempArr);
    }

    public static boolean takeScreenshot(String filename, int width, int height, Color fillColor, IConcreteRenderSurface renderSurface, List<? extends SceneLayout> layouts, List<Rectangle> layoutBounds) throws IOException {
        if (layouts.size() != layoutBounds.size()) {
            return false;
        }
        int extix = filename.lastIndexOf(46);
        if (extix == -1) {
            return false;
        }
        String ext = filename.substring(extix + 1);
        Rectangle bounds = new Rectangle();
        for (int m = 0; m < layouts.size(); ++m) {
            Rectangle rect = layoutBounds.get(m);
            bounds.add(rect);
        }
        int pitch = width * 3;
        int numBytes = pitch * height;
        ByteBuffer buffer = ByteBuffer.allocateDirect(numBytes).order(ByteOrder.nativeOrder());
        if (fillColor != null) {
            for (int m = 0; m < numBytes; m += 3) {
                buffer.put((byte)fillColor.getRed());
                buffer.put((byte)fillColor.getGreen());
                buffer.put((byte)fillColor.getBlue());
            }
            buffer.position(0);
        }
        RenderBuffer rb = new RenderBuffer(renderSurface);
        for (int m = 0; m < layouts.size(); ++m) {
            SceneLayout layout = layouts.get(m);
            Rectangle lbounds = layoutBounds.get(m);
            double newWidth = lbounds.getWidth() / bounds.getWidth() * (double)width;
            double newHeight = lbounds.getHeight() / bounds.getHeight() * (double)height;
            double x = lbounds.getMinX() / bounds.getWidth() * (double)width;
            double y = (bounds.getHeight() - lbounds.getMaxY()) / bounds.getHeight() * (double)height;
            rb.setLayout(layout);
            rb.setSize((int)newWidth, (int)newHeight);
            buffer.position((int)y * pitch + (int)x * 3);
            rb.setBuffer(buffer.slice(), pitch);
            rb.render();
        }
        buffer.position(0);
        BufferedImage bi = new BufferedImage(width, height, 5);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int r = buffer.get() & 0xFF;
                int g = buffer.get() & 0xFF;
                int b = buffer.get() & 0xFF;
                int data = 0xFF000000 | r << 16 | g << 8 | b;
                bi.setRGB(col, height - row - 1, data);
            }
        }
        ImageIO.write((RenderedImage)bi, ext, new File(filename));
        return true;
    }

    public static IConcreteRenderSurface findRenderSurface(Collection<? extends IRenderSurface> surfaces) {
        for (IRenderSurface iRenderSurface : surfaces) {
            IConcreteRenderSurface cs;
            if (iRenderSurface instanceof IConcreteRenderSurface) {
                return (IConcreteRenderSurface)iRenderSurface;
            }
            if (!(iRenderSurface instanceof VirtualRenderSurface) || (cs = ((VirtualRenderSurface)iRenderSurface).getBackingSurface()) == null) continue;
            return cs;
        }
        return null;
    }
}

