/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import javax.vecmath.Point2d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.FlattenedProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;

public class DisplayGeom {
    public static final ITexCoordGenerator DEF_TEXCOORDGEN = new DefTexCoordGen();
    public static final DisplayGeom EMPTY = new DisplayGeom((IGeom)EmptyGeom.INSTANCE, new FlattenedProps(new IPrimProps[0]));
    public final IGeom geom;
    public final IPropsSrc props;
    public final ITexCoordGenerator texuv;

    public DisplayGeom(IGeom geom, ITexCoordGenerator texuv, IPropsSrc props) {
        this.geom = geom;
        this.props = props;
        this.texuv = texuv;
    }

    public DisplayGeom(IGeom geom, IPropsSrc props) {
        this(geom, DEF_TEXCOORDGEN, props);
    }

    public DisplayGeom(IGeom geom, IPrimProps props) {
        this(geom, new UniformProps(props));
    }

    public DisplayGeom(IGeom geom, ITexCoordGenerator texuv, IPrimProps props) {
        this(geom, texuv, new UniformProps(props));
    }

    public DisplayGeom(IGeom geom, IPrimProps ... props) {
        this(geom, new FlattenedProps(props));
    }

    public DisplayGeom(IGeom geom, ITexCoordGenerator texuv, IPrimProps ... props) {
        this(geom, texuv, new FlattenedProps(props));
    }

    private static class DefTexCoordGen
    implements ITexCoordGenerator,
    Serializable {
        static final long serialVersionUID = 1L;

        private DefTexCoordGen() {
        }

        @Override
        public IElemSource<Point2d> fromLegacy(LegacyDictionary_2012_1 dict) {
            return Elements.NO_UV;
        }

        @Override
        public void generate(int faceIx, IPolygon face, IPrimProps props, List<Point2d> texuv) {
            Point2d defPoint = new Point2d(0.0, 0.0);
            int numLoops = face.getNumLoops();
            for (int m = 0; m < numLoops; ++m) {
                int numVerts = face.getNumPoints(m);
                for (int n = 0; n < numVerts; ++n) {
                    texuv.add(defPoint);
                }
            }
        }

        @Override
        public void generate(int faceIx, IFace face, IPrimProps props, Mesh triangulated, List<Point2d> texuv) {
            Point2d defPoint = new Point2d(0.0, 0.0);
            for (int m = 0; m < triangulated.vertices.length; ++m) {
                texuv.add(defPoint);
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return DEF_TEXCOORDGEN;
        }
    }
}

