/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ABufferedNativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeObject;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.JNIException;

public class NativeManager
extends ABufferedNativeStream {
    protected long d_peerObj;
    private static final byte COMMAND_CREATE_OBJECT = 0;
    private static final byte COMMAND_DELETE_OBJECT = 1;
    private static final byte COMMAND_UPDATE_OBJECT = 2;
    private static final byte COMMAND_EXEC_METHOD = 3;
    private static final byte COMMAND_EXEC_STATIC_METHOD = 4;
    private static final byte COMMAND_STATUS_COMPLETE = 0;
    private static final byte COMMAND_STATUS_INCOMPLETE = 1;
    private int d_numCommands = 0;
    private byte d_commandStatus = 1;
    private int d_lastCommandPosition = 0;
    private int d_firstCommandLengthB = 0;
    private int d_lastCommandLengthB = 0;
    private final Map<Class<?>, Integer> d_classKeyMap = new HashMap();
    private int d_classKeyIt = 0;
    private int d_numFlushes = 0;
    private final ExecutorService d_executor = Executors.newSingleThreadExecutor();

    private native void registerClassKey(String var1, int var2);

    private final native void dispatch(ByteBuffer var1, ByteBuffer var2, int var3, byte var4, int var5, int var6) throws JNIException;

    public NativeManager() {
        this(0x100000, 0x100000);
    }

    public NativeManager(int writeBufferCapacity, int readBufferCapacity) {
        super(writeBufferCapacity, readBufferCapacity);
    }

    public ExecutorService getDispatchExecutor() {
        return this.d_executor;
    }

    private int registerClass(Class<?> clazz) {
        int key = this.d_classKeyIt++;
        this.d_classKeyMap.put(clazz, key);
        this.registerClassKey(clazz.getCanonicalName(), key);
        return key;
    }

    private final void beginCommand(byte command) {
        this.lockWriteBuffer();
        this.writeByte(command);
        this.d_lastCommandPosition = this.getWritePosition() - 1;
        this.d_commandStatus = 1;
        ++this.d_numCommands;
    }

    private final void endCommand() {
        this.d_commandStatus = 0;
        if (this.d_numCommands == 1) {
            this.d_firstCommandLengthB = this.getWritePosition() - this.d_lastCommandPosition;
        }
        this.markStrongRefsFinished();
        this.unlockWriteBuffer();
    }

    private final void beginCustomCommand(byte command, Class clazz, int key) {
        Integer classKey = this.d_classKeyMap.get(clazz);
        if (classKey == null) {
            classKey = this.registerClass(clazz);
        }
        this.beginCommand(command);
        this.writeInt(classKey);
        this.writeInt(key);
    }

    private final void beginStaticCustomCommand(byte command, Class clazz) {
        Integer classKey = this.d_classKeyMap.get(clazz);
        if (classKey == null) {
            classKey = this.registerClass(clazz);
        }
        this.beginCommand(command);
        this.writeInt(classKey);
    }

    private final void beginFullCommand(byte command, INativeObject obj) {
        this.beginCustomCommand(command, obj.resolveNativeClass(), obj.getKey());
    }

    private final void beginSimpleCommand(byte command, INativeObject obj) {
        this.beginCommand(command);
        this.writeInt(obj.getKey());
    }

    public final void markPeerDirty(INativelyMirrored obj) {
        this.updatePeer(obj);
    }

    public final void createPeer(INativeObject obj) {
        this.beginFullCommand((byte)0, obj);
        this.endCommand();
    }

    public final void createPeers(Collection<? extends INativeObject> objs) {
        for (INativeObject iNativeObject : objs) {
            this.createPeer(iNativeObject);
        }
    }

    public final void createPeer(Class type, int key) {
        this.beginCustomCommand((byte)0, type, key);
        this.endCommand();
    }

    private final void updatePeer(INativelyMirrored obj) {
        this.beginSimpleCommand((byte)2, obj);
        obj.writeNativeData(this);
        this.endCommand();
        obj.markNativeClean();
    }

    private final void updatePeers(Collection<? extends INativelyMirrored> objs) {
        for (INativelyMirrored iNativelyMirrored : objs) {
            this.updatePeer(iNativelyMirrored);
        }
    }

    public final void execMethod(Class type, INativeObject obj, int methodID, Object ... args) {
        this.beginCustomCommand((byte)3, type, obj.getKey());
        this.writeInt(methodID);
        this.writeObjects(args);
        this.endCommand();
    }

    public final void execStaticMethod(Class type, int methodID, Object ... args) {
        this.beginStaticCustomCommand((byte)4, type);
        this.writeInt(methodID);
        this.writeObjects(args);
        this.endCommand();
    }

    public final void deletePeer(INativeObject obj) {
        this.scheduleFlush(5000L);
        this.beginSimpleCommand((byte)1, obj);
        this.endCommand();
    }

    public final void deletePeers(Collection<? extends INativeObject> objs) {
        for (INativeObject iNativeObject : objs) {
            this.deletePeer(iNativeObject);
        }
    }

    @Override
    public final void flush() {
        super.flush();
    }

    @Override
    protected void dispatch(final ByteBuffer writeBuffer, final ByteBuffer readBuffer) {
        this.d_lastCommandLengthB = this.getWritePosition() - this.d_lastCommandPosition;
        if (this.d_numCommands == 1) {
            this.d_firstCommandLengthB = this.d_lastCommandLengthB;
        }
        Runnable dispatchRunner = new Runnable(){

            @Override
            public void run() {
                NativeManager.this.dispatch(writeBuffer, readBuffer, NativeManager.this.d_numCommands, NativeManager.this.d_commandStatus, NativeManager.this.d_firstCommandLengthB, NativeManager.this.d_lastCommandLengthB);
            }
        };
        try {
            this.d_executor.submit(dispatchRunner).get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.d_numCommands = this.d_commandStatus == 1 ? 1 : 0;
        this.d_lastCommandPosition = 0;
        ++this.d_numFlushes;
    }

    public void resetFlushCount() {
        this.lockWriteBuffer();
        this.d_numFlushes = 0;
        this.unlockWriteBuffer();
    }

    public int getFlushCount() {
        return this.d_numFlushes;
    }
}

