/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiField;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.ValueRange;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public abstract class guiValueField<T>
extends guiField {
    private static final long serialVersionUID = -1885287366275642444L;
    private T d_value;
    private ValueRange<T> d_range;
    private boolean d_modified;
    private DocumentListener d_modListener;
    private final Map<String, T> d_specialValMap = new LinkedHashMap<String, T>(1);
    private final Semaphore d_writeLock = new Semaphore(1);

    protected abstract String format(T var1);

    public abstract T parse(String var1) throws ParseException;

    protected abstract ValueRange<T> getUncheckedRange(T var1);

    protected guiValueField() {
    }

    public guiValueField(T value, ValueRange<T> range) {
        this.init(value, range);
    }

    public void aliasValue(T val, String ... aliases) {
        for (String alias : aliases) {
            this.addSpecialValue(alias, val);
        }
    }

    public T addSpecialValue(String text, T val) {
        return this.d_specialValMap.put(text, val);
    }

    public T removeSpecialValue(String text) {
        T oldVal = this.d_specialValMap.remove(text);
        return oldVal;
    }

    public T getSpecialValue(String text) {
        return this.d_specialValMap.get(text);
    }

    protected void init(T value, ValueRange<T> range) {
        this.d_modified = false;
        this.setHorizontalAlignment(2);
        this.d_range = range;
        if (this.d_range == null) {
            this.d_range = this.getUncheckedRange(value);
        }
        this.setValue(value);
        this.d_modListener = new ModifyListener();
        this.getDocument().addDocumentListener(this.d_modListener);
    }

    public boolean getConvertDecimalToLocaleSeparator() {
        return true;
    }

    @Override
    public String getText() {
        return super.getText().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(T value) {
        if (!this.d_writeLock.tryAcquire()) {
            return;
        }
        try {
            boolean specialFound = false;
            String text = "";
            for (Map.Entry<String, T> entry : this.d_specialValMap.entrySet()) {
                if (!theUtil.equal(entry.getValue(), value)) continue;
                specialFound = true;
                text = entry.getKey();
                break;
            }
            if (!specialFound) {
                assert (value != null && this.d_range.checkValue(value)) : "Value cannot be null and must lie in range.";
                text = this.format(value);
            }
            try {
                super.setText(text);
            }
            catch (IllegalStateException e) {
                this.d_writeLock.release();
                return;
            }
            this.d_value = value;
            this.d_modified = false;
        }
        finally {
            this.d_writeLock.release();
        }
    }

    @Override
    public void setText(String text) {
        Pair<T, Exception> valResult = this.getValue(text);
        if (valResult.v2 == null) {
            this.setValue(valResult.v1);
        }
    }

    protected Pair<T, Exception> getValue(String text) {
        if (this.d_specialValMap.containsKey(text)) {
            T specialVal = this.d_specialValMap.get(text);
            return new Pair<T, Object>(specialVal, null);
        }
        try {
            T value = this.parse(text);
            return new Pair<T, Object>(value, null);
        }
        catch (Exception e) {
            return new Pair<Object, Exception>(null, e);
        }
    }

    public T getValue() {
        return this.d_value;
    }

    public ValueRange<T> getValueRange() {
        return this.d_range;
    }

    public void setValueRange(ValueRange<T> range) {
        this.d_range = range;
        if (this.d_range == null) {
            this.d_range = this.getUncheckedRange(this.d_value);
        }
        this.setValue(this.d_range.clampValue(this.d_value));
    }

    protected ParseException getDefaultNumParseException() {
        String msg = String.format(Intl.intl("The entry \"%1$s\" is invalid. \nPlease enter %2$s."), this.getText(), this.d_range.describeRange());
        return new ParseException(msg, 0);
    }

    @Override
    public boolean validateData(boolean warn, boolean modify) {
        if (!this.shouldValidate()) {
            return true;
        }
        Pair<T, Exception> newValueResult = this.getValue(this.getText());
        if (newValueResult.v2 != null) {
            if (warn) {
                this.showMessageBox(((Exception)newValueResult.v2).getLocalizedMessage(), true);
                this.requestFocusHack();
            }
            return false;
        }
        Object newValue = newValueResult.v1;
        if (newValue != null && !this.d_range.checkValue(newValue)) {
            if (warn) {
                String msg = String.format(Intl.intl("The entry \"%1$s\" is out of range. \nPlease enter %2$s."), this.getText(), this.d_range.describeRange());
                this.showMessageBox(msg, true);
                this.requestFocusHack();
            }
            return false;
        }
        if (modify) {
            if (this.isModified()) {
                this.setValue(newValue);
                this.setModified(true);
            }
        } else {
            this.d_value = newValue;
        }
        return true;
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    public void setEmptyAllowed(boolean emptyAllowed) {
        if (emptyAllowed) {
            this.addSpecialValue("", null);
        } else {
            this.removeSpecialValue("");
        }
    }

    public boolean getEmptyAllowed() {
        return this.d_specialValMap.containsKey("");
    }

    public boolean isEmpty() {
        return this.getText().equals("");
    }

    private class ModifyListener
    implements DocumentListener {
        private ModifyListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            guiValueField.this.d_modified = true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            guiValueField.this.d_modified = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            guiValueField.this.d_modified = true;
        }
    }
}

