/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.SerShape;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Spline2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Spline3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;

public class ShapeUtil {
    public static AABox getBounds(Shape s, Matrix4d lwXform) {
        Rectangle2D bounds = s.getBounds2D();
        AABox box = new AABox();
        box.add(ShapeUtil.xform(lwXform, bounds.getMinX(), bounds.getMinY()), ShapeUtil.xform(lwXform, bounds.getMinX(), bounds.getMaxY()), ShapeUtil.xform(lwXform, bounds.getMaxX(), bounds.getMinY()), ShapeUtil.xform(lwXform, bounds.getMaxX(), bounds.getMaxY()));
        return box;
    }

    public static boolean isZAligned(Matrix4d xform) {
        return xform.m20 == 0.0 && xform.m21 == 0.0 && xform.m22 == 1.0;
    }

    public static double getZLoc(Matrix4d xform) {
        assert (ShapeUtil.isZAligned(xform));
        return xform.m23;
    }

    public static void setZLoc(Matrix4d xform, double z) {
        xform.setRow(2, 0.0, 0.0, 1.0, z);
    }

    public static Point3d xform(Matrix4d localToWorldXform, double x, double y) {
        Point3d p = new Point3d(x, y, 0.0);
        localToWorldXform.transform(p);
        return p;
    }

    public static Point3d xform(Matrix4d localToWorldXform, Point2d p) {
        Point3d p3d = new Point3d(p.x, p.y, 0.0);
        localToWorldXform.transform(p3d);
        return p3d;
    }

    public static Vector3d xform(Matrix4d localToWorldXform, Vector2d v) {
        Vector3d v3d = new Vector3d(v.x, v.y, 0.0);
        localToWorldXform.transform(v3d);
        return v3d;
    }

    public static Vector3d invXform(Matrix4d worldToLocalXform, Vector3d v) {
        Vector3d v2 = new Vector3d(v);
        worldToLocalXform.transform(v2);
        return v2;
    }

    public static Point3d invXform(Matrix4d worldToLocalXform, Point3d p) {
        Point3d p2 = new Point3d(p);
        worldToLocalXform.transform(p2);
        return p2;
    }

    public static Point2d invXform2d(Matrix4d worldToLocalXform, Point3d p) {
        Point3d p2 = new Point3d(p);
        worldToLocalXform.transform(p2);
        return new Point2d(p2.x, p2.y);
    }

    public static Point3d extract3d(Matrix4d localToWorldXform, double[] coords, int offset) {
        return ShapeUtil.xform(localToWorldXform, coords[offset], coords[offset + 1]);
    }

    public static Point2d extract2d(double[] coords, int offset) {
        return new Point2d(coords[offset], coords[offset + 1]);
    }

    public static CubicCurve2D subcurve(CubicCurve2D src, double t1, double t2) {
        double[] t = Util.clampTRange(t1, t2);
        t1 = t[0];
        t2 = t[1];
        if (t1 == 0.0 && t2 == 1.0) {
            return (CubicCurve2D)src.clone();
        }
        if (t1 == 0.0) {
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            ShapeUtil.split(src, left, null, t2);
            return left;
        }
        if (t2 == 1.0) {
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            ShapeUtil.split(src, null, right, t1);
            return right;
        }
        CubicCurve2D.Double left = new CubicCurve2D.Double();
        ShapeUtil.split(src, left, null, t2);
        CubicCurve2D.Double middle = new CubicCurve2D.Double();
        ShapeUtil.split(left, null, middle, t1 / t2);
        return middle;
    }

    public static void split(CubicCurve2D src, CubicCurve2D left, CubicCurve2D right, double t) {
        if (t <= 0.0) {
            if (left != null) {
                Point2D p = src.getP1();
                left.setCurve(p, p, p, p);
            }
            if (right != null) {
                right.setCurve(src);
            }
            return;
        }
        if (t >= 1.0) {
            Point2D p = src.getP2();
            if (left != null) {
                left.setCurve(p, p, p, p);
            }
            if (right != null) {
                right.setCurve(p, p, p, p);
            }
            return;
        }
        double x1 = src.getX1();
        double y1 = src.getY1();
        double ctrlx1 = src.getCtrlX1();
        double ctrly1 = src.getCtrlY1();
        double ctrlx2 = src.getCtrlX2();
        double ctrly2 = src.getCtrlY2();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double centerx = ctrlx1 + (ctrlx2 - ctrlx1) * t;
        double centery = ctrly1 + (ctrly2 - ctrly1) * t;
        ctrlx1 = x1 + (ctrlx1 - x1) * t;
        ctrly1 = y1 + (ctrly1 - y1) * t;
        ctrlx2 += (x2 - ctrlx2) * t;
        ctrly2 += (y2 - ctrly2) * t;
        double ctrlx12 = ctrlx1 + (centerx - ctrlx1) * t;
        double ctrly12 = ctrly1 + (centery - ctrly1) * t;
        double ctrlx21 = centerx + (ctrlx2 - centerx) * t;
        double ctrly21 = centery + (ctrly2 - centery) * t;
        centerx = ctrlx12 + (ctrlx21 - ctrlx12) * t;
        centery = ctrly12 + (ctrly21 - ctrly12) * t;
        if (left != null) {
            left.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx12, ctrly12, centerx, centery);
        }
        if (right != null) {
            right.setCurve(centerx, centery, ctrlx21, ctrly21, ctrlx2, ctrly2, x2, y2);
        }
    }

    public static QuadCurve2D subcurve(QuadCurve2D src, double t1, double t2) {
        double[] t = Util.clampTRange(t1, t2);
        t1 = t[0];
        t2 = t[1];
        if (t1 == 0.0 && t2 == 1.0) {
            return (QuadCurve2D)src.clone();
        }
        if (t1 == 0.0) {
            QuadCurve2D.Double left = new QuadCurve2D.Double();
            ShapeUtil.split(src, left, null, t2);
            return left;
        }
        if (t2 == 1.0) {
            QuadCurve2D.Double right = new QuadCurve2D.Double();
            ShapeUtil.split(src, null, right, t1);
            return right;
        }
        QuadCurve2D.Double left = new QuadCurve2D.Double();
        ShapeUtil.split(src, left, null, t2);
        QuadCurve2D.Double middle = new QuadCurve2D.Double();
        ShapeUtil.split(left, null, middle, t1 / t2);
        return middle;
    }

    public static void split(QuadCurve2D src, QuadCurve2D left, QuadCurve2D right, double t) {
        if (t <= 0.0) {
            if (left != null) {
                Point2D p = src.getP1();
                left.setCurve(p, p, p);
            }
            if (right != null) {
                right.setCurve(src);
            }
            return;
        }
        if (t >= 1.0) {
            Point2D p = src.getP2();
            if (left != null) {
                left.setCurve(p, p, p);
            }
            if (right != null) {
                right.setCurve(p, p, p);
            }
            return;
        }
        double x1 = src.getX1();
        double y1 = src.getY1();
        double ctrlx = src.getCtrlX();
        double ctrly = src.getCtrlY();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double ctrlx1 = x1 + (ctrlx - x1) * t;
        double ctrly1 = y1 + (ctrly - y1) * t;
        double ctrlx2 = ctrlx + (x2 - ctrlx) * t;
        double ctrly2 = ctrly + (y2 - ctrly) * t;
        ctrlx = ctrlx1 + (ctrlx2 - ctrlx1) * t;
        ctrly = ctrly1 + (ctrly2 - ctrly1) * t;
        if (left != null) {
            left.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx, ctrly);
        }
        if (right != null) {
            right.setCurve(ctrlx, ctrly, ctrlx2, ctrly2, x2, y2);
        }
    }

    public static double getFlatness(Shape s, double error) {
        return ShapeUtil.getFlatness(s.getBounds2D(), error);
    }

    public static double getFlatness(Rectangle2D bounds, double error) {
        double minDim = Math.min(bounds.getWidth(), bounds.getHeight());
        double flatness = minDim * error;
        return flatness;
    }

    public static PathIterator getPathIterator(Shape s, AffineTransform xform, double curveError) {
        if (curveError > 0.0) {
            double flatness = ShapeUtil.getFlatness(s, curveError);
            return s.getPathIterator(xform, flatness);
        }
        return s.getPathIterator(xform);
    }

    public static <T extends IParametric2D> Collection<T> getBoundary2D(Shape s, AffineTransform xform, double curveError, Class<T> type) {
        return new FilteredCollection<T>(ShapeUtil.getBoundary2D(s, xform, curveError), type);
    }

    public static List<IParametric2D> getBoundary2D(Shape s, AffineTransform xform, double curveError) {
        ArrayList<IParametric2D> parms = new ArrayList<IParametric2D>();
        double[] coords = new double[6];
        Point2d firstPoint = null;
        Tuple2d lastPoint = null;
        boolean reverse = s instanceof Area;
        PathIterator path = ShapeUtil.getPathIterator(s, xform, curveError);
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            IParametric2D parm = null;
            switch (type) {
                case 0: {
                    firstPoint = ShapeUtil.extract2d(coords, 0);
                    lastPoint = firstPoint;
                    break;
                }
                case 4: {
                    if (lastPoint.equals(firstPoint)) break;
                    parm = new LineSeg2D((Point2d)lastPoint, firstPoint);
                    break;
                }
                case 1: {
                    Point2d currPoint = ShapeUtil.extract2d(coords, 0);
                    parm = new LineSeg2D((Point2d)lastPoint, currPoint);
                    lastPoint = currPoint;
                    break;
                }
                case 2: {
                    Point2d c = ShapeUtil.extract2d(coords, 0);
                    Point2d p2 = ShapeUtil.extract2d(coords, 2);
                    parm = new Spline2D.Quadratic((Point2d)lastPoint, c, p2);
                    lastPoint = p2;
                    break;
                }
                case 3: {
                    Point2d c1 = ShapeUtil.extract2d(coords, 0);
                    Point2d c2 = ShapeUtil.extract2d(coords, 2);
                    Point2d p2 = ShapeUtil.extract2d(coords, 4);
                    parm = new Spline2D.Cubic((Point2d)lastPoint, c1, c2, p2);
                    lastPoint = p2;
                    break;
                }
            }
            if (parm != null) {
                if (reverse) {
                    parm = parm.reverse();
                }
                parms.add(parm);
            }
            path.next();
        }
        return parms;
    }

    public static <T extends IParametric3D> Collection<T> getBoundary3D(Shape s, Matrix4d lwXform, double error, Class<T> type) {
        return new FilteredCollection<T>(ShapeUtil.getBoundary3D(s, lwXform, error), type);
    }

    public static List<IParametric3D> getBoundary3D(Shape s, Matrix4d lwXform, double error) {
        ArrayList<IParametric3D> parms = new ArrayList<IParametric3D>();
        double[] coords = new double[6];
        Point3d firstPoint = null;
        Tuple3d lastPoint = null;
        boolean reverse = s instanceof Area;
        PathIterator path = ShapeUtil.getPathIterator(s, null, error);
        while (!path.isDone()) {
            IParametric3D parm = null;
            int type = path.currentSegment(coords);
            switch (type) {
                case 0: {
                    firstPoint = ShapeUtil.extract3d(lwXform, coords, 0);
                    lastPoint = firstPoint;
                    break;
                }
                case 4: {
                    if (lastPoint.equals(firstPoint)) break;
                    parm = new LineSeg3D((Point3d)lastPoint, firstPoint);
                    break;
                }
                case 1: {
                    Point3d currPoint = ShapeUtil.extract3d(lwXform, coords, 0);
                    parm = new LineSeg3D((Point3d)lastPoint, currPoint);
                    lastPoint = currPoint;
                    break;
                }
                case 2: {
                    Point3d c = ShapeUtil.extract3d(lwXform, coords, 0);
                    Point3d p2 = ShapeUtil.extract3d(lwXform, coords, 2);
                    parm = new Spline3D.Quadratic((Point3d)lastPoint, c, p2);
                    lastPoint = p2;
                    break;
                }
                case 3: {
                    Point3d c1 = ShapeUtil.extract3d(lwXform, coords, 0);
                    Point3d c2 = ShapeUtil.extract3d(lwXform, coords, 2);
                    Point3d p2 = ShapeUtil.extract3d(lwXform, coords, 4);
                    parm = new Spline3D.Cubic((Point3d)lastPoint, c1, c2, p2);
                    lastPoint = p2;
                    break;
                }
            }
            if (parm != null) {
                if (reverse) {
                    parm = parm.reverse();
                }
                parms.add(parm);
            }
            path.next();
        }
        return parms;
    }

    public static Point3d[] getBoundaryVerts(Shape s, Matrix4d lwXform, double error) {
        ArrayList<Point3d> verts = new ArrayList<Point3d>();
        double[] coords = new double[6];
        Point3d firstPoint = null;
        boolean reverse = s instanceof Area;
        PathIterator path = ShapeUtil.getPathIterator(s, null, error);
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            switch (type) {
                case 0: {
                    firstPoint = ShapeUtil.extract3d(lwXform, coords, 0);
                    verts.add(firstPoint);
                    break;
                }
                case 1: {
                    Point3d currPoint = ShapeUtil.extract3d(lwXform, coords, 0);
                    verts.add(currPoint);
                    break;
                }
                case 2: {
                    Point3d p2 = ShapeUtil.extract3d(lwXform, coords, 2);
                    verts.add(p2);
                    break;
                }
                case 3: {
                    Point3d p2 = ShapeUtil.extract3d(lwXform, coords, 4);
                    verts.add(p2);
                    break;
                }
            }
            path.next();
        }
        Point3d[] varr = new Point3d[verts.size()];
        if (reverse) {
            for (int m = verts.size() - 1; m >= 0; --m) {
                varr[verts.size() - 1 - m] = (Point3d)verts.get(m);
            }
        } else {
            verts.toArray(varr);
        }
        return varr;
    }

    public static Path2D.Double toPolygon(Point3d ... points) {
        assert (points.length >= 3);
        Plane3d plane = new Plane3d(points);
        Matrix4d wlXform = Util.getWorldToLocalXform(plane);
        return ShapeUtil.toPolygon(wlXform, points);
    }

    public static Path2D.Double toPolygon(Matrix4d wlXform, Point3d ... points) {
        assert (points.length >= 3);
        Path2D.Double path = ShapeUtil.toPath(wlXform, points);
        path.closePath();
        return path;
    }

    public static Path2D.Double toPolygon(Point2d ... points) {
        assert (points.length >= 3);
        Path2D.Double path = ShapeUtil.toPath(points);
        path.closePath();
        return path;
    }

    public static void appendAsSubPath(Path2D.Double path, List<? extends IParametric2D> segments) {
        if (!segments.isEmpty()) {
            Point2d p1 = segments.get(0).get(0.0);
            path.moveTo(p1.x, p1.y);
            for (IParametric2D iParametric2D : segments) {
                iParametric2D.append(path);
            }
        }
    }

    public static Path2D.Double toPath(List<? extends IParametric2D> segments) {
        Path2D.Double path = new Path2D.Double();
        ShapeUtil.appendAsSubPath(path, segments);
        return path;
    }

    public static Path2D.Double toPath(Matrix4d wlXform, Point3d ... points) {
        Point2d[] points2d = new Point2d[points.length];
        for (int m = 0; m < points.length; ++m) {
            points2d[m] = ShapeUtil.invXform2d(wlXform, points[m]);
        }
        return ShapeUtil.toPath(points2d);
    }

    public static Path2D.Double toPath(Point2d ... points) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(points[0].x, points[0].y);
        for (int m = 1; m < points.length; ++m) {
            Point2d p = points[m];
            path.lineTo(p.x, p.y);
        }
        return path;
    }

    public static void writeShape(ObjectOutputStream oos, Shape a) throws IOException {
        SerShape shape = new SerShape(a);
        oos.writeObject(shape);
    }

    public static Shape readShape(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        SerShape as = (SerShape)ois.readObject();
        return as.getShape();
    }

    public static Arc2D.Double newCircularArc(Point2d p1, Point2d p2, double bulge) {
        double dirby;
        double dirbx;
        double bulgeMag = Math.abs(bulge);
        double distTobx = (p2.x - p1.x) * 0.5;
        double distToby = (p2.y - p1.y) * 0.5;
        if (bulge > 0.0) {
            dirbx = distToby;
            dirby = -distTobx;
        } else {
            dirbx = -distToby;
            dirby = distTobx;
        }
        double bx = p1.x + distTobx;
        double by = p1.y + distToby;
        double db = Math.sqrt(distTobx * distTobx + distToby * distToby);
        double h = db * bulgeMag;
        double radius = Math.abs(0.5 * (h + db / bulgeMag));
        double bisectCenterDist = h - radius;
        Vector2d centerVec = new Vector2d(dirbx, dirby);
        centerVec.normalize();
        centerVec.scale(bisectCenterDist);
        double cx = bx + centerVec.x;
        double cy = by + centerVec.y;
        double angle1 = Util2D.sAngle(1.0, 0.0, p1.x - cx, p1.y - cy);
        double angle2 = Util2D.sAngle(1.0, 0.0, p2.x - cx, p2.y - cy);
        return ShapeUtil.newCircularArc(cx, cy, radius, angle1, angle2, bulge >= 0.0);
    }

    public static Arc2D.Double newCircularArc(double cx, double cy, double radius, double startAngle, double endAngle, boolean ccw) {
        double size = radius + radius;
        return ShapeUtil.newArc(cx, cy, size, size, startAngle, endAngle, ccw);
    }

    public static Arc2D.Double newArc(double cx, double cy, double width, double height, double startAngle, double endAngle, boolean ccw) {
        endAngle = ShapeUtil.adjustAngle2(startAngle, endAngle, ccw);
        startAngle = -Math.toDegrees(startAngle);
        endAngle = -Math.toDegrees(endAngle);
        return new Arc2D.Double(cx - width * 0.5, cy - height * 0.5, width, height, startAngle, endAngle - startAngle, 0);
    }

    private static double adjustAngle2(double angle1, double angle2, boolean ccw) {
        double extent = angle2 - angle1;
        if (angle1 < angle2 && !ccw) {
            extent -= Math.PI * 2;
        } else if (angle1 > angle2 && ccw) {
            extent += Math.PI * 2;
        }
        return angle1 + extent;
    }

    public static Ellipse2D.Double newCircle(double radius) {
        double diam = radius + radius;
        return ShapeUtil.newEllipse(diam, diam);
    }

    public static Ellipse2D.Double newEllipse(double width, double height) {
        return new Ellipse2D.Double(-width * 0.5, -height * 0.5, width, height);
    }

    public static class PolyLineBuilder {
        private final Path2D.Double d_path = new Path2D.Double();

        public Path2D.Double getPath() {
            return this.d_path;
        }

        public void moveTo(Point2d p) {
            this.getPath().moveTo(p.x, p.y);
        }

        public void lineTo(Point2d p) {
            this.getPath().lineTo(p.x, p.y);
        }

        public void bulgeTo(Point2d p, double bulge) {
            Path2D.Double path = this.getPath();
            Point2D currPoint = path.getCurrentPoint();
            Arc2D.Double arc = ShapeUtil.newCircularArc(new Point2d(currPoint.getX(), currPoint.getY()), p, bulge);
            path.append(arc, true);
        }

        public void close() {
            this.getPath().closePath();
        }

        public void clear() {
            this.getPath().reset();
        }
    }
}

