/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.delaunay;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Point2d;

public class Triangles
extends JPanel {
    private static final long serialVersionUID = 2408084301129701635L;
    private Vector<Point2d> d_points = new Vector();
    private Vector<Edge> d_edges = new Vector();
    private Vector<Tri> d_tris = new Vector();
    private AffineTransform d_transform = new AffineTransform();
    private float d_size = 0.0f;

    public static void main(String[] args) {
        System.out.println("Triangle...");
        JFrame frame = new JFrame("Triangle");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        frame.getContentPane().add(new Triangles());
        frame.pack();
        frame.setVisible(true);
    }

    public Triangles() {
        this.readFile();
        this.setPreferredSize(new Dimension(800, 800));
    }

    private void readFile() {
        this.d_points.clear();
        this.d_tris.clear();
        try (BufferedReader file = new BufferedReader(new FileReader("triangle.data"));){
            String line = file.readLine();
            assert (line != null);
            int numVerts = Integer.parseInt(line);
            for (int i = 0; i < numVerts; ++i) {
                line = file.readLine();
                assert (line != null);
                String[] coords = line.split(",");
                double x = Double.parseDouble(coords[0]);
                double y = Double.parseDouble(coords[1]);
                this.d_points.add(new Point2d(x, y));
            }
            line = file.readLine();
            assert (line != null);
            int numTris = Integer.parseInt(line);
            for (int i = 0; i < numTris; ++i) {
                line = file.readLine();
                assert (line != null);
                String[] verts = line.split(" ");
                int v1 = Integer.parseInt(verts[0]);
                int v2 = Integer.parseInt(verts[1]);
                int v3 = Integer.parseInt(verts[2]);
                this.d_tris.add(new Tri(v1, v2, v3));
            }
            while ((line = file.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        Point2d v2;
        Point2d v1;
        int i;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(SystemColor.window);
        g2d.fill(new Rectangle(this.getSize()));
        this.updateTransform();
        Path2D.Double path = new Path2D.Double();
        g2d.setPaint(Color.LIGHT_GRAY);
        for (i = 0; i < this.d_tris.size(); ++i) {
            Tri tri = this.d_tris.get(i);
            v1 = this.d_points.get(tri.p1);
            v2 = this.d_points.get(tri.p2);
            Point2d v3 = this.d_points.get(tri.p3);
            Point2D.Double p1 = new Point2D.Double(v1.x, v1.y);
            Point2D.Double p2 = new Point2D.Double(v2.x, v2.y);
            Point2D.Double p3 = new Point2D.Double(v3.x, v3.y);
            this.d_transform.transform(p1, p1);
            this.d_transform.transform(p2, p2);
            this.d_transform.transform(p3, p3);
            path.moveTo(p1.x, p1.y);
            path.lineTo(p2.x, p2.y);
            path.lineTo(p3.x, p3.y);
            path.lineTo(p1.x, p1.y);
        }
        g2d.fill(path);
        g2d.setColor(Color.RED);
        for (i = 0; i < this.d_edges.size(); ++i) {
            Edge e = this.d_edges.get(i);
            v1 = this.d_points.get(e.p1);
            v2 = this.d_points.get(e.p2);
            Point2D.Double p1 = new Point2D.Double(v1.x, v1.y);
            Point2D.Double p2 = new Point2D.Double(v2.x, v2.y);
            this.d_transform.transform(p1, p1);
            this.d_transform.transform(p2, p2);
            path.moveTo(p1.x, p1.y);
            path.lineTo(p2.x, p2.y);
        }
        g2d.draw(path);
    }

    private void updateTransform() {
        double xmin = 0.0;
        double xmax = 1.0;
        double ymin = 0.0;
        double ymax = 1.0;
        Dimension dim = this.getSize();
        this.d_transform.setToIdentity();
        double scale = Math.min((double)dim.width / (xmax - xmin) / 1.4, (double)dim.height / (ymax - ymin) / 1.4);
        this.d_transform.scale(scale, -scale);
        this.d_transform.translate(-(xmin - 0.2 * (xmax - xmin)), -(ymax + 0.2 * (ymax - ymin)));
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.updateTransform();
        this.d_size = (float)w / 800.0f;
    }

    private void drawCircle(Graphics2D gra, double x, double y, int filled) {
        Arc2D.Double circle = new Arc2D.Double(x - (double)(3.5f * this.d_size), y - (double)(3.5f * this.d_size), 7.0f * this.d_size, 7.0f * this.d_size, 0.0, 360.0, 0);
        if (filled == 0) {
            gra.draw(circle);
        } else {
            gra.fill(circle);
        }
    }

    private static class Tri {
        public int p1;
        public int p2;
        public int p3;

        public Tri(int v1, int v2, int v3) {
            this.p1 = v1;
            this.p2 = v2;
            this.p3 = v3;
        }
    }

    private static class Edge {
        public int p1;
        public int p2;

        public Edge(int v1, int v2) {
            this.p1 = v1;
            this.p2 = v2;
        }
    }
}

