/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.Multiplier;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class MultParser
extends AFDS5Parser {
    public MultParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("MULT");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = rec.getString("ID");
        if (id == null) {
            this.addWarning(rec, Intl.intl("MULT record does not have an ID."), Intl.intl("Adding to the additional records section."));
            return false;
        }
        FDSArray dxb = rec.getArray("DXB", true);
        assert (dxb.getTotalLength() >= 6);
        UnitDouble dx0 = rec.getUnitDouble("DX0", true);
        UnitDouble dy0 = rec.getUnitDouble("DY0", true);
        UnitDouble dz0 = rec.getUnitDouble("DZ0", true);
        Multiplier mult = new Multiplier(id, new UnitPoint3D(dx0, dy0, dz0), new UnitDouble[]{(UnitDouble)dxb.get(0), (UnitDouble)dxb.get(1)}, new UnitDouble[]{(UnitDouble)dxb.get(2), (UnitDouble)dxb.get(3)}, new UnitDouble[]{(UnitDouble)dxb.get(4), (UnitDouble)dxb.get(5)}, rec.getUnitDouble("DX", true), rec.getUnitDouble("DY", true), rec.getUnitDouble("DZ", true), new int[]{rec.getInteger("I_LOWER", true), rec.getInteger("I_UPPER", true)}, new int[]{rec.getInteger("J_LOWER", true), rec.getInteger("J_UPPER", true)}, new int[]{rec.getInteger("K_LOWER", true), rec.getInteger("K_UPPER", true)}, new int[]{rec.getInteger("N_LOWER", true), rec.getInteger("N_UPPER", true)});
        this.getParsingInfo().addMultipler(mult);
        return true;
    }
}

