/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.io.fds.FDSRenderRecord;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.treeview.TVEntryPoints;
import pyrosim.legacy_2012_1.util.Util;

public class QuantityMap {
    public static final String CONTROL = "CONTROL";
    public static final String LINK_TEMPERATURE = "LINK TEMPERATURE";
    public static final String SPOT_OBSCURATION = "spot obscuration";
    public static final String CHAMBER_OBSCURATION = "CHAMBER OBSCURATION";
    public static final String SPRINKLER_LINK_TEMPERATURE = "SPRINKLER LINK TEMPERATURE";
    public static final String ASPIRATION = "ASPIRATION";
    public static final String HEAT_FLOW = "HEAT FLOW";
    public static final String MASS_FLOW = "MASS FLOW";
    public static final String VOLUME_FLOW = "VOLUME FLOW";
    public static final String CABLE_TEMPERATURE = "CABLE TEMPERATURE";
    public static final String FDS_TIME = "TIME";
    private final Map<Quantity, String> d_pyroToFDSMap = new HashMap<Quantity, String>();
    private final Map<String, IQuantity> d_fdsToPyroPredefMap = new HashMap<String, IQuantity>();
    private final Map<String, Quantity> d_fdsToPyroObjMap = new HashMap<String, Quantity>();
    private final List<Pair<String, Quantity>> d_fdsToPyroLegPostfixMap = new ArrayList<Pair<String, Quantity>>();

    public QuantityMap() {
        this.mapPredef(Quantity.ABSORPTION_COEFFICIENT, "ABSORPTION COEFFICIENT", "ABSORPTION_COEFFICIENT");
        this.mapPredef(Quantity.AVERAGE_SPECIFIC_HEAT, "AVERAGE SPECIFIC HEAT");
        this.mapPredef(Quantity.CONDUCTIVITY, "CONDUCTIVITY");
        this.mapPredef(Quantity.DENSITY, "DENSITY");
        this.mapPredef(Quantity.DIVERGENCE, "DIVERGENCE");
        this.mapPredef(Quantity.ENTHALPY, "ENTHALPY");
        this.mapPredef(Quantity.EXTINCTION_COEFFICIENT, "EXTINCTION COEFFICIENT", "extinction coefficient");
        this.mapPredef(Quantity.FED, "FED");
        this.mapPredef(Quantity.H, "H");
        this.mapPredef(Quantity.HRRPUV, "HRRPUV");
        this.mapPredef(Quantity.MIXTURE_FRACTION, "MIXTURE FRACTION", "MIXTURE_FRACTION");
        this.mapPredef(Quantity.OPTICAL_DENSITY, "OPTICAL DENSITY");
        this.mapPredef(Quantity.PRESSURE, "PRESSURE");
        this.mapPredef(Quantity.RADIATIVE_HEAT_FLUX_GAS, "RADIATIVE HEAT FLUX GAS");
        this.mapPredef(Quantity.RELATIVE_HUMIDITY, "RELATIVE HUMIDITY");
        this.mapPredef(Quantity.SPECIFIC_ENTHALPY, "SPECIFIC ENTHALPY");
        this.mapPredef(Quantity.SPECIFIC_HEAT, "SPECIFIC HEAT");
        this.mapPredef(Quantity.TEMPERATURE, "TEMPERATURE");
        this.mapPredef(Quantity.THERMOCOUPLE, "THERMOCOUPLE");
        this.mapPredef(Quantity.U_VELOCITY, "U-VELOCITY");
        this.mapPredef(Quantity.V_VELOCITY, "V-VELOCITY");
        this.mapPredef(Quantity.W_VELOCITY, "W-VELOCITY");
        this.mapPredef(Quantity.VELOCITY, "VELOCITY");
        this.mapPredef(Quantity.VISCOSITY, "VISCOSITY");
        this.mapPredef(Quantity.VISIBILITY, "VISIBILITY", "visibility");
        this.mapPredef(Quantity.ADIABATIC_SURFACE_TEMPERATURE, "ADIABATIC SURFACE TEMPERATURE", "ADIABATIC_SURFACE_TEMPERATURE");
        this.mapPredef(Quantity.BACK_WALL_TEMPERATURE, "BACK WALL TEMPERATURE", "BACK_WALL_TEMPERATURE");
        this.mapPredef(Quantity.BURNING_RATE, "BURNING RATE", "BURNING_RATE");
        this.mapPredef(Quantity.CONVECTIVE_FLUX, "CONVECTIVE HEAT FLUX", "CONVECTIVE_FLUX");
        this.mapPredef(Quantity.GAS_TEMPERATURE, "GAS TEMPERATURE");
        this.mapPredef(Quantity.GAUGE_HEAT_FLUX, "GAUGE HEAT FLUX", "GAUGE_HEAT_FLUX");
        this.mapPredef(Quantity.HEAT_FLUX, "NET HEAT FLUX", "HEAT_FLUX");
        this.mapPredef(Quantity.HEAT_TRANSFER_COEFFICIENT, "HEAT TRANSFER COEFFICIENT", "HEAT_TRANSFER_COEFFICIENT");
        this.mapPredef(Quantity.INCIDENT_HEAT_FLUX, "INCIDENT HEAT FLUX", "INCIDENT_HEAT_FLUX");
        this.mapPredef(Quantity.INSIDE_WALL_TEMPERATURE, "INSIDE WALL TEMPERATURE", "INSIDE_WALL_TEMPERATURE");
        this.mapPredef(Quantity.MASS_LOSS, "MASS LOSS", "MASS_LOSS");
        this.mapPredef(Quantity.NORMAL_VELOCITY, "NORMAL VELOCITY", "NORMAL_VELOCITY");
        this.mapPredef(Quantity.PRESSURE_COEFFICIENT, "PRESSURE COEFFICIENT", "PRESSURE_COEFFICIENT");
        this.mapPredef(Quantity.RADIATIVE_FLUX, "RADIATIVE HEAT FLUX", "RADIATIVE_FLUX");
        this.mapPredef(Quantity.RADIOMETER, "RADIOMETER");
        this.mapPredef(Quantity.SURFACE_DENSITY, "SURFACE DENSITY");
        this.mapPredef(Quantity.WALL_TEMPERATURE, "WALL TEMPERATURE", "WALL_TEMPERATURE");
        this.mapPredef(Quantity.WALL_THICKNESS, "WALL THICKNESS", "WALL_THICKNESS");
        this.mapPredef(Quantity.HEAT_FLOW, HEAT_FLOW);
        this.mapPredef(Quantity.HRR, "HRR");
        this.mapPredef(Quantity.MASS_FLOW, MASS_FLOW);
        this.mapPredef(Quantity.VOLUME_FLOW, VOLUME_FLOW);
        this.mapPredef(Quantity.LAYER_HEIGHT, "LAYER HEIGHT");
        this.mapPredef(Quantity.LOWER_TEMPERATURE, "LOWER TEMPERATURE");
        this.mapPredef(Quantity.PATH_OBSCURATION, "PATH OBSCURATION", "path obscuration");
        this.mapPredef(Quantity.UPPER_TEMPERATURE, "UPPER TEMPERATURE");
        this.mapPredef(Quantity.ACTUATED_SPRINKLERS, "ACTUATED SPRINKLERS");
        this.mapPredef(Quantity.CPU_TIME, "CPU TIME");
        this.mapPredef(Quantity.ITERATION, "ITERATION");
        this.mapPredef(Quantity.OPEN_NOZZLES, "OPEN NOZZLES");
        this.mapPredef(Quantity.PRESSURE_ZONE, "PRESSURE ZONE");
        this.mapPredef(Quantity.TIME, FDS_TIME);
        this.mapPredef(Quantity.TIME_STEP, "TIME STEP");
        this.mapPredef(Quantity.TURBULENCE_RESOLUTION, "TURBULENCE RESOLUTION");
        this.mapPredef(Quantity.WALL_CLOCK_TIME, "WALL CLOCK TIME");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.CARBON_DIOXIDE, Quantity.SPEC_VOLUME_FRACTION), "carbon dioxide");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.CARBON_MONOXIDE, Quantity.SPEC_VOLUME_FRACTION), "carbon monoxide");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.FUEL, Quantity.SPEC_VOLUME_FRACTION), "fuel");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.HYDROGEN, Quantity.SPEC_VOLUME_FRACTION), "hydrogen");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.NITROGEN, Quantity.SPEC_VOLUME_FRACTION), "nitrogen");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.OTHER, Quantity.SPEC_VOLUME_FRACTION), "other");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.OTHER, Quantity.SPEC_MASS_FRACTION), "other mass fraction");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.OXYGEN, Quantity.SPEC_VOLUME_FRACTION), "oxygen");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.OXYGEN, Quantity.SPEC_MASS_FRACTION), "oxygen mass fraction");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.SOOT, Quantity.SPEC_VOLUME_FRACTION), "soot", "soot volume fraction");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.SOOT, Quantity.SPEC_DENSITY), "soot density");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.WATER_VAPOR, Quantity.SPEC_VOLUME_FRACTION), "water vapor");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.WATER_VAPOR, Quantity.SPEC_MASS_FRACTION), "WATER VAPOR", "water vapor mass fraction");
        this.mapObj(Quantity.PART_ACMPUA, "AMPUA", "_AMPUA");
        this.mapObj(Quantity.PART_CPUA, "CPUA", "_CPUA");
        this.mapObj(Quantity.PART_MASS_FLUX_X, "DROPLET FLUX X", "_FLUX_X");
        this.mapObj(Quantity.PART_MASS_FLUX_Y, "DROPLET FLUX Y", "_FLUX_Y");
        this.mapObj(Quantity.PART_MASS_FLUX_Z, "DROPLET FLUX Z", "_FLUX_Z");
        this.mapObj(Quantity.PART_MPUA, "MPUA", "_MPUA");
        this.mapObj(Quantity.PART_MPUV, "MPUV", "_MPUV");
        this.mapObj(Quantity.SPEC_MASS_FLUX, "MASS FLUX");
        this.mapObj(Quantity.SPEC_MASS_FLUX_X, "MASS FLUX X", "_FLUX_X");
        this.mapObj(Quantity.SPEC_MASS_FLUX_Y, "MASS FLUX Y", "_FLUX_Y");
        this.mapObj(Quantity.SPEC_MASS_FLUX_Z, "MASS FLUX Z", "_FLUX_Z");
        this.mapObj(Quantity.SPEC_MASS_FRACTION, "MASS FRACTION");
        this.mapObj(Quantity.SPEC_VOLUME_FRACTION, "VOLUME FRACTION", "_VF");
        this.mapObj(Quantity.SPEC_DENSITY, "DENSITY");
        this.mapObj(Quantity.SPEC_VISIBILITY, "VISIBILITY");
        this.mapObj(Quantity.SPEC_OPTICAL_DENSITY, "OPTICAL DENSITY");
        this.mapObj(Quantity.MATL_SOLID_DENSITY, "SOLID DENSITY");
        this.mapObj(Quantity.HVAC_AIRCOIL_HEAT_EXCHANGE, "AIRCOIL HEAT EXCHANGE");
        this.mapObj(Quantity.HVAC_DUCT_DENSITY, "DUCT DENSITY");
        this.mapObj(Quantity.HVAC_DUCT_MASS_FLOW, "DUCT MASS FLOW");
        this.mapObj(Quantity.HVAC_DUCT_MASS_FRACTION, "DUCT MASS FRACTION");
        this.mapObj(Quantity.HVAC_DUCT_TEMPERATURE, "DUCT TEMPERATURE");
        this.mapObj(Quantity.HVAC_DUCT_VELOCITY, "DUCT VELOCITY");
        this.mapObj(Quantity.HVAC_DUCT_VOLUME_FLOW, "DUCT VOLUME FLOW");
        this.mapObj(Quantity.HVAC_DUCT_VOLUME_FRACTION, "DUCT VOLUME FRACTION");
        this.mapObj(Quantity.HVAC_FILTER_LOADING, "FILTER LOADING");
        this.mapObj(Quantity.HVAC_FILTER_LOSS, "FILTER LOSS");
        this.mapObj(Quantity.HVAC_NODE_DENSITY, "NODE DENSITY");
        this.mapObj(Quantity.HVAC_NODE_MASS_FRACTION, "NODE MASS FRACTION");
        this.mapObj(Quantity.HVAC_NODE_PRESSURE, "NODE PRESSURE");
        this.mapObj(Quantity.HVAC_NODE_TEMPERATURE, "NODE TEMPERATURE");
        this.mapObj(Quantity.HVAC_NODE_VOLUME_FRACTION, "NODE VOLUME FRACTION");
        this.mapObj(Quantity.HVAC_NODE_PRESSURE_DIFFERENCE, "NODE PRESSURE DIFFERENCE");
    }

    private static ObjectQuantity newQuant(ExSpecList.MixFrac mf, Quantity quant) {
        return quant.create(mf.spec);
    }

    private void mapObj(Quantity quantity, String fdsName) {
        this.mapObj(quantity, fdsName, null);
    }

    private void mapObj(Quantity quantity, String fdsName, String optLegPostfix) {
        this.d_fdsToPyroObjMap.put(fdsName, quantity);
        this.d_pyroToFDSMap.put(quantity, fdsName);
        if (optLegPostfix != null) {
            this.d_fdsToPyroLegPostfixMap.add(new Pair<String, Quantity>(optLegPostfix, quantity));
        }
    }

    private void mapPredef(Quantity quantity, String ... fdsNames) {
        assert (quantity.getNumArgs() == 0);
        this.mapPredef(quantity.create(), fdsNames);
    }

    private void mapPredef(IQuantity quantity, String ... fdsNames) {
        for (String fdsName : fdsNames) {
            this.d_fdsToPyroPredefMap.put(fdsName, quantity);
        }
        if (quantity.get().getNumArgs() == 0) {
            this.d_pyroToFDSMap.put(quantity.get(), fdsNames[0]);
        }
    }

    public IQuantity parseQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantKey, String partIdKey, String specIdKey, String matIdKey, String ductIdKey, String nodeIdKey, boolean quantityRequired) throws FDSRecordFormatException {
        String quantName = rec.getString(quantKey);
        if (quantName == null) {
            if (quantityRequired) {
                throw new FDSRecordFormatException(rec, Intl.intl("Quantity missing."));
            }
            return null;
        }
        Object partId = partIdKey == null ? null : rec.get(partIdKey);
        Object specId = specIdKey == null ? null : rec.get(specIdKey);
        Object matId = matIdKey == null ? null : rec.get(matIdKey);
        Object ductId = ductIdKey == null ? null : rec.get(ductIdKey);
        Object nodeId = nodeIdKey == null ? null : rec.get(nodeIdKey);
        return this.parseQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId);
    }

    public IQuantity parseQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId) throws FDSRecordFormatException {
        IQuantity quantity = this.tryParseObjQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId);
        if (quantity != null) {
            return quantity;
        }
        quantity = this.d_fdsToPyroPredefMap.get(quantName);
        if (quantity != null) {
            return quantity;
        }
        for (Pair<String, Quantity> pair : this.d_fdsToPyroLegPostfixMap) {
            int ix = quantName.indexOf((String)pair.v1);
            if (ix <= 0) continue;
            String objName = quantName.substring(0, ix);
            assert (((Quantity)((Object)pair.v2)).requiredTypes.length == 1);
            try {
                IPyroObject obj = this.findObject(parseInfo, rec, ((Quantity)((Object)pair.v2)).requiredTypes[0], ((Quantity)((Object)pair.v2)).typeFilters[0], objName, quantName);
                return ((Quantity)((Object)pair.v2)).create(obj);
            }
            catch (FDSRecordFormatException fDSRecordFormatException) {
            }
        }
        ExSpec spec = parseInfo.findObject(ExSpec.class, quantName);
        if (spec != null) {
            return Quantity.SPEC_MASS_FRACTION.create(spec);
        }
        Material mat = parseInfo.findObject(Material.class, quantName);
        if (mat != null) {
            return Quantity.MATL_DENSITY.create(mat);
        }
        throw new FDSRecordFormatException(rec, String.format(Intl.intl("Unknown quantity: %s"), quantName));
    }

    private IQuantity tryParseObjQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId) throws FDSRecordFormatException {
        Quantity objQuantity = this.d_fdsToPyroObjMap.get(quantName);
        if (objQuantity != null) {
            IQuantity staticQuantity = this.d_fdsToPyroPredefMap.get(quantName);
            boolean argumentsOptional = staticQuantity != null;
            ArrayList<String> missingTypes = new ArrayList<String>();
            ArrayList<IPyroObject> objects = new ArrayList<IPyroObject>(objQuantity.getNumArgs());
            for (int m = 0; m < objQuantity.getNumArgs(); ++m) {
                Class<? extends IPyroObject> type = objQuantity.requiredTypes[m];
                int count = 1;
                for (int n = m + 1; n < objQuantity.getNumArgs() && objQuantity.requiredTypes[n].equals(type); ++n) {
                    ++count;
                }
                Object ids = QuantityMap.getObjVal(type, partId, specId, matId, ductId, nodeId);
                for (int n = 0; n < count; ++n) {
                    if (ids == null) {
                        String typeDesc = TVEntryPoints.ep(type).getCategoryName();
                        missingTypes.add(typeDesc);
                        objects.add(null);
                        continue;
                    }
                    String id = ids instanceof String ? (String)ids : (String)((List)ids).get(n);
                    IPyroObject obj = this.findObject(parseInfo, rec, type, objQuantity.typeFilters[m + n], id, quantName);
                    objects.add(obj);
                }
                m += count;
            }
            if (argumentsOptional && missingTypes.size() == objQuantity.requiredTypes.length) {
                return staticQuantity;
            }
            if (!missingTypes.isEmpty()) {
                String typeDesc = (String)missingTypes.get(0);
                String msg = String.format(Intl.intl("Use of quantity, %1$s, requires a %2$s to be specified."), quantName, typeDesc);
                throw new FDSRecordFormatException(rec, msg);
            }
            assert (objects.size() == objQuantity.requiredTypes.length);
            return objQuantity.create(objects.toArray(new IPyroObject[objects.size()]));
        }
        return null;
    }

    private IPyroObject findObject(FDSParsingInfo parseInfo, FDSParseRecord rec, Class type, IObjectFilter filter, String id, String quantName) throws FDSRecordFormatException {
        String typeDesc = TVEntryPoints.ep(type).getCategoryName();
        Object obj = parseInfo.findObject(type, id);
        if (obj == null) {
            String msg = String.format(Intl.intl("Could not find %1$s, %2$s, needed for quantity, %3$s."), typeDesc, id, quantName);
            throw new FDSRecordFormatException(rec, msg);
        }
        if (filter.shouldFilter(obj)) {
            String msg = String.format(Intl.intl("Invalid %1$s for quantity, %2$s: %3$s"), typeDesc, quantName, filter.toString());
            throw new FDSRecordFormatException(rec, msg);
        }
        return obj;
    }

    public void renderQuantity(FDSRenderRecord rec, String quantKey, String partIdKey, String specIdKey, String matIdKey, String ductIdKey, String nodeIdKey, IQuantity msr) {
        if (msr.get() == Quantity.MATL_DENSITY) {
            rec.setValue(quantKey, Util.getName(((ObjectQuantity)msr).objects[0]));
            return;
        }
        String quantity = this.d_pyroToFDSMap.get((Object)msr.get());
        assert (quantity != null);
        rec.setValue(quantKey, quantity);
        if (msr instanceof ObjectQuantity) {
            int count;
            ObjectQuantity om = (ObjectQuantity)msr;
            Quantity q = msr.get();
            for (int m = 0; m < q.getNumArgs(); m += count) {
                Class<? extends IPyroObject> type = q.requiredTypes[m];
                count = 1;
                for (int n = m + 1; n < q.getNumArgs() && q.requiredTypes[n].equals(type); ++n) {
                    ++count;
                }
                ArrayList<String> ids = new ArrayList<String>(count);
                for (int n = 0; n < count; ++n) {
                    Object obj = om.objects[m + n];
                    ids.add(((INamed)obj).getName());
                }
                String objIdKey = QuantityMap.getObjVal(type, partIdKey, specIdKey, matIdKey, ductIdKey, nodeIdKey);
                if (objIdKey == null || ids.size() <= 0) continue;
                FDSRecordSpec.Field fld = rec.getSpec().fields.get(objIdKey);
                ArrayList<String> objVal = fld instanceof FDSRecordSpec.ListFld ? ids : ids.get(0);
                rec.setValue(objIdKey, objVal);
            }
        }
    }

    public Quantity getQuantity(String quantityName) {
        IQuantity predef = this.d_fdsToPyroPredefMap.get(quantityName);
        if (predef != null) {
            return predef.get();
        }
        return this.d_fdsToPyroObjMap.get(quantityName);
    }

    public String getFDSName(Quantity msr) {
        return this.d_pyroToFDSMap.get((Object)msr);
    }

    private static <T> T getObjVal(Class type, T part, T spec, T mat, T duct, T node) {
        if (ExSpec.class.isAssignableFrom(type)) {
            return spec;
        }
        if (Particle.class.isAssignableFrom(type)) {
            return part;
        }
        if (Material.class.isAssignableFrom(type)) {
            return mat;
        }
        if (HvacNode.class.isAssignableFrom(type)) {
            return node;
        }
        if (HvacDuct.class.isAssignableFrom(type)) {
            return duct;
        }
        return null;
    }
}

