/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.hvac;

import java.util.Arrays;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class HvacFan
extends HvacComponent {
    private static final long serialVersionUID = 5609437954326712322L;
    public static final String OPT_FAN_MODEL = "opt_fan_model";
    public static final Integer FAN_MODEL_VOLFLOW = 0;
    public static final Integer FAN_MODEL_PRESDROP = 1;
    public static final Integer FAN_MODEL_QUADRATIC = 2;
    public TimeFunction d_tauFunc;
    public Ramp d_fanRamp;

    public HvacFan(String id) {
        super(id);
        HvacFan.setDefaults(this);
        this.d_tauFunc = TimeFunction.newDefault();
        this.d_fanRamp = null;
    }

    public static void setDefaults(HvacComponent obj) {
        obj.setProp("TYPE_ID", "FAN");
        obj.setProp("TAU_FAN", null);
        obj.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE)));
        obj.setProp(OPT_FAN_MODEL, FAN_MODEL_QUADRATIC);
        obj.setProp("MAX_FLOW", new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND)));
        obj.setProp("MAX_PRESSURE", new UnitDouble(0.0, SI.PASCAL));
        obj.setProp("RAMP_ID", null);
        obj.setProp("VOLUME_FLOW", new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND)));
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        this.addDep(deps, "RAMP_ID");
    }

    @Override
    public Object clone() {
        HvacFan clone = (HvacFan)super.clone();
        if (this.d_fanRamp != null) {
            try {
                clone.d_fanRamp = (Ramp)this.d_fanRamp.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        clone.d_tauFunc = (TimeFunction)this.d_tauFunc.clone();
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && theUtil.equal(((HvacFan)obj).d_fanRamp, this.d_fanRamp) && theUtil.equal(((HvacFan)obj).d_tauFunc, this.d_tauFunc);
    }
}

