/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.sprayers;

import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.ASprayer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.DryPipe;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class Sprinkler
extends ASprayer
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private LinkModel d_linkModel;
    private DryPipe d_dryPipe;

    public Sprinkler(String name, SprayModel sprayDesc, LinkModel linkModel, FreePointLoc loc) {
        super(name, sprayDesc, loc);
        this.d_linkModel = linkModel;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Sprinkler)) {
            return false;
        }
        Sprinkler sprk = (Sprinkler)obj;
        return super.equals(obj) && this.d_linkModel.equals(sprk.d_linkModel) && theUtil.equal(this.d_dryPipe, sprk.d_dryPipe);
    }

    public DryPipe getDryPipe() {
        return this.d_dryPipe;
    }

    public void setDryPipe(DryPipe pipe) {
        this.d_dryPipe = pipe;
        this.changedEvt(new Object[0]);
    }

    public LinkModel getLinkModel() {
        return this.d_linkModel;
    }

    public void setLinkModel(LinkModel linkModel) {
        this.d_linkModel = linkModel;
        this.changedEvt(new Object[0]);
    }

    public Task taskSetLinkModel(LinkModel linkModel) {
        return new AReplaceRefTask<LinkModel>((Object)this.d_linkModel, (Object)linkModel){

            @Override
            protected void set(LinkModel obj) {
                Sprinkler.this.setLinkModel(obj);
            }
        };
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        if (this.d_linkModel instanceof TraditionalModel) {
            deps.add(DLink.STRONG, (IPyroObject)((TraditionalModel)this.d_linkModel).d_link);
        } else {
            QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, ((QuantityModel)this.d_linkModel).d_quantity);
        }
        deps.add(DLink.WEAK, (IPyroObject)this.d_dryPipe);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof SprinklerLinkModel) {
            Util.removeAllNotOfType(objs, SprinklerLinkModel.class);
        } else if (old instanceof DryPipe) {
            Util.removeAllNotOfType(objs, DryPipe.class);
        } else if (this.d_linkModel instanceof QuantityModel && QuantityUtil.isQuantityRef(old, ((QuantityModel)this.d_linkModel).d_quantity)) {
            QuantReplacer replacer = new QuantReplacer();
            replacer.removeInvalidReplacements(old, objs, ((QuantityModel)this.d_linkModel).d_quantity);
        } else {
            super.removeInvalidReplacements(old, objs);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof SprinklerLinkModel) {
            assert (replacement != null);
            TraditionalModel newModel = new TraditionalModel((SprinklerLinkModel)replacement);
            return this.taskSetLinkModel(newModel);
        }
        if (old instanceof DryPipe) {
            return new AReplaceRefTask<DryPipe>((Object)old, (Object)replacement){

                @Override
                protected void set(DryPipe obj) {
                    Sprinkler.this.setDryPipe(obj);
                }
            };
        }
        if (this.d_linkModel instanceof QuantityModel && QuantityUtil.isQuantityRef(old, ((QuantityModel)this.d_linkModel).d_quantity)) {
            QuantReplacer replacer = new QuantReplacer();
            return replacer.taskReplaceDep(old, replacement, ((QuantityModel)this.d_linkModel).d_quantity);
        }
        return super.taskReplaceDep(old, replacement);
    }

    public static class QuantityModel
    extends LinkModel {
        static final long serialVersionUID = 1L;
        public final IQuantity d_quantity;
        public final UnitDouble d_setPoint;

        public QuantityModel(IQuantity quantity, UnitDouble setPoint) {
            this(quantity, setPoint, false, true);
        }

        public QuantityModel(IQuantity quantity, UnitDouble setPoint, boolean initState, boolean latch) {
            super(initState, latch);
            this.d_quantity = quantity;
            this.d_setPoint = setPoint;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof QuantityModel)) {
                return false;
            }
            QuantityModel mod = (QuantityModel)obj;
            return this.d_quantity.equals(mod.d_quantity) && this.d_setPoint.equals(mod.d_setPoint);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 1647607715 + this.d_quantity.hashCode() + this.d_setPoint.hashCode();
        }

        public static int getOutputType() {
            return 1;
        }

        public static QuantityType getQuantityType() {
            return QuantityType.GAS;
        }

        public static IObjectFilter<Quantity> getQuantityFilter() {
            return new QuantityUtil.TypeFilter(QuantityModel.getOutputType(), new QuantityType[]{QuantityModel.getQuantityType()}){

                @Override
                public boolean shouldFilter(Quantity o) {
                    if (o == Quantity.TIME) {
                        return false;
                    }
                    return super.shouldFilter(o);
                }
            };
        }
    }

    public static class TraditionalModel
    extends LinkModel {
        static final long serialVersionUID = 1L;
        public final SprinklerLinkModel d_link;

        public TraditionalModel(SprinklerLinkModel link) {
            this(link, false, true);
        }

        public TraditionalModel(SprinklerLinkModel link, boolean initState, boolean latch) {
            super(initState, latch);
            this.d_link = link;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof TraditionalModel && this.d_link.equals(((TraditionalModel)obj).d_link);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 864318175 + this.d_link.hashCode();
        }
    }

    public static abstract class LinkModel
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final boolean d_initState;
        public final boolean d_latch;

        public LinkModel(boolean initState, boolean latch) {
            this.d_initState = initState;
            this.d_latch = latch;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LinkModel)) {
                return false;
            }
            LinkModel model = (LinkModel)obj;
            return this.d_initState == model.d_initState && this.d_latch == model.d_latch;
        }

        public int hashCode() {
            return 9602042 + theUtil.hashCode(this.d_initState) + theUtil.hashCode(this.d_latch);
        }
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Sprinkler.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            Unit newUnit;
            assert (newMsr != null);
            QuantityModel oldMod = (QuantityModel)Sprinkler.this.d_linkModel;
            Unit oldUnit = oldMod.d_setPoint.getUnit();
            UnitDouble newsp = pyrosim.legacy_2012_1.domain.signals.Util.areCompatible(oldUnit, newUnit = SIUS.unit(newMsr.get().unitType)) ? oldMod.d_setPoint : new UnitDouble(oldMod.d_setPoint.getValueNoUnit(), newUnit);
            QuantityModel newModel = new QuantityModel(newMsr, newsp);
            return Sprinkler.this.taskSetLinkModel(newModel);
        }
    }
}

