/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import pyrosim.legacy_2006_2.thunderheadeng.util.AbstractValueRange;

public final class DoubleValueRange
extends AbstractValueRange<Double>
implements Serializable {
    static final long serialVersionUID = 1L;

    private DoubleValueRange(double min, double max, boolean checkMin, boolean checkMax, boolean minInclusive, boolean maxInclusive) {
        super(min, max, checkMin, checkMax, minInclusive, maxInclusive);
    }

    public static DoubleValueRange createUncheckedRange() {
        return new DoubleValueRange(0.0, 0.0, false, false, false, false);
    }

    public static DoubleValueRange createCheckedMin(double min, boolean inclusive) {
        return new DoubleValueRange(min, 0.0, true, false, inclusive, false);
    }

    public static DoubleValueRange createCheckedMax(double max, boolean inclusive) {
        return new DoubleValueRange(0.0, max, false, true, false, inclusive);
    }

    public static DoubleValueRange createCheckedMinAndMax(double min, double max, boolean minInclusive, boolean maxInclusive) {
        return new DoubleValueRange(min, max, true, true, minInclusive, maxInclusive);
    }

    private double getClampOffset() {
        if (this.checksMin() && this.checksMax()) {
            double diff = (Double)this.getMaxValue() - (Double)this.getMinValue();
            return diff * 1.0E-6;
        }
        return 0.01;
    }

    @Override
    public String getDataType() {
        return "floating-point number";
    }

    @Override
    public String format(Object value) {
        Double dVal = (Double)value;
        if ((double)dVal.intValue() == dVal) {
            return dVal.intValue() + ".0";
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        df.applyPattern("##0.0####E0##");
        return df.format(value);
    }

    @Override
    protected Double clampMaxUnincl(Double val) {
        if (this.checksMin() && this.checksMax() && ((Double)this.getMinValue()).equals(this.getMaxValue())) {
            return null;
        }
        return (Double)this.getMaxValue() - this.getClampOffset();
    }

    @Override
    protected Double clampMinUnincl(Double val) {
        if (this.checksMin() && this.checksMax() && ((Double)this.getMinValue()).equals(this.getMaxValue())) {
            return null;
        }
        return (Double)this.getMinValue() + this.getClampOffset();
    }
}

