/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class guiComboBox
extends JComboBox
implements Modifiable,
Validateable {
    private static final long serialVersionUID = -2137489260497858960L;
    private ValueRange d_range = IntValueRange.createUncheckedRange();
    private boolean d_modified = false;

    public guiComboBox() {
        this.init(null);
    }

    public guiComboBox(Object[] items) {
        super(items);
        this.init(null);
    }

    public guiComboBox(Vector items) {
        super(items);
        this.init(null);
    }

    public guiComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.init(null);
    }

    private void init(ValueRange vr) {
        this.setControls();
        this.attachModifiedListener();
    }

    public void setRange(ValueRange vr) {
        this.d_range = vr;
    }

    private void attachModifiedListener() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                guiComboBox.this.d_modified = true;
            }
        });
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    public void setItems(Object[] items) {
        this.setModel(new DefaultComboBoxModel<Object>(items));
    }

    private void setControls() {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width, 24);
    }

    @Override
    public boolean validateData() {
        if (!this.isEnabled() || !this.d_range.checksMax() && !this.d_range.checksMin()) {
            return true;
        }
        int value = 0;
        try {
            value = Integer.parseInt(this.getSelectedItem().toString());
        }
        catch (NumberFormatException e) {
            String msg = "The entry \"" + this.getSelectedItem().toString() + "\" is invalid.\n" + "Please enter " + this.d_range.describeRange() + ".";
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        if (!this.d_range.checkValue(value)) {
            String msg = "The entry \"" + this.getSelectedItem().toString() + "\" is invalid.\n" + "Please enter " + this.d_range.describeRange() + ".";
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    protected void showMessageBox(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Invalid Entry", 2);
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiComboBox.this.requestFocus();
            }
        });
    }
}

