/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.HashSet;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class MiscProcessor
extends AFDSRecordProcessor {
    private static final HashSet<String> d_supportedFields;

    public MiscProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "MISC";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        if (!"MISC".equals(rec.getType())) {
            return false;
        }
        FDSRecordFormatException caughtExc = null;
        boolean err = false;
        try {
            String defaultMatKey;
            PyroMod.MiscRecord misc = this.getContainer().getMiscManager().getMiscRecord();
            String reactionKey = (String)rec.getValue("REACTION");
            if (reactionKey != null) {
                Reaction reaction = this.getResource(reactionKey, Reaction.class);
                if (reaction == null) {
                    throw new FDSRecordFormatException(rec, "The specified reaction, \"" + reactionKey + ",\" does not exist.");
                }
                misc.taskSetReaction(reactionKey).run();
            }
            if ((defaultMatKey = (String)rec.getValue("SURF_DEFAULT")) != null) {
                Material defMat = this.getResource(defaultMatKey, Material.class);
                if (defMat == null) {
                    throw new FDSRecordFormatException(rec, "The specified default surface, \"" + defaultMatKey + ",\" does not exist.");
                }
                this.getParsingInfo().setDefaultMaterial(defMat);
            }
            Unit time = FdsSISystem.getInstance().getTimeUnit();
            Unit atmTempLapseUnit = FdsSISystem.getInstance().getAtmGradUnit();
            Unit temperature = FdsSISystem.getInstance().getTempUnit();
            Unit ambPressUnit = FdsSISystem.getInstance().getAmbientPressureUnit();
            Unit vel = FdsSISystem.getInstance().getVelocityUnit();
            Unit accel = FdsSISystem.getInstance().getAccelUnit();
            misc.setRestart(rec.extractBoolean("RESTART", misc.getRestart()));
            misc.setDtcore(rec.extractDouble("DTCORE", time, misc.getDtcore(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("DTCORE")));
            misc.setAutoMFAdjust(rec.extractBoolean("AUTOMATIC_Z", misc.getAutoMFAdjust()));
            misc.setGPFSuppress(rec.extractBoolean("SUPPRESSION", misc.getGPFSuppress()));
            misc.setAtmTempLapse(rec.extractDouble("DT0DZ", atmTempLapseUnit, misc.getAtmTempLapse(), null));
            misc.setAmbientTemp(rec.extractDouble("TMPA", temperature, misc.getAmbientTemp(), null));
            misc.setAmbientPressure(rec.extractDouble("PINF", ambPressUnit, misc.getAmbientPressure(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("PINF")));
            misc.setOutsideTemp(rec.extractDouble("TMPO", temperature, misc.getOutsideTemp(), null));
            if (rec.getValue("U0") != null || rec.getValue("V0") != null || rec.getValue("W0") != null) {
                UnitDouble initVelX = rec.extractDouble("U0", vel, misc.getInitVel() != null ? misc.getInitVel().xu() : FDSInputRecord.DEF_INIT_VEL.xu(), null);
                UnitDouble initVelY = rec.extractDouble("V0", vel, misc.getInitVel() != null ? misc.getInitVel().yu() : FDSInputRecord.DEF_INIT_VEL.yu(), null);
                UnitDouble initVelZ = rec.extractDouble("W0", vel, misc.getInitVel() != null ? misc.getInitVel().zu() : FDSInputRecord.DEF_INIT_VEL.zu(), null);
                misc.setInitVel(new UnitPoint3D(initVelX.getValue(vel), initVelY.getValue(vel), initVelZ.getValue(vel), vel));
            }
            misc.setNumFrames(rec.extractInt("NFRAMES", misc.getNumFrames(), (IntValueRange)PyroMod.MiscRecord.getValueRange("NFRAMES")));
            misc.setCharVel(rec.extractDouble("CHARACTERISTIC_VELOCITY", vel, misc.getCharVel(), null));
            misc.setGaugeTemp(rec.extractDouble("GAUGE_TEMPERATURE", temperature, misc.getGaugeTemp(), null));
            misc.setPorousFloor(rec.extractBoolean("POROUS_FLOOR", misc.getPorousFloor()));
            misc.setSprkDtspar(rec.extractDouble("DTSPAR", time, misc.getSprkDtspar(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("DTSPAR")));
            misc.setPartDtsam(rec.extractDouble("DTSAM_PART", time, misc.getPartDtsam(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("DTSAM_PART")));
            misc.setPartDtpar(rec.extractDouble("DTPAR", time, misc.getPartDtpar(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("DTPAR")));
            if (rec.getValue("NPPS") != null) {
                int npps = rec.extractInt("NPPS", -1, (IntValueRange)PyroMod.MiscRecord.getValueRange("NPPS"));
                misc.setPartNpps(new UnitDouble(npps, time));
            }
            misc.setPartMaxDrop(rec.extractInt("MAXIMUM_DROPLETS", misc.getPartMaxDrop(), (IntValueRange)PyroMod.MiscRecord.getValueRange("MAXIMUM_DROPLETS")));
            misc.setSmag(rec.extractDouble("CSMAG", misc.getSmag(), (DoubleValueRange)PyroMod.MiscRecord.getValueRange("CSMAG")));
            misc.setSchmidt(rec.extractDouble("SC", misc.getSchmidt(), (DoubleValueRange)PyroMod.MiscRecord.getValueRange("SC")));
            misc.setPrandtl(rec.extractDouble("PR", misc.getPrandtl(), (DoubleValueRange)PyroMod.MiscRecord.getValueRange("PR")));
            misc.setIsothermal(rec.extractBoolean("ISOTHERMAL", misc.getIsothermal()));
            boolean radSolverOff = misc.getRadSolverOff();
            if (!misc.getIsothermal()) {
                radSolverOff = !rec.extractBoolean("RADIATION", !misc.getRadSolverOff());
            }
            misc.setRadSolverOff(radSolverOff);
            misc.setIncompressible(rec.extractBoolean("INCOMPRESSIBLE", misc.getIncompressible()));
            misc.setSmokeOff(!rec.extractBoolean("SMOKE3D", !misc.getSmokeOff()));
            int simType = misc.getSimulationType();
            Boolean b = (Boolean)rec.getValue("DNS");
            if (b != null) {
                simType = 1;
            }
            misc.setSimulationType(simType);
            int baroclinic = misc.getBaroclinic();
            b = (Boolean)rec.getValue("BAROCLINIC");
            if (b != null && b == Boolean.TRUE) {
                baroclinic = 1;
            }
            misc.setBaroclinic(baroclinic);
            Vector v = (Vector)rec.getValue("GVEC");
            if (v != null) {
                misc.setGvec(new UnitPoint3D((Double)v.elementAt(0), (Double)v.elementAt(1), (Double)v.elementAt(2), accel));
            }
            this.flagPyroTypeAffected(PyroMod.MiscRecord.class);
            boolean unsupportedFields = false;
            String[] keys = rec.getKeys();
            for (int m = 0; m < keys.length; ++m) {
                if (d_supportedFields.contains(keys[m])) {
                    rec.removeValue(keys[m]);
                    continue;
                }
                unsupportedFields = true;
            }
            return !unsupportedFields;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            err = true;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            err = true;
        }
        catch (FDSRecordFormatException e) {
            e.printStackTrace();
            err = true;
            caughtExc = e;
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
    }

    static {
        String[] supportedFields = new String[]{"DATABASE", "DATABASE_DIRECTORY", "RESTART", "DTCORE", "REACTION", "AUTOMATIC_Z", "SUPPRESSION", "DT0DZ", "TMPA", "PINF", "TMPO", "U0", "V0", "W0", "NFRAMES", "CHARACTERISTIC_VELOCITY", "GAUGE_TEMPERATURE", "POROUS_FLOOR", "DTSPAR", "DTSAM_PART", "DTPAR", "NPPS", "MAXIMUM_DROPLETS", "DNS", "ISOTHERMAL", "INCOMPRESSIBLE", "RADIATION", "CSMAG", "SC", "PR", "SMOKE3D", "BAROCLINIC", "GVEC", "SURF_DEFAULT", "RENDER_FILE"};
        d_supportedFields = new HashSet<String>(new VectorFromArray<String>(supportedFields));
    }
}

