/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSInputRecordDebugInfo;

public class FDSRecordFormatException
extends Exception {
    private static final long serialVersionUID = -2463984113898547256L;
    String d_sErrorMessage = "";

    public FDSRecordFormatException(String error) {
        super("Invalid record format.");
        this.constructErrorMessage(null, error);
    }

    public FDSRecordFormatException(FDSInputRecord rec) {
        super("Invalid " + rec.getType() + " record format.");
        this.constructErrorMessage(rec, null);
    }

    public FDSRecordFormatException(FDSInputRecord rec, String error) {
        super("Invalid " + rec.getType() + " record format.");
        this.constructErrorMessage(rec, error);
    }

    private void constructErrorMessage(FDSInputRecord rec, String error) {
        String message = "";
        if (rec != null) {
            message = "Invalid " + rec.getType() + " record specified";
            FDSInputRecordDebugInfo debugInfo = rec.getDebugInfo();
            if (debugInfo != null) {
                int beginLine = debugInfo.getBeginLineNum();
                int endLine = debugInfo.getEndLineNum();
                if (beginLine > 0 && endLine > 0) {
                    message = beginLine == endLine ? message + " on line " + beginLine : message + " on lines " + beginLine + " through " + endLine;
                }
            }
            if (debugInfo != null && debugInfo.getFilename() != null) {
                message = message + " in the file,\n" + debugInfo.getFilename();
            }
            message = message + ".";
            if (debugInfo != null && debugInfo.getOriginalText() != null) {
                message = message + "\n\n\"" + debugInfo.getOriginalText() + "\"\n";
            }
            if (error != null) {
                message = message + "\n" + error;
            }
        } else {
            message = super.getMessage();
        }
        this.d_sErrorMessage = message;
    }

    @Override
    public String getMessage() {
        return this.d_sErrorMessage;
    }
}

