/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class PyroDomainEvent<C, E>
extends ADomainEvent {
    public static final int SELECTION_CHANGED = 0;
    public static final int VISIBILITY_CHANGED = 1;
    public static final int OBJECT_ORDER_CHANGED = 2;
    public static final int OBJECT_ADDED = 3;
    public static final int OBJECT_REMOVED = 4;
    public static final int OBJECT_CHANGED = 5;
    protected static final String[] TYPE_DESC = new String[]{"Selection Changed", "Visibility Changed", "Object Order Changed", "Added", "Removed", "Modified"};
    private Set<E> d_objects = new HashSet();
    private Map<C, Set<E>> d_parentChildMap;
    private final int d_eventType;
    private final Class<E> d_objType;

    public PyroDomainEvent(E obj, Class<E> objType, int eventType) {
        this(new VectorFromArray<E>(obj), objType, eventType);
    }

    public PyroDomainEvent(E[] objects, Class<E> objType, int eventType) {
        this(new VectorFromArray<E>(objects), objType, eventType);
    }

    public PyroDomainEvent(Collection<? extends E> objects, Class<E> objType, int eventType) {
        assert (eventType != 3 && eventType != 4);
        this.d_objects.addAll(objects);
        this.d_eventType = eventType;
        this.d_objType = objType;
    }

    public PyroDomainEvent(C parent, E child, Class<E> objType, int eventType) {
        this(parent, Arrays.asList(child), objType, eventType);
    }

    public PyroDomainEvent(C parent, Collection<? extends E> children, Class<E> objType, int eventType) {
        this.d_objType = objType;
        this.d_eventType = eventType;
        this.d_parentChildMap = new HashMap<C, Set<E>>();
        this.d_parentChildMap.put(parent, new HashSet<E>(children));
        this.d_objects.addAll(children);
    }

    private void mergeParentChildMapWithExisting(Map<C, Set<E>> parentToChildMap) {
        for (Map.Entry<C, Set<E>> entry : parentToChildMap.entrySet()) {
            C parent = entry.getKey();
            Collection addedChildren = entry.getValue();
            HashSet children = this.d_parentChildMap.get(parent);
            if (children == null) {
                children = (HashSet)((HashSet)addedChildren).clone();
                this.d_parentChildMap.put(parent, children);
            } else {
                children.addAll(addedChildren);
            }
            this.d_objects.addAll(addedChildren);
        }
    }

    private void removeParentChildMapWithExisting(Map<C, Set<E>> parentToChildMap) {
        for (Map.Entry<C, Set<E>> entry : parentToChildMap.entrySet()) {
            C otherParent = entry.getKey();
            Collection otherChildren = entry.getValue();
            Collection thisChildren = this.d_parentChildMap.get(otherParent);
            if (thisChildren == null) continue;
            thisChildren.removeAll(otherChildren);
            if (!thisChildren.isEmpty()) continue;
            this.d_parentChildMap.remove(otherParent);
        }
        this.rebuildAffectedObjects();
    }

    private void cancelParentChildMapWithExisting(PyroDomainEvent<C, E> event) {
        boolean clearEmptyParents = false;
        for (Map.Entry<C, Set<E>> entry : event.d_parentChildMap.entrySet()) {
            C otherParent = entry.getKey();
            Collection otherChildren = entry.getValue();
            Collection thisChildren = this.d_parentChildMap.get(otherParent);
            if (thisChildren == null) continue;
            ArrayList childrenRemovedFromThis = new ArrayList(otherChildren.size());
            for (Object otherChild : otherChildren) {
                if (!thisChildren.remove(otherChild)) continue;
                childrenRemovedFromThis.add(otherChild);
                clearEmptyParents = true;
            }
            otherChildren.removeAll(childrenRemovedFromThis);
        }
        if (clearEmptyParents) {
            this.clearEmptyParents();
            super.clearEmptyParents();
        }
    }

    private void clearEmptyParents() {
        HashMap<C, Set<E>> newParentToChildMapThis = new HashMap<C, Set<E>>(this.d_parentChildMap.size());
        for (Map.Entry<C, Set<E>> entry : this.d_parentChildMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            newParentToChildMapThis.put(entry.getKey(), entry.getValue());
        }
        this.d_parentChildMap = newParentToChildMapThis;
        this.rebuildAffectedObjects();
    }

    private void rebuildAffectedObjects() {
        HashSet newObjects = new HashSet(this.d_objects.size());
        for (Map.Entry<C, Set<E>> entry : this.d_parentChildMap.entrySet()) {
            newObjects.addAll(entry.getValue());
        }
        this.d_objects = newObjects;
    }

    @Override
    public IDomainEvent.MergeResult merge(IDomainEvent nextEvent) {
        PyroDomainEvent evt;
        if (nextEvent instanceof PyroDomainEvent && this.d_objType.isAssignableFrom((evt = (PyroDomainEvent)nextEvent).getObjectType())) {
            this.merge(evt);
            if (this.d_objects.isEmpty() && evt.d_objects.isEmpty()) {
                return IDomainEvent.MergeResult.keepNeither();
            }
            if (this.d_objects.isEmpty()) {
                return IDomainEvent.MergeResult.keepNext();
            }
            if (evt.d_objects.isEmpty()) {
                return IDomainEvent.MergeResult.keepCurrent();
            }
        }
        return IDomainEvent.MergeResult.keepBoth();
    }

    private void merge(PyroDomainEvent<C, E> nextEvent) {
        block0 : switch (this.getEventType()) {
            case 3: {
                switch (nextEvent.getEventType()) {
                    case 0: 
                    case 1: 
                    case 5: {
                        nextEvent.d_objects.removeAll(this.d_objects);
                        break;
                    }
                    case 3: {
                        if (nextEvent.d_objects.size() <= this.d_objects.size()) {
                            this.mergeParentChildMapWithExisting(nextEvent.d_parentChildMap);
                            nextEvent.d_objects.clear();
                            nextEvent.d_parentChildMap.clear();
                            break;
                        }
                        super.mergeParentChildMapWithExisting(this.d_parentChildMap);
                        this.d_objects.clear();
                        this.d_parentChildMap.clear();
                        break;
                    }
                    case 4: {
                        this.cancelParentChildMapWithExisting(nextEvent);
                    }
                }
                break;
            }
            case 4: {
                switch (nextEvent.getEventType()) {
                    case 0: 
                    case 1: 
                    case 5: {
                        break;
                    }
                    case 3: {
                        this.cancelParentChildMapWithExisting(nextEvent);
                        break;
                    }
                    case 4: {
                        if (nextEvent.d_objects.size() <= this.d_objects.size()) {
                            this.mergeParentChildMapWithExisting(nextEvent.d_parentChildMap);
                            nextEvent.d_objects.clear();
                            nextEvent.d_parentChildMap.clear();
                            break;
                        }
                        super.mergeParentChildMapWithExisting(this.d_parentChildMap);
                        this.d_objects.clear();
                        this.d_parentChildMap.clear();
                    }
                }
                break;
            }
            case 0: 
            case 1: 
            case 5: {
                switch (nextEvent.getEventType()) {
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        this.d_objects.removeAll(nextEvent.d_objects);
                        break block0;
                    }
                }
                if (this.getEventType() != nextEvent.getEventType()) break;
                if (this.d_objects.size() > nextEvent.d_objects.size()) {
                    this.d_objects.addAll(nextEvent.d_objects);
                    nextEvent.d_objects.clear();
                    break;
                }
                nextEvent.d_objects.addAll(this.d_objects);
                this.d_objects.clear();
                break;
            }
            default: {
                if (this.getEventType() != nextEvent.getEventType()) break;
                if (this.d_objects.size() > nextEvent.d_objects.size()) {
                    this.d_objects.addAll(nextEvent.d_objects);
                    nextEvent.d_objects.clear();
                    break;
                }
                nextEvent.d_objects.addAll(this.d_objects);
                this.d_objects.clear();
            }
        }
    }

    public int getEventType() {
        return this.d_eventType;
    }

    public Class<E> getObjectType() {
        return this.d_objType;
    }

    public Collection<E> getObjects() {
        return this.d_objects;
    }

    public Map<C, Set<E>> getParentChildMap() {
        return this.d_parentChildMap;
    }

    public String toString() {
        return this.d_objType.getSimpleName() + "DomainEvent: " + TYPE_DESC[this.getEventType()] + " (" + this.d_objects.size() + " objects)";
    }
}

