/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.TransformTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class TranslateTask
extends TransformTask {
    private final UnitPoint3D d_offset;

    public TranslateTask(PyroMod mediator, Collection<? extends FDSObject> objects, int mode, int n, UnitPoint3D offset) {
        super(mediator, objects, mode, n);
        this.d_offset = (UnitPoint3D)offset.clone();
    }

    @Override
    protected Object getXFormForIteration(int i) {
        Point3d offset = this.d_offset.getValue(SI.METER).getP3d();
        offset.scale(i);
        Transform xform = new Transform();
        xform.d_offset = new UnitPoint3D(offset, (Unit)SI.METER);
        return xform;
    }

    @Override
    protected Task taskTransformObject(FDSObject o, Object xform) {
        assert (xform instanceof Transform);
        return o.taskTranslateObject(((Transform)xform).d_offset);
    }

    private static class Transform {
        private UnitPoint3D d_offset;

        private Transform() {
        }
    }
}

