/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.TransformTask;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class RotateTask
extends TransformTask {
    private final UnitPoint3D d_base;
    private final Vector3d d_rotateAxis;
    private final Unit d_angleUnit = SI.RADIAN;
    private final double d_angle;

    public RotateTask(PyroMod mediator, Collection<? extends FDSObject> objects, int mode, int n, UnitPoint3D base, Vector3d rotateAxis, UnitDouble angle) {
        super(mediator, objects, mode, n);
        this.d_base = (UnitPoint3D)base.clone();
        this.d_rotateAxis = new Vector3d(rotateAxis);
        this.d_angle = angle.getValue(this.d_angleUnit);
    }

    @Override
    protected Object getXFormForIteration(int i) {
        Transform xform = new Transform();
        xform.d_angle = new UnitDouble(this.d_angle * (double)i, this.d_angleUnit);
        return xform;
    }

    @Override
    protected Task taskTransformObject(FDSObject o, Object xform) {
        assert (xform instanceof Transform);
        return o.taskRotateObject(this.d_base, this.d_rotateAxis, ((Transform)xform).d_angle);
    }

    private static class Transform {
        private UnitDouble d_angle;

        private Transform() {
        }
    }
}

