/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class RadiRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    private static final long serialVersionUID = 1L;
    public static final String RADI = "RADI";
    public static final String ANGLE_INCREMENT = "ANGLE_INCREMENT";
    public static final String CH4_BANDS = "CH4_BANDS";
    public static final String KAPPA0 = "KAPPA0";
    public static final String NMIEANG = "NMIEANG";
    public static final String NUMBER_RADIATION_ANGLES = "NUMBER_RADIATION_ANGLES";
    public static final String PATH = "PATH";
    public static final String RADTMP = "RADTMP";
    public static final String TIME_STEP_INCREMENT = "TIME_STEP_INCREMENT";
    public static final String WIDE_BAND_MODEL = "WIDE_BAND_MODEL";
    public static final Map DEFAULT = new Hashtable();
    private final Map d_defaults;
    private final Map d_values;

    public RadiRecord(Map defaults) {
        this.d_defaults = defaults;
        this.d_values = new Hashtable(this.d_defaults);
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord radiRec = this.toRecord();
        if (radiRec.getKeys().length == 0) {
            return;
        }
        recs.add(this.toRecord());
    }

    public void imprint(RadiRecord rec, boolean purify) {
        if (purify) {
            this.d_values.clear();
            this.d_defaults.clear();
        }
        this.d_values.putAll(rec.d_values);
        this.d_defaults.putAll(rec.d_defaults);
        PyroDomainEvent evt = new PyroDomainEvent(this, RadiRecord.class, 5);
        this.fireDomainEvent(evt);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RadiRecord)) {
            return false;
        }
        RadiRecord rec = (RadiRecord)obj;
        return this.d_values.equals(rec.d_values) && this.d_defaults.equals(rec.d_defaults);
    }

    public FDSInputRecord toRecord() {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType(RADI);
        this.addIfSet(ANGLE_INCREMENT, rec);
        this.addIfSet(CH4_BANDS, rec);
        this.addIfSet(KAPPA0, rec);
        this.addIfSet(NMIEANG, rec);
        this.addIfSet(NUMBER_RADIATION_ANGLES, rec);
        this.addIfSet(PATH, rec);
        this.addIfSet(RADTMP, rec);
        this.addIfSet(TIME_STEP_INCREMENT, rec);
        this.addIfSet(WIDE_BAND_MODEL, rec);
        return rec;
    }

    public boolean getBool(String key) {
        return (Boolean)this.d_values.get(key);
    }

    public int getInt(String key) {
        return (Integer)this.d_values.get(key);
    }

    public UnitDouble getUD(String key) {
        return (UnitDouble)this.d_values.get(key);
    }

    public RadiRecord set(String key, Object val) {
        this.d_values.put(key, val);
        PyroDomainEvent evt = new PyroDomainEvent(this, RadiRecord.class, 5);
        this.fireDomainEvent(evt);
        return this;
    }

    private boolean isSet(String key) {
        return !this.d_values.get(key).equals(this.d_defaults.get(key));
    }

    private FDSInputRecord addIfSet(String key, FDSInputRecord rec) {
        if (this.isSet(key)) {
            Double val;
            if (key.equals(KAPPA0)) {
                Unit uKappa = FdsSISystem.getInstance().getKappa0Unit();
                val = ((UnitDouble)this.d_values.get(key)).getValue(uKappa);
            } else if (key.equals(RADTMP)) {
                Unit uTemp = FdsSISystem.getInstance().getTempUnit();
                val = ((UnitDouble)this.d_values.get(key)).getValue(uTemp);
            } else if (key.equals(PATH)) {
                Unit uLen = FdsSISystem.getInstance().getLengthUnit();
                val = ((UnitDouble)this.d_values.get(key)).getValue(uLen);
            } else {
                val = this.d_values.get(key);
            }
            rec.setValue(key, val);
        }
        return rec;
    }

    @Override
    public String getFDSType() {
        return RADI;
    }

    @Override
    public String getTypeDescription() {
        return "RADI Record";
    }

    static {
        FdsSISystem uSys = FdsSISystem.getInstance();
        DEFAULT.put(ANGLE_INCREMENT, 5);
        DEFAULT.put(CH4_BANDS, Boolean.FALSE);
        DEFAULT.put(KAPPA0, new UnitDouble(0.0, uSys.getKappa0Unit()));
        DEFAULT.put(NMIEANG, 15);
        DEFAULT.put(NUMBER_RADIATION_ANGLES, 100);
        DEFAULT.put(PATH, new UnitDouble(0.0, uSys.getLengthUnit()));
        DEFAULT.put(RADTMP, new UnitDouble(900.0, uSys.getTempUnit()));
        DEFAULT.put(TIME_STEP_INCREMENT, 3);
        DEFAULT.put(WIDE_BAND_MODEL, Boolean.FALSE);
    }
}

