/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManDeleteTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;

public abstract class APyroManReplaceTask<K, V extends IPyroObject>
extends CompositeTask<PyroMod> {
    private final IPyroManager<K, V> d_manager;
    private final List<V> d_objs;
    private final List<V> d_replacements;

    protected abstract boolean add(V var1);

    protected abstract boolean remove(V var1);

    public APyroManReplaceTask(IPyroManager<K, V> manager, List<V> objs, List<V> replacements) {
        this(manager, objs, replacements, true);
    }

    public APyroManReplaceTask(IPyroManager<K, V> manager, List<V> objs, List<V> replacements, boolean queueTasks) {
        super(manager.getDomains());
        this.d_manager = manager;
        this.d_objs = new ArrayList<V>(objs);
        ArrayList<V> arrayList = this.d_replacements = replacements != null ? new ArrayList<V>(replacements) : null;
        if (queueTasks) {
            this.queueTasks();
        }
    }

    protected List<V> getObjects() {
        return this.d_objs;
    }

    protected void queueTasks() {
        this.queueDeleteTasks();
        this.queueAddTasks();
    }

    private void queueAddTasks() {
        if (this.d_replacements != null) {
            HashSet<IPyroObject> actualReplacements = new HashSet<IPyroObject>(this.d_replacements.size());
            for (IPyroObject replacement : this.d_replacements) {
                if (replacement == null) continue;
                actualReplacements.add(replacement);
            }
            if (actualReplacements.isEmpty()) {
                return;
            }
            this.addTask(new APyroManAddTask<K, V>(this.d_manager, actualReplacements){

                @Override
                protected boolean add(V obj) {
                    return APyroManReplaceTask.this.add(obj);
                }

                @Override
                protected boolean remove(V obj) {
                    return APyroManReplaceTask.this.remove(obj);
                }
            });
        }
    }

    private void queueDeleteTasks() {
        if (this.d_objs.isEmpty()) {
            return;
        }
        this.addTask(new APyroManDeleteTask<K, V>(this.d_manager, this.d_objs){

            @Override
            protected boolean add(V obj) {
                return APyroManReplaceTask.this.add(obj);
            }

            @Override
            protected boolean remove(V obj) {
                return APyroManReplaceTask.this.remove(obj);
            }
        });
    }
}

