/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.AirDuct;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.zones.Zone;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.ExSpecRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.io.fds.v6.renderers.ZoneRenderer;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Sets;

public class SurfaceRenderer
extends AFDS6Renderer {
    private static Set<String> s_fdsPredefNames = Sets.fromArrayHS("INERT", "MIRROR", "OPEN", "HVAC", "PERIODIC");
    private final FDSNameMap d_nameMap;
    private final ExSpecRenderer d_specRenderer;
    private final ZoneRenderer d_zoneRenderer;
    private final PinConnectionRenderer d_pinConns;
    private final Map<IImage, String> d_imgFNMap;
    private Surface d_defaultSurface;

    public SurfaceRenderer(FDSNameMap nameMap, ExSpecRenderer sr, ZoneRenderer zr, PinConnectionRenderer pinConns, Map<IImage, String> imgFilenames) {
        this.d_specRenderer = sr;
        this.d_nameMap = nameMap;
        this.d_zoneRenderer = zr;
        this.d_pinConns = pinConns;
        this.d_imgFNMap = imgFilenames;
        this.d_defaultSurface = null;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Surface.class);
        types.add(SimParams.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        if (o.getClass().equals(SimParams.class)) {
            SimParams s = (SimParams)o;
            this.d_defaultSurface = s.getMisc().getSurfDefault();
            return true;
        }
        Surface obj = (Surface)o;
        if (s_fdsPredefNames.contains(obj.getName())) {
            return false;
        }
        FDSRenderRecord rec = FDS6Const.newRenderRecord("SURF");
        rec.setValue("ID", obj.getName());
        String fyi = obj.getFYI().trim();
        if (fyi.length() > 0) {
            rec.setValue("FYI", fyi);
        }
        Color c = obj.getColor();
        SurfaceRenderer.renderColor(rec, true, c, "RGB", "COLOR", "TRANSPARENCY");
        this.renderDefault(rec, obj);
        Material texinfo = obj.getAppearance();
        if (texinfo != null && texinfo.getAttributes().getTexture(MatChannel.DIFFUSE) != null) {
            Texture tex = texinfo.getAttributes().getTexture(MatChannel.DIFFUSE);
            String imgName = this.d_imgFNMap.get(tex.image);
            if (imgName == null) {
                imgName = new File(tex.image.getFilename()).getName();
            }
            rec.setValue("TEXTURE_MAP", imgName);
            rec.setValue("TEXTURE_WIDTH", texinfo.getWidth(), false);
            rec.setValue("TEXTURE_HEIGHT", texinfo.getHeight(), false);
        }
        HashMap<String, Ramp> ramps = new HashMap<String, Ramp>();
        this.render(rec, ramps, obj, obj.getSurfDesc());
        SurfaceRenderer.renderCustomFDSProps(rec, obj);
        props.props().pushProps();
        props.props().setRenderMultiLine(true);
        props.render(rec, o);
        props.props().popProps();
        RampRenderer.render(props, ramps, this.d_pinConns);
        return true;
    }

    private void render(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, ISurfDesc desc) {
        if (desc instanceof SurfDescStatic.Inert) {
            this.render(rec, (SurfDescStatic.Inert)desc);
        } else if (desc instanceof SurfDescStatic.Adiabatic) {
            this.render(rec, (SurfDescStatic.Adiabatic)desc);
        } else if (desc instanceof BurnerSurfDesc) {
            this.render(rec, ramps, surf, (BurnerSurfDesc)desc);
        } else if (desc instanceof LayeredSurfDesc) {
            this.render(rec, ramps, surf, (LayeredSurfDesc)desc);
        } else if (desc instanceof GeneralSurfDesc) {
            this.render(rec, ramps, surf, (GeneralSurfDesc)desc);
        } else if (desc instanceof ConstantTempSurfDesc) {
            this.render(rec, ramps, surf, (ConstantTempSurfDesc)desc);
        } else if (desc instanceof InFlowSurfDesc) {
            this.render(rec, ramps, surf, (InFlowSurfDesc)desc);
        } else if (desc instanceof BlowerSurfDesc) {
            this.render(rec, ramps, surf, (BlowerSurfDesc)desc);
        } else if (desc instanceof LeakSurfDesc) {
            this.render(rec, ramps, surf, (LeakSurfDesc)desc);
        }
    }

    private void render(FDSRenderRecord rec, SurfDescStatic.Inert desc) {
    }

    private void render(FDSRenderRecord rec, SurfDescStatic.Adiabatic desc) {
        rec.setValue("ADIABATIC", true);
    }

    private void render(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, LeakSurfDesc desc) {
        this.renderZoneConnection(rec, "LEAK_PATH", desc.d_leak);
    }

    private void render(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, BurnerSurfDesc desc) {
        this.renderHeatRelease(rec, ramps, surf, desc.d_heatRelease);
        SurfaceRenderer.renderTempRegulation(rec, this.d_nameMap, ramps, surf, desc.d_temperature, true);
        this.renderParticlInj(rec, ramps, surf, desc.d_partInj);
        this.renderGeometry(rec, desc.d_geometry);
    }

    private void render(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, GeneralSurfDesc desc) {
        this.renderAirFlow(rec, ramps, surf, desc.d_airflow, false);
        SurfaceRenderer.renderTempRegulation(rec, this.d_nameMap, ramps, surf, desc.d_tempReg, false);
        this.renderParticlInj(rec, ramps, surf, desc.d_partInj);
        this.renderSpecInjs(rec, ramps, surf, desc.d_specInj);
        this.renderGeometry(rec, desc.d_geometry);
        this.renderHeatRelease(rec, ramps, surf, desc.d_heatRelease);
    }

    private void render(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, ConstantTempSurfDesc desc) {
        SurfaceRenderer.renderTempRegulation(rec, this.d_nameMap, ramps, surf, desc.d_tempReg, true);
        this.renderParticlInj(rec, ramps, surf, desc.d_partInj);
        this.renderGeometry(rec, desc.d_geometry);
    }

    private void render(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, InFlowSurfDesc desc) {
        SurfaceRenderer.renderTempRegulation(rec, this.d_nameMap, ramps, surf, desc.d_temperature, false);
        this.renderAirFlow(rec, ramps, surf, desc.d_airFlow, false);
    }

    private void render(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, BlowerSurfDesc desc) {
        SurfaceRenderer.renderTempRegulation(rec, this.d_nameMap, ramps, surf, desc.d_tempReg, false);
        this.renderAirFlow(rec, ramps, surf, desc.d_airFlow, true);
        this.renderParticlInj(rec, ramps, surf, desc.d_partInj);
        this.renderGeometry(rec, desc.d_geometry);
    }

    private void render(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, LayeredSurfDesc desc) {
        this.renderZoneConnection(rec, "LEAK_PATH", desc.d_leakPath);
        SurfaceRenderer.renderTempRegulation(rec, this.d_nameMap, ramps, surf, desc.d_temperature, false);
        this.renderReaction(rec, ramps, surf, desc.d_iReac);
        rec.setValue("BURN_AWAY", desc.d_burnAway, false);
        this.renderSurfComp(rec, ramps, surf, desc.d_surfComp);
        this.renderParticlInj(rec, ramps, surf, desc.d_partInj);
        this.renderSpecInjs(rec, ramps, surf, desc.d_specInj);
        this.renderGeometry(rec, desc.d_geometry);
    }

    private void renderDefault(FDSRenderRecord rec, Surface surf) {
        if (surf.equals(this.d_defaultSurface)) {
            rec.setValue("DEFAULT", true);
        }
    }

    private void renderGeometry(FDSRenderRecord rec, IGeometry geom) {
        if (geom instanceof IGeometry.Default) {
            return;
        }
        if (geom instanceof IGeometry.Cartesian) {
            IGeometry.Cartesian cart = (IGeometry.Cartesian)geom;
            rec.setValue("GEOMETRY", "CARTESIAN");
            rec.setValue("LENGTH", cart.length);
            rec.setValue("WIDTH", cart.width);
            FDSArray<UnitDouble> thickness = new FDSArray<UnitDouble>(new int[]{FDS6Const.SURF_LAYER_DIMENSIONS[0]});
            thickness.set(cart.thickness, new int[]{0});
            if (cart.thickness != null) {
                rec.setValue("THICKNESS", thickness);
            }
        } else if (geom instanceof IGeometry.Cylindrical) {
            IGeometry.Cylindrical cyl = (IGeometry.Cylindrical)geom;
            rec.setValue("GEOMETRY", "CYLINDRICAL");
            this.renderSimpleVariant(rec, "LENGTH", cyl.lengthVar);
            if (cyl.innerRadius != null) {
                rec.setValue("INNER_RADIUS", cyl.innerRadius);
            } else if (cyl.radius != null) {
                rec.setValue("RADIUS", cyl.radius);
            }
        } else if (geom instanceof IGeometry.Spherical) {
            IGeometry.Spherical spher = (IGeometry.Spherical)geom;
            rec.setValue("GEOMETRY", "SPHERICAL");
            if (spher.innerRadius != null) {
                rec.setValue("INNER_RADIUS", spher.innerRadius);
            } else if (spher.radius != null) {
                rec.setValue("RADIUS", spher.radius);
            }
        }
    }

    private void renderSpecInjs(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, SpecInjList injs) {
        if (injs == null) {
            return;
        }
        Collection<SpeciesInjection> injections = injs.getInjections();
        Object[] values = new Object[injections.size()];
        UnitDouble[] taus = new UnitDouble[injections.size()];
        String[] specNames = new String[injections.size()];
        String[] rampNames = new String[injections.size()];
        int ix = 0;
        for (SpeciesInjection inj : injs.getInjections()) {
            this.renderSpecInj(inj, ix, surf, ramps, values, taus, specNames, rampNames);
            ++ix;
        }
        String valKey = injs.injType == 0 ? "MASS_FLUX" : "MASS_FRACTION";
        rec.setValue(valKey, Arrays.asList(values), false);
        rec.setValue("SPEC_ID", Arrays.asList(specNames), false);
        rec.setValue("RAMP_MF", Arrays.asList(rampNames), false);
        rec.setValue("TAU_MF", Arrays.asList(taus), false);
    }

    private void renderSpecInj(SpeciesInjection inj, int ix, Surface surf, Map<String, Ramp> ramps, Object[] values, UnitDouble[] taus, String[] specNames, String[] rampNames) {
        values[ix] = inj.val;
        specNames[ix] = inj.species.getName();
        if (inj.func instanceof TimeFunction.TanH) {
            taus[ix] = (UnitDouble)((TimeFunction.TanH)inj.func).val;
        } else if (inj.func instanceof TimeFunction.TSquared) {
            UnitDouble time = (UnitDouble)((TimeFunction.TSquared)inj.func).val;
            taus[ix] = time.negate();
        } else {
            Ramp r = (Ramp)((TimeFunction.Custom)inj.func).val;
            String rName = RampRenderer.createID(this.d_nameMap, surf.getName(), "RAMP_MF");
            ramps.put(rName, r);
            rampNames[ix] = rName;
        }
    }

    private void renderParticlInj(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, ParticleInjection inj) {
        if (inj == null || inj.getParticle() == null) {
            return;
        }
        rec.setValue("PART_ID", inj.getParticle().getName());
        rec.setValue("NPPC", inj.d_numPartsPerCell, false);
        if (inj.getMassFlux() != null && ((UnitDouble)inj.getMassFlux().val).getValueNoUnit() != 0.0) {
            rec.setValue("PARTICLE_MASS_FLUX", inj.getMassFlux().val, false);
            SurfaceRenderer.renderTimeFunc(rec, this.d_nameMap, ramps, surf.getName(), inj.getMassFlux().func, "RAMP_PART", "TAU_PART");
        }
        rec.setValue("DT_INSERT", inj.d_dtInsert, false);
    }

    private void renderBacking(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, Backing backing) {
        String backingStr = null;
        if (backing instanceof Backing.AirGap) {
            backingStr = "VOID";
            rec.setValue("TMP_BACK", ((Backing.AirGap)backing).d_airTemp, false);
            SurfaceRenderer.renderTimeFunc(rec, this.d_nameMap, ramps, surf.getName(), ((Backing.AirGap)backing).d_airTempRamp, "RAMP_T_B", null);
        } else if (backing instanceof Backing.Exposed) {
            backingStr = "EXPOSED";
        } else if (backing instanceof Backing.Insulated) {
            backingStr = "INSULATED";
        }
        rec.setValue("BACKING", backingStr, false);
    }

    private void renderHeatRelease(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, HeatRelease hr) {
        String typeKey = hr.d_type instanceof HeatRelease.HRRType ? "HRRPUA" : "MLRPUA";
        SurfaceRenderer.renderTVal(rec, this.d_nameMap, ramps, surf.getName(), hr.d_type, typeKey, "RAMP_Q", "TAU_Q", true);
        rec.setValue("E_COEFFICIENT", hr.d_extingCoeff, false);
    }

    public static void renderTempRegulation(FDSRenderRecord rec, FDSNameMap nameMap, Map<String, Ramp> ramps, Surface surf, TempRegulation tr, boolean writeDefaultTemp) {
        if (tr.d_logarithmic) {
            rec.setValue("HEAT_TRANSFER_MODEL", "LOGLAW");
        } else if (tr.d_htCoef != null) {
            rec.setValue("HEAT_TRANSFER_COEFFICIENT", tr.d_htCoef);
        }
        if (tr.isAdiabaticTR()) {
            rec.setValue("ADIABATIC", true);
        } else if (tr.isNetHeatFluxTR()) {
            rec.setValue("NET_HEAT_FLUX", tr.d_thermalBCs.d_netHeatFlux);
            SurfaceRenderer.renderTimeFunc(rec, nameMap, ramps, surf.getName(), tr.d_thermalBCs.d_netFluxRamp, "RAMP_Q", "TAU_Q");
            rec.setValue("EMISSIVITY", tr.d_thermalBCs.d_emissivity, false);
        } else if (tr.isGrossFluxTR()) {
            rec.setValue("TMP_FRONT", tr.d_thermalBCs.d_temp, writeDefaultTemp);
            if (tr.d_thermalBCs.d_temp != null) {
                SurfaceRenderer.renderTimeFunc(rec, nameMap, ramps, surf.getName(), tr.d_thermalBCs.d_tempRamp, "RAMP_T", "TAU_T");
            }
            rec.setValue("EMISSIVITY", tr.d_thermalBCs.d_emissivity, false);
            rec.setValue("CONVECTIVE_HEAT_FLUX", tr.d_thermalBCs.d_convHeatFlux, false);
            SurfaceRenderer.renderTimeFunc(rec, nameMap, ramps, surf.getName(), tr.d_thermalBCs.d_convFluxRamp, "RAMP_Q", "TAU_Q");
        } else if (tr.isFixedTempTR()) {
            rec.setValue("TMP_FRONT", tr.d_thermalBCs.d_temp);
            SurfaceRenderer.renderTimeFunc(rec, nameMap, ramps, surf.getName(), tr.d_thermalBCs.d_tempRamp, "RAMP_T", "TAU_T");
            rec.setValue("EMISSIVITY", tr.d_thermalBCs.d_emissivity, false);
        } else if (tr.isCalcTempTR()) {
            rec.setValue("EMISSIVITY", tr.d_thermalBCs.d_emissivity, false);
        }
    }

    private void renderAirDuct(FDSRenderRecord rec, AirDuct airDuct) {
        if (airDuct == null) {
            return;
        }
        Zone[] zones = airDuct.d_ductPath.getZones();
        if (zones[0] == null || zones[1] == null) {
            return;
        }
    }

    private void renderZoneConnection(FDSRenderRecord rec, String key, ZonePath zc) {
        if (zc == null) {
            return;
        }
        Zone[] zones = zc.getZones();
        if (zones[0] == null || zones[1] == null) {
            return;
        }
        Integer[] ixes = new Integer[]{this.d_zoneRenderer.indexOf(zones[0]), this.d_zoneRenderer.indexOf(zones[1])};
        FDSArray<Integer> fdsixes = new FDSArray<Integer>((T[])ixes);
        rec.setValue(key, fdsixes);
    }

    private void renderAirFlow(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, AirFlow airFlow, boolean negateVel) {
        if (airFlow.d_rate instanceof AirFlow.ValRate) {
            String valKey = airFlow.d_rate instanceof AirFlow.NormalVel ? "VEL" : (airFlow.d_rate instanceof AirFlow.VolumeFlux ? "VOLUME_FLOW" : "MASS_FLUX_TOTAL");
            AirFlow.ValRate valRate = (AirFlow.ValRate)airFlow.d_rate;
            if (negateVel) {
                rec.setValue(valKey, valRate.val.negate(), true);
            } else {
                rec.setValue(valKey, valRate.val, true);
            }
        }
        SurfaceRenderer.renderTimeFunc(rec, this.d_nameMap, ramps, surf.getName(), airFlow.d_rate.func, "RAMP_V", "TAU_V");
        FDSArray<Object> velt = new FDSArray<Object>(airFlow.d_rate.tanVelU, airFlow.d_rate.tanVelV);
        rec.setValue("VEL_T", velt, false);
        if (airFlow.d_profile instanceof AirFlow.TopHatProf) {
            rec.setValue("PROFILE", FDS6Const.TOP_HAT, false);
        } else if (airFlow.d_profile instanceof AirFlow.ParabolicProf) {
            rec.setValue("PROFILE", "PARABOLIC", false);
        } else if (airFlow.d_profile instanceof AirFlow.AtmosphericProf) {
            rec.setValue("PROFILE", "ATMOSPHERIC", false);
            AirFlow.AtmosphericProf prof = (AirFlow.AtmosphericProf)airFlow.d_profile;
            rec.setValue("PLE", prof.d_exponent, false);
            rec.setValue("Z0", prof.d_origin, false);
        }
        if (negateVel) {
            this.renderSpecInjs(rec, ramps, surf, airFlow.d_rate.specInj);
        }
    }

    private void renderReaction(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, Fuel.IReaction reac) {
        if (reac instanceof Fuel.MaterialReac) {
            return;
        }
        Fuel.ManualReac mreac = (Fuel.ManualReac)reac;
        this.renderHeatRelease(rec, ramps, surf, mreac.d_heatRelease);
        rec.setValue("HEAT_OF_VAPORIZATION", mreac.d_heatOfVap, true);
        if (mreac.d_ignition instanceof Fuel.ManualReac.TemperatureIgnite) {
            rec.setValue("IGNITION_TEMPERATURE", ((Fuel.ManualReac.TemperatureIgnite)mreac.d_ignition).d_temperature, true);
        }
    }

    private void renderSurfComp(FDSRenderRecord rec, Map<String, Ramp> ramps, Surface surf, SurfComposition sc) {
        Variant val = sc.d_innerTempVariant;
        if (val.isConstant()) {
            rec.setValue("TMP_INNER", (UnitDouble)val.val, false);
        } else {
            assert (val.isRamp());
            String rName = RampRenderer.createID(this.d_nameMap, surf.getName(), "RAMP_T_I");
            ramps.put(rName, (Ramp)val.val);
            rec.setValue("RAMP_T_I", rName, false);
        }
        this.renderBacking(rec, ramps, surf, sc.d_backing);
        FDSArray<String> matIDs = new FDSArray<String>(FDS6Const.SURF_LAYER_DIMENSIONS);
        FDSArray<Double> massFracs = new FDSArray<Double>(FDS6Const.SURF_LAYER_DIMENSIONS);
        FDSArray<UnitDouble> thicknesses = new FDSArray<UnitDouble>(new int[]{FDS6Const.SURF_LAYER_DIMENSIONS[0]});
        int[] ix = new int[2];
        for (int layerix = 0; layerix < sc.d_layers.size(); ++layerix) {
            SurfComposition.SurfLayer layer = sc.d_layers.get(layerix);
            thicknesses.set(layer.d_thickness, new int[]{layerix});
            ix[0] = layerix;
            int compix = 0;
            for (SurfComposition.SurfLayer.SurfComponent comp : layer.getComponents()) {
                ix[1] = compix++;
                massFracs.set(comp.d_massFraction, ix);
                matIDs.set(comp.d_material.getName(), ix);
            }
        }
        rec.setValue("MATL_ID", matIDs);
        rec.setValue("MATL_MASS_FRACTION", massFracs, false);
        rec.setValue("THICKNESS", thicknesses);
        rec.setValue("LAYER_DIVIDE", sc.d_layerDivide, false);
    }
}

