/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jscience.physics.units.Unit;
import pyrosim.domain.Grid;
import pyrosim.domain.GridProcessUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.grid.RegularGridCreator;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class GridRenderer
extends AFDS6Renderer {
    private int d_gridIx = 0;
    private final Map<List<TRNCard>, String>[] d_trnRecs = new Map[]{new HashMap(), new HashMap(), new HashMap()};
    private final int[] d_trnIdNextIx = new int[]{0, 0, 0};
    private GridProcessUtil d_procUtil;

    public GridRenderer(GridProcessUtil util) {
        this.d_procUtil = util;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Grid.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Grid obj = (Grid)o;
        ArrayList newTRNRecs = new ArrayList();
        String[] trnIds = new String[3];
        if (!RegularGridCreator.isUniform(obj.getXDivisions())) {
            trnIds[0] = this.getTRNRecordsId(props, obj, "TRNX", obj.getMinPoint().xu(), obj.getMaxPoint().xu(), obj.getXDivisions(), newTRNRecs::add, 0);
        }
        if (!RegularGridCreator.isUniform(obj.getYDivisions())) {
            trnIds[1] = this.getTRNRecordsId(props, obj, "TRNY", obj.getMinPoint().yu(), obj.getMaxPoint().yu(), obj.getYDivisions(), newTRNRecs::add, 1);
        }
        if (!RegularGridCreator.isUniform(obj.getZDivisions())) {
            trnIds[2] = this.getTRNRecordsId(props, obj, "TRNZ", obj.getMinPoint().zu(), obj.getMaxPoint().zu(), obj.getZDivisions(), newTRNRecs::add, 2);
        }
        this.writeMeshRecord(props, obj, trnIds[0], trnIds[1], trnIds[2]);
        for (FDSRenderRecord trnRec : newTRNRecs) {
            props.render(trnRec, obj);
        }
        ++this.d_gridIx;
        return true;
    }

    private void writeMeshRecord(IFDSRecordRenderer props, Grid obj, String ... trnIds) {
        Integer nThreads;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("MESH");
        rec.setValue("ID", obj.getName());
        rec.setValue("FYI", obj.getFYI(), false);
        GridRenderer.renderColor(rec, true, obj.getColor(), "RGB", "COLOR", null);
        FDSArray<Object> ijk = new FDSArray<Object>(obj.getXDivisions().length, obj.getYDivisions().length, obj.getZDivisions().length);
        rec.setValue("IJK", ijk);
        GridRenderer.renderXB(rec, "XB", obj.getMinPoint(), obj.getMaxPoint());
        rec.setValue("TRNX_ID", trnIds[0]);
        rec.setValue("TRNY_ID", trnIds[1]);
        rec.setValue("TRNZ_ID", trnIds[2]);
        Integer mpiProcess = this.d_procUtil.getMPI_PROCESS(obj);
        if (mpiProcess != null) {
            rec.setValue("MPI_PROCESS", mpiProcess);
        }
        if ((nThreads = this.d_procUtil.getNumThreads(obj)) != null) {
            rec.setValue("N_THREADS", nThreads);
        }
        if (obj.getEvacuation()) {
            rec.setValue("EVACUATION", obj.getEvacuation());
            rec.setValue("EVAC_HUMANS", obj.getEvacHumans(), false);
            rec.setValue("EVAC_Z_OFFSET", obj.getEvacZOffset(), true);
        }
        GridRenderer.renderCustomFDSProps(rec, obj);
        props.render(rec, obj);
    }

    private String getTRNRecordsId(IFDSRecordRenderer props, Grid grid, String recName, UnitDouble minu, UnitDouble maxu, UnitDouble[] divisions, Consumer<FDSRenderRecord> newTrnRecords, int trnix) {
        if (divisions.length <= 0) {
            return null;
        }
        double[] vals = new double[divisions.length];
        Unit u = SIUS.getInstance().getLengthUnit();
        for (int i = 0; i < divisions.length; ++i) {
            vals[i] = divisions[i].getValue(u);
        }
        ArrayList<TRNCard> cards = new ArrayList<TRNCard>();
        double min = minu.getValue(u);
        double max = maxu.getValue(u);
        double ccMult = (max - min) / (double)vals.length;
        double numSame = 1.0;
        double sizeLast = vals[0];
        double pc = min + sizeLast;
        double ccLast = min;
        for (int m = 1; m < vals.length; ++m) {
            if (vals[m] == sizeLast) {
                numSame += 1.0;
            } else {
                double ccCurrent = ccLast + numSame * ccMult;
                cards.add(new TRNCard(new UnitDouble(ccCurrent, u), new UnitDouble(pc, u)));
                numSame = 1.0;
                sizeLast = vals[m];
                ccLast = ccCurrent;
            }
            pc += vals[m];
        }
        if (cards.isEmpty()) {
            return null;
        }
        return this.d_trnRecs[trnix].computeIfAbsent(cards, cardList -> {
            String id = recName.toLowerCase();
            int nidix = this.d_trnIdNextIx[trnix];
            if (nidix > 0) {
                id = id + String.format("%02d", nidix);
            }
            int n2 = trnix;
            this.d_trnIdNextIx[n2] = this.d_trnIdNextIx[n2] + 1;
            for (TRNCard card : cardList) {
                FDSRenderRecord trnRec = FDS6Const.newRenderRecord(recName);
                trnRec.setComment(grid.getName());
                trnRec.setValue("ID", id);
                trnRec.setValue("CC", card.CC);
                trnRec.setValue("PC", card.PC);
                newTrnRecords.accept(trnRec);
            }
            return id;
        });
    }

    private static class TRNCard {
        public final UnitDouble CC;
        public final UnitDouble PC;

        public TRNCard(UnitDouble cC, UnitDouble pC) {
            this.CC = cC;
            this.PC = pC;
        }

        public int hashCode() {
            return 0x8A7F893 ^ Objects.hash(this.CC, this.PC);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof TRNCard && ((TRNCard)obj).CC.equals(this.CC) && ((TRNCard)obj).PC.equals(this.PC);
        }
    }
}

