/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import pyrosim.Intl;
import pyrosim.io.fds.FDSParseRecord;
import thunderheadeng.util.Warning;

public class FDSParseWarning
extends Warning {
    public static final int WARNINGINFO_LINE_NUMBER = 2;
    public static final int WARNINGINFO_RECORD_TEXT = 3;
    private final int d_lineNumber;
    private final String d_originalRecord;

    public FDSParseWarning(int lineNumber, String warning, String actionTaken) {
        this(lineNumber, warning, actionTaken, "");
    }

    public FDSParseWarning(int lineNumber, String warning, String actionTaken, String originalRecord) {
        super(warning, actionTaken);
        this.d_lineNumber = lineNumber;
        this.d_originalRecord = originalRecord.replaceAll("[\\s]+", " ").trim();
    }

    public FDSParseWarning(FDSParseRecord record, String warning, String actionTaken) {
        this(record.getDebugInfo() != null ? record.getDebugInfo().getBeginLineNum() : 0, warning, actionTaken, record.getDebugInfo() != null ? record.getDebugInfo().getOriginalText() : "");
    }

    public static int[] getWarningInfoTypes() {
        return new int[]{2, 0, 1, 3};
    }

    public static String[] getWarningInfoDescriptions() {
        return new String[]{Intl.intl("Line"), Intl.intl("Warning"), Intl.intl("Action Taken"), Intl.intl("Original Record")};
    }

    @Override
    public Comparable getWarningInfo(int type) {
        switch (type) {
            case 2: {
                return Integer.valueOf(this.d_lineNumber);
            }
            case 3: {
                return this.d_originalRecord;
            }
        }
        return super.getWarningInfo(type);
    }
}

