/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import pyrosim.Intl;

public class FDSParseException
extends Exception {
    private static final long serialVersionUID = -2762429751059404333L;

    public FDSParseException(String file, int lineNum, String message, StackTraceElement[] st) {
        this(file, lineNum, message);
        this.setStackTrace(st);
    }

    public FDSParseException(String file, int lineNum, String message) {
        super(FDSParseException.constructErrorMessage(file, lineNum, message));
    }

    private static String constructErrorMessage(String file, int lineNum, String message) {
        String msg = "";
        if (file != null) {
            msg = msg + String.format(Intl.intl("Error in file, %s."), file);
        }
        if (lineNum > 0) {
            if (msg.length() > 0) {
                msg = msg + "\n";
            }
            msg = msg + String.format(Intl.intl("Line Number: %d"), lineNum);
        }
        if (message != null) {
            if (msg.length() > 0) {
                msg = msg + "\n\n";
            }
            msg = msg + message;
        }
        return msg;
    }
}

