/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.domain.reaction.Reaction;
import pyrosim.util.RefWrapper;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class SetActiveReacDlg
extends guiDialog {
    private static final long serialVersionUID = 2139970846970882168L;
    private final guiComboBox<RefWrapper<Reaction>> d_combo;

    public SetActiveReacDlg(List<Reaction> reacList, Function<Reaction, String> nameMapper, Reaction activeReac) {
        super((Window)Application.getApp().getMainFrame(), Intl.intl("Set Active Reaction"), 9);
        this.d_combo = this.buildCombo(reacList, nameMapper, activeReac);
        guiLabel msg = new guiLabel(Intl.intl("Please set an active reaction:"));
        guiLabel reacLabel = new guiLabel(Intl.intl("Reaction:"));
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        GridBagUtil.add(dlgPanel, msg, 0, 0, 2, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, reacLabel, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, this.d_combo, 1, 1, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.addGlue(dlgPanel);
    }

    private guiComboBox<RefWrapper<Reaction>> buildCombo(List<Reaction> reacs, Function<Reaction, String> nameMapper, Reaction activeReac) {
        reacs = new ArrayList<Reaction>(reacs);
        reacs.add(0, null);
        int activeIx = -1;
        for (int i = 0; i < reacs.size(); ++i) {
            if (reacs.get(i) != activeReac) continue;
            activeIx = i;
            break;
        }
        guiComboBox<RefWrapper<Reaction>> combo = new guiComboBox<RefWrapper<Reaction>>(reacs.stream().map(r -> new RefWrapper<Reaction>((Reaction)r)).collect(Collectors.toList()));
        combo.setRenderer(new ReactionListCellRenderer(activeReac, nameMapper));
        combo.setSelectedIndex(activeIx);
        return combo;
    }

    public Reaction getSelectedReac() {
        return (Reaction)this.d_combo.getSelectedItem().obj;
    }

    private static class ReactionListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -6041394035117475920L;
        private final Reaction d_active;
        private final Function<Reaction, String> d_nameMapper;

        public ReactionListCellRenderer(Reaction active, Function<Reaction, String> nameMapper) {
            this.d_active = active;
            this.d_nameMapper = nameMapper;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String strNone = Intl.intl("None");
            String strActive = Intl.intl("Active");
            Reaction reacValue = (Reaction)((RefWrapper)value).obj;
            if (reacValue == null && reacValue == this.d_active) {
                this.setText(String.format("<html><i><b>%s</b></i>", strNone));
            } else if (reacValue == null && reacValue != this.d_active) {
                this.setText(String.format("<html><i>%s</i>", strNone));
            } else if (reacValue != null && reacValue == this.d_active) {
                this.setText(String.format("<html><b>%s (%s)</b>", this.d_nameMapper.apply(reacValue), strActive));
            } else if (reacValue != null && reacValue != this.d_active) {
                this.setText(String.format("<html>%s", this.d_nameMapper.apply(reacValue)));
            }
            return this;
        }
    }
}

