/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.SimParams;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.variant.Variant;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.DoubleVR;

public class ReactionConfigPanel
extends guiPanel
implements IEditor<Reaction> {
    private static final long serialVersionUID = 8520540044821832889L;
    private static final String FUEL_LABEL = Intl.intl("Fuel");
    private static final String SUPP_LABEL = Intl.intl("Fire Suppression");
    private static final String PROD_LABEL = Intl.intl("Byproducts");
    private static final String COMPLEX_LABEL = Intl.intl("Complex Chemistry");
    private static final String ADVANCED_LABEL = Intl.intl("Advanced");
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private ReactionList d_reacList;
    private final guiTextField d_fyiFld;
    private final guiComboBox<Reaction.ReacType> d_typeCB;
    private final JTabbedPane d_tabs;
    private final FuelPanel d_fuelPanel;
    private final FireSupPanel d_fireSupPanel;
    private final ByproductsPanel d_byproductsPanel;
    private final ComplexReacEditor d_complexReacPanel;
    private final CustomFDSPanel d_advancedPnl;

    public ReactionConfigPanel() {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        this.d_reacList = pyMod.getReactions();
        this.d_fuelPanel = new FuelPanel();
        this.d_fireSupPanel = new FireSupPanel();
        this.d_byproductsPanel = new ByproductsPanel();
        this.d_complexReacPanel = new ComplexReacEditor(pyMod.getExSpecList());
        this.d_advancedPnl = new CustomFDSPanel(7);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(FUEL_LABEL, this.d_fuelPanel);
        this.d_tabs.addTab(SUPP_LABEL, this.d_fireSupPanel);
        this.d_tabs.addTab(PROD_LABEL, this.d_byproductsPanel);
        this.d_tabs.addTab(COMPLEX_LABEL, this.d_complexReacPanel);
        this.d_tabs.addTab(ADVANCED_LABEL, this.d_advancedPnl);
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_fuelPanel, this.d_fireSupPanel, this.d_byproductsPanel, this.d_complexReacPanel, this.d_advancedPnl));
        this.getEditorPanel().setLayout(new GridBagLayout());
        this.d_fyiFld = new guiTextField();
        this.d_typeCB = new guiComboBox();
        this.d_typeCB.setRenderer(ReactionConfigPanel.getReacTypeRenderer());
        this.d_typeCB.addActionListener(e -> this.updateActivePanels());
        this.d_typeCB.add(Reaction.ReacType.SIMPLE);
        this.d_typeCB.add(Reaction.ReacType.COMPLEX);
        this.d_typeCB.setSelectedItem((Object)Reaction.ReacType.SIMPLE);
        GridBagHelper gb = new GridBagHelper(this.getEditorPanel());
        gb.addRow(Intl.intl("Description:"), this.d_fyiFld, 1.0);
        gb.addRow(Intl.intl("Reaction Type:"), this.d_typeCB, 1.0);
        gb.addRow(this.d_tabs, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        gb.finalizeRows();
        this.setEnabled(false);
        this.setModified(false);
    }

    private static ListCellRenderer getReacTypeRenderer() {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Reaction.ReacType) {
                    this.setText(((Reaction.ReacType)((Object)value)).id);
                }
                return this;
            }
        };
    }

    private void updateActivePanels() {
        this.d_tabs.removeAll();
        if (this.d_typeCB.getSelectedItem().equals((Object)Reaction.ReacType.SIMPLE)) {
            this.d_tabs.addTab(FUEL_LABEL, this.d_fuelPanel);
            this.d_tabs.addTab(SUPP_LABEL, this.d_fireSupPanel);
            this.d_tabs.addTab(PROD_LABEL, this.d_byproductsPanel);
            this.d_tabs.addTab(ADVANCED_LABEL, this.d_advancedPnl);
        } else {
            this.d_tabs.addTab(COMPLEX_LABEL, this.d_complexReacPanel);
            this.d_tabs.addTab(ADVANCED_LABEL, this.d_advancedPnl);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.d_fyiFld.setEnabled(enable);
        this.d_byproductsPanel.setEnabled(enable);
        this.d_fireSupPanel.setEnabled(enable);
        this.d_fuelPanel.setEnabled(enable);
        this.d_complexReacPanel.setEnabled(enable);
        this.d_advancedPnl.setEnabled(enable);
    }

    @Override
    public Reaction commit(final Reaction dataObj) {
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                ReactionConfigPanel.this.saveReaction(dataObj, false);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit Reaction"));
        this.setModified(false);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(Reaction dataObj) {
        this.setEnabled(dataObj != null);
        if (dataObj != null) {
            this.loadReactions(dataObj);
            this.updateActivePanels();
        }
        this.setModified(false);
    }

    @Override
    public Reaction preview(Reaction reaction) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveReaction(reaction, true);
        return reaction;
    }

    public void loadReactions(Reaction dataObj) {
        this.d_fyiFld.setText(dataObj.getFYI());
        this.d_typeCB.setSelectedItem((Object)dataObj.getReacType());
        this.d_fuelPanel.loadData(dataObj);
        this.d_fireSupPanel.loadData(dataObj);
        this.d_byproductsPanel.loadData(dataObj);
        this.d_complexReacPanel.loadData(dataObj);
        this.d_advancedPnl.clear();
        this.d_advancedPnl.load(Collections.singleton(dataObj), new CustomFDSPanel.AdvPropWrapper<Boolean>(dataObj.isForceWrite(), 1));
    }

    public void saveReaction(Reaction reac, boolean isPreview) {
        reac.setFYI(this.d_fyiFld.getText());
        reac.setReacType(this.d_typeCB.getSelectedItem());
        if (this.checkShouldSave(this.d_fuelPanel)) {
            this.d_fuelPanel.saveData(reac, isPreview);
        }
        if (this.checkShouldSave(this.d_fireSupPanel)) {
            this.d_fireSupPanel.saveData(reac);
        }
        if (this.checkShouldSave(this.d_byproductsPanel)) {
            this.d_byproductsPanel.saveData(reac);
        }
        if (this.checkShouldSave(this.d_complexReacPanel)) {
            this.d_complexReacPanel.saveData(reac);
        }
        this.d_advancedPnl.save(Collections.singleton(reac));
    }

    private boolean checkShouldSave(guiPanel pnl) {
        return this.d_tabs.indexOfComponent(pnl) != -1;
    }

    private static class ComplexReacEditor
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final ExSpecList d_specList;
        private final guiComboBox<ExSpec> d_fuelCombo;
        private final guiTable d_chemTable;
        private final guiCheckBox d_heatOfCombustionCB;
        private final ValueField<UnitDouble> d_heatOfCombustionVF;
        private static final String OPT_REACTANT = Intl.intl("Reactant");
        private static final String OPT_PRODUCT = Intl.intl("Product");

        public ComplexReacEditor(ExSpecList specList) {
            this.d_specList = specList;
            this.d_fuelCombo = new ExSpecComboBox(specList);
            this.d_heatOfCombustionCB = new guiCheckBox(Intl.intl("Heat of Combustion:"));
            this.d_heatOfCombustionVF = ValueFields.udFld(UnitSystem.getSource(48));
            LinkStatus.link((AbstractButton)this.d_heatOfCombustionCB, this.d_heatOfCombustionVF);
            this.d_chemTable = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Species"), Intl.intl("Type"), Intl.intl("NU")}, new Class[]{ExSpec.class, String.class, Double.class}, 16);
            this.d_chemTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setValue(Object value) {
                    this.setText(value == null ? "" : ((ExSpec)value).getName());
                }
            });
            this.d_chemTable.setColumnEditable(0, false);
            this.d_chemTable.setColumnOptions(1, OPT_REACTANT, OPT_PRODUCT);
            this.d_chemTable.setPreferredScrollableViewportSize(new Dimension(150, 200));
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_heatOfCombustionCB, this.d_heatOfCombustionVF, 1.0);
            gb.addRow(Intl.intl("Fuel Species:"), this.d_fuelCombo, 1.0);
            gb.addRow(Intl.intl("Stoichiometric Coefficients:"));
            gb.addRow(new JScrollPane(this.d_chemTable), new double[]{1.0, 1.0}, new int[]{0, 0});
            gb.finalizeRows();
        }

        public void loadData(Reaction reac) {
            Variant hoc = reac.getHeatOfCombustion();
            if (hoc.getType().equals((Object)Variant.Type.DEFAULT)) {
                Unit hocUnit = ((PyroSim)Application.getApp()).getUnitSystem().getHeatOfCombustion();
                this.d_heatOfCombustionCB.setSelected(false);
                this.d_heatOfCombustionVF.setValue(new UnitDouble(0.0, hocUnit));
            } else if (hoc.getType().equals((Object)Variant.Type.CONSTANT)) {
                this.d_heatOfCombustionCB.setSelected(true);
                this.d_heatOfCombustionVF.setValue(hoc.val);
            }
            this.d_fuelCombo.setSelectedItem(reac.getFuel());
            List sortedSpecs = this.d_specList.flatten().stream().sorted((s1, s2) -> s1.getName().compareTo(s2.getName())).collect(Collectors.toList());
            this.d_chemTable.clearRows();
            Map<ExSpec, Double> reactionChem = reac.getComplexStoichiometry();
            int row = 0;
            for (ExSpec spec : sortedSpecs) {
                this.d_chemTable.getModel().setValueAt(spec, row, 0);
                if (reactionChem.containsKey(spec)) {
                    Double specLookup = reactionChem.get(spec);
                    if (specLookup != null) {
                        String sign = specLookup < 0.0 ? OPT_REACTANT : OPT_PRODUCT;
                        double abs = Math.abs(specLookup);
                        this.d_chemTable.getModel().setValueAt(sign, row, 1);
                        this.d_chemTable.getModel().setValueAt(abs, row, 2);
                    } else {
                        this.d_chemTable.getModel().setValueAt(OPT_REACTANT, row, 1);
                        this.d_chemTable.getModel().setValueAt(0.0, row, 2);
                    }
                } else {
                    this.d_chemTable.getModel().setValueAt(OPT_REACTANT, row, 1);
                    this.d_chemTable.getModel().setValueAt(0.0, row, 2);
                }
                ++row;
            }
            if (row > 0) {
                this.d_chemTable.setRowLimit(row);
            } else {
                this.d_chemTable.setRowLimit(1);
            }
            this.setModified(false);
        }

        public void saveData(Reaction reac) {
            if (this.d_heatOfCombustionCB.isSelected()) {
                reac.setHeatOfCombustion((UnitDouble)this.d_heatOfCombustionVF.getValue());
            } else {
                reac.setHeatOfCombustion(null);
            }
            reac.setFuel(this.d_fuelCombo.getSelectedItem());
            LinkedHashMap<ExSpec, Double> newCompMap = new LinkedHashMap<ExSpec, Double>();
            int numRows = this.d_chemTable.getRowCount();
            if (numRows > 0) {
                for (int row = 0; row < numRows; ++row) {
                    Double tableVal = (Double)this.d_chemTable.getValueAt(row, 2);
                    if (tableVal == null || tableVal == 0.0) continue;
                    double val = tableVal;
                    String sign = (String)this.d_chemTable.getValueAt(row, 1);
                    if (sign == null) continue;
                    if (sign.equals(OPT_REACTANT)) {
                        val *= -1.0;
                    }
                    newCompMap.put((ExSpec)this.d_chemTable.getValueAt(row, 0), val);
                }
            }
            reac.setComplexStoichiometry(newCompMap);
        }
    }

    private class ByproductsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1217278318223851207L;
        private guiRadioButton d_epumRB;
        private guiRadioButton d_hocRB;
        private guiCheckBox d_ideal;
        private ValueField<UnitDouble> d_epum;
        private ValueField<UnitDouble> d_hoc;
        private guiCheckBox d_radFracCB;
        private ValueField<Double> d_radFraction;
        private ValueField<Double> d_co;
        private ValueField<Double> d_soot;
        private ValueField<Double> d_hFraction;

        public ByproductsPanel() {
            this.setLayout(new GridBagLayout());
            guiLabel energyLab = new guiLabel(Intl.intl("Energy Released") + ":");
            this.d_epumRB = new guiRadioButton(Intl.intl("Specify release per unit mass oxygen") + ":");
            this.d_hocRB = new guiRadioButton(Intl.intl("Specify heat of combustion") + ":");
            this.d_epum = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_hoc = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_radFracCB = new guiCheckBox(Intl.intl("Radiative Fraction:"));
            this.d_radFraction = ValueFields.doubleFld(SimParams.RadiationTransport.RADIATIVE_FRACTION_RANGE);
            this.d_ideal = new guiCheckBox(Intl.intl("<html>Energy is Ideal (does not account for yields of CO, H<sub>2</sub>, or Soot)</html>"));
            this.d_co = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
            this.d_soot = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
            this.d_hFraction = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
            guiLabel coLab = new guiLabel(Intl.intl("<html>CO Yield (Y<sub>co</sub>):</html>"));
            guiLabel sootLab = new guiLabel(Intl.intl("<html>Soot Yield (Y<sub>s</sub>):</html>"));
            guiLabel hfracLab = new guiLabel(Intl.intl("Hydrogen Fraction:"));
            int row = 0;
            GridBagUtil.add(this, energyLab, 0, row++, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_epumRB, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_epum, 2, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hocRB, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hoc, 2, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_radFracCB, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_radFraction, 2, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_ideal, 0, row++, 4, 1, 0, 30, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, coLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_co, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, sootLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_soot, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, hfracLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hFraction, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            ButtonGroup group = new ButtonGroup();
            group.add(this.d_epumRB);
            group.add(this.d_hocRB);
            LinkStatus.link((AbstractButton)this.d_epumRB, this.d_epum);
            LinkStatus.link((AbstractButton)this.d_hocRB, this.d_hoc);
            LinkStatus.link((AbstractButton)this.d_radFracCB, this.d_radFraction);
        }

        private void loadData(Reaction reac) {
            this.d_epum.setValue(reac.getEpumo2());
            if (reac.getHeatOfCombustion().getType() == Variant.Type.CONSTANT) {
                this.d_hoc.setValue((UnitDouble)reac.getHeatOfCombustion().val);
            }
            if (reac.getEnergyType() == Reaction.EnergyRelease.EPUMO2) {
                this.d_epumRB.setSelected(true);
            } else {
                this.d_hocRB.setSelected(true);
            }
            this.d_ideal.setSelected(reac.isIdeal());
            Variant radFrac = reac.getRadiativeFraction();
            if (radFrac.getType() == Variant.Type.DEFAULT) {
                this.d_radFracCB.setSelected(false);
                this.d_radFraction.setValue(0.35);
            } else {
                this.d_radFracCB.setSelected(true);
                this.d_radFraction.setValue(((UnitDouble)radFrac.val).getRawValue());
            }
            this.d_co.setValue(reac.getCOYield());
            this.d_soot.setValue(reac.getSootYield());
            this.d_hFraction.setValue(reac.getSootHFraction());
        }

        public void saveData(Reaction reac) {
            reac.setEpumo2((UnitDouble)this.d_epum.getValue());
            reac.setHeatOfCombustion((UnitDouble)this.d_hoc.getValue());
            if (this.d_epumRB.isSelected()) {
                reac.setEnergyType(Reaction.EnergyRelease.EPUMO2);
            } else {
                reac.setEnergyType(Reaction.EnergyRelease.HEAT_OF_COMBUSTION);
            }
            if (this.d_radFracCB.isSelected()) {
                reac.setRadiativeFraction(SIUS.newud((Double)this.d_radFraction.getValue(), 28));
            } else {
                reac.setRadiativeFraction(null);
            }
            reac.setCOYield((Double)this.d_co.getValue());
            reac.setSootYield((Double)this.d_soot.getValue());
            reac.setSootHFraction((Double)this.d_hFraction.getValue());
            reac.setIdeal(this.d_ideal.isSelected());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if ((Double)this.d_co.getValue() + (Double)this.d_soot.getValue() > 1.0) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Yield values must add up to one or less."));
                }
                if (allowModify) {
                    ReactionConfigPanel.this.d_tabs.setSelectedComponent(ReactionConfigPanel.this.d_byproductsPanel);
                }
                return false;
            }
            return true;
        }
    }

    private class FireSupPanel
    extends guiPanel {
        private static final long serialVersionUID = 7271780612622304827L;
        private guiCheckBox d_fireSupCB;
        private ValueField<UnitDouble> d_critFlameTemp;
        private ValueField<UnitDouble> d_autoIgnitionTemp;

        public FireSupPanel() {
            this.setLayout(new GridBagLayout());
            this.d_fireSupCB = new guiCheckBox(Intl.intl("Enable Fire Suppression"));
            this.d_critFlameTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_critFlameTemp.setNullAllowed(true);
            this.d_autoIgnitionTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_autoIgnitionTemp.setNullAllowed(true);
            guiLabel critFlameLab = new guiLabel(Intl.intl("Critical Flame Temperature:"));
            guiLabel autoIgniteLab = new guiLabel(Intl.intl("Autoignition Temperature:"));
            int row = 0;
            GridBagUtil.add(this, this.d_fireSupCB, 0, row, 1, 1, 12, 12, 6, 6, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, new JSeparator(0), 1, row++, 3, 1, 12, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, critFlameLab, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_critFlameTemp, 2, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, autoIgniteLab, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_autoIgnitionTemp, 2, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, critFlameLab);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, this.d_critFlameTemp);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, autoIgniteLab);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, this.d_autoIgnitionTemp);
        }

        public void loadData(Reaction reac) {
            this.d_fireSupCB.setSelected(reac.allowSuppression());
            this.d_critFlameTemp.setValue(reac.getCritFlameTemp());
            if (reac.getAutoIgnitionTemp().getType() == Variant.Type.CONSTANT) {
                this.d_autoIgnitionTemp.setValue((UnitDouble)reac.getAutoIgnitionTemp().val);
            }
        }

        public void saveData(Reaction reac) {
            reac.setSuppression(this.d_fireSupCB.isSelected());
            reac.setCritFlameTemp((UnitDouble)this.d_critFlameTemp.getValue());
            reac.setAutoIgnitionTemp((UnitDouble)this.d_autoIgnitionTemp.getValue());
        }
    }

    private class FuelPanel
    extends guiPanel {
        private static final long serialVersionUID = 177924900571047191L;
        private final CardLayout d_specCL;
        private final CardLayout d_compCL;
        private final guiPanel d_specCardPanel;
        private final guiPanel d_compCardPanel;
        private final String DEFAULT = Intl.intl("Simple Chemistry Model");
        private final String PREDEF = Intl.intl("Predefined");
        private final String USERDEF = Intl.intl("User Defined");
        private final String SHOWCOMP = "COMPOSITION";
        private final String SHOWSPEC = "SPECIES";
        private final String SHOWNULL = "BLANK";
        private final guiLabel d_specLab;
        private final guiLabel d_carbonLab;
        private final guiLabel d_hydrogenLab;
        private final guiLabel d_oxygenLab;
        private final guiLabel d_nitrogenLab;
        private final guiComboBox d_fuelTypeCombo;
        private guiComboBox d_specCombo;
        private final JButton d_editSpecs;
        private final ValueField<Double> d_carbon;
        private final ValueField<Double> d_hydrogen;
        private final ValueField<Double> d_oxygen;
        private final ValueField<Double> d_nitrogen;

        public FuelPanel() {
            this.setLayout(new GridBagLayout());
            this.d_specCL = new CardLayout();
            this.d_compCL = new CardLayout();
            guiPanel specCard = new guiPanel(new GridBagLayout());
            guiPanel compCard = new guiPanel(new GridBagLayout());
            this.d_specCardPanel = new guiPanel(this.d_specCL);
            this.d_compCardPanel = new guiPanel(this.d_compCL);
            guiPanel nullPanel = new guiPanel(new GridBagLayout());
            guiLabel nullLabel = new guiLabel(Intl.intl("Fuel assumed to contain only C, O, H, and N."));
            nullLabel.setFont(nullLabel.getFont().deriveFont(2));
            GridBagUtil.add(nullPanel, nullLabel, 0, 0, 1, 1, 6, 12, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(nullPanel);
            this.d_specCardPanel.add((Component)specCard, "SPECIES");
            this.d_compCardPanel.add((Component)compCard, "COMPOSITION");
            this.d_specCardPanel.add((Component)nullPanel, "BLANK");
            this.d_compCardPanel.add((Component)new guiPanel(), "BLANK");
            guiLabel fuelLab = new guiLabel(Intl.intl("Fuel Type:"));
            this.d_specLab = new guiLabel(Intl.intl("Fuel Species:"));
            this.d_fuelTypeCombo = new guiComboBox<Object>((T[])new Object[]{this.DEFAULT, this.PREDEF, this.USERDEF});
            PyroMod pySim = PyroSim.getApp().getMediator();
            this.d_specCombo = new ExSpecComboBox(pySim.getExSpecList());
            this.d_specCombo.setPreferredSize(new Dimension(100, this.d_specCombo.getPreferredSize().height));
            this.d_editSpecs = new JButton(Intl.intl("Edit Species") + "...");
            ActionListener editAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (arg0.getSource() instanceof JButton) {
                        Actions.editSpecies((ExSpec)FuelPanel.this.d_specCombo.getSelectedItem());
                    }
                }
            };
            this.d_editSpecs.addActionListener(editAction);
            this.d_carbon = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            this.d_hydrogen = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            this.d_oxygen = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            this.d_nitrogen = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            TitleSeparator speciesTitle = new TitleSeparator(Intl.intl("Composition"));
            this.d_carbonLab = new guiLabel(Intl.intl("Carbon atoms") + ":");
            this.d_hydrogenLab = new guiLabel(Intl.intl("Hydrogen atoms") + ":");
            this.d_oxygenLab = new guiLabel(Intl.intl("Oxygen atoms") + ":");
            this.d_nitrogenLab = new guiLabel(Intl.intl("Nitrogen atoms") + ":");
            this.d_fuelTypeCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (FuelPanel.this.d_fuelTypeCombo.getSelectedItem().equals(FuelPanel.this.DEFAULT)) {
                        FuelPanel.this.defaultSelected();
                    } else if (FuelPanel.this.d_fuelTypeCombo.getSelectedItem().equals(FuelPanel.this.PREDEF)) {
                        FuelPanel.this.predefSelected();
                    } else {
                        FuelPanel.this.userDefSelected();
                    }
                }
            });
            int row = 0;
            GridBagUtil.add(specCard, this.d_specLab, 0, row, 1, 1, 0, 0, 0, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(specCard, this.d_specCombo, 1, row, 1, 1, 0, 0, 0, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(specCard, this.d_editSpecs, 2, row, 1, 1, 0, 0, 0, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(specCard);
            row = 0;
            GridBagUtil.add(compCard, speciesTitle, 0, row++, 5, 1, 12, 0, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(compCard, this.d_carbonLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(compCard, this.d_carbon, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(compCard, this.d_hydrogenLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(compCard, this.d_hydrogen, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(compCard, this.d_oxygenLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(compCard, this.d_oxygen, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(compCard, this.d_nitrogenLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(compCard, this.d_nitrogen, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addVerticalGlue(compCard);
            row = 0;
            GridBagUtil.add(this, fuelLab, 0, row, 1, 1, 12, 12, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_fuelTypeCombo, 1, row++, 1, 1, 12, 12, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_specCardPanel, 0, row++, 2, 1, 0, 12, 0, 0, 2, 0.0, 0.0, 18);
            GridBagUtil.add(this, this.d_compCardPanel, 0, row, 5, 1, 0, 12, 0, 0, 2, 1.0, 0.0, 18);
            GridBagUtil.addVerticalGlue(this);
        }

        private void defaultSelected() {
            ((PyroComboBox)this.d_specCombo).setFilter(new Predicate<ExSpec>(){

                @Override
                public boolean test(ExSpec o) {
                    return true;
                }
            });
            this.d_compCL.show(this.d_compCardPanel, "COMPOSITION");
            this.d_specCL.show(this.d_specCardPanel, "BLANK");
            this.d_specCombo.setSelectedItem(ExSpecList.getDefaultFuel(false));
        }

        private void predefSelected() {
            ((PyroComboBox)this.d_specCombo).setFilter(new Predicate<ExSpec>(){

                @Override
                public boolean test(ExSpec spec) {
                    return ExSpecList.isPredefinedSpecies(spec.getName());
                }
            });
            this.d_specCL.show(this.d_specCardPanel, "SPECIES");
            this.d_compCL.show(this.d_compCardPanel, "BLANK");
        }

        private void userDefSelected() {
            ((PyroComboBox)this.d_specCombo).setFilter(new Predicate<ExSpec>(){

                @Override
                public boolean test(ExSpec spec) {
                    return !ExSpecList.isPredefinedSpecies(spec.getName()) && spec.getType() != 4;
                }
            });
            this.d_compCL.show(this.d_compCardPanel, "COMPOSITION");
            this.d_specCL.show(this.d_specCardPanel, "SPECIES");
        }

        public void loadData(Reaction reac) {
            if (reac.getFuel() == null || reac.getFuel().getType() == 4) {
                this.d_fuelTypeCombo.setSelectedItem(this.DEFAULT);
                this.defaultSelected();
            } else if (ExSpecList.isPredefinedSpecies(reac.getFuel().getName())) {
                this.d_fuelTypeCombo.setSelectedItem(this.PREDEF);
                this.predefSelected();
            } else {
                this.d_fuelTypeCombo.setSelectedItem(this.USERDEF);
                this.userDefSelected();
            }
            this.d_specCombo.setSelectedItem(reac.getFuel());
            this.d_carbon.setValue(reac.getC());
            this.d_hydrogen.setValue(reac.getH());
            this.d_oxygen.setValue(reac.getO());
            this.d_nitrogen.setValue(reac.getN());
        }

        public void saveData(Reaction reac, boolean isPreview) {
            if (this.d_fuelTypeCombo.getSelectedItem().equals(this.DEFAULT)) {
                reac.setFuel(ExSpecList.getDefaultFuel(!isPreview));
            } else {
                ExSpec spec = (ExSpec)this.d_specCombo.getSelectedItem();
                reac.setFuel(spec);
            }
            if (!this.d_fuelTypeCombo.getSelectedItem().equals(this.PREDEF)) {
                reac.setC((Double)this.d_carbon.getValue());
                reac.setH((Double)this.d_hydrogen.getValue());
                reac.setO((Double)this.d_oxygen.getValue());
                reac.setN((Double)this.d_nitrogen.getValue());
            } else {
                reac.setFuelComp(0.0, 0.0, 0.0, 0.0);
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            boolean validSpec = true;
            if (showWarn && !(validSpec = Actions.isValidSpecies((ExSpec)this.d_specCombo.getSelectedItem()))) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Must select a valid Species."));
                return false;
            }
            return validSpec && super.validateData(showWarn, allowModify);
        }
    }
}

