/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.output.guiOutputUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Task;

public class ProfListDlg
extends guiDialog {
    private static final long serialVersionUID = 9119082078203525066L;
    private guiTableEditor d_tableEd;
    private Unit d_uLen;

    public ProfListDlg(JFrame owner, Unit uLen) {
        super((Window)owner, "Edit Solid Profiles", 9);
        this.d_uLen = uLen;
        String uLenStr = " (" + uLen.toString() + ")";
        String[] headers = new String[]{Intl.intl("ID"), Intl.intl("X") + uLenStr, Intl.intl("Y") + uLenStr, Intl.intl("Z") + uLenStr, Intl.intl("ORIENT"), Intl.intl("QUANTITY")};
        Class[] classes = new Class[]{String.class, Double.class, Double.class, Double.class, String.class, IQuantity.class};
        this.d_tableEd = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, classes), 30);
        this.d_tableEd.getTable().setNullValuesAllowed(false);
        guiTable table = this.d_tableEd.getTable();
        table.setColumnOptions(4, this.ior2str(1), this.ior2str(-1), this.ior2str(2), this.ior2str(-2), this.ior2str(3), this.ior2str(-3));
        QuantityUtil.TypeFilter quantFilter = new QuantityUtil.TypeFilter(256L, new QuantityType[0]);
        List<IQuantity> quantities = QuantityUtil.generateAllQuantities(PyroSim.getApp().getMediator(), quantFilter, true);
        table.setColumnOptions(5, quantities);
        Dimension szDef = ((DefaultTableCellRenderer)table.getDefaultRenderer(Double.class)).getPreferredSize();
        szDef.width = 50;
        ((DefaultTableCellRenderer)table.getDefaultRenderer(Double.class)).setPreferredSize(szDef);
        ((DefaultTableCellRenderer)table.getDefaultRenderer(String.class)).setPreferredSize(szDef);
        table.autoSizeColumns(50);
        guiPanel c = this.getDialogPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.d_tableEd, "Center");
    }

    public void init(ProfList profList) {
        int row = 0;
        for (ProfRec rec : profList.flatten()) {
            this.setRow(row, rec);
            ++row;
        }
    }

    private void setRow(int row, ProfRec rec) {
        TableModel tMod = this.d_tableEd.getTable().getModel();
        IQuantity m = rec.getQuantity();
        UnitPoint3D upPt = rec.getPoint();
        Point3d pt = upPt.getPoint3dValue(this.d_uLen);
        tMod.setValueAt(rec.getName(), row, 0);
        tMod.setValueAt(pt.x, row, 1);
        tMod.setValueAt(pt.y, row, 2);
        tMod.setValueAt(pt.z, row, 3);
        tMod.setValueAt(this.ior2str(rec.getIOR()), row, 4);
        tMod.setValueAt(m, row, 5);
    }

    public Task taskSaveTo(PyroMod pyMod, ProfList profList) {
        ArrayList<ProfRec> newProfs = new ArrayList<ProfRec>();
        guiTable table = this.d_tableEd.getTable();
        int n = table.getRowCount() - 1;
        for (int row = 0; row < n; ++row) {
            String id = (String)table.getValueAt(row, 0);
            double x = (Double)table.getValueAt(row, 1);
            double y = (Double)table.getValueAt(row, 2);
            double z = (Double)table.getValueAt(row, 3);
            int ior = this.str2ior((String)table.getValueAt(row, 4));
            IQuantity q = (IQuantity)table.getValueAt(row, 5);
            UnitPoint3D pt = new UnitPoint3D(x, y, z, this.d_uLen);
            ProfRec prof = new ProfRec(id, ior, q, pt);
            newProfs.add(prof);
        }
        return guiOutputUtil.taskReplaceObjs(profList, newProfs);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        guiTable table = this.d_tableEd.getTable();
        ArrayList<String> ids = new ArrayList<String>();
        int n = table.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            String id = (String)table.getValueAt(i, 0);
            String idUp = id.toUpperCase();
            if (ids.contains(idUp)) {
                String msg = Intl.intl("Error: Duplicate ID ") + "\"" + id + "\"" + "\n" + Intl.intl("Please enter a unique ID for each profile.");
                this.showMessageBox(msg);
                this.requestFocusHack();
                return false;
            }
            ids.add(idUp);
        }
        return true;
    }

    private int str2ior(String s) {
        if (s.equals("X+")) {
            return 1;
        }
        if (s.equals("X-")) {
            return -1;
        }
        if (s.equals("Y+")) {
            return 2;
        }
        if (s.equals("Y-")) {
            return -2;
        }
        if (s.equals("Z+")) {
            return 3;
        }
        if (s.equals("Z-")) {
            return -3;
        }
        return 0;
    }

    private String ior2str(int ior) {
        switch (ior) {
            case 1: {
                return "X+";
            }
            case -1: {
                return "X-";
            }
            case 2: {
                return "Y+";
            }
            case -2: {
                return "Y-";
            }
            case 3: {
                return "Z+";
            }
            case -3: {
                return "Z-";
            }
        }
        return "?";
    }
}

