/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.gui.grid.GridPanel;
import pyrosim.gui.grid.MeshmakerGridCreator;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class MeshmakerGridCreatorFDS
extends MeshmakerGridCreator {
    private GridPanel d_gridDlg;
    private Grid d_currentGrid;

    public MeshmakerGridCreatorFDS(GridPanel gridDlg) {
        this.d_gridDlg = gridDlg;
        this.setValues(null);
    }

    @Override
    public String getPanelName() {
        return Intl.intl("Non-uniform");
    }

    @Override
    public void setValues(Grid g) {
        this.d_currentGrid = g;
        this.clearTable();
        Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
        if (g != null) {
            MeshmakerGridCreator.MeshmakerEntry xEntries = MeshmakerGridCreatorFDS.buildEntryList(g.getXDivisions(), unit);
            MeshmakerGridCreator.MeshmakerEntry yEntries = MeshmakerGridCreatorFDS.buildEntryList(g.getYDivisions(), unit);
            MeshmakerGridCreator.MeshmakerEntry zEntries = MeshmakerGridCreatorFDS.buildEntryList(g.getZDivisions(), unit);
            int row = 0;
            MeshmakerGridCreator.MeshmakerEntry current = xEntries;
            while (current != null) {
                this.d_table.getModel().setValueAt(new String("X"), row, 0);
                this.d_table.getModel().setValueAt(current.numCells, row, 1);
                this.d_table.getModel().setValueAt(current.value, row, 2);
                ++row;
                current = current.next;
            }
            current = yEntries;
            while (current != null) {
                this.d_table.getModel().setValueAt(new String("Y"), row, 0);
                this.d_table.getModel().setValueAt(current.numCells, row, 1);
                this.d_table.getModel().setValueAt(current.value, row, 2);
                ++row;
                current = current.next;
            }
            current = zEntries;
            while (current != null) {
                this.d_table.getModel().setValueAt(new String("Z"), row, 0);
                this.d_table.getModel().setValueAt(current.numCells, row, 1);
                this.d_table.getModel().setValueAt(current.value, row, 2);
                ++row;
                current = current.next;
            }
        }
    }

    @Override
    public Grid createGrid(UnitPoint3D minPt, UnitPoint3D maxPt) {
        int i;
        this.calcCellSizes();
        Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
        UnitDouble[] xs = new UnitDouble[this.d_XCells.length];
        UnitDouble[] ys = new UnitDouble[this.d_YCells.length];
        UnitDouble[] zs = new UnitDouble[this.d_ZCells.length];
        for (i = 0; i < xs.length; ++i) {
            xs[i] = new UnitDouble(this.d_XCells[i], unit);
        }
        for (i = 0; i < ys.length; ++i) {
            ys[i] = new UnitDouble(this.d_YCells[i], unit);
        }
        for (i = 0; i < zs.length; ++i) {
            zs[i] = new UnitDouble(this.d_ZCells[i], unit);
        }
        return new Grid("Mesh", minPt, maxPt, xs, ys, zs);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        int i;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        this.calcCellSizes();
        Unit dispUnit = UnitSystem.getSource(0).getUnit();
        double extent = 0.0;
        double xLen = this.d_gridDlg.getMax(0).get(dispUnit) - this.d_gridDlg.getMin(0).get(dispUnit);
        double yLen = this.d_gridDlg.getMax(1).get(dispUnit) - this.d_gridDlg.getMin(1).get(dispUnit);
        double zLen = this.d_gridDlg.getMax(2).get(dispUnit) - this.d_gridDlg.getMin(2).get(dispUnit);
        for (int i2 = 0; i2 < this.d_XCells.length; ++i2) {
            extent += this.d_XCells[i2];
        }
        double tol = UnitDouble.convert(TOL, Geometry.LU, dispUnit);
        if (Math.abs(extent - xLen) > tol) {
            if (showWarn) {
                this.showDimensionError("X", extent, xLen, tol);
            }
            return false;
        }
        extent = 0.0;
        for (i = 0; i < this.d_YCells.length; ++i) {
            extent += this.d_YCells[i];
        }
        if (Math.abs(extent - yLen) > tol) {
            if (showWarn) {
                this.showDimensionError("Y", extent, yLen, tol);
            }
            return false;
        }
        extent = 0.0;
        for (i = 0; i < this.d_ZCells.length; ++i) {
            extent += this.d_ZCells[i];
        }
        if (Math.abs(extent - zLen) > tol) {
            if (showWarn) {
                this.showDimensionError("Z", extent, zLen, tol);
            }
            return false;
        }
        return true;
    }
}

